/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.compiler;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.XmlRecursiveElementWalkingVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.compiler.CompileContext;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.compiler.WordOptimizer;
import com.intellij.structuralsearch.impl.matcher.filters.TagValueFilter;
import com.intellij.structuralsearch.impl.matcher.handlers.TopLevelMatchingHandler;
import com.intellij.structuralsearch.impl.matcher.strategies.XmlMatchingStrategy;
import org.jetbrains.annotations.NotNull;

public class XmlCompilingVisitor
extends XmlRecursiveElementVisitor {
    @NotNull
    private final GlobalCompilingVisitor myCompilingVisitor;
    private final XmlWordOptimizer myOptimizer;

    public XmlCompilingVisitor(@NotNull GlobalCompilingVisitor compilingVisitor) {
        if (compilingVisitor == null) {
            XmlCompilingVisitor.$$$reportNull$$$0(0);
        }
        this.myOptimizer = new XmlWordOptimizer();
        this.myCompilingVisitor = compilingVisitor;
    }

    public void compile(PsiElement @NotNull [] topLevelElements) {
        if (topLevelElements == null) {
            XmlCompilingVisitor.$$$reportNull$$$0(1);
        }
        CompileContext context2 = this.myCompilingVisitor.getContext();
        CompiledPattern pattern = context2.getPattern();
        MatchOptions options2 = context2.getOptions();
        pattern.setStrategy(new XmlMatchingStrategy(options2.getDialect()));
        for (PsiElement element2 : topLevelElements) {
            element2.accept((PsiElementVisitor)this);
            this.optimize(element2);
            pattern.setHandler(element2, new TopLevelMatchingHandler(pattern.getHandler(element2)));
        }
    }

    public void optimize(@NotNull PsiElement element2) {
        if (element2 == null) {
            XmlCompilingVisitor.$$$reportNull$$$0(2);
        }
        element2.accept((PsiElementVisitor)this.myOptimizer);
    }

    public void visitElement(@NotNull PsiElement element2) {
        if (element2 == null) {
            XmlCompilingVisitor.$$$reportNull$$$0(3);
        }
        this.myCompilingVisitor.handle(element2);
        super.visitElement(element2);
    }

    public void visitXmlToken(XmlToken token2) {
        IElementType tokenType = token2.getTokenType();
        if (tokenType != XmlTokenType.XML_NAME && tokenType != XmlTokenType.XML_COMMENT_CHARACTERS && tokenType != XmlTokenType.XML_DATA_CHARACTERS) {
            return;
        }
        super.visitXmlToken(token2);
        if (tokenType == XmlTokenType.XML_DATA_CHARACTERS) {
            this.myCompilingVisitor.setFilterSimple((PsiElement)token2, TagValueFilter.getInstance());
        }
    }

    public void visitXmlText(XmlText text2) {
        super.visitXmlText(text2);
        if (this.myCompilingVisitor.getContext().getPattern().isRealTypedVar((PsiElement)text2)) {
            this.myCompilingVisitor.setFilterSimple((PsiElement)text2, TagValueFilter.getInstance());
        }
    }

    public void visitXmlTag(XmlTag tag2) {
        super.visitXmlTag(tag2);
        this.myCompilingVisitor.setFilterSimple((PsiElement)tag2, element2 -> element2 instanceof XmlTag);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilingVisitor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topLevelElements";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/structuralsearch/impl/matcher/compiler/XmlCompilingVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "compile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "optimize";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class XmlWordOptimizer
    extends XmlRecursiveElementWalkingVisitor
    implements WordOptimizer {
        private XmlWordOptimizer() {
        }

        public void visitXmlTag(XmlTag tag2) {
            if (!this.handleWord(tag2.getName(), GlobalCompilingVisitor.OccurenceKind.CODE, XmlCompilingVisitor.this.myCompilingVisitor.getContext())) {
                return;
            }
            super.visitXmlTag(tag2);
        }

        public void visitXmlAttribute(XmlAttribute attribute) {
            if (!this.handleWord(attribute.getName(), GlobalCompilingVisitor.OccurenceKind.CODE, XmlCompilingVisitor.this.myCompilingVisitor.getContext())) {
                return;
            }
            this.handleWord(attribute.getValue(), GlobalCompilingVisitor.OccurenceKind.CODE, XmlCompilingVisitor.this.myCompilingVisitor.getContext());
            super.visitXmlAttribute(attribute);
        }

        public void visitXmlToken(XmlToken token2) {
            super.visitXmlToken(token2);
            IElementType tokenType = token2.getTokenType();
            if (tokenType == XmlTokenType.XML_COMMENT_CHARACTERS || tokenType == XmlTokenType.XML_DATA_CHARACTERS) {
                this.handleWord(token2.getText(), GlobalCompilingVisitor.OccurenceKind.TEXT, XmlCompilingVisitor.this.myCompilingVisitor.getContext());
            }
        }
    }
}

