/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.SmartList;
import com.intellij.xml.util.XmlUtil;
import java.util.List;

public final class XmlMatchUtil {
    private XmlMatchUtil() {
    }

    public static boolean isWhiteSpace(PsiElement element2) {
        return element2 instanceof PsiWhiteSpace || element2 instanceof XmlText && element2.getFirstChild() == element2.getLastChild() && element2.getFirstChild() instanceof PsiWhiteSpace;
    }

    public static List<PsiElement> getElementsToMatch(XmlTagChild[] elements) {
        SmartList list2 = new SmartList();
        for (XmlTagChild child2 : elements) {
            if (child2 instanceof XmlText) {
                for (PsiElement element2 : child2.getChildren()) {
                    if (XmlUtil.isXmlToken(element2, XmlTokenType.XML_DATA_CHARACTERS)) {
                        list2.add(element2);
                        continue;
                    }
                    if (!(element2 instanceof XmlComment)) continue;
                    list2.add(element2);
                }
                continue;
            }
            list2.add(child2);
        }
        return list2;
    }
}

