/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.configuration;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableProvider;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.impl.configuration.RemoteServerListConfigurable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class RemoteServerListConfigurableProvider
extends ConfigurableProvider {
    public boolean canCreateConfigurable() {
        List<ServerType<?>> serverTypes = RemoteServerListConfigurableProvider.getServerTypesIncludedInList();
        return !serverTypes.isEmpty();
    }

    public Configurable createConfigurable() {
        return new RemoteServerListConfigurable(RemoteServersManager.getInstance(), RemoteServerListConfigurableProvider.getServerTypesIncludedInList(), null);
    }

    @NotNull
    private static List<ServerType<?>> getServerTypesIncludedInList() {
        Set includedTypes = IncludeServerType.EP_NAME.extensions().map(type -> type.myServerType).collect(Collectors.toSet());
        List list2 = ContainerUtil.filter((Collection)ServerType.EP_NAME.getExtensionList(), type -> includedTypes.contains(type.getClass().getName()));
        if (list2 == null) {
            RemoteServerListConfigurableProvider.$$$reportNull$$$0(0);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/configuration/RemoteServerListConfigurableProvider", "getServerTypesIncludedInList"));
    }

    public static class IncludeServerType {
        public static final ExtensionPointName<IncludeServerType> EP_NAME = ExtensionPointName.create((String)"com.intellij.remoteServer.defaultConfigurable.includeServerType");
        @Attribute(value="serverType")
        public String myServerType;
    }
}

