/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.remote.ext.CredentialsManager;
import com.intellij.remote.ext.RemoteCredentialsHandler;
import com.intellij.remote.ext.UnknownCredentialsHolder;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class RemoteConnectionCredentialsWrapper {
    private UserDataHolderBase myCredentialsTypeHolder = new UserDataHolderBase();

    public <C> void setCredentials(Key<C> key, C credentials2) {
        this.myCredentialsTypeHolder = new UserDataHolderBase();
        this.myCredentialsTypeHolder.putUserData(key, credentials2);
    }

    public Object getConnectionKey() {
        return this.getCredentials();
    }

    public void save(Element rootElement) {
        this.getTypeHandler().save(rootElement);
    }

    public static IllegalStateException unknownConnectionType() {
        return new IllegalStateException("Unknown connection type");
    }

    public void copyTo(RemoteConnectionCredentialsWrapper copy2) {
        copy2.myCredentialsTypeHolder = new UserDataHolderBase();
        Pair<Object, CredentialsType> credentialsAndProvider = this.getCredentialsAndType();
        ((CredentialsType)credentialsAndProvider.getSecond()).putCredentials(copy2.myCredentialsTypeHolder, credentialsAndProvider.getFirst());
    }

    @NotNull
    public String getId() {
        String string = this.getTypeHandler().getId();
        if (string == null) {
            RemoteConnectionCredentialsWrapper.$$$reportNull$$$0(0);
        }
        return string;
    }

    public RemoteCredentialsHandler getTypeHandler() {
        Pair<Object, CredentialsType> credentialsAndType = this.getCredentialsAndType();
        return ((CredentialsType)credentialsAndType.getSecond()).getHandler(credentialsAndType.getFirst());
    }

    public CredentialsType getRemoteConnectionType() {
        return (CredentialsType)this.getCredentialsAndType().getSecond();
    }

    public Object getCredentials() {
        return this.getCredentialsAndType().getFirst();
    }

    private Pair<Object, CredentialsType> getCredentialsAndType() {
        for (CredentialsType<?> type : CredentialsManager.getInstance().getAllTypes()) {
            Object credentials2 = type.getCredentials(this.myCredentialsTypeHolder);
            if (credentials2 == null) continue;
            return Pair.create(credentials2, type);
        }
        UnknownCredentialsHolder credentials3 = CredentialsType.UNKNOWN.getCredentials(this.myCredentialsTypeHolder);
        if (credentials3 != null) {
            return Pair.create((Object)credentials3, CredentialsType.UNKNOWN);
        }
        throw RemoteConnectionCredentialsWrapper.unknownConnectionType();
    }

    public void switchType(CredentialsCase ... cases2) {
        Pair<Object, CredentialsType> credentialsAndType = this.getCredentialsAndType();
        CredentialsType type = (CredentialsType)credentialsAndType.getSecond();
        for (CredentialsCase credentialsCase : cases2) {
            if (credentialsCase.getType() != type) continue;
            credentialsCase.process(credentialsAndType.getFirst());
            return;
        }
    }

    public boolean equals(Object obj2) {
        if (obj2 instanceof RemoteConnectionCredentialsWrapper) {
            RemoteConnectionCredentialsWrapper w = (RemoteConnectionCredentialsWrapper)obj2;
            try {
                Object credentials2 = this.getCredentials();
                Object counterCredentials = w.getCredentials();
                return credentials2.equals(counterCredentials);
            }
            catch (IllegalStateException e) {
                return false;
            }
        }
        return false;
    }

    public String getPresentableDetails(String interpreterPath) {
        return this.getTypeHandler().getPresentableDetails(interpreterPath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remote/RemoteConnectionCredentialsWrapper", "getId"));
    }
}

