/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.ui;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.VisibilityPanelBase;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.ui.DialogUtil;
import com.intellij.util.ui.UpDownHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;

public class ComboBoxVisibilityPanel<V>
extends VisibilityPanelBase<V> {
    private final JLabel myLabel;
    protected final JComboBox myComboBox;
    private final Map<V, String> myNamesMap = new HashMap<V, String>();

    public ComboBoxVisibilityPanel(@NlsContexts.Label String name, V[] options2, @NlsContexts.ListItem String[] presentableNames) {
        this.setLayout(new BorderLayout(0, 2));
        this.myLabel = new JLabel(name);
        this.add((Component)this.myLabel, "North");
        this.myComboBox = new JComboBox<V>(options2);
        this.myComboBox.setRenderer(this.getRenderer());
        this.add((Component)this.myComboBox, "South");
        for (int i2 = 0; i2 < options2.length; ++i2) {
            this.myNamesMap.put((String)options2[i2], presentableNames[i2]);
        }
        this.myComboBox.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComboBoxVisibilityPanel.this.stateChanged(new ChangeEvent(ComboBoxVisibilityPanel.this));
            }
        });
        this.myLabel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ComboBoxVisibilityPanel.this.myComboBox.showPopup();
            }
        });
        DialogUtil.registerMnemonic((JLabel)this.myLabel, (JComponent)this.myComboBox);
    }

    protected ListCellRenderer<?> getRenderer() {
        return SimpleListCellRenderer.create((String)"", this.myNamesMap::get);
    }

    public ComboBoxVisibilityPanel(@NlsContexts.Label String name, V[] options2) {
        this(name, options2, ComboBoxVisibilityPanel.getObjectNames(options2));
    }

    private static String[] getObjectNames(Object[] options2) {
        String[] names2 = new String[options2.length];
        for (int i2 = 0; i2 < options2.length; ++i2) {
            names2[i2] = options2[i2].toString();
        }
        return names2;
    }

    public ComboBoxVisibilityPanel(V[] options2) {
        this(RefactoringBundle.message((String)"visibility.combo.title"), options2);
    }

    public ComboBoxVisibilityPanel(V[] options2, String[] presentableNames) {
        this(RefactoringBundle.message((String)"visibility.combo.title"), options2, presentableNames);
    }

    protected void addOption(int index2, V option2, String presentableName, boolean select2) {
        this.myNamesMap.put((String)option2, presentableName);
        this.myComboBox.insertItemAt(option2, index2);
        if (select2) {
            this.myComboBox.setSelectedIndex(index2);
        }
    }

    protected void addOption(V option2) {
        this.addOption(this.myComboBox.getItemCount(), option2, option2.toString(), false);
    }

    public void setDisplayedMnemonicIndex(int index2) {
        this.myLabel.setDisplayedMnemonicIndex(index2);
    }

    @Override
    public V getVisibility() {
        return (V)this.myComboBox.getSelectedItem();
    }

    public final void registerUpDownActionsFor(JComponent input) {
        UpDownHandler.register(input, this.myComboBox);
    }

    @Override
    public void setVisibility(V visibility) {
        this.myComboBox.setSelectedItem(visibility);
        this.stateChanged(new ChangeEvent(this));
    }
}

