/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduce.inplace;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.ToolWindowManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComboBox;

public final class KeyboardComboSwitcher {
    public static void setupActions(final JComboBox comboBox2, final Project project) {
        final Ref moveFocusBack = Ref.create((Object)true);
        comboBox2.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (!((Boolean)moveFocusBack.get()).booleanValue()) {
                    moveFocusBack.set((Object)true);
                    return;
                }
                int size2 = comboBox2.getModel().getSize();
                int next = comboBox2.getSelectedIndex() + 1;
                if (size2 > 0) {
                    if (next < 0 || next >= size2) {
                        if (!UISettings.getInstance().getCycleScrolling()) {
                            return;
                        }
                        next = (next + size2) % size2;
                    }
                    comboBox2.setSelectedIndex(next);
                }
                ToolWindowManager.getInstance((Project)project).activateEditorComponent();
            }
        });
        comboBox2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                moveFocusBack.set((Object)false);
            }
        });
        comboBox2.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                moveFocusBack.set((Object)true);
            }
        });
        comboBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                moveFocusBack.set((Object)true);
                if (!project.isDisposed()) {
                    ToolWindowManager.getInstance((Project)project).activateEditorComponent();
                }
            }
        });
    }
}

