/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ExceptionWithAttachments;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.FreeThreadedFileViewProvider;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class StubTextInconsistencyException
extends RuntimeException
implements ExceptionWithAttachments {
    private final String myStubsFromText;
    private final String myStubsFromPsi;
    private final String myFileName;
    private final String myFileText;

    private StubTextInconsistencyException(String message2, PsiFile file2, List<PsiFileStub> fromText2, List<PsiFileStub> fromPsi) {
        super(message2);
        this.myStubsFromText = StringUtil.join(fromText2, DebugUtil::stubTreeToString, (String)"\n");
        this.myStubsFromPsi = StringUtil.join(fromPsi, DebugUtil::stubTreeToString, (String)"\n");
        this.myFileName = file2.getName();
        this.myFileText = file2.getText();
    }

    @NotNull
    public String getStubsFromText() {
        String string = this.myStubsFromText;
        if (string == null) {
            StubTextInconsistencyException.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getStubsFromPsi() {
        String string = this.myStubsFromPsi;
        if (string == null) {
            StubTextInconsistencyException.$$$reportNull$$$0(1);
        }
        return string;
    }

    public Attachment @NotNull [] getAttachments() {
        Attachment[] attachmentArray = new Attachment[]{new Attachment(this.myFileName, this.myFileText), new Attachment("stubsRestoredFromText.txt", this.myStubsFromText), new Attachment("stubsFromExistingPsi.txt", this.myStubsFromPsi)};
        if (attachmentArray == null) {
            StubTextInconsistencyException.$$$reportNull$$$0(2);
        }
        return attachmentArray;
    }

    public static void checkStubTextConsistency(@NotNull PsiFile file2) throws StubTextInconsistencyException {
        if (file2 == null) {
            StubTextInconsistencyException.$$$reportNull$$$0(3);
        }
        PsiUtilCore.ensureValid((PsiElement)file2);
        FileViewProvider viewProvider = file2.getViewProvider();
        if (viewProvider instanceof FreeThreadedFileViewProvider || viewProvider.getVirtualFile() instanceof LightVirtualFile) {
            return;
        }
        PsiFile bindingRoot = viewProvider.getStubBindingRoot();
        if (!(bindingRoot instanceof PsiFileImpl)) {
            return;
        }
        IStubFileElementType<?> fileElementType = ((PsiFileImpl)bindingRoot).getElementTypeForStubBuilder();
        if (fileElementType == null || !fileElementType.shouldBuildStubFor(viewProvider.getVirtualFile())) {
            return;
        }
        List<PsiFileStub> fromText2 = StubTextInconsistencyException.restoreStubsFromText(viewProvider);
        List fromPsi = ContainerUtil.map(StubTreeBuilder.getStubbedRoots(viewProvider), p -> ((PsiFileImpl)p.getSecond()).calcStubTree().getRoot());
        if (fromPsi.size() != fromText2.size()) {
            throw new StubTextInconsistencyException("Inconsistent stub roots: PSI says it's " + ContainerUtil.map((Collection)fromPsi, s -> s.getType()) + " but re-parsing the text gives " + ContainerUtil.map(fromText2, s -> s.getType()), file2, fromText2, fromPsi);
        }
        for (int i2 = 0; i2 < fromPsi.size(); ++i2) {
            PsiFileStub psiStub = (PsiFileStub)fromPsi.get(i2);
            if (DebugUtil.stubTreeToString((Stub)psiStub).equals(DebugUtil.stubTreeToString((Stub)fromText2.get(i2)))) continue;
            throw new StubTextInconsistencyException("Stub is inconsistent with text in " + file2.getLanguage(), file2, fromText2, fromPsi);
        }
    }

    @NotNull
    private static List<PsiFileStub> restoreStubsFromText(FileViewProvider viewProvider) {
        Project project = viewProvider.getManager().getProject();
        FileContentImpl fc = (FileContentImpl)FileContentImpl.createByText(viewProvider.getVirtualFile(), viewProvider.getContents(), project);
        fc.setProject(project);
        PsiFileStubImpl copyTree = (PsiFileStubImpl)StubTreeBuilder.buildStubTree((FileContent)fc);
        List<PsiFileStub> list2 = copyTree == null ? Collections.emptyList() : Arrays.asList(copyTree.getStubRoots());
        if (list2 == null) {
            StubTextInconsistencyException.$$$reportNull$$$0(4);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/StubTextInconsistencyException";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubsFromText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubsFromPsi";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttachments";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/StubTextInconsistencyException";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "restoreStubsFromText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkStubTextConsistency";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

