/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.URLReference;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.xml.XmlElementImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlMarkupDecl;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlDoctypeImpl
extends XmlElementImpl
implements XmlDoctype {
    private static final Logger LOG = Logger.getInstance(XmlDoctypeImpl.class);

    public XmlDoctypeImpl() {
        super(XmlElementType.XML_DOCTYPE);
    }

    @Override
    public void clearCaches() {
        XmlTag rootTag;
        XmlDocument doc = this.getContainingDocument();
        if (doc != null && (rootTag = doc.getRootTag()) instanceof TreeElement) {
            ((TreeElement)rootTag).clearCaches();
        }
        super.clearCaches();
    }

    private XmlDocument getContainingDocument() {
        for (PsiElement elem = this.getParent(); elem != null; elem = elem.getParent()) {
            if (elem instanceof XmlDocument) {
                return (XmlDocument)elem;
            }
            if (elem instanceof PsiFile) break;
        }
        return null;
    }

    @Nullable
    public String getDtdUri() {
        PsiElement dtdUrlElement = this.getDtdUrlElement();
        if (dtdUrlElement == null || dtdUrlElement.getTextLength() == 0) {
            return null;
        }
        return XmlDoctypeImpl.extractValue(dtdUrlElement);
    }

    private static String extractValue(PsiElement element2) {
        String text2 = element2.getText();
        if (!text2.startsWith("\"") && !text2.startsWith("'") && XmlDoctypeImpl.hasInjectedEscapingQuotes(element2, text2)) {
            return XmlDoctypeImpl.stripInjectedEscapingQuotes(text2);
        }
        return StringUtil.stripQuotesAroundValue((String)text2);
    }

    private static String stripInjectedEscapingQuotes(String text2) {
        return text2.substring(2, text2.length() - 2);
    }

    private static boolean hasInjectedEscapingQuotes(PsiElement element2, String text2) {
        if (text2.startsWith("\\") && text2.length() >= 4) {
            char escapedChar = text2.charAt(1);
            PsiLanguageInjectionHost context2 = InjectedLanguageManager.getInstance((Project)element2.getContainingFile().getProject()).getInjectionHost((PsiElement)element2.getContainingFile());
            if (context2 != null && context2.textContains(escapedChar) && context2.getText().startsWith(String.valueOf(escapedChar)) && text2.endsWith("\\" + escapedChar)) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public PsiElement getDtdUrlElement() {
        PsiElement docTypeSystem;
        PsiElement docTypePublic;
        ASTNode child2 = this.getNode().findChildByType(XmlTokenType.XML_DOCTYPE_PUBLIC);
        PsiElement psiElement = docTypePublic = child2 != null ? child2.getPsi() : null;
        if (docTypePublic != null) {
            PsiElement element2 = docTypePublic.getNextSibling();
            while (element2 instanceof PsiWhiteSpace || element2 instanceof XmlComment) {
                element2 = element2.getNextSibling();
            }
            if (element2 instanceof XmlToken && ((XmlToken)element2).getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN) {
                element2 = element2.getNextSibling();
                while (element2 instanceof PsiWhiteSpace || element2 instanceof XmlComment) {
                    element2 = element2.getNextSibling();
                }
                if (element2 instanceof XmlToken && ((XmlToken)element2).getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN) {
                    return element2;
                }
            }
        }
        PsiElement psiElement2 = docTypeSystem = (child2 = this.getNode().findChildByType(XmlTokenType.XML_DOCTYPE_SYSTEM)) != null ? child2.getPsi() : null;
        if (docTypeSystem != null) {
            PsiElement element3 = docTypeSystem.getNextSibling();
            while (element3 instanceof PsiWhiteSpace || element3 instanceof XmlComment) {
                element3 = element3.getNextSibling();
            }
            if (element3 instanceof XmlToken && ((XmlToken)element3).getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN) {
                return element3;
            }
        }
        return null;
    }

    public XmlElement getNameElement() {
        ASTNode child2 = this.getNode().findChildByType(XmlTokenType.XML_NAME);
        return child2 != null ? (XmlElement)child2.getPsi(XmlElement.class) : null;
    }

    @Nullable
    public String getPublicId() {
        return this.getSomeId(XmlTokenType.XML_DOCTYPE_PUBLIC);
    }

    public String getSystemId() {
        return this.getSomeId(XmlTokenType.XML_DOCTYPE_SYSTEM);
    }

    private String getSomeId(IElementType elementType) {
        PsiElement docTypeSystem;
        ASTNode child2 = this.getNode().findChildByType(elementType);
        PsiElement psiElement = docTypeSystem = child2 != null ? child2.getPsi() : null;
        if (docTypeSystem != null) {
            PsiElement element2 = docTypeSystem.getNextSibling();
            while (element2 instanceof PsiWhiteSpace || element2 instanceof XmlComment) {
                element2 = element2.getNextSibling();
            }
            if (element2 instanceof XmlToken && ((XmlToken)element2).getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN && element2.getTextLength() != 0) {
                return XmlDoctypeImpl.extractValue(element2);
            }
        }
        return null;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            XmlDoctypeImpl.$$$reportNull$$$0(0);
        }
        if (visitor instanceof XmlElementVisitor) {
            ((XmlElementVisitor)visitor).visitXmlDoctype((XmlDoctype)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public XmlMarkupDecl getMarkupDecl() {
        for (PsiElement child2 = this.getFirstChild(); child2 != null; child2 = child2.getNextSibling()) {
            if (!(child2 instanceof XmlMarkupDecl)) continue;
            return (XmlMarkupDecl)child2;
        }
        return null;
    }

    @Override
    public PsiReference @NotNull [] getReferences() {
        PsiElement dtdUrlElement = this.getDtdUrlElement();
        PsiReference uriRef = null;
        if (dtdUrlElement != null) {
            uriRef = this.createUrlReference(dtdUrlElement);
        }
        Object[] refs = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this);
        Object[] objectArray = uriRef == null ? refs : (PsiReference[])ArrayUtil.mergeArrays((Object[])new PsiReference[]{uriRef}, (Object[])refs);
        if (objectArray == null) {
            XmlDoctypeImpl.$$$reportNull$$$0(1);
        }
        return objectArray;
    }

    protected PsiReference createUrlReference(final PsiElement dtdUrlElement) {
        return new URLReference(this){

            @Override
            @NotNull
            public String getCanonicalText() {
                String string = XmlDoctypeImpl.extractValue(dtdUrlElement);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            @NotNull
            public TextRange getRangeInElement() {
                TextRange textRange = TextRange.from((int)(dtdUrlElement.getTextRange().getStartOffset() - XmlDoctypeImpl.this.getTextRange().getStartOffset() + 1), (int)Math.max(dtdUrlElement.getTextRange().getLength() - 2, 0));
                if (textRange == null) {
                    1.$$$reportNull$$$0(1);
                }
                return textRange;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/psi/impl/source/xml/XmlDoctypeImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCanonicalText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRangeInElement";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/xml/XmlDoctypeImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/xml/XmlDoctypeImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

