/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationWithSeparator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.HintedReferenceHost;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.tree.injected.XmlAttributeLiteralEscaper;
import com.intellij.psi.impl.source.xml.XmlElementImpl;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.intellij.lang.regexp.DefaultRegExpPropertiesProvider;
import org.intellij.lang.regexp.RegExpLanguageHost;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpNamedGroupRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlAttributeValueImpl
extends XmlElementImpl
implements XmlAttributeValue,
PsiLanguageInjectionHost,
RegExpLanguageHost,
PsiMetaOwner,
PsiMetaData,
HintedReferenceHost {
    private static final Logger LOG = Logger.getInstance(XmlAttributeValueImpl.class);

    public XmlAttributeValueImpl() {
        super(XmlElementType.XML_ATTRIBUTE_VALUE);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            XmlAttributeValueImpl.$$$reportNull$$$0(0);
        }
        if (visitor instanceof XmlElementVisitor) {
            ((XmlElementVisitor)visitor).visitXmlAttributeValue((XmlAttributeValue)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @NotNull
    public String getValue() {
        ASTNode endQuote;
        String text2 = this.getText();
        ASTNode startQuote = this.findChildByType(XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER);
        if (startQuote != null) {
            text2 = StringUtil.trimStart((String)text2, (String)startQuote.getText());
        }
        if ((endQuote = this.findChildByType(XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER)) != null) {
            text2 = StringUtil.trimEnd((String)text2, (String)endQuote.getText());
        }
        String string = text2;
        if (string == null) {
            XmlAttributeValueImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    public TextRange getValueTextRange() {
        TextRange range2 = this.getTextRange();
        String value2 = this.getValue();
        if (value2.isEmpty()) {
            return range2;
        }
        int start2 = range2.getStartOffset() + this.getText().indexOf(value2);
        int end = start2 + value2.length();
        return new TextRange(start2, end);
    }

    public PsiReference @NotNull [] getReferences(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PsiReferenceService.Hints hints2) {
        if (hints2 == null) {
            XmlAttributeValueImpl.$$$reportNull$$$0(2);
        }
        PsiReference[] psiReferenceArray = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this, (PsiReferenceService.Hints)hints2);
        if (psiReferenceArray == null) {
            XmlAttributeValueImpl.$$$reportNull$$$0(3);
        }
        return psiReferenceArray;
    }

    public boolean shouldAskParentForReferences(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PsiReferenceService.Hints hints2) {
        if (hints2 == null) {
            XmlAttributeValueImpl.$$$reportNull$$$0(4);
        }
        return false;
    }

    @Override
    public PsiReference @NotNull [] getReferences() {
        PsiReference[] psiReferenceArray = this.getReferences(PsiReferenceService.Hints.NO_HINTS);
        if (psiReferenceArray == null) {
            XmlAttributeValueImpl.$$$reportNull$$$0(5);
        }
        return psiReferenceArray;
    }

    @Override
    public PsiReference getReference() {
        PsiReference[] refs = this.getReferences();
        if (refs.length > 0) {
            return refs[0];
        }
        return null;
    }

    @Override
    public int getTextOffset() {
        return this.getTextRange().getStartOffset() + 1;
    }

    public boolean isValidHost() {
        return this.getParent() instanceof XmlAttribute;
    }

    public PsiLanguageInjectionHost updateText(@NotNull String text2) {
        if (text2 == null) {
            XmlAttributeValueImpl.$$$reportNull$$$0(6);
        }
        try {
            String quoteChar = this.getTextLength() > 0 ? this.getText().substring(0, 1) : "";
            String contents = StringUtil.containsAnyChar((String)quoteChar, (String)"'\"") ? StringUtil.trimEnd((String)StringUtil.trimStart((String)text2, (String)quoteChar), (String)quoteChar) : text2;
            XmlAttribute newAttribute = XmlElementFactory.getInstance((Project)this.getProject()).createAttribute(StringUtil.defaultIfEmpty(this.getParent() instanceof XmlAttribute ? ((XmlAttribute)this.getParent()).getName() : null, (String)"q"), contents, (PsiElement)this);
            XmlAttributeValue newValue2 = newAttribute.getValueElement();
            CheckUtil.checkWritable(this);
            this.replaceAllChildrenToChildrenOf(newValue2.getNode());
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        return this;
    }

    @NotNull
    public LiteralTextEscaper<XmlAttributeValueImpl> createLiteralTextEscaper() {
        return new XmlAttributeLiteralEscaper(this);
    }

    public PsiMetaData getMetaData() {
        return this;
    }

    public PsiElement getDeclaration() {
        return this;
    }

    public String getName(PsiElement context2) {
        return this.getValue();
    }

    @Override
    public String getName() {
        return this.getValue();
    }

    public void init(PsiElement element2) {
    }

    @Override
    public ItemPresentation getPresentation() {
        return new ItemPresentationWithSeparator(){

            public String getPresentableText() {
                return XmlAttributeValueImpl.this.getText();
            }

            public String getLocationString() {
                return SymbolPresentationUtil.getFilePathPresentation(XmlAttributeValueImpl.this.getContainingFile());
            }

            public Icon getIcon(boolean open2) {
                return null;
            }
        };
    }

    @Override
    public boolean characterNeedsEscaping(char c) {
        return c == ']' || c == '}';
    }

    @Override
    public boolean supportsPerl5EmbeddedComments() {
        return false;
    }

    @Override
    public boolean supportsPossessiveQuantifiers() {
        return true;
    }

    @Override
    public boolean supportsPythonConditionalRefs() {
        return false;
    }

    @Override
    public boolean supportsNamedGroupSyntax(RegExpGroup group2) {
        return true;
    }

    @Override
    public boolean supportsNamedGroupRefSyntax(RegExpNamedGroupRef ref) {
        return true;
    }

    @Override
    public boolean supportsExtendedHexCharacter(RegExpChar regExpChar) {
        return false;
    }

    @Override
    public boolean isValidCategory(@NotNull String category) {
        if (category == null) {
            XmlAttributeValueImpl.$$$reportNull$$$0(7);
        }
        if (category.startsWith("Is")) {
            try {
                return Character.UnicodeBlock.forName(category.substring(2)) != null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        for (String[] name : DefaultRegExpPropertiesProvider.getInstance().getAllKnownProperties()) {
            if (!name[0].equals(category)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] @NotNull [] getAllKnownProperties() {
        return DefaultRegExpPropertiesProvider.getInstance().getAllKnownProperties();
    }

    @Override
    @Nullable
    public String getPropertyDescription(@Nullable String name) {
        return DefaultRegExpPropertiesProvider.getInstance().getPropertyDescription(name);
    }

    @Override
    public String[] @NotNull [] getKnownCharacterClasses() {
        return DefaultRegExpPropertiesProvider.getInstance().getKnownCharacterClasses();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/xml/XmlAttributeValueImpl";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hints";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/xml/XmlAttributeValueImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getReferences";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "shouldAskParentForReferences";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateText";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isValidCategory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

