/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TagNameReference
implements PsiReference {
    private static final Logger LOG = Logger.getInstance(TagNameReference.class);
    protected final boolean myStartTagFlag;
    private final ASTNode myNameElement;

    public TagNameReference(ASTNode nameElement, boolean startTagFlag) {
        this.myStartTagFlag = startTagFlag;
        this.myNameElement = nameElement;
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement element2 = this.myNameElement.getPsi();
        PsiElement parent = element2.getParent();
        PsiElement psiElement = parent instanceof XmlTag ? parent : element2;
        if (psiElement == null) {
            TagNameReference.$$$reportNull$$$0(0);
        }
        return psiElement;
    }

    @Nullable
    protected XmlTag getTagElement() {
        PsiElement element2 = this.getElement();
        if (element2 == this.myNameElement.getPsi()) {
            return null;
        }
        return (XmlTag)element2;
    }

    @NotNull
    public TextRange getRangeInElement() {
        ASTNode nameElement = this.getNameElement();
        if (nameElement == null) {
            TextRange textRange = TextRange.EMPTY_RANGE;
            if (textRange == null) {
                TagNameReference.$$$reportNull$$$0(1);
            }
            return textRange;
        }
        int colon = this.getPrefixIndex(nameElement.getText()) + 1;
        if (this.myStartTagFlag) {
            int parentOffset = nameElement.getStartOffsetInParent();
            return new TextRange(parentOffset + colon, parentOffset + nameElement.getTextLength());
        }
        PsiElement element2 = this.getElement();
        if (element2 == this.myNameElement) {
            return new TextRange(colon, this.myNameElement.getTextLength());
        }
        int elementLength = element2.getTextLength();
        int diffFromEnd = 0;
        for (ASTNode node2 = element2.getNode().getLastChildNode(); node2 != nameElement && node2 != null; node2 = node2.getTreePrev()) {
            diffFromEnd += node2.getTextLength();
        }
        int nameEnd = elementLength - diffFromEnd;
        return new TextRange(nameEnd - nameElement.getTextLength() + colon, nameEnd);
    }

    protected int getPrefixIndex(@NotNull String name) {
        if (name == null) {
            TagNameReference.$$$reportNull$$$0(2);
        }
        return name.indexOf(":");
    }

    public ASTNode getNameElement() {
        return this.myNameElement;
    }

    public PsiElement resolve() {
        XmlElementDescriptor descriptor2;
        XmlTag tag2 = this.getTagElement();
        XmlElementDescriptor xmlElementDescriptor = descriptor2 = tag2 != null ? tag2.getDescriptor() : null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Descriptor for tag " + (tag2 != null ? tag2.getName() : "NULL") + " is " + (String)(descriptor2 != null ? descriptor2.toString() + ": " + descriptor2.getClass().getCanonicalName() : "NULL"));
        }
        if (descriptor2 != null) {
            return descriptor2 instanceof AnyXmlElementDescriptor ? tag2 : descriptor2.getDeclaration();
        }
        return null;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getNameElement().getText();
        if (string == null) {
            TagNameReference.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        XmlTag element2;
        if (newElementName == null) {
            TagNameReference.$$$reportNull$$$0(4);
        }
        if ((element2 = this.getTagElement()) == null || !this.myStartTagFlag) {
            return element2;
        }
        if (this.getPrefixIndex(newElementName) == -1) {
            PsiElement psiElement;
            String namespacePrefix = element2.getNamespacePrefix();
            int index2 = newElementName.lastIndexOf(46);
            if (index2 != -1 && ((psiElement = this.resolve()) instanceof PsiFile || psiElement != null && psiElement.isEquivalentTo((PsiElement)psiElement.getContainingFile()))) {
                newElementName = newElementName.substring(0, index2);
            }
            newElementName = this.prependNamespacePrefix(newElementName, namespacePrefix);
        }
        element2.setName(newElementName);
        return element2;
    }

    protected String prependNamespacePrefix(String newElementName, String namespacePrefix) {
        newElementName = (String)(!namespacePrefix.isEmpty() ? namespacePrefix + ":" : namespacePrefix) + (String)newElementName;
        return newElementName;
    }

    public PsiElement bindToElement(@NotNull PsiElement element2) throws IncorrectOperationException {
        XmlTag tag2;
        if (element2 == null) {
            TagNameReference.$$$reportNull$$$0(5);
        }
        PsiMetaData metaData = null;
        if (element2 instanceof PsiMetaOwner) {
            PsiMetaOwner owner = (PsiMetaOwner)element2;
            metaData = owner.getMetaData();
            if (metaData instanceof XmlElementDescriptor) {
                return this.getTagElement().setName(metaData.getName(this.getElement()));
            }
        } else if (element2 instanceof PsiFile) {
            XmlTag tagElement = this.getTagElement();
            if (tagElement == null || !this.myStartTagFlag) {
                return tagElement;
            }
            String newElementName = ((PsiFile)element2).getName();
            int index2 = newElementName.lastIndexOf(46);
            newElementName = this.prependNamespacePrefix(newElementName.substring(0, index2), tagElement.getNamespacePrefix());
            return this.getTagElement().setName(newElementName);
        }
        throw new IncorrectOperationException("Cant bind to not a xml element definition!" + element2 + "," + metaData + "," + tag2 + "," + ((tag2 = this.getTagElement()) != null ? tag2.getDescriptor() : "unknown descriptor"));
    }

    public boolean isReferenceTo(@NotNull PsiElement element2) {
        if (element2 == null) {
            TagNameReference.$$$reportNull$$$0(6);
        }
        return this.getElement().getManager().areElementsEquivalent(element2, this.resolve());
    }

    public boolean isSoft() {
        return false;
    }

    @Nullable
    static TagNameReference createTagNameReference(XmlElement element2, @NotNull ASTNode nameElement, boolean startTagFlag) {
        XmlExtension extension2;
        if (nameElement == null) {
            TagNameReference.$$$reportNull$$$0(7);
        }
        return (extension2 = XmlExtension.getExtensionByElement((PsiElement)element2)) == null ? null : extension2.createTagNameReference(nameElement, startTagFlag);
    }

    public boolean isStartTagFlag() {
        return this.myStartTagFlag;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/xml/TagNameReference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/xml/TagNameReference";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPrefixIndex";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createTagNameReference";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

