/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.XmlTagInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.html.dtd.HtmlElementDescriptorImpl;
import com.intellij.psi.impl.source.xml.TagNameVariantCollector;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.XmlNamespaceHelper;
import com.intellij.xml.XmlTagNameProvider;
import com.intellij.xml.index.XmlNamespaceIndex;
import com.intellij.xml.index.XsdNamespaceBuilder;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DefaultXmlTagNameProvider
implements XmlTagNameProvider {
    private static final Logger LOG = Logger.getInstance(DefaultXmlTagNameProvider.class);

    @Override
    public void addTagNameVariants(List<LookupElement> elements, @NotNull XmlTag tag2, String prefix2) {
        ArrayList<String> namespaces;
        if (tag2 == null) {
            DefaultXmlTagNameProvider.$$$reportNull$$$0(0);
        }
        if (prefix2.isEmpty()) {
            namespaces = new ArrayList<String>(Arrays.asList(tag2.knownNamespaces()));
            namespaces.add("");
        } else {
            namespaces = new ArrayList<String>(Collections.singletonList(tag2.getNamespace()));
        }
        PsiFile psiFile = tag2.getContainingFile();
        XmlExtension xmlExtension = XmlExtension.getExtension(psiFile);
        ArrayList nsInfo = new ArrayList();
        List<XmlElementDescriptor> variants = TagNameVariantCollector.getTagDescriptors(tag2, namespaces, nsInfo);
        if (psiFile instanceof XmlFile && ((XmlFile)psiFile).getRootTag() == tag2) {
            DefaultXmlTagNameProvider.addXmlProcessingInstructions(elements, tag2);
            if (variants.isEmpty()) {
                DefaultXmlTagNameProvider.getRootTagsVariants(tag2, elements);
                return;
            }
        }
        HashSet<String> visited = new HashSet<String>();
        for (int i2 = 0; i2 < variants.size(); ++i2) {
            boolean deprecated;
            String ns;
            PsiElement declaration;
            XmlElementDescriptor descriptor2 = variants.get(i2);
            String qname = descriptor2.getName((PsiElement)tag2);
            if (!visited.add(qname)) continue;
            if (!prefix2.isEmpty() && qname.startsWith(prefix2 + ":")) {
                qname = qname.substring(prefix2.length() + 1);
            }
            if ((declaration = descriptor2.getDeclaration()) != null && !declaration.isValid()) {
                LOG.error(descriptor2 + " contains invalid declaration: " + declaration);
            }
            LookupElementBuilder lookupElement = declaration == null ? LookupElementBuilder.create((String)qname) : LookupElementBuilder.create((Object)declaration, (String)qname);
            int separator = qname.indexOf(58);
            if (separator > 0) {
                lookupElement = lookupElement.withLookupString(qname.substring(separator + 1));
            }
            if (StringUtil.isNotEmpty((String)(ns = (String)nsInfo.get(i2)))) {
                lookupElement = lookupElement.withTypeText(ns, true);
            }
            if (descriptor2 instanceof PsiPresentableMetaData) {
                lookupElement = lookupElement.withIcon(((PsiPresentableMetaData)descriptor2).getIcon());
            }
            if (xmlExtension.useXmlTagInsertHandler()) {
                lookupElement = lookupElement.withInsertHandler((InsertHandler)XmlTagInsertHandler.INSTANCE);
            }
            boolean bl = deprecated = descriptor2 instanceof HtmlElementDescriptorImpl && ((HtmlElementDescriptorImpl)descriptor2).isDeprecated();
            if (deprecated) {
                lookupElement = lookupElement.withStrikeoutness(true);
            }
            lookupElement = lookupElement.withCaseSensitivity(!(descriptor2 instanceof HtmlElementDescriptorImpl));
            elements.add(PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)(deprecated ? -1.0 : (separator > 0 ? 0.0 : 1.0))));
        }
    }

    private static void addXmlProcessingInstructions(@NotNull List<LookupElement> elements, @NotNull XmlTag tag2) {
        PsiElement file2;
        PsiElement prolog;
        if (elements == null) {
            DefaultXmlTagNameProvider.$$$reportNull$$$0(1);
        }
        if (tag2 == null) {
            DefaultXmlTagNameProvider.$$$reportNull$$$0(2);
        }
        if ((prolog = (file2 = tag2.getParent()).getFirstChild()).getTextLength() != 0) {
            return;
        }
        if (ContainerUtil.exists((Object[])tag2.getChildren(), OuterLanguageElement.class::isInstance)) {
            return;
        }
        LookupElementBuilder xmlDeclaration = LookupElementBuilder.create((String)"?xml version=\"1.0\" encoding=\"\" ?>").withPresentableText("<?xml version=\"1.0\" encoding=\"\" ?>").withInsertHandler((context2, item) -> {
            int offset = context2.getEditor().getCaretModel().getOffset();
            context2.getEditor().getCaretModel().moveToOffset(offset - 4);
            AutoPopupController.getInstance(context2.getProject()).scheduleAutoPopup(context2.getEditor());
        });
        elements.add((LookupElement)xmlDeclaration);
    }

    private static void getRootTagsVariants(final XmlTag tag2, final List<? super LookupElement> elements) {
        FileBasedIndex fbi = FileBasedIndex.getInstance();
        ArrayList result2 = new ArrayList();
        Processor processor2 = Processors.cancelableCollectProcessor(result2);
        fbi.processAllKeys(XmlNamespaceIndex.NAME, processor2, tag2.getProject());
        GlobalSearchScope scope2 = GlobalSearchScope.everythingScope((Project)tag2.getProject());
        for (final String ns : result2) {
            if (ns.isEmpty()) continue;
            fbi.processValues(XmlNamespaceIndex.NAME, (Object)ns, null, (FileBasedIndex.ValueProcessor)new FileBasedIndex.ValueProcessor<XsdNamespaceBuilder>(){

                public boolean process(@NotNull VirtualFile file2, XsdNamespaceBuilder value2) {
                    if (file2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    List<String> tags = value2.getRootTags();
                    for (String s : tags) {
                        elements.add(LookupElementBuilder.create((String)s).withTypeText(ns).withInsertHandler((InsertHandler)new XmlTagInsertHandler(){

                            @Override
                            public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
                                if (context2 == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                if (item == null) {
                                    1.$$$reportNull$$$0(1);
                                }
                                Editor editor = context2.getEditor();
                                Document document = context2.getDocument();
                                int caretOffset = editor.getCaretModel().getOffset();
                                RangeMarker caretMarker = document.createRangeMarker(caretOffset, caretOffset);
                                caretMarker.setGreedyToRight(true);
                                XmlFile psiFile = (XmlFile)context2.getFile();
                                boolean incomplete = XmlUtil.getTokenOfType((PsiElement)tag2, XmlTokenType.XML_TAG_END) == null && XmlUtil.getTokenOfType((PsiElement)tag2, XmlTokenType.XML_EMPTY_ELEMENT_END) == null;
                                XmlNamespaceHelper.getHelper((PsiFile)psiFile).insertNamespaceDeclaration(psiFile, editor, Collections.singleton(ns), null, null);
                                editor.getCaretModel().moveToOffset(caretMarker.getEndOffset());
                                XmlTag rootTag = psiFile.getRootTag();
                                if (incomplete) {
                                    XmlToken token2 = XmlUtil.getTokenOfType((PsiElement)rootTag, XmlTokenType.XML_EMPTY_ELEMENT_END);
                                    if (token2 != null) {
                                        token2.delete();
                                    }
                                    PsiDocumentManager.getInstance((Project)context2.getProject()).doPostponedOperationsAndUnblockDocument(document);
                                    super.handleInsert(context2, item);
                                }
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                Object[] objectArray;
                                Object[] objectArray2 = new Object[3];
                                switch (n) {
                                    default: {
                                        objectArray = objectArray2;
                                        objectArray2[0] = "context";
                                        break;
                                    }
                                    case 1: {
                                        objectArray = objectArray2;
                                        objectArray2[0] = "item";
                                        break;
                                    }
                                }
                                objectArray[1] = "com/intellij/psi/impl/source/xml/DefaultXmlTagNameProvider$1$1";
                                objectArray[2] = "handleInsert";
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                            }
                        }));
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/xml/DefaultXmlTagNameProvider$1", "process"));
                }
            }, scope2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/xml/DefaultXmlTagNameProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addTagNameVariants";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addXmlProcessingInstructions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

