/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file.impl;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.model.ModelBranch;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.StackOverflowPreventedException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.FileTypeFileViewProviders;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.FileViewProviderFactory;
import com.intellij.psi.LanguageFileViewProviders;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.FreeThreadedFileViewProvider;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class FileManagerImpl
implements FileManager {
    private static final Key<Boolean> IN_COMA = Key.create((String)"IN_COMA");
    private static final Logger LOG = Logger.getInstance(FileManagerImpl.class);
    private final Key<FileViewProvider> myPsiHardRefKey;
    private final PsiManagerImpl myManager;
    private final NotNullLazyValue<? extends FileIndexFacade> myFileIndex;
    private final AtomicReference<ConcurrentMap<VirtualFile, PsiDirectory>> myVFileToPsiDirMap;
    private final AtomicReference<ConcurrentMap<VirtualFile, FileViewProvider>> myVFileToViewProviderMap;
    private final ThreadLocal<Map<VirtualFile, FileViewProvider>> myTempProviders;
    private final MessageBusConnection myConnection;
    private static final VirtualFile NULL = new LightVirtualFile();
    private boolean myProcessingFileTypesChange;

    public FileManagerImpl(@NotNull PsiManagerImpl manager2, @NotNull NotNullLazyValue<? extends FileIndexFacade> fileIndex) {
        if (manager2 == null) {
            FileManagerImpl.$$$reportNull$$$0(0);
        }
        if (fileIndex == null) {
            FileManagerImpl.$$$reportNull$$$0(1);
        }
        this.myPsiHardRefKey = Key.create((String)"HARD_REFERENCE_TO_PSI");
        this.myVFileToPsiDirMap = new AtomicReference();
        this.myVFileToViewProviderMap = new AtomicReference();
        this.myTempProviders = ThreadLocal.withInitial(HashMap::new);
        this.myManager = manager2;
        this.myFileIndex = fileIndex;
        this.myConnection = manager2.getProject().getMessageBus().connect((Disposable)manager2);
        LowMemoryWatcher.register(this::processQueue, (Disposable)manager2);
        this.myConnection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                FileManagerImpl.this.processFileTypesChanged(false);
            }

            public void exitDumbMode() {
                FileManagerImpl.this.processFileTypesChanged(false);
            }
        });
    }

    public void processQueue() {
        ConcurrentMap<VirtualFile, FileViewProvider> map2 = this.myVFileToViewProviderMap.get();
        if (map2 != null) {
            map2.remove(NULL);
        }
    }

    @ApiStatus.Internal
    @NotNull
    public ConcurrentMap<VirtualFile, FileViewProvider> getVFileToViewProviderMap() {
        ConcurrentMap map2 = this.myVFileToViewProviderMap.get();
        if (map2 == null) {
            map2 = (ConcurrentMap)ConcurrencyUtil.cacheOrGet(this.myVFileToViewProviderMap, (Object)ContainerUtil.createConcurrentWeakValueMap());
        }
        ConcurrentMap concurrentMap = map2;
        if (concurrentMap == null) {
            FileManagerImpl.$$$reportNull$$$0(2);
        }
        return concurrentMap;
    }

    @NotNull
    private ConcurrentMap<VirtualFile, PsiDirectory> getVFileToPsiDirMap() {
        ConcurrentMap map2 = this.myVFileToPsiDirMap.get();
        if (map2 == null) {
            map2 = (ConcurrentMap)ConcurrencyUtil.cacheOrGet(this.myVFileToPsiDirMap, (Object)ContainerUtil.createConcurrentSoftValueMap());
        }
        ConcurrentMap concurrentMap = map2;
        if (concurrentMap == null) {
            FileManagerImpl.$$$reportNull$$$0(3);
        }
        return concurrentMap;
    }

    public static void clearPsiCaches(@NotNull FileViewProvider provider2) {
        if (provider2 == null) {
            FileManagerImpl.$$$reportNull$$$0(4);
        }
        ((AbstractFileViewProvider)provider2).getCachedPsiFiles().forEach(PsiFile::clearCaches);
    }

    public void forceReload(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(5);
        }
        LanguageSubstitutors.cancelReparsing((VirtualFile)vFile);
        FileViewProvider viewProvider = this.findCachedViewProvider(vFile);
        if (viewProvider == null) {
            return;
        }
        if (!viewProvider.isEventSystemEnabled()) {
            this.setViewProvider(vFile, null);
            return;
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        VirtualFile dir = vFile.getParent();
        PsiDirectory parentDir = dir == null ? null : this.getCachedDirectory(dir);
        PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(this.myManager);
        if (parentDir == null) {
            event.setPropertyName("propUnloadedPsi");
            this.myManager.beforePropertyChange(event);
            this.setViewProvider(vFile, null);
            this.myManager.propertyChanged(event);
        } else {
            event.setParent((PsiElement)parentDir);
            this.myManager.beforeChildrenChange(event);
            this.setViewProvider(vFile, null);
            this.myManager.childrenChanged(event);
        }
    }

    public void firePropertyChangedForUnloadedPsi() {
        PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(this.myManager);
        event.setPropertyName("propUnloadedPsi");
        this.myManager.beforePropertyChange(event);
        this.myManager.propertyChanged(event);
    }

    public void dispose() {
        this.clearViewProviders();
    }

    private void clearViewProviders() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        DebugUtil.performPsiModification("clearViewProviders", () -> {
            ConcurrentMap<VirtualFile, FileViewProvider> map2 = this.myVFileToViewProviderMap.get();
            if (map2 != null) {
                for (FileViewProvider provider2 : map2.values()) {
                    this.markInvalidated(provider2);
                }
            }
            this.myVFileToViewProviderMap.set(null);
        });
    }

    @Override
    @TestOnly
    public void cleanupForNextTest() {
        ApplicationManager.getApplication().runWriteAction(this::clearViewProviders);
        this.myVFileToPsiDirMap.set(null);
        this.myManager.dropPsiCaches();
    }

    @Override
    @NotNull
    public FileViewProvider findViewProvider(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileManagerImpl.$$$reportNull$$$0(6);
        }
        assert (!file2.isDirectory());
        FileViewProvider viewProvider = this.findCachedViewProvider(file2);
        if (viewProvider != null) {
            FileViewProvider fileViewProvider = viewProvider;
            if (fileViewProvider == null) {
                FileManagerImpl.$$$reportNull$$$0(7);
            }
            return fileViewProvider;
        }
        if (file2 instanceof VirtualFileWindow) {
            throw new IllegalStateException("File " + file2 + " is invalid");
        }
        Map<VirtualFile, FileViewProvider> tempMap = this.myTempProviders.get();
        if (tempMap.containsKey(file2)) {
            FileViewProvider fileViewProvider = Objects.requireNonNull(tempMap.get(file2), "Recursive file view provider creation");
            if (fileViewProvider == null) {
                FileManagerImpl.$$$reportNull$$$0(8);
            }
            return fileViewProvider;
        }
        viewProvider = this.createFileViewProvider(file2, ModelBranch.getFileBranch((VirtualFile)file2) == null);
        if (file2 instanceof LightVirtualFile) {
            this.checkHasNoOtherPsi(file2);
            FileViewProvider fileViewProvider = (FileViewProvider)file2.putUserDataIfAbsent(this.myPsiHardRefKey, (Object)viewProvider);
            if (fileViewProvider == null) {
                FileManagerImpl.$$$reportNull$$$0(9);
            }
            return fileViewProvider;
        }
        FileViewProvider fileViewProvider = (FileViewProvider)ConcurrencyUtil.cacheOrGet(this.getVFileToViewProviderMap(), (Object)file2, (Object)viewProvider);
        if (fileViewProvider == null) {
            FileManagerImpl.$$$reportNull$$$0(10);
        }
        return fileViewProvider;
    }

    private void checkHasNoOtherPsi(@NotNull VirtualFile file2) {
        Project project;
        FileViewProvider vp;
        if (file2 == null) {
            FileManagerImpl.$$$reportNull$$$0(11);
        }
        if ((vp = FileDocumentManager.getInstance().findCachedPsiInAnyProject(file2)) != null && (project = vp.getManager().getProject()) != this.myManager.getProject()) {
            String psiFiles = vp.getAllFiles().stream().map(f -> f.getClass() + " [" + f.getLanguage() + "]").collect(Collectors.joining(", "));
            LOG.error("Light files should have PSI only in one project, existing=" + vp + " in " + project + ", requested in " + this.myManager.getProject() + "; psiFiles: " + psiFiles);
        }
    }

    @Override
    public FileViewProvider findCachedViewProvider(@NotNull VirtualFile file2) {
        FileViewProvider viewProvider;
        if (file2 == null) {
            FileManagerImpl.$$$reportNull$$$0(12);
        }
        if ((viewProvider = this.getRawCachedViewProvider(file2)) instanceof AbstractFileViewProvider && viewProvider.getUserData(IN_COMA) != null) {
            Map<VirtualFile, FileViewProvider> tempMap = this.myTempProviders.get();
            FileViewProvider temp = tempMap.get(file2);
            if (temp != null) {
                return temp;
            }
            if (!this.evaluateValidity((AbstractFileViewProvider)viewProvider)) {
                return null;
            }
        }
        return viewProvider;
    }

    @Nullable
    private FileViewProvider getRawCachedViewProvider(@NotNull VirtualFile file2) {
        ConcurrentMap<VirtualFile, FileViewProvider> map2;
        if (file2 == null) {
            FileManagerImpl.$$$reportNull$$$0(13);
        }
        FileViewProvider viewProvider = (map2 = this.myVFileToViewProviderMap.get()) == null ? null : (FileViewProvider)map2.get(file2);
        return viewProvider == null ? (FileViewProvider)file2.getUserData(this.myPsiHardRefKey) : viewProvider;
    }

    @Override
    public void setViewProvider(@NotNull VirtualFile virtualFile2, @Nullable FileViewProvider fileViewProvider) {
        FileViewProvider prev2;
        if (virtualFile2 == null) {
            FileManagerImpl.$$$reportNull$$$0(14);
        }
        if ((prev2 = this.getRawCachedViewProvider(virtualFile2)) == fileViewProvider) {
            return;
        }
        if (prev2 != null) {
            DebugUtil.performPsiModification(null, () -> this.markInvalidated(prev2));
        }
        if (fileViewProvider == null) {
            this.getVFileToViewProviderMap().remove(virtualFile2);
        } else if (virtualFile2 instanceof LightVirtualFile) {
            this.checkHasNoOtherPsi(virtualFile2);
            virtualFile2.putUserData(this.myPsiHardRefKey, (Object)fileViewProvider);
        } else {
            this.getVFileToViewProviderMap().put(virtualFile2, fileViewProvider);
        }
    }

    @Override
    @NotNull
    public FileViewProvider createFileViewProvider(@NotNull VirtualFile file2, boolean eventSystemEnabled) {
        if (file2 == null) {
            FileManagerImpl.$$$reportNull$$$0(15);
        }
        FileType fileType = file2.getFileType();
        Language language = LanguageUtil.getLanguageForPsi((Project)this.myManager.getProject(), (VirtualFile)file2, (FileType)fileType);
        FileViewProviderFactory factory2 = language == null ? (FileViewProviderFactory)FileTypeFileViewProviders.INSTANCE.forFileType(fileType) : (FileViewProviderFactory)LanguageFileViewProviders.INSTANCE.forLanguage(language);
        SingleRootFileViewProvider viewProvider = factory2 == null ? null : factory2.createFileViewProvider(file2, language, (PsiManager)this.myManager, eventSystemEnabled);
        SingleRootFileViewProvider singleRootFileViewProvider = viewProvider == null ? new SingleRootFileViewProvider((PsiManager)this.myManager, file2, eventSystemEnabled, fileType) : viewProvider;
        if (singleRootFileViewProvider == null) {
            FileManagerImpl.$$$reportNull$$$0(16);
        }
        return singleRootFileViewProvider;
    }

    void processFileTypesChanged(boolean clearViewProviders) {
        if (this.myProcessingFileTypesChange) {
            return;
        }
        this.myProcessingFileTypesChange = true;
        DebugUtil.performPsiModification(null, () -> {
            try {
                ApplicationManager.getApplication().runWriteAction(() -> {
                    PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(this.myManager);
                    event.setPropertyName("propFileTypes");
                    this.myManager.beforePropertyChange(event);
                    this.possiblyInvalidatePhysicalPsi();
                    if (clearViewProviders) {
                        this.clearViewProviders();
                    }
                    this.myManager.propertyChanged(event);
                });
            }
            finally {
                this.myProcessingFileTypesChange = false;
            }
        });
    }

    void possiblyInvalidatePhysicalPsi() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.removeInvalidDirs();
        for (FileViewProvider provider2 : this.getVFileToViewProviderMap().values()) {
            FileManagerImpl.markPossiblyInvalidated(provider2);
        }
    }

    void dispatchPendingEvents() {
        Project project = this.myManager.getProject();
        if (project.isDisposed()) {
            LOG.error("Project is already disposed: " + project);
        }
        this.myConnection.deliverImmediately();
    }

    @TestOnly
    void checkConsistency() {
        for (Object file2 : new ArrayList(this.getVFileToViewProviderMap().keySet())) {
            this.findCachedViewProvider((VirtualFile)file2);
        }
        HashMap<VirtualFile, FileViewProvider> fileToViewProvider = new HashMap<VirtualFile, FileViewProvider>(this.getVFileToViewProviderMap());
        this.myVFileToViewProviderMap.set(null);
        for (Map.Entry entry2 : fileToViewProvider.entrySet()) {
            FileViewProvider fileViewProvider = (FileViewProvider)entry2.getValue();
            VirtualFile vFile = (VirtualFile)entry2.getKey();
            LOG.assertTrue(vFile.isValid());
            PsiFile psiFile1 = this.findFile(vFile);
            if (psiFile1 == null || fileViewProvider == null || !fileViewProvider.isPhysical()) continue;
            PsiFile psi = fileViewProvider.getPsi(fileViewProvider.getBaseLanguage());
            assert (psi != null) : fileViewProvider + "; " + fileViewProvider.getBaseLanguage() + "; " + psiFile1;
            assert (psiFile1.getClass().equals(psi.getClass())) : psiFile1 + "; " + psi + "; " + psiFile1.getClass() + "; " + psi.getClass();
        }
        HashMap<VirtualFile, PsiDirectory> fileToPsiDirMap = new HashMap<VirtualFile, PsiDirectory>(this.getVFileToPsiDirMap());
        this.myVFileToPsiDirMap.set(null);
        for (VirtualFile vFile : fileToPsiDirMap.keySet()) {
            LOG.assertTrue(vFile.isValid());
            PsiDirectory psiDir1 = this.findDirectory(vFile);
            LOG.assertTrue(psiDir1 != null);
            VirtualFile parent = vFile.getParent();
            if (parent == null) continue;
            LOG.assertTrue(this.getVFileToPsiDirMap().get(parent) != null);
        }
    }

    @Override
    @Nullable
    public PsiFile findFile(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(17);
        }
        if (vFile.isDirectory()) {
            return null;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!vFile.isValid()) {
            LOG.error("Invalid file: " + vFile);
            return null;
        }
        this.dispatchPendingEvents();
        FileViewProvider viewProvider = this.findViewProvider(vFile);
        return viewProvider.getPsi(viewProvider.getBaseLanguage());
    }

    @Override
    @Nullable
    public PsiFile getCachedPsiFile(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(18);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!vFile.isValid()) {
            throw new InvalidVirtualFileAccessException(vFile);
        }
        Project project = this.myManager.getProject();
        if (project.isDisposed()) {
            LOG.error("Project is already disposed: " + project);
        }
        this.dispatchPendingEvents();
        return this.getCachedPsiFileInner(vFile);
    }

    @Override
    @Nullable
    public PsiDirectory findDirectory(@NotNull VirtualFile vFile) {
        Project project;
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(19);
        }
        if ((project = this.myManager.getProject()).isDisposed()) {
            LOG.error("Access to psi files should not be performed after project disposal: " + project);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!vFile.isValid()) {
            LOG.error("File is not valid:" + vFile);
            return null;
        }
        if (!vFile.isDirectory()) {
            return null;
        }
        this.dispatchPendingEvents();
        return this.findDirectoryImpl(vFile, this.getVFileToPsiDirMap());
    }

    @Nullable
    private PsiDirectory findDirectoryImpl(@NotNull VirtualFile vFile, @NotNull ConcurrentMap<VirtualFile, PsiDirectory> psiDirMap) {
        PsiDirectory psiDir;
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(20);
        }
        if (psiDirMap == null) {
            FileManagerImpl.$$$reportNull$$$0(21);
        }
        if ((psiDir = (PsiDirectory)psiDirMap.get(vFile)) != null) {
            return psiDir;
        }
        if (this.isExcludedOrIgnored(vFile)) {
            return null;
        }
        VirtualFile parent = vFile.getParent();
        if (parent != null) {
            this.findDirectoryImpl(parent, psiDirMap);
        }
        psiDir = PsiDirectoryFactory.getInstance(this.myManager.getProject()).createDirectory(vFile);
        return (PsiDirectory)ConcurrencyUtil.cacheOrGet(psiDirMap, (Object)vFile, (Object)psiDir);
    }

    private boolean isExcludedOrIgnored(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(22);
        }
        if (this.myManager.getProject().isDefault()) {
            return false;
        }
        FileIndexFacade fileIndexFacade = (FileIndexFacade)this.myFileIndex.getValue();
        return Registry.is((String)"ide.hide.excluded.files") ? fileIndexFacade.isExcludedFile(vFile) : fileIndexFacade.isUnderIgnored(vFile);
    }

    public PsiDirectory getCachedDirectory(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(23);
        }
        return (PsiDirectory)this.getVFileToPsiDirMap().get(vFile);
    }

    void removeFilesAndDirsRecursively(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(24);
        }
        DebugUtil.performPsiModification("removeFilesAndDirsRecursively", () -> VfsUtilCore.visitChildrenRecursively((VirtualFile)vFile, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (file2.isDirectory()) {
                    FileManagerImpl.this.getVFileToPsiDirMap().remove(file2);
                } else {
                    FileViewProvider viewProvider = (FileViewProvider)FileManagerImpl.this.getVFileToViewProviderMap().remove(file2);
                    if (viewProvider != null) {
                        FileManagerImpl.this.markInvalidated(viewProvider);
                    }
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/file/impl/FileManagerImpl$2", "visitFile"));
            }
        }));
    }

    private void markInvalidated(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            FileManagerImpl.$$$reportNull$$$0(25);
        }
        viewProvider.putUserData(IN_COMA, null);
        ((AbstractFileViewProvider)viewProvider).markInvalidated();
        viewProvider.getVirtualFile().putUserData(this.myPsiHardRefKey, null);
    }

    public static void markPossiblyInvalidated(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            FileManagerImpl.$$$reportNull$$$0(26);
        }
        LOG.assertTrue(!(viewProvider instanceof FreeThreadedFileViewProvider));
        viewProvider.putUserData(IN_COMA, (Object)true);
        ((AbstractFileViewProvider)viewProvider).markPossiblyInvalidated();
        FileManagerImpl.clearPsiCaches(viewProvider);
    }

    @Nullable
    PsiFile getCachedPsiFileInner(@NotNull VirtualFile file2) {
        FileViewProvider fileViewProvider;
        if (file2 == null) {
            FileManagerImpl.$$$reportNull$$$0(27);
        }
        return (fileViewProvider = this.findCachedViewProvider(file2)) != null ? ((AbstractFileViewProvider)fileViewProvider).getCachedPsi(fileViewProvider.getBaseLanguage()) : null;
    }

    @Override
    @NotNull
    public List<PsiFile> getAllCachedFiles() {
        ArrayList<PsiFile> files2 = new ArrayList<PsiFile>();
        for (VirtualFile file2 : new ArrayList(this.getVFileToViewProviderMap().keySet())) {
            FileViewProvider provider2 = this.findCachedViewProvider(file2);
            if (provider2 == null) continue;
            ContainerUtil.addAllNotNull(files2, ((AbstractFileViewProvider)provider2).getCachedPsiFiles());
        }
        ArrayList<PsiFile> arrayList = files2;
        if (arrayList == null) {
            FileManagerImpl.$$$reportNull$$$0(28);
        }
        return arrayList;
    }

    private void removeInvalidDirs() {
        this.myVFileToPsiDirMap.set(null);
    }

    void removeInvalidFilesAndDirs(boolean useFind) {
        this.removeInvalidDirs();
        HashMap<VirtualFile, FileViewProvider> fileToPsiFileMap = new HashMap<VirtualFile, FileViewProvider>(this.getVFileToViewProviderMap());
        HashMap<VirtualFile, FileViewProvider> originalFileToPsiFileMap = new HashMap<VirtualFile, FileViewProvider>(this.getVFileToViewProviderMap());
        if (useFind) {
            this.myVFileToViewProviderMap.set(null);
        }
        Iterator iterator2 = fileToPsiFileMap.keySet().iterator();
        while (iterator2.hasNext()) {
            VirtualFile vFile = (VirtualFile)iterator2.next();
            if (!vFile.isValid()) {
                iterator2.remove();
                continue;
            }
            FileViewProvider view = (FileViewProvider)fileToPsiFileMap.get(vFile);
            if (useFind) {
                if (view == null) {
                    iterator2.remove();
                    continue;
                }
                PsiFile psiFile1 = this.findFile(vFile);
                if (psiFile1 == null) {
                    iterator2.remove();
                    continue;
                }
                if (!FileManagerImpl.areViewProvidersEquivalent(view, psiFile1.getViewProvider())) {
                    iterator2.remove();
                    continue;
                }
                FileManagerImpl.clearPsiCaches(view);
                continue;
            }
            if (this.evaluateValidity((AbstractFileViewProvider)view)) continue;
            iterator2.remove();
        }
        this.myVFileToViewProviderMap.set(null);
        this.getVFileToViewProviderMap().putAll(fileToPsiFileMap);
        this.markInvalidations(originalFileToPsiFileMap);
    }

    static boolean areViewProvidersEquivalent(@NotNull FileViewProvider view1, @NotNull FileViewProvider view2) {
        if (view1 == null) {
            FileManagerImpl.$$$reportNull$$$0(29);
        }
        if (view2 == null) {
            FileManagerImpl.$$$reportNull$$$0(30);
        }
        if (view1.getClass() != view2.getClass() || view1.getFileType() != view2.getFileType()) {
            return false;
        }
        Language baseLanguage = view1.getBaseLanguage();
        if (baseLanguage != view2.getBaseLanguage()) {
            return false;
        }
        if (!view1.getLanguages().equals(view2.getLanguages())) {
            return false;
        }
        PsiFile psi1 = view1.getPsi(baseLanguage);
        PsiFile psi2 = view2.getPsi(baseLanguage);
        if (psi1 == null || psi2 == null) {
            return psi1 == psi2;
        }
        return psi1.getClass() == psi2.getClass();
    }

    private void markInvalidations(@NotNull Map<VirtualFile, FileViewProvider> originalFileToPsiFileMap) {
        if (originalFileToPsiFileMap == null) {
            FileManagerImpl.$$$reportNull$$$0(31);
        }
        if (!originalFileToPsiFileMap.isEmpty()) {
            DebugUtil.performPsiModification(null, () -> {
                for (Map.Entry entry2 : originalFileToPsiFileMap.entrySet()) {
                    FileViewProvider viewProvider = (FileViewProvider)entry2.getValue();
                    if (this.getVFileToViewProviderMap().get(entry2.getKey()) == viewProvider) continue;
                    this.markInvalidated(viewProvider);
                }
            });
        }
    }

    @Override
    public void reloadFromDisk(@NotNull PsiFile file2) {
        if (file2 == null) {
            FileManagerImpl.$$$reportNull$$$0(32);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        VirtualFile vFile = file2.getVirtualFile();
        assert (vFile != null);
        Document document = FileDocumentManager.getInstance().getCachedDocument(vFile);
        if (document != null) {
            FileDocumentManager.getInstance().reloadFromDisk(document);
        } else {
            this.reloadPsiAfterTextChange(file2.getViewProvider(), vFile);
        }
    }

    void reloadPsiAfterTextChange(@NotNull FileViewProvider viewProvider, @NotNull VirtualFile vFile) {
        if (viewProvider == null) {
            FileManagerImpl.$$$reportNull$$$0(33);
        }
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(34);
        }
        if (!FileManagerImpl.areViewProvidersEquivalent(viewProvider, this.createFileViewProvider(vFile, false))) {
            this.forceReload(vFile);
            return;
        }
        ((AbstractFileViewProvider)viewProvider).onContentReload();
    }

    public boolean evaluateValidity(@NotNull PsiFile file2) {
        AbstractFileViewProvider vp;
        if (file2 == null) {
            FileManagerImpl.$$$reportNull$$$0(35);
        }
        return this.evaluateValidity(vp = (AbstractFileViewProvider)file2.getViewProvider()) && vp.getCachedPsiFiles().contains(file2);
    }

    private boolean evaluateValidity(@NotNull AbstractFileViewProvider viewProvider) {
        if (viewProvider == null) {
            FileManagerImpl.$$$reportNull$$$0(36);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        VirtualFile file2 = viewProvider.getVirtualFile();
        if (this.getRawCachedViewProvider(file2) != viewProvider) {
            return false;
        }
        if (viewProvider.getUserData(IN_COMA) == null) {
            return true;
        }
        if (this.shouldResurrect(viewProvider, file2)) {
            viewProvider.putUserData(IN_COMA, null);
            LOG.assertTrue(this.getRawCachedViewProvider(file2) == viewProvider);
            for (PsiFile psiFile : viewProvider.getCachedPsiFiles()) {
                if (psiFile.isValid()) continue;
                LOG.error((Throwable)new PsiInvalidElementAccessException((PsiElement)psiFile));
            }
            return true;
        }
        this.getVFileToViewProviderMap().remove(file2, (Object)viewProvider);
        file2.replace(this.myPsiHardRefKey, (Object)viewProvider, null);
        viewProvider.putUserData(IN_COMA, null);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldResurrect(@NotNull FileViewProvider viewProvider, @NotNull VirtualFile file2) {
        if (viewProvider == null) {
            FileManagerImpl.$$$reportNull$$$0(37);
        }
        if (file2 == null) {
            FileManagerImpl.$$$reportNull$$$0(38);
        }
        if (!file2.isValid()) {
            return false;
        }
        Map<VirtualFile, FileViewProvider> tempProviders = this.myTempProviders.get();
        if (tempProviders.containsKey(file2)) {
            LOG.error((Throwable)new StackOverflowPreventedException("isValid leads to endless recursion in " + viewProvider.getClass() + ": " + new ArrayList(viewProvider.getLanguages())));
        }
        tempProviders.put(file2, null);
        try {
            FileViewProvider recreated = this.createFileViewProvider(file2, true);
            tempProviders.put(file2, recreated);
            boolean bl = FileManagerImpl.areViewProvidersEquivalent(viewProvider, recreated) && !ContainerUtil.exists(((AbstractFileViewProvider)viewProvider).getCachedPsiFiles(), FileManagerImpl::hasInvalidOriginal);
            return bl;
        }
        finally {
            FileViewProvider temp = tempProviders.remove(file2);
            if (temp != null) {
                DebugUtil.performPsiModification("invalidate temp view provider", ((AbstractFileViewProvider)temp)::markInvalidated);
            }
        }
    }

    private static boolean hasInvalidOriginal(@NotNull PsiFile file2) {
        PsiFile original;
        if (file2 == null) {
            FileManagerImpl.$$$reportNull$$$0(39);
        }
        return (original = file2.getOriginalFile()) != file2 && !original.isValid();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileIndex";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/file/impl/FileManagerImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 5: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 27: 
            case 32: 
            case 35: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiDirMap";
                break;
            }
            case 25: 
            case 26: 
            case 33: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view1";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view2";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFileToPsiFileMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/file/impl/FileManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVFileToViewProviderMap";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVFileToPsiDirMap";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findViewProvider";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileViewProvider";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllCachedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 28: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "clearPsiCaches";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "forceReload";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findViewProvider";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkHasNoOtherPsi";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findCachedViewProvider";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getRawCachedViewProvider";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setViewProvider";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createFileViewProvider";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getCachedPsiFile";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findDirectory";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findDirectoryImpl";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isExcludedOrIgnored";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getCachedDirectory";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "removeFilesAndDirsRecursively";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "markInvalidated";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "markPossiblyInvalidated";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getCachedPsiFileInner";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "areViewProvidersEquivalent";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "markInvalidations";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "reloadFromDisk";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "reloadPsiAfterTextChange";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "evaluateValidity";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "shouldResurrect";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "hasInvalidOriginal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

