/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NonNls;

public class XmlTextFilter
implements ElementFilter {
    protected final String[] myValue;

    public XmlTextFilter(@NonNls String value2) {
        this.myValue = new String[1];
        this.myValue[0] = value2;
    }

    public XmlTextFilter(String ... values2) {
        this.myValue = values2;
    }

    public boolean isClassAcceptable(Class hintClass) {
        return true;
    }

    public boolean isAcceptable(Object element2, PsiElement context2) {
        if (element2 != null) {
            String text2 = this.getTextByElement(element2);
            for (String value2 : this.myValue) {
                if (value2 != null && !value2.equals(text2)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        Object ret = "(";
        for (int i2 = 0; i2 < this.myValue.length; ++i2) {
            ret = (String)ret + this.myValue[i2];
            if (i2 >= this.myValue.length - 1) continue;
            ret = (String)ret + " | ";
        }
        ret = (String)ret + ")";
        return ret;
    }

    protected String getTextByElement(Object element2) {
        String elementValue = null;
        if (element2 instanceof PsiNamedElement) {
            elementValue = element2 instanceof XmlTag ? ((XmlTag)element2).getLocalName() : ((PsiNamedElement)element2).getName();
        } else if (element2 instanceof PsiElement) {
            elementValue = ((PsiElement)element2).getText();
        }
        return elementValue;
    }
}

