/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.treetable;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public final class TreeExpandedPaths {
    private final List<TreePath> myExpandedPath;
    private final JTree myTree;

    private TreeExpandedPaths(JTree tree, TreePath path2) {
        this.myTree = tree;
        this.myExpandedPath = TreeUtil.collectExpandedPaths((JTree)tree, (TreePath)path2);
    }

    public static TreeExpandedPaths createOn(JTree tree, TreePath path2) {
        return new TreeExpandedPaths(tree, path2);
    }

    public TreeExpandedPaths with(TreePath ... somePaths) {
        ContainerUtil.addAll(this.myExpandedPath, (Object[])somePaths);
        return this;
    }

    public TreeExpandedPaths updateAny(TreePathReplacer replacer) {
        for (int i2 = 0; i2 < this.myExpandedPath.size(); ++i2) {
            TreePath newPath;
            TreePath oldPath = this.myExpandedPath.get(i2);
            if (oldPath == (newPath = replacer.replace(oldPath))) continue;
            this.myExpandedPath.set(i2, newPath);
        }
        return this;
    }

    public List<TreePath> getPaths() {
        return this.myExpandedPath;
    }

    public int getSize() {
        return this.myExpandedPath.size();
    }

    public static TreePath requireExists(JTree tree, TreePath path2) {
        Object[] thePath = path2.getPath();
        for (int i2 = 1; i2 < thePath.length; ++i2) {
            int index2 = tree.getModel().getIndexOfChild(thePath[i2 - 1], thePath[i2]);
            if (index2 >= 0) continue;
            throw new IllegalStateException("TreePath is not exists. Fail on " + thePath[i2 - 1] + " and " + thePath[i2]);
        }
        return path2;
    }

    @FunctionalInterface
    public static interface TreePathReplacer {
        public TreePath replace(TreePath var1);
    }
}

