/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.flamegraph;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.ui.flamegraph.FlameGraphPanel;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\bB\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/profiler/ui/flamegraph/CaptureImageActionGroup;", "T", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "flameGraphPanel", "Lcom/intellij/profiler/ui/flamegraph/FlameGraphPanel;", "(Lcom/intellij/profiler/ui/flamegraph/FlameGraphPanel;)V", "createImage", "Ljava/awt/image/BufferedImage;", "ImageTransferable", "intellij.profiler.common"})
public class CaptureImageActionGroup<T>
extends DefaultActionGroup {
    private final FlameGraphPanel<T> flameGraphPanel;

    @NotNull
    public final BufferedImage createImage() {
        Rectangle bounds2 = this.flameGraphPanel.getVisibleRect();
        BufferedImage bufferedImage = UIUtil.createImage((Component)((Component)((Object)this.flameGraphPanel)), (int)bounds2.width, (int)bounds2.height, (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"UIUtil.createImage(flame\u2026fferedImage.TYPE_INT_RGB)");
        BufferedImage image = bufferedImage;
        Graphics2D graphics = image.createGraphics();
        graphics.translate(-bounds2.x, -bounds2.y);
        this.flameGraphPanel.paint(graphics);
        return image;
    }

    public CaptureImageActionGroup(@NotNull FlameGraphPanel<T> flameGraphPanel) {
        Intrinsics.checkNotNullParameter(flameGraphPanel, (String)"flameGraphPanel");
        this.flameGraphPanel = flameGraphPanel;
        Presentation presentation2 = this.getTemplatePresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"templatePresentation");
        presentation2.setIcon(AllIcons.Actions.Dump);
        Presentation presentation3 = this.getTemplatePresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation3, (String)"templatePresentation");
        presentation3.setText(CommonProfilerBundleKt.profilerMessage("ui.flamechart.actions.capture", new Object[0]));
        this.setPopup(true);
        this.add((AnAction)new DumbAwareAction(CommonProfilerBundleKt.profilerMessage("ui.flamechart.actions.capture.toClipboard", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                CopyPasteManager.getInstance().setContents((Transferable)new ImageTransferable(this.createImage()));
            }
        });
        this.add((AnAction)new DumbAwareAction(CommonProfilerBundleKt.profilerMessage("ui.flamechart.actions.capture.save", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                FileSaverDescriptor descriptor2 = new FileSaverDescriptor(CommonProfilerBundleKt.profilerMessage("ui.flamechart.actions.capture.saveImage", new Object[0]), CommonProfilerBundleKt.profilerMessage("ui.flamechart.actions.capture.saveImage", new Object[0]), new String[]{"png"});
                FileSaverDialog fileSaverDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor2, e.getProject());
                Intrinsics.checkNotNullExpressionValue((Object)fileSaverDialog, (String)"FileChooserFactory.getIn\u2026og(descriptor, e.project)");
                FileSaverDialog dialog2 = fileSaverDialog;
                VirtualFileWrapper file2 = dialog2.save("flamegraph.png");
                if (file2 != null) {
                    ImageIO.write((RenderedImage)this.createImage(), "png", file2.getFile());
                }
            }
        });
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0013\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0016\u00a2\u0006\u0002\u0010\rJ\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/intellij/profiler/ui/flamegraph/CaptureImageActionGroup$ImageTransferable;", "Ljava/awt/datatransfer/Transferable;", "image", "Ljava/awt/image/BufferedImage;", "(Ljava/awt/image/BufferedImage;)V", "getImage", "()Ljava/awt/image/BufferedImage;", "getTransferData", "", "flavor", "Ljava/awt/datatransfer/DataFlavor;", "getTransferDataFlavors", "", "()[Ljava/awt/datatransfer/DataFlavor;", "isDataFlavorSupported", "", "intellij.profiler.common"})
    private static final class ImageTransferable
    implements Transferable {
        @NotNull
        private final BufferedImage image;

        @Override
        @NotNull
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] dataFlavorArray = new DataFlavor[1];
            DataFlavor dataFlavor = DataFlavor.imageFlavor;
            Intrinsics.checkNotNullExpressionValue((Object)dataFlavor, (String)"DataFlavor.imageFlavor");
            dataFlavorArray[0] = dataFlavor;
            return dataFlavorArray;
        }

        @Override
        public boolean isDataFlavorSupported(@Nullable DataFlavor flavor) {
            return DataFlavor.imageFlavor.equals(flavor);
        }

        @Override
        @NotNull
        public Object getTransferData(@Nullable DataFlavor flavor) {
            if (!this.isDataFlavorSupported(flavor)) {
                throw (Throwable)new UnsupportedFlavorException(flavor);
            }
            return this.image;
        }

        @NotNull
        public final BufferedImage getImage() {
            return this.image;
        }

        public ImageTransferable(@NotNull BufferedImage image) {
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            this.image = image;
        }
    }
}

