/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.callusage;

import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.CommonProfilerUISettings;
import com.intellij.profiler.CommonProfilerUiOptions;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.api.ValueMetric;
import com.intellij.profiler.model.CallTreeNode;
import com.intellij.profiler.model.CallWithValue;
import com.intellij.profiler.ui.BaseCallStackElementRenderer;
import com.intellij.profiler.ui.callusage.FlameChartColorsRenderer;
import com.intellij.profiler.ui.callusage.UIVisibleCallTreeNode;
import com.intellij.profiler.ui.flamechart.ColorType;
import com.intellij.profiler.ui.flamechart.FlameChartColorScheme;
import com.intellij.profiler.ui.flamechart.FlameChartColors;
import com.intellij.profiler.ui.flamegraph.CallUsageNodeFlameGraphModel;
import com.intellij.profiler.ui.flamegraph.DefaultFlameGraphRenderer;
import com.intellij.profiler.ui.flamegraph.FlameGraphModel;
import com.intellij.profiler.ui.flamegraph.FlameGraphNode;
import com.intellij.profiler.ui.flamegraph.FlameGraphPanel;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 12\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u0001:\u00011B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ8\u0010\u0012\u001a\u00020\u00132\u0016\u0010\u0014\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u00152\u0016\u0010\u0016\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u0017H\u0002J(\u0010\u0018\u001a\u00020\u00192\u0016\u0010\u0014\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J8\u0010\u001c\u001a\u00020\u00132\u0016\u0010\u0014\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u00152\u0016\u0010\u0016\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u0017H\u0002J8\u0010\u001d\u001a\u00020\r2\u0016\u0010\u0014\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u00152\u0016\u0010\u001e\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u0017H\u0002J8\u0010\u001f\u001a\u00020 2\u0016\u0010\u0014\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u00152\u0016\u0010\u0016\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u0017H\u0014J:\u0010!\u001a\u0004\u0018\u00010 2\u0016\u0010\u0014\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u00152\u0016\u0010\u0016\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u0017H\u0014J4\u0010\"\u001a\u0004\u0018\u00010#2\u0016\u0010$\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040%2\u0010\u0010\u001e\u001a\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0004H\u0017J4\u0010&\u001a\u0004\u0018\u00010#2\u0016\u0010$\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040%2\u0010\u0010\u001e\u001a\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0004H\u0016J8\u0010'\u001a\u00020(2\u0016\u0010\u0014\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u00152\u0016\u0010\u0016\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u0017H\u0002J@\u0010)\u001a\u00020\u00192\u0016\u0010\u0014\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0016\u0010\u0016\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u0017H\u0014J4\u0010*\u001a\u0004\u0018\u00010 *\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u00172\u0014\u0010+\u001a\u0010\u0012\u0004\u0012\u00020-\u0012\u0006\u0012\u0004\u0018\u00010 0,H\u0002J\u001c\u0010.\u001a\u00020 *\u0004\u0018\u00010 2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020 00H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/profiler/ui/callusage/FlameChartColorsRenderer;", "Lcom/intellij/profiler/ui/flamegraph/DefaultFlameGraphRenderer;", "Lcom/intellij/profiler/model/CallTreeNode;", "Lcom/intellij/profiler/api/BaseCallStackElement;", "Lcom/intellij/profiler/ui/callusage/CallUsageNode;", "baseRenderer", "Lcom/intellij/profiler/ui/BaseCallStackElementRenderer;", "metric", "Lcom/intellij/profiler/api/ValueMetric;", "(Lcom/intellij/profiler/ui/BaseCallStackElementRenderer;Lcom/intellij/profiler/api/ValueMetric;)V", "ellipsisStringWidth", "", "filterValue", "", "getFilterValue", "()D", "setFilterValue", "(D)V", "backgroundType", "Lcom/intellij/profiler/ui/flamechart/ColorType;", "component", "Lcom/intellij/profiler/ui/flamegraph/FlameGraphPanel;", "bounds", "Lcom/intellij/profiler/ui/flamegraph/FlameGraphNode;", "beforePaint", "", "g", "Ljava/awt/Graphics2D;", "foregroundType", "fractionOfAllCallsForGraphNode", "node", "getBackgroundColor", "Ljava/awt/Color;", "getBorderColor", "getDisplayableText", "", "model", "Lcom/intellij/profiler/ui/flamegraph/FlameGraphModel;", "getTooltipText", "isShadowed", "", "paintText", "getColor", "colorFunction", "Lkotlin/Function1;", "Lcom/intellij/profiler/ui/flamechart/FlameChartColorScheme;", "orDefault", "producer", "Lkotlin/Function0;", "Companion", "intellij.profiler.common"})
public final class FlameChartColorsRenderer
extends DefaultFlameGraphRenderer<CallTreeNode<BaseCallStackElement>> {
    private double filterValue;
    private int ellipsisStringWidth;
    private final BaseCallStackElementRenderer baseRenderer;
    private final ValueMetric metric;
    private static final Color TRANSPARENT;
    @NotNull
    public static final Companion Companion;

    public final double getFilterValue() {
        return this.filterValue;
    }

    public final void setFilterValue(double d) {
        this.filterValue = d;
    }

    @Override
    @Nls
    @Nullable
    public String getDisplayableText(@NotNull FlameGraphModel<CallTreeNode<BaseCallStackElement>> model2, @NotNull CallTreeNode<BaseCallStackElement> node2) {
        String string;
        Intrinsics.checkNotNullParameter(model2, (String)"model");
        Intrinsics.checkNotNullParameter(node2, (String)"node");
        Object object = (CallWithValue)node2.getData();
        if (object != null && (object = (BaseCallStackElement)object.getCall()) != null) {
            Object object2 = object;
            BaseCallStackElementRenderer baseCallStackElementRenderer = this.baseRenderer;
            boolean bl = false;
            boolean bl2 = false;
            Object p1 = object2;
            boolean bl3 = false;
            string = baseCallStackElementRenderer.getText((BaseCallStackElement)p1);
        } else {
            string = null;
        }
        return string;
    }

    @Override
    public void beforePaint(@NotNull FlameGraphPanel<CallTreeNode<BaseCallStackElement>> component2, @NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter(component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        super.beforePaint(component2, g);
        this.ellipsisStringWidth = g.getFontMetrics().stringWidth("...");
    }

    @Override
    protected void paintText(@NotNull FlameGraphPanel<CallTreeNode<BaseCallStackElement>> component2, @NotNull Graphics2D g, @NotNull FlameGraphNode<CallTreeNode<BaseCallStackElement>> bounds2) {
        block5: {
            Object object;
            int y;
            int x;
            block7: {
                block6: {
                    Intrinsics.checkNotNullParameter(component2, (String)"component");
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    Intrinsics.checkNotNullParameter(bounds2, (String)"bounds");
                    int boundsWidth = FlameGraphPanel.calculateWidth$default(component2, bounds2, 0, 2, null);
                    int boundsHeight = component2.calculateHeight(bounds2);
                    if (boundsWidth < this.ellipsisStringWidth) {
                        return;
                    }
                    ColorType foregroundType = this.foregroundType(component2, bounds2);
                    g.setColor(new Color((this.filterValue > 0.0 && this.fractionOfAllCallsForGraphNode(component2, bounds2) <= this.filterValue ? (Color)FlameChartColors.PALE.INSTANCE.color(foregroundType) : this.orDefault(this.getColor(bounds2, (Function1<? super FlameChartColorScheme, ? extends Color>)((Function1)new Function1<FlameChartColorScheme, Color>(foregroundType){
                        final /* synthetic */ ColorType $foregroundType;

                        @Nullable
                        public final Color invoke(@NotNull FlameChartColorScheme it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return (Color)it.color(this.$foregroundType);
                        }
                        {
                            this.$foregroundType = colorType;
                            super(1);
                        }
                    })), (Function0<? extends Color>)((Function0)new Function0<Color>(foregroundType){
                        final /* synthetic */ ColorType $foregroundType;

                        @NotNull
                        public final Color invoke() {
                            return (Color)FlameChartColors.PARENT.INSTANCE.color(this.$foregroundType);
                        }
                        {
                            this.$foregroundType = colorType;
                            super(0);
                        }
                    }))).getRGB()));
                    CallWithValue callWithValue = (CallWithValue)bounds2.getContent().getData();
                    BaseCallStackElement callStackElement = callWithValue != null ? (BaseCallStackElement)callWithValue.getCall() : null;
                    int pad = JBUI.scale((int)2);
                    if (component2.getSearchResultNode() == bounds2) {
                        g.setFont(g.getFont().deriveFont(1));
                    }
                    FontMetrics fm = g.getFontMetrics(g.getFont());
                    x = (((CommonProfilerUiOptions)CommonProfilerUISettings.Companion.getInstance().getState()).getFlameGraphState().getStickyText() ? g.getClipBounds().x : 0) + pad;
                    int n = boundsHeight / 2;
                    FontMetrics fontMetrics = fm;
                    Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"fm");
                    y = n + fontMetrics.getAscent() * 2 / 5;
                    Rectangle r = new Rectangle(x, y, boundsWidth - x, component2.getHeight());
                    if (r.width <= this.ellipsisStringWidth) break block5;
                    object = callStackElement;
                    if (object == null) break block6;
                    BaseCallStackElement baseCallStackElement = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    BaseCallStackElement it = baseCallStackElement;
                    boolean bl3 = false;
                    Rectangle2D rectangle2D = r;
                    FontMetrics fontMetrics2 = g.getFontMetrics();
                    Intrinsics.checkNotNullExpressionValue((Object)fontMetrics2, (String)"g.fontMetrics");
                    object = this.baseRenderer.fillTextInsideNode(it, rectangle2D, fontMetrics2);
                    if (object != null) break block7;
                }
                object = bounds2.getDepth() <= 1 ? "all" : "";
            }
            Object str = object;
            g.drawString((String)str, x, y);
        }
    }

    private final Color getColor(FlameGraphNode<CallTreeNode<BaseCallStackElement>> $this$getColor, Function1<? super FlameChartColorScheme, ? extends Color> colorFunction) {
        Color color;
        Object object = (CallWithValue)$this$getColor.getContent().getData();
        if (object != null && (object = (BaseCallStackElement)object.getCall()) != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            color = (Color)colorFunction.invoke((Object)this.baseRenderer.getColorScheme((BaseCallStackElement)it));
        } else {
            color = null;
        }
        return color;
    }

    private final Color orDefault(Color $this$orDefault, Function0<? extends Color> producer) {
        Color color = $this$orDefault;
        if (color == null) {
            color = (Color)producer.invoke();
        }
        return color;
    }

    @Override
    @Nullable
    public String getTooltipText(@NotNull FlameGraphModel<CallTreeNode<BaseCallStackElement>> model2, @NotNull CallTreeNode<BaseCallStackElement> node2) {
        Intrinsics.checkNotNullParameter(model2, (String)"model");
        Intrinsics.checkNotNullParameter(node2, (String)"node");
        String string = this.getDisplayableText(model2, node2);
        if (string == null) {
            return null;
        }
        String text2 = string;
        UIVisibleCallTreeNode<BaseCallStackElement> uiVisibleNode = ((CallUsageNodeFlameGraphModel)model2).getUIVisibleNode(node2);
        return new HtmlBuilder().append((HtmlChunk)HtmlChunk.div((String)"font-weight: bold").addText(text2)).append((HtmlChunk)HtmlChunk.div().addText(CommonProfilerBundleKt.profilerMessage("ui.flamechart.tooltip.parentAndAll", this.metric.print(uiVisibleNode.getValue(), true), Float.valueOf((float)((int)(uiVisibleNode.getFractionOfParentCall() * (double)10000)) / 100.0f), Float.valueOf((float)((int)(uiVisibleNode.getFractionOfAllCalls() * (double)10000)) / 100.0f)))).wrapWithHtmlBody().toString();
    }

    @Override
    @NotNull
    protected Color getBackgroundColor(@NotNull FlameGraphPanel<CallTreeNode<BaseCallStackElement>> component2, @NotNull FlameGraphNode<CallTreeNode<BaseCallStackElement>> bounds2) {
        Intrinsics.checkNotNullParameter(component2, (String)"component");
        Intrinsics.checkNotNullParameter(bounds2, (String)"bounds");
        ColorType backgroundType = this.backgroundType(component2, bounds2);
        return this.filterValue > 0.0 && this.fractionOfAllCallsForGraphNode(component2, bounds2) <= this.filterValue ? (Color)FlameChartColors.PALE.INSTANCE.color(backgroundType) : this.orDefault(this.getColor(bounds2, (Function1<? super FlameChartColorScheme, ? extends Color>)((Function1)new Function1<FlameChartColorScheme, Color>(backgroundType){
            final /* synthetic */ ColorType $backgroundType;

            @Nullable
            public final Color invoke(@NotNull FlameChartColorScheme it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (Color)it.color(this.$backgroundType);
            }
            {
                this.$backgroundType = colorType;
                super(1);
            }
        })), (Function0<? extends Color>)((Function0)new Function0<Color>(backgroundType){
            final /* synthetic */ ColorType $backgroundType;

            @NotNull
            public final Color invoke() {
                return (Color)FlameChartColors.PARENT.INSTANCE.color(this.$backgroundType);
            }
            {
                this.$backgroundType = colorType;
                super(0);
            }
        }));
    }

    private final double fractionOfAllCallsForGraphNode(FlameGraphPanel<CallTreeNode<BaseCallStackElement>> component2, FlameGraphNode<CallTreeNode<BaseCallStackElement>> node2) {
        FlameGraphModel<CallTreeNode<BaseCallStackElement>> flameGraphModel = component2.getModel();
        if (flameGraphModel == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.profiler.ui.flamegraph.CallUsageNodeFlameGraphModel<com.intellij.profiler.api.BaseCallStackElement>");
        }
        UIVisibleCallTreeNode<BaseCallStackElement> uiVisibleNode = ((CallUsageNodeFlameGraphModel)flameGraphModel).getUIVisibleNode(node2.getContent());
        return uiVisibleNode.getFractionOfAllCalls();
    }

    @Override
    @Nullable
    protected Color getBorderColor(@NotNull FlameGraphPanel<CallTreeNode<BaseCallStackElement>> component2, @NotNull FlameGraphNode<CallTreeNode<BaseCallStackElement>> bounds2) {
        Intrinsics.checkNotNullParameter(component2, (String)"component");
        Intrinsics.checkNotNullParameter(bounds2, (String)"bounds");
        if (component2.getSearchResultNode() == bounds2) {
            Color color;
            Color color2 = this.getColor(bounds2, (Function1<? super FlameChartColorScheme, ? extends Color>)((Function1)getBorderColor.1.INSTANCE));
            if (color2 != null) {
                Color color3 = color2;
                boolean bl = false;
                boolean bl2 = false;
                Color it = color3;
                boolean bl3 = false;
                color = it != TRANSPARENT ? color3 : null;
            } else {
                color = null;
            }
            return color;
        }
        return super.getBorderColor(component2, bounds2);
    }

    private final ColorType foregroundType(FlameGraphPanel<CallTreeNode<BaseCallStackElement>> component2, FlameGraphNode<CallTreeNode<BaseCallStackElement>> bounds2) {
        return ColorType.Companion.findForegroundType(component2.getHighlightedNode() == bounds2, this.isShadowed(component2, bounds2));
    }

    private final ColorType backgroundType(FlameGraphPanel<CallTreeNode<BaseCallStackElement>> component2, FlameGraphNode<CallTreeNode<BaseCallStackElement>> bounds2) {
        boolean search2 = component2.isSearchActive();
        boolean search_ok = search2 && component2.isMatchingSearch(bounds2);
        boolean focus = component2.getHighlightedNode() == bounds2;
        boolean shadow2 = this.isShadowed(component2, bounds2);
        return ColorType.Companion.findBackgroundType(search2, search_ok, focus, shadow2);
    }

    private final boolean isShadowed(FlameGraphPanel<CallTreeNode<BaseCallStackElement>> component2, FlameGraphNode<CallTreeNode<BaseCallStackElement>> bounds2) {
        FlameGraphNode<CallTreeNode<BaseCallStackElement>> flameGraphNode = component2.getSelectedNode();
        if (flameGraphNode == null) {
            return false;
        }
        FlameGraphNode<CallTreeNode<BaseCallStackElement>> selectedNode = flameGraphNode;
        boolean isDepthIsNotLess = selectedNode.getDepth() <= bounds2.getDepth();
        boolean isBoundsAreInIt = bounds2.getStart() >= selectedNode.getStart() && bounds2.getEnd() <= selectedNode.getEnd();
        return !isDepthIsNotLess || !isBoundsAreInIt;
    }

    public FlameChartColorsRenderer(@NotNull BaseCallStackElementRenderer baseRenderer, @NotNull ValueMetric metric) {
        Intrinsics.checkNotNullParameter((Object)baseRenderer, (String)"baseRenderer");
        Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
        this.baseRenderer = baseRenderer;
        this.metric = metric;
    }

    static {
        Companion = new Companion(null);
        TRANSPARENT = new Color(0, 0, 0, 0);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/profiler/ui/callusage/FlameChartColorsRenderer$Companion;", "", "()V", "TRANSPARENT", "Ljava/awt/Color;", "intellij.profiler.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

