/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui;

import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.api.ValueMetric;
import com.intellij.profiler.model.CalleesListItem;
import com.intellij.profiler.ui.BaseCallStackElementRenderer;
import com.intellij.profiler.ui.callusage.CallUsageTableCellRenderer;
import com.intellij.profiler.ui.callusage.Percentage;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.ui.ColumnInfo;
import java.util.Comparator;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u0000*\u0004\b\u0000\u0010\u00012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0004\u0012\u0002H\u00010\u0002:\u0003\u0015\u0016\u0017B\u0019\b\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0001\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0014\u0010\u0010\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u0082\u0001\u0003\u0018\u0019\u001a\u00a8\u0006\u001b"}, d2={"Lcom/intellij/profiler/ui/CalleesListColumn;", "Aspect", "Lcom/intellij/util/ui/ColumnInfo;", "Lcom/intellij/profiler/model/CalleesListItem;", "Lcom/intellij/profiler/api/BaseCallStackElement;", "metric", "Lcom/intellij/profiler/api/ValueMetric;", "name", "", "(Lcom/intellij/profiler/api/ValueMetric;Ljava/lang/String;)V", "getMetric", "()Lcom/intellij/profiler/api/ValueMetric;", "renderer", "Ljavax/swing/table/TableCellRenderer;", "getRenderer", "()Ljavax/swing/table/TableCellRenderer;", "printValue", "", "Lcom/intellij/ui/ColoredTableCellRenderer;", "value", "", "MethodNameColumn", "OwnValueColumn", "ValueColumn", "Lcom/intellij/profiler/ui/CalleesListColumn$MethodNameColumn;", "Lcom/intellij/profiler/ui/CalleesListColumn$ValueColumn;", "Lcom/intellij/profiler/ui/CalleesListColumn$OwnValueColumn;", "intellij.profiler.common"})
abstract class CalleesListColumn<Aspect>
extends ColumnInfo<CalleesListItem<BaseCallStackElement>, Aspect> {
    @NotNull
    private final ValueMetric metric;

    @NotNull
    protected abstract TableCellRenderer getRenderer();

    protected final void printValue(@NotNull ColoredTableCellRenderer $this$printValue, long value2) {
        Intrinsics.checkNotNullParameter((Object)$this$printValue, (String)"$this$printValue");
        $this$printValue.setBorder((Border)null);
        $this$printValue.setTextAlign(4);
        $this$printValue.append(this.metric.print(value2, false));
    }

    @NotNull
    public final ValueMetric getMetric() {
        return this.metric;
    }

    private CalleesListColumn(ValueMetric metric, @Nls String name) {
        super(name);
        this.metric = metric;
    }

    public /* synthetic */ CalleesListColumn(ValueMetric metric, String name, DefaultConstructorMarker $constructor_marker) {
        this(metric, name);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00100\u000fH\u0016J\u0018\u0010\f\u001a\u00020\u000b2\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0010H\u0016J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0010H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lcom/intellij/profiler/ui/CalleesListColumn$MethodNameColumn;", "Lcom/intellij/profiler/ui/CalleesListColumn;", "Lcom/intellij/profiler/api/BaseCallStackElement;", "delegate", "Lcom/intellij/profiler/ui/BaseCallStackElementRenderer;", "metric", "Lcom/intellij/profiler/api/ValueMetric;", "(Lcom/intellij/profiler/ui/BaseCallStackElementRenderer;Lcom/intellij/profiler/api/ValueMetric;)V", "getDelegate", "()Lcom/intellij/profiler/ui/BaseCallStackElementRenderer;", "renderer", "Lcom/intellij/ui/ColoredTableCellRenderer;", "getRenderer", "()Lcom/intellij/ui/ColoredTableCellRenderer;", "getComparator", "Ljava/util/Comparator;", "Lcom/intellij/profiler/model/CalleesListItem;", "item", "valueOf", "intellij.profiler.common"})
    public static final class MethodNameColumn
    extends CalleesListColumn<BaseCallStackElement> {
        @NotNull
        private final ColoredTableCellRenderer renderer;
        @NotNull
        private final BaseCallStackElementRenderer delegate;

        @NotNull
        protected ColoredTableCellRenderer getRenderer() {
            return this.renderer;
        }

        @Nullable
        public BaseCallStackElement valueOf(@Nullable CalleesListItem<BaseCallStackElement> item) {
            CalleesListItem<BaseCallStackElement> calleesListItem = item;
            return calleesListItem != null ? calleesListItem.getCall() : null;
        }

        @NotNull
        public ColoredTableCellRenderer getRenderer(@Nullable CalleesListItem<BaseCallStackElement> item) {
            return this.getRenderer();
        }

        @NotNull
        public Comparator<CalleesListItem<BaseCallStackElement>> getComparator() {
            boolean bl = false;
            return new Comparator<T>(this){
                final /* synthetic */ MethodNameColumn this$0;
                {
                    this.this$0 = methodNameColumn;
                }

                public final int compare(T a, T b) {
                    boolean bl = false;
                    CalleesListItem it = (CalleesListItem)a;
                    boolean bl2 = false;
                    Comparable comparable = (Comparable)((Object)this.this$0.getDelegate().getText((BaseCallStackElement)it.getCall()));
                    it = (CalleesListItem)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Comparable comparable3 = (Comparable)((Object)this.this$0.getDelegate().getText((BaseCallStackElement)it.getCall()));
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
                }
            };
        }

        @NotNull
        public final BaseCallStackElementRenderer getDelegate() {
            return this.delegate;
        }

        public MethodNameColumn(@NotNull BaseCallStackElementRenderer delegate2, @NotNull ValueMetric metric) {
            Intrinsics.checkNotNullParameter((Object)delegate2, (String)"delegate");
            Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
            super(metric, CommonProfilerBundleKt.profilerMessage("ui.column.method", new Object[0]), null);
            this.delegate = delegate2;
            this.renderer = new ColoredTableCellRenderer(this){
                final /* synthetic */ MethodNameColumn this$0;

                protected void customizeCellRenderer(@NotNull JTable table, @Nullable Object value2, boolean selected2, boolean hasFocus, int row2, int column2) {
                    Intrinsics.checkNotNullParameter((Object)table, (String)"table");
                    if (!(value2 instanceof BaseCallStackElement)) {
                        return;
                    }
                    this.setBorder(null);
                    this.this$0.getDelegate().appendStackElementInRenderer((BaseCallStackElement)value2, (SimpleColoredComponent)this, table, selected2);
                }
                {
                    this.this$0 = this$0;
                }
            };
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J$\u0010\f\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rj\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e`\u0010H\u0016J\u0018\u0010\n\u001a\u00020\t2\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eH\u0016J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/profiler/ui/CalleesListColumn$ValueColumn;", "Lcom/intellij/profiler/ui/CalleesListColumn;", "Lcom/intellij/profiler/ui/callusage/Percentage;", "metric", "Lcom/intellij/profiler/api/ValueMetric;", "maxValue", "", "(Lcom/intellij/profiler/api/ValueMetric;J)V", "renderer", "Ljavax/swing/table/TableCellRenderer;", "getRenderer", "()Ljavax/swing/table/TableCellRenderer;", "getComparator", "Ljava/util/Comparator;", "Lcom/intellij/profiler/model/CalleesListItem;", "Lcom/intellij/profiler/api/BaseCallStackElement;", "Lkotlin/Comparator;", "item", "valueOf", "intellij.profiler.common"})
    public static final class ValueColumn
    extends CalleesListColumn<Percentage> {
        @NotNull
        private final TableCellRenderer renderer;
        private final long maxValue;

        @Override
        @NotNull
        protected TableCellRenderer getRenderer() {
            return this.renderer;
        }

        @Nullable
        public Percentage valueOf(@Nullable CalleesListItem<BaseCallStackElement> item) {
            Percentage percentage;
            CalleesListItem<BaseCallStackElement> calleesListItem = item;
            if (calleesListItem != null) {
                CalleesListItem<BaseCallStackElement> calleesListItem2 = calleesListItem;
                boolean bl = false;
                boolean bl2 = false;
                CalleesListItem<BaseCallStackElement> it = calleesListItem2;
                boolean bl3 = false;
                percentage = new Percentage((double)it.getTotalValue() / (double)this.maxValue, it.getTotalValue());
            } else {
                percentage = null;
            }
            return percentage;
        }

        @NotNull
        public TableCellRenderer getRenderer(@Nullable CalleesListItem<BaseCallStackElement> item) {
            return this.getRenderer();
        }

        @NotNull
        public Comparator<CalleesListItem<BaseCallStackElement>> getComparator() {
            boolean bl = false;
            return new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    T receiver = a;
                    boolean bl2 = false;
                    Comparable comparable = Long.valueOf(((CalleesListItem)receiver).getTotalValue());
                    receiver = b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Long l = ((CalleesListItem)receiver).getTotalValue();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
                }
            };
        }

        public ValueColumn(@NotNull ValueMetric metric, long maxValue) {
            Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
            super(metric, metric.getColumnTitle(), null);
            this.maxValue = maxValue;
            this.renderer = new CallUsageTableCellRenderer(null, 1, null);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J$\u0010\n\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000bj\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f`\u000eH\u0016J\u0018\u0010\b\u001a\u00020\u00072\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fH\u0016J\u001f\u0010\u0010\u001a\u0004\u0018\u00010\u00022\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fH\u0016\u00a2\u0006\u0002\u0010\u0011R\u0014\u0010\u0006\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/intellij/profiler/ui/CalleesListColumn$OwnValueColumn;", "Lcom/intellij/profiler/ui/CalleesListColumn;", "", "metric", "Lcom/intellij/profiler/api/ValueMetric;", "(Lcom/intellij/profiler/api/ValueMetric;)V", "renderer", "Lcom/intellij/ui/ColoredTableCellRenderer;", "getRenderer", "()Lcom/intellij/ui/ColoredTableCellRenderer;", "getComparator", "Ljava/util/Comparator;", "Lcom/intellij/profiler/model/CalleesListItem;", "Lcom/intellij/profiler/api/BaseCallStackElement;", "Lkotlin/Comparator;", "item", "valueOf", "(Lcom/intellij/profiler/model/CalleesListItem;)Ljava/lang/Long;", "intellij.profiler.common"})
    public static final class OwnValueColumn
    extends CalleesListColumn<Long> {
        @NotNull
        private final ColoredTableCellRenderer renderer;

        @NotNull
        protected ColoredTableCellRenderer getRenderer() {
            return this.renderer;
        }

        @Nullable
        public Long valueOf(@Nullable CalleesListItem<BaseCallStackElement> item) {
            CalleesListItem<BaseCallStackElement> calleesListItem = item;
            return calleesListItem != null ? Long.valueOf(calleesListItem.getOwnValue()) : null;
        }

        @NotNull
        public ColoredTableCellRenderer getRenderer(@Nullable CalleesListItem<BaseCallStackElement> item) {
            return this.getRenderer();
        }

        @NotNull
        public Comparator<CalleesListItem<BaseCallStackElement>> getComparator() {
            boolean bl = false;
            return new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    T receiver = a;
                    boolean bl2 = false;
                    Comparable comparable = Long.valueOf(((CalleesListItem)receiver).getOwnValue());
                    receiver = b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Long l = ((CalleesListItem)receiver).getOwnValue();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
                }
            };
        }

        public OwnValueColumn(@NotNull ValueMetric metric) {
            Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
            super(metric, CommonProfilerBundleKt.profilerMessage("ui.column.own.method", metric.getColumnTitle()), null);
            this.renderer = new ColoredTableCellRenderer(this){
                final /* synthetic */ OwnValueColumn this$0;

                protected void customizeCellRenderer(@NotNull JTable table, @Nullable Object value2, boolean selected2, boolean hasFocus, int row2, int column2) {
                    Intrinsics.checkNotNullParameter((Object)table, (String)"table");
                    if (!(value2 instanceof Long)) {
                        return;
                    }
                    this.this$0.printValue(this, ((Number)value2).longValue());
                }
                {
                    this.this$0 = this$0;
                }
            };
        }
    }
}

