/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.sudo;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.profiler.sudo.SendResult;
import com.intellij.profiler.sudo.SudoPasswordWriter;
import com.intellij.profiler.sudo.ValidationResult;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000J\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a)\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\b\"\u00020\u0006H\u0000\u00a2\u0006\u0002\u0010\t\u001a\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0000\u001a\r\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rH\u0000\u001a&\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\r2\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\b\"\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\u0010\u001a\u001b\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\r2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0002\u001a\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0016\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0016\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a&\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u0001H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"SIGINT", "", "SIGKILL", "startSudoProcess", "Lcom/intellij/execution/process/OSProcessHandler;", "password", "", "commandWithParameters", "", "(Ljava/lang/String;[Ljava/lang/String;)Lcom/intellij/execution/process/OSProcessHandler;", "", "sudoCmd", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "Lorg/jetbrains/annotations/NotNull;", "sudoProcess", "Ljava/lang/Process;", "([Ljava/lang/String;)Ljava/lang/Process;", "sudoSendSIGINT", "Lcom/intellij/profiler/sudo/SendResult;", "process", "pid", "sudoSendSIGKILL", "sudoSendSignal", "signal", "validateSudoPassword", "Lcom/intellij/profiler/sudo/ValidationResult;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "timeoutInMilliseconds", "intellij.profiler.common"})
public final class ExecSudoCommandKt {
    public static final int SIGINT = 2;
    public static final int SIGKILL = 9;

    @NotNull
    public static final GeneralCommandLine sudoCmd() {
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(new String[]{"sudo"}).withParameters(new String[]{"-k"}).withParameters(new String[]{"-S"}).withParameters(new String[]{"-p", "\"\""});
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"GeneralCommandLine(\"sudo\u2026hParameters(\"-p\", \"\\\"\\\"\")");
        return generalCommandLine;
    }

    private static final Process sudoProcess(String ... commandWithParameters) {
        return ExecSudoCommandKt.sudoProcess(ArraysKt.toList((Object[])commandWithParameters));
    }

    private static final Process sudoProcess(List<String> commandWithParameters) {
        Process process2 = ExecSudoCommandKt.sudoCmd().withParameters(commandWithParameters).createProcess();
        Intrinsics.checkNotNullExpressionValue((Object)process2, (String)"sudoCmd().withParameters\u2026rameters).createProcess()");
        return process2;
    }

    @NotNull
    public static final OSProcessHandler startSudoProcess(@NotNull String password, String ... commandWithParameters) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)commandWithParameters, (String)"commandWithParameters");
        return ExecSudoCommandKt.startSudoProcess(password, ArraysKt.toList((Object[])commandWithParameters));
    }

    @NotNull
    public static final OSProcessHandler startSudoProcess(@NotNull String password, @NotNull List<String> commandWithParameters) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter(commandWithParameters, (String)"commandWithParameters");
        OSProcessHandler oSProcessHandler = new OSProcessHandler(ExecSudoCommandKt.sudoProcess(commandWithParameters), "sudo " + CollectionsKt.joinToString$default((Iterable)commandWithParameters, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
        boolean bl = false;
        boolean bl2 = false;
        OSProcessHandler $this$apply = oSProcessHandler;
        boolean bl3 = false;
        $this$apply.addProcessListener((ProcessListener)new SudoPasswordWriter(password, false, 2, null));
        return oSProcessHandler;
    }

    @NotNull
    public static final SendResult sudoSendSIGINT(@NotNull Process process2, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        return ExecSudoCommandKt.sudoSendSIGINT(OSProcessUtil.getProcessID((Process)process2), password);
    }

    @NotNull
    public static final SendResult sudoSendSIGINT(int pid2, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        return ExecSudoCommandKt.sudoSendSignal(pid2, 2, password);
    }

    @NotNull
    public static final SendResult sudoSendSIGKILL(@NotNull Process process2, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        return ExecSudoCommandKt.sudoSendSIGKILL(OSProcessUtil.getProcessID((Process)process2), password);
    }

    @NotNull
    public static final SendResult sudoSendSIGKILL(int pid2, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        return ExecSudoCommandKt.sudoSendSignal(pid2, 9, password);
    }

    @NotNull
    public static final SendResult sudoSendSignal(int pid2, int signal, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        CapturingProcessHandler handler2 = new CapturingProcessHandler(ExecSudoCommandKt.sudoProcess("kill", "" + '-' + signal, String.valueOf(pid2)), null, "sudo kill -" + signal + ' ' + pid2);
        handler2.addProcessListener((ProcessListener)new SudoPasswordWriter(password, true));
        ProcessOutput processOutput = handler2.runProcess();
        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"handler.runProcess()");
        ProcessOutput result2 = processOutput;
        if (result2.getExitCode() == 1) {
            String string = result2.getStderr();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.stderr");
            String string2 = string;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
            if (StringsKt.contains$default((CharSequence)string4, (CharSequence)"no such process", (boolean)false, (int)2, null)) {
                return SendResult.NO_SUCH_PROCESS;
            }
        }
        if (result2.getExitCode() == 0) {
            return SendResult.OK;
        }
        return SendResult.FAILED;
    }

    @NotNull
    public static final ValidationResult validateSudoPassword(@NotNull String password, @Nullable ProgressIndicator progressIndicator, int timeoutInMilliseconds) {
        ProcessOutput result2;
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        CapturingProcessHandler handler2 = new CapturingProcessHandler(ExecSudoCommandKt.sudoProcess("echo", "OK"), null, "sudo echo OK");
        handler2.addProcessListener((ProcessListener)new SudoPasswordWriter(password, true));
        ProcessOutput processOutput = result2 = progressIndicator != null ? handler2.runProcessWithProgressIndicator(progressIndicator, timeoutInMilliseconds, true) : handler2.runProcess(timeoutInMilliseconds);
        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"result");
        if (processOutput.isCancelled()) {
            return ValidationResult.CANCELED;
        }
        return result2.getExitCode() == 0 && Intrinsics.areEqual((Object)result2.getStdout(), (Object)"OK\n") ? ValidationResult.VALID : ValidationResult.INVALID;
    }

    public static /* synthetic */ ValidationResult validateSudoPassword$default(String string, ProgressIndicator progressIndicator, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            progressIndicator = null;
        }
        if ((n2 & 4) != 0) {
            n = 10000;
        }
        return ExecSudoCommandKt.validateSudoPassword(string, progressIndicator, n);
    }
}

