/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.linux;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.linux.AllVariablesAreOK;
import com.intellij.profiler.linux.KernelVariable;
import com.intellij.profiler.linux.KernelVariablesValidatorKt;
import com.intellij.profiler.linux.OK;
import com.intellij.profiler.linux.ValidationResult;
import com.intellij.profiler.linux.VariableValidationResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002Jm\u0010\u0003\u001a\u00020\u00042\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r2#\u0010\u000e\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\u000b\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00040\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002Jk\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u000b2\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r2#\u0010\u0019\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\u000b\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00040\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016Jc\u0010\u001a\u001a\u00020\u00042\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r2#\u0010\u0019\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\u000b\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00040\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0014J(\u0010!\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000b2\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\tH\u0014J \u0010\"\u001a\u00020\u000b2\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\tH\u0014\u00a8\u0006#"}, d2={"Lcom/intellij/profiler/linux/KernelVariablesFixer;", "", "()V", "changeVars", "", "validationResult", "", "Lcom/intellij/profiler/linux/KernelVariable;", "Lcom/intellij/profiler/linux/VariableValidationResult;", "Lcom/intellij/profiler/linux/AllVariablesValidationResult;", "scriptPath", "", "onSuccess", "Lkotlin/Function0;", "onErrorCallback", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "message", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "project", "Lcom/intellij/openapi/project/Project;", "changeVarsPermanently", "sysctlPath", "onError", "changeVarsUntilRestart", "executeScript", "Lcom/intellij/execution/process/ProcessOutput;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "timeout", "", "getChangeVarsPermanentlyScript", "getChangeVarsUntilRestartScriptPath", "intellij.profiler.common"})
public class KernelVariablesFixer {
    public final void changeVarsUntilRestart(@NotNull Map<KernelVariable, ? extends VariableValidationResult> validationResult, @NotNull Function0<Unit> onSuccess2, @NotNull Function1<? super String, Unit> onError2, @Nullable Logger logger, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(validationResult, (String)"validationResult");
        Intrinsics.checkNotNullParameter(onSuccess2, (String)"onSuccess");
        Intrinsics.checkNotNullParameter(onError2, (String)"onError");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.changeVars(validationResult, this.getChangeVarsUntilRestartScriptPath(validationResult), onSuccess2, onError2, logger, project);
    }

    public final void changeVarsPermanently(@NotNull String sysctlPath, @NotNull Map<KernelVariable, ? extends VariableValidationResult> validationResult, @NotNull Function0<Unit> onSuccess2, @NotNull Function1<? super String, Unit> onError2, @Nullable Logger logger, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)sysctlPath, (String)"sysctlPath");
        Intrinsics.checkNotNullParameter(validationResult, (String)"validationResult");
        Intrinsics.checkNotNullParameter(onSuccess2, (String)"onSuccess");
        Intrinsics.checkNotNullParameter(onError2, (String)"onError");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.changeVars(validationResult, this.getChangeVarsPermanentlyScript(sysctlPath, validationResult), onSuccess2, onError2, logger, project);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected String getChangeVarsUntilRestartScriptPath(@NotNull Map<KernelVariable, ? extends VariableValidationResult> validationResult) {
        void $this$mapTo$iv$iv;
        Object it;
        Intrinsics.checkNotNullParameter(validationResult, (String)"validationResult");
        Map<KernelVariable, ? extends VariableValidationResult> $this$filterValues$iv = validationResult;
        boolean $i$f$filterValues = false;
        Object result$iv = new LinkedHashMap();
        Map<KernelVariable, ? extends VariableValidationResult> map2 = $this$filterValues$iv;
        boolean bl = false;
        for (Map.Entry<KernelVariable, ? extends VariableValidationResult> entry$iv : map2.entrySet()) {
            it = entry$iv.getValue();
            boolean bl2 = false;
            if (!(!(it instanceof OK))) continue;
            ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
        }
        Iterable $this$map$iv = ((Map)result$iv).keySet();
        boolean $i$f$map = false;
        result$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Map.Entry<KernelVariable, VariableValidationResult> item$iv$iv : $this$mapTo$iv$iv) {
            it = (KernelVariable)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            String string = "echo " + ((KernelVariable)it).getRequiredValue() + " > " + ((KernelVariable)it).getPath();
            collection.add(string);
        }
        List echoLines = (List)destination$iv$iv;
        String script = CollectionsKt.joinToString$default((Iterable)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)"#!/bin/sh"), (Iterable)echoLines), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        String string = ExecUtil.createTempExecutableScript((String)"change_kernel_variables_until_restart", (String)".sh", (String)script).getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ExecUtil.createTempExecu\u2026sh\", script).absolutePath");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected String getChangeVarsPermanentlyScript(@NotNull String sysctlPath, @NotNull Map<KernelVariable, ? extends VariableValidationResult> validationResult) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object it;
        Intrinsics.checkNotNullParameter((Object)sysctlPath, (String)"sysctlPath");
        Intrinsics.checkNotNullParameter(validationResult, (String)"validationResult");
        Object $this$filterValues$iv = validationResult;
        boolean $i$f$filterValues = false;
        LinkedHashMap<KernelVariable, VariableValidationResult> result$iv = new LinkedHashMap<KernelVariable, VariableValidationResult>();
        Map<KernelVariable, ? extends VariableValidationResult> map2 = $this$filterValues$iv;
        boolean bl = false;
        for (Map.Entry<KernelVariable, ? extends VariableValidationResult> entry$iv : map2.entrySet()) {
            it = entry$iv.getValue();
            boolean bl2 = false;
            if (!(!(it instanceof OK))) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        $this$filterValues$iv = ((Map)result$iv).keySet();
        boolean $i$f$map = false;
        result$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Map.Entry<KernelVariable, VariableValidationResult> item$iv$iv : $this$mapTo$iv$iv) {
            it = (KernelVariable)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            String string = "echo kernel." + ((KernelVariable)it).getName() + '=' + ((KernelVariable)it).getRequiredValue() + " >> " + sysctlPath;
            collection.add(string);
        }
        List sysctlLines = (List)destination$iv$iv;
        String script = CollectionsKt.joinToString$default((Iterable)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])new String[]{"#!/bin/sh", "set -e"}), (Iterable)sysctlLines), (Object)"sysctl --system"), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        String string = ExecUtil.createTempExecutableScript((String)"change_kernel_variables_permanently", (String)".sh", (String)script).getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ExecUtil.createTempExecu\u2026sh\", script).absolutePath");
        return string;
    }

    @NotNull
    protected ProcessOutput executeScript(@NotNull String scriptPath, @NotNull ProgressIndicator indicator2, int timeout) {
        Intrinsics.checkNotNullParameter((Object)scriptPath, (String)"scriptPath");
        Intrinsics.checkNotNullParameter((Object)indicator2, (String)"indicator");
        GeneralCommandLine generalCommandLine = ExecUtil.sudoCommand((GeneralCommandLine)new GeneralCommandLine(new String[]{scriptPath}), (String)CommonProfilerBundleKt.profilerMessage("profiler.kernel.vars.prompt.password", new Object[0])).withRedirectErrorStream(true);
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"ExecUtil.sudoCommand(Gen\u2026RedirectErrorStream(true)");
        GeneralCommandLine cmd = generalCommandLine;
        ProcessOutput processOutput = new CapturingProcessHandler(cmd).runProcessWithProgressIndicator(indicator2, timeout, true);
        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"CapturingProcessHandler(\u2026indicator, timeout, true)");
        return processOutput;
    }

    private final void changeVars(Map<KernelVariable, ? extends VariableValidationResult> validationResult, String scriptPath, Function0<Unit> onSuccess2, Function1<? super String, Unit> onErrorCallback, Logger logger, Project project) {
        String errorMsg = CommonProfilerBundleKt.profilerMessage("profiler.kernel.vars.error", new Object[0]);
        Logger logger2 = logger;
        if (logger2 != null) {
            logger2.info("Kernel variables changer script: " + scriptPath);
        }
        new Task.Modal(this, scriptPath, onErrorCallback, logger, errorMsg, validationResult, onSuccess2, project, project, CommonProfilerBundleKt.profilerMessage("profiler.kernel.vars.writing", new Object[0]), true){
            final /* synthetic */ KernelVariablesFixer this$0;
            final /* synthetic */ String $scriptPath;
            final /* synthetic */ Function1 $onErrorCallback;
            final /* synthetic */ Logger $logger;
            final /* synthetic */ String $errorMsg;
            final /* synthetic */ Map $validationResult;
            final /* synthetic */ Function0 $onSuccess;
            final /* synthetic */ Project $project;

            public void run(@NotNull ProgressIndicator indicator2) {
                Intrinsics.checkNotNullParameter((Object)indicator2, (String)"indicator");
                ProcessOutput result2 = this.this$0.executeScript(this.$scriptPath, indicator2, 10000);
                if (result2.getExitCode() != 0) {
                    if (result2.isCancelled()) {
                        this.$onErrorCallback.invoke(null);
                        return;
                    }
                    Logger logger = this.$logger;
                    if (logger != null) {
                        logger.info("can't change variables: exit code:" + result2.getExitCode() + ", output:" + result2.getStdout());
                    }
                    this.$onErrorCallback.invoke((Object)this.$errorMsg);
                    return;
                }
                ValidationResult postExecutionValidationResult = KernelVariablesValidatorKt.checkKernelVariables(CollectionsKt.toList((Iterable)this.$validationResult.keySet()));
                if (!(postExecutionValidationResult instanceof AllVariablesAreOK)) {
                    Logger logger = this.$logger;
                    if (logger != null) {
                        logger.info("Not all variables are valid after success write: " + postExecutionValidationResult);
                    }
                    this.$onErrorCallback.invoke((Object)this.$errorMsg);
                    return;
                }
                this.$onSuccess.invoke();
            }
            {
                this.this$0 = this$0;
                this.$scriptPath = $captured_local_variable$1;
                this.$onErrorCallback = $captured_local_variable$2;
                this.$logger = $captured_local_variable$3;
                this.$errorMsg = $captured_local_variable$4;
                this.$validationResult = $captured_local_variable$5;
                this.$onSuccess = $captured_local_variable$6;
                this.$project = $captured_local_variable$7;
                super($super_call_param$8, $super_call_param$9, $super_call_param$10);
            }
        }.queue();
    }
}

