/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.charts;

import com.intellij.profiler.charts.LineChart;
import com.intellij.profiler.charts.Overlay;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00020\u0001B\u0019\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/profiler/charts/DragOverlay;", "Lcom/intellij/profiler/charts/Overlay;", "Lcom/intellij/profiler/charts/LineChart;", "onRelease", "Ljava/util/function/BiConsumer;", "Ljava/awt/Point;", "(Ljava/util/function/BiConsumer;)V", "getOnRelease", "()Ljava/util/function/BiConsumer;", "startPoint", "afterChartInitialized", "", "paintComponent", "g", "Ljava/awt/Graphics2D;", "intellij.profiler.common"})
public final class DragOverlay
extends Overlay<LineChart<?, ?, ?>> {
    private Point startPoint;
    @NotNull
    private final BiConsumer<Point, Point> onRelease;

    @Override
    public void afterChartInitialized() {
        ((LineChart)this.getChart()).getComponent().addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DragOverlay this$0;

            public void mousePressed(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Point point = e.getPoint();
                Intrinsics.checkNotNullExpressionValue((Object)point, (String)"e.point");
                DragOverlay.access$setStartPoint$p(this.this$0, this.this$0.toChartSpace(point));
            }

            public void mouseReleased(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Point start2 = DragOverlay.access$getStartPoint$p(this.this$0);
                Point point = e.getPoint();
                Intrinsics.checkNotNullExpressionValue((Object)point, (String)"e.point");
                Point end = this.this$0.toChartSpace(point);
                DragOverlay.access$setStartPoint$p(this.this$0, null);
                if (start2 != null && end != null) {
                    this.this$0.getOnRelease().accept(start2, end);
                }
            }
            {
                this.this$0 = this$0;
            }
        });
    }

    @Override
    public void paintComponent(@NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Point start2 = this.startPoint;
        if (start2 == null) {
            return;
        }
        Point end = this.getMouseLocation();
        if (end == null) {
            return;
        }
        g.setColor((Color)JBColor.BLACK);
        int n = start2.x;
        int n2 = end.x;
        boolean bl = false;
        int n3 = Math.min(n, n2);
        n = start2.y;
        n2 = end.y;
        bl = false;
        int n4 = Math.min(n, n2);
        n = start2.x - end.x;
        n2 = 0;
        int n5 = Math.abs(n);
        n = start2.y - end.y;
        n2 = 0;
        g.drawRect(n3, n4, n5, Math.abs(n));
    }

    @NotNull
    public final BiConsumer<Point, Point> getOnRelease() {
        return this.onRelease;
    }

    public DragOverlay(@NotNull BiConsumer<Point, Point> onRelease) {
        Intrinsics.checkNotNullParameter(onRelease, (String)"onRelease");
        this.onRelease = onRelease;
    }

    public static final /* synthetic */ Point access$getStartPoint$p(DragOverlay $this) {
        return $this.startPoint;
    }

    public static final /* synthetic */ void access$setStartPoint$p(DragOverlay $this, Point point) {
        $this.startPoint = point;
    }
}

