/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.api.monitor;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.profiler.charts.Coordinates;
import com.intellij.profiler.charts.Dataset;
import com.intellij.profiler.charts.LineChart;
import com.intellij.profiler.charts.Overlay;
import com.intellij.ui.JBColor;
import java.awt.Graphics2D;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002H\u0001\u0012\u0002\b\u00030\u00040\u0003BG\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00028\u00000\b0\u0007\u0012\b\b\u0001\u0010\t\u001a\u00020\n\u0012\b\b\u0001\u0010\u000b\u001a\u00020\n\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R#\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00028\u00000\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014\u00a8\u0006\u001a"}, d2={"Lcom/intellij/profiler/api/monitor/ValueDisplay;", "T", "", "Lcom/intellij/profiler/charts/Overlay;", "Lcom/intellij/profiler/charts/LineChart;", "", "data", "Lcom/intellij/profiler/charts/Dataset;", "Lcom/intellij/profiler/charts/Coordinates;", "prefix", "", "postfix", "digits", "", "onlyValue", "", "(Lcom/intellij/profiler/charts/Dataset;Ljava/lang/String;Ljava/lang/String;IZ)V", "getData", "()Lcom/intellij/profiler/charts/Dataset;", "getPostfix", "()Ljava/lang/String;", "getPrefix", "paintComponent", "", "g", "Ljava/awt/Graphics2D;", "intellij.profiler.common"})
final class ValueDisplay<T extends Number>
extends Overlay<LineChart<Long, T, ?>> {
    @NotNull
    private final Dataset<Coordinates<Long, T>> data;
    @NotNull
    private final String prefix;
    @NotNull
    private final String postfix;
    private final int digits;
    private final boolean onlyValue;

    @Override
    public void paintComponent(@NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Coordinates current2 = (Coordinates)CollectionsKt.lastOrNull(this.data.getData());
        if (current2 != null && ((LineChart)this.getChart()).getRanges().getYMaxInitialized()) {
            String string;
            boolean bl;
            Object[] objectArray;
            String string2;
            StringCompanionObject stringCompanionObject;
            g.setColor(JBColor.foreground());
            g.drawString(this.prefix, ((LineChart)this.getChart()).getMargins().left, 20);
            if (this.onlyValue) {
                stringCompanionObject = StringCompanionObject.INSTANCE;
                string2 = "%." + this.digits + 'f' + this.postfix;
                objectArray = new Object[]{((Number)current2.getY()).doubleValue()};
                bl = false;
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
            } else {
                stringCompanionObject = StringCompanionObject.INSTANCE;
                string2 = "%." + this.digits + "f / %." + this.digits + 'f' + this.postfix;
                objectArray = new Object[]{((Number)current2.getY()).doubleValue(), ((Number)((LineChart)this.getChart()).getRanges().getYMax()).doubleValue()};
                bl = false;
                String string4 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
            }
            String values2 = string;
            int offset = g.getFontMetrics().stringWidth(values2);
            g.drawString(values2, ((LineChart)this.getChart()).getWidth() - ((LineChart)this.getChart()).getMargins().left - offset, 20);
        }
    }

    @NotNull
    public final Dataset<Coordinates<Long, T>> getData() {
        return this.data;
    }

    @NotNull
    public final String getPrefix() {
        return this.prefix;
    }

    @NotNull
    public final String getPostfix() {
        return this.postfix;
    }

    public ValueDisplay(@NotNull Dataset<Coordinates<Long, T>> data2, @Nls @NotNull String prefix2, @NlsSafe @NotNull String postfix, int digits, boolean onlyValue) {
        Intrinsics.checkNotNullParameter(data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)prefix2, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)postfix, (String)"postfix");
        this.data = data2;
        this.prefix = prefix2;
        this.postfix = postfix;
        this.digits = digits;
        this.onlyValue = onlyValue;
    }

    public /* synthetic */ ValueDisplay(Dataset dataset2, String string, String string2, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            n = 2;
        }
        if ((n2 & 0x10) != 0) {
            bl = false;
        }
        this(dataset2, string, string2, n, bl);
    }
}

