/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.api;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.profiler.actions.ImportProfilerResultAction;
import com.intellij.profiler.api.ProfilerDumpDescriptor;
import com.intellij.profiler.api.ProfilerDumpManager;
import com.intellij.profiler.api.ProfilerDumpParserProvider;
import java.io.File;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u001b\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\tH\u00c6\u0003J\u000b\u0010\u001f\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\t\u0010 \u001a\u00020\rH\u00c2\u0003JG\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u00c6\u0001J\u0013\u0010\"\u001a\u00020\u00122\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010$\u001a\u00020%H\u00d6\u0001J\u0006\u0010&\u001a\u00020'J\u0014\u0010(\u001a\u00020'2\n\b\u0002\u0010)\u001a\u0004\u0018\u00010*H\u0007J\u0006\u0010+\u001a\u00020'J\u0006\u0010,\u001a\u00020'J\t\u0010-\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006."}, d2={"Lcom/intellij/profiler/api/ProfilerDumpDescriptor;", "", "project", "Lcom/intellij/openapi/project/Project;", "name", "", "time", "Ljava/util/Date;", "file", "Ljava/io/File;", "parserProvider", "Lcom/intellij/profiler/api/ProfilerDumpParserProvider;", "openCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/util/Date;Ljava/io/File;Lcom/intellij/profiler/api/ProfilerDumpParserProvider;Ljava/util/concurrent/atomic/AtomicInteger;)V", "getFile", "()Ljava/io/File;", "isClosed", "", "isClosed$intellij_profiler_common", "()Z", "getName", "()Ljava/lang/String;", "getParserProvider", "()Lcom/intellij/profiler/api/ProfilerDumpParserProvider;", "getTime", "()Ljava/util/Date;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "", "markOpened", "", "open", "onComplete", "Ljava/lang/Runnable;", "release", "remove", "toString", "intellij.profiler.common"})
public final class ProfilerDumpDescriptor {
    private final Project project;
    @NotNull
    private final String name;
    @NotNull
    private final Date time;
    @NotNull
    private final File file;
    @Nullable
    private final ProfilerDumpParserProvider parserProvider;
    private AtomicInteger openCounter;

    @JvmOverloads
    public final void open(@Nullable Runnable onComplete) {
        ImportProfilerResultAction.Companion.importProfilerDump(this.project, this, onComplete);
    }

    public static /* synthetic */ void open$default(ProfilerDumpDescriptor profilerDumpDescriptor, Runnable runnable2, int n, Object object) {
        if ((n & 1) != 0) {
            runnable2 = null;
        }
        profilerDumpDescriptor.open(runnable2);
    }

    @JvmOverloads
    public final void open() {
        ProfilerDumpDescriptor.open$default(this, null, 1, null);
    }

    public final boolean isClosed$intellij_profiler_common() {
        return this.openCounter.get() <= 0;
    }

    public final void markOpened() {
        this.openCounter.incrementAndGet();
    }

    public final void release() {
        this.openCounter.updateAndGet(release.1.INSTANCE);
        ProfilerDumpManager.Companion.getInstance(this.project).removeOldDumps$intellij_profiler_common();
    }

    public final void remove() {
        ProfilerDumpManager.Companion.getInstance(this.project).removeDump$intellij_profiler_common(this);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Date getTime() {
        return this.time;
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @Nullable
    public final ProfilerDumpParserProvider getParserProvider() {
        return this.parserProvider;
    }

    public ProfilerDumpDescriptor(@NotNull Project project, @NlsSafe @NotNull String name, @NotNull Date time, @NotNull File file2, @Nullable ProfilerDumpParserProvider parserProvider, @NotNull AtomicInteger openCounter) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)openCounter, (String)"openCounter");
        this.project = project;
        this.name = name;
        this.time = time;
        this.file = file2;
        this.parserProvider = parserProvider;
        this.openCounter = openCounter;
    }

    public /* synthetic */ ProfilerDumpDescriptor(Project project, String string, Date date, File file2, ProfilerDumpParserProvider profilerDumpParserProvider, AtomicInteger atomicInteger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            atomicInteger = new AtomicInteger(1);
        }
        this(project, string, date, file2, profilerDumpParserProvider, atomicInteger);
    }

    private final Project component1() {
        return this.project;
    }

    @NotNull
    public final String component2() {
        return this.name;
    }

    @NotNull
    public final Date component3() {
        return this.time;
    }

    @NotNull
    public final File component4() {
        return this.file;
    }

    @Nullable
    public final ProfilerDumpParserProvider component5() {
        return this.parserProvider;
    }

    private final AtomicInteger component6() {
        return this.openCounter;
    }

    @NotNull
    public final ProfilerDumpDescriptor copy(@NotNull Project project, @NlsSafe @NotNull String name, @NotNull Date time, @NotNull File file2, @Nullable ProfilerDumpParserProvider parserProvider, @NotNull AtomicInteger openCounter) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)openCounter, (String)"openCounter");
        return new ProfilerDumpDescriptor(project, name, time, file2, parserProvider, openCounter);
    }

    public static /* synthetic */ ProfilerDumpDescriptor copy$default(ProfilerDumpDescriptor profilerDumpDescriptor, Project project, String string, Date date, File file2, ProfilerDumpParserProvider profilerDumpParserProvider, AtomicInteger atomicInteger, int n, Object object) {
        if ((n & 1) != 0) {
            project = profilerDumpDescriptor.project;
        }
        if ((n & 2) != 0) {
            string = profilerDumpDescriptor.name;
        }
        if ((n & 4) != 0) {
            date = profilerDumpDescriptor.time;
        }
        if ((n & 8) != 0) {
            file2 = profilerDumpDescriptor.file;
        }
        if ((n & 0x10) != 0) {
            profilerDumpParserProvider = profilerDumpDescriptor.parserProvider;
        }
        if ((n & 0x20) != 0) {
            atomicInteger = profilerDumpDescriptor.openCounter;
        }
        return profilerDumpDescriptor.copy(project, string, date, file2, profilerDumpParserProvider, atomicInteger);
    }

    @NotNull
    public String toString() {
        return "ProfilerDumpDescriptor(project=" + this.project + ", name=" + this.name + ", time=" + this.time + ", file=" + this.file + ", parserProvider=" + this.parserProvider + ", openCounter=" + this.openCounter + ")";
    }

    public int hashCode() {
        Project project = this.project;
        String string = this.name;
        Date date = this.time;
        File file2 = this.file;
        ProfilerDumpParserProvider profilerDumpParserProvider = this.parserProvider;
        AtomicInteger atomicInteger = this.openCounter;
        return (((((project != null ? project.hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (date != null ? ((Object)date).hashCode() : 0)) * 31 + (file2 != null ? ((Object)file2).hashCode() : 0)) * 31 + (profilerDumpParserProvider != null ? profilerDumpParserProvider.hashCode() : 0)) * 31 + (atomicInteger != null ? atomicInteger.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ProfilerDumpDescriptor)) break block3;
                ProfilerDumpDescriptor profilerDumpDescriptor = (ProfilerDumpDescriptor)object;
                if (!Intrinsics.areEqual((Object)this.project, (Object)profilerDumpDescriptor.project) || !Intrinsics.areEqual((Object)this.name, (Object)profilerDumpDescriptor.name) || !Intrinsics.areEqual((Object)this.time, (Object)profilerDumpDescriptor.time) || !Intrinsics.areEqual((Object)this.file, (Object)profilerDumpDescriptor.file) || !Intrinsics.areEqual((Object)this.parserProvider, (Object)profilerDumpDescriptor.parserProvider) || !Intrinsics.areEqual((Object)this.openCounter, (Object)profilerDumpDescriptor.openCounter)) break block3;
            }
            return true;
        }
        return false;
    }
}

