/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.api.Attached;
import com.intellij.profiler.api.Disposed;
import com.intellij.profiler.api.Inactive;
import com.intellij.profiler.api.ProfilerProcess;
import com.intellij.profiler.api.ProfilerState;
import com.intellij.profiler.api.ProfilerTargetProcess;
import com.intellij.profiler.api.Terminated;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 C*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001CB\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0007JD\u0010.\u001a\u00020)2:\u0010/\u001a6\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b('\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b((\u0012\u0004\u0012\u00020)0$j\u0002`*H\u0016J\u0010\u00100\u001a\u00020)2\u0006\u0010(\u001a\u00020\u0016H\u0004J\b\u00101\u001a\u00020)H\u0016J\b\u00102\u001a\u00020\u001eH\u0014J\u0010\u00103\u001a\u00020)2\u0006\u00104\u001a\u000205H\u0004J\u0010\u00106\u001a\u00020)2\u0006\u0010\u001f\u001a\u00020\u0019H\u0002J\b\u00107\u001a\u00020)H$J\b\u00108\u001a\u00020)H\u0014JD\u00109\u001a\u00020)2:\u0010/\u001a6\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b('\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b((\u0012\u0004\u0012\u00020)0$j\u0002`*H\u0016J\u001c\u0010:\u001a\u00020)2\u0012\u0010;\u001a\u000e\u0012\u0004\u0012\u00020=\u0012\u0004\u0012\u00020)0<H\u0004J\u0010\u0010>\u001a\u00020)2\u0006\u0010?\u001a\u00020\u0011H\u0007J\b\u0010@\u001a\u00020)H\u0016J\b\u0010A\u001a\u00020\u001eH\u0016J\b\u0010B\u001a\u00020\u001eH\u0016R\u0012\u0010\b\u001a\u00020\tX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\u00190\u0018j\b\u0012\u0004\u0012\u00020\u0019`\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!RH\u0010\"\u001a<\u00128\u00126\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b('\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b((\u0012\u0004\u0012\u00020)0$j\u0002`*0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00028\u0000X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010-\u001a\u0004\b+\u0010,\u00a8\u0006D"}, d2={"Lcom/intellij/profiler/ProfilerProcessBase;", "TargetProcess", "Lcom/intellij/profiler/api/ProfilerTargetProcess;", "Lcom/intellij/profiler/api/ProfilerProcess;", "project", "Lcom/intellij/openapi/project/Project;", "targetProcess", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/profiler/api/ProfilerTargetProcess;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "dumpReadIndicator", "Lcom/intellij/openapi/progress/util/ProgressIndicatorBase;", "getDumpReadIndicator", "()Lcom/intellij/openapi/progress/util/ProgressIndicatorBase;", "eventsBroadcaster", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "myState", "Lcom/intellij/profiler/api/ProfilerState;", "pendingEvents", "Ljava/util/ArrayList;", "Lcom/intellij/profiler/ProfilerProcessBase$Companion$StateTransition;", "Lkotlin/collections/ArrayList;", "getProject", "()Lcom/intellij/openapi/project/Project;", "startNotified", "", "state", "getState", "()Lcom/intellij/profiler/api/ProfilerState;", "stateChangedListeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "oldState", "newState", "", "Lcom/intellij/profiler/api/OnStateChangedCallback;", "getTargetProcess", "()Lcom/intellij/profiler/api/ProfilerTargetProcess;", "Lcom/intellij/profiler/api/ProfilerTargetProcess;", "addStateChangedListener", "listener", "changeStateAndNotifyAsync", "dispose", "doStop", "initTargetProcessLifecycleListener", "handler", "Lcom/intellij/execution/process/ProcessHandler;", "notifyListeners", "onTargetProcessTerminated", "onTerminateCalled", "removeStateChangedListener", "runUnderDumpReadIndicator", "process", "Lkotlin/Function1;", "Lcom/intellij/openapi/progress/ProgressIndicator;", "setEventsBroadcastingExecutorService", "executorService", "startNotify", "stop", "terminate", "Companion", "intellij.profiler.common"})
public abstract class ProfilerProcessBase<TargetProcess extends ProfilerTargetProcess>
implements ProfilerProcess<TargetProcess> {
    private ExecutorService eventsBroadcaster;
    private ArrayList<Companion.StateTransition> pendingEvents;
    private boolean startNotified;
    private ProfilerState myState;
    private final ReentrantLock lock;
    @NotNull
    private final ProgressIndicatorBase dumpReadIndicator;
    private final CopyOnWriteArrayList<Function2<ProfilerState, ProfilerState, Unit>> stateChangedListeners;
    @NotNull
    private final Project project;
    @NotNull
    private final TargetProcess targetProcess;
    @NotNull
    private static final Companion Companion = new Companion(null);

    @NotNull
    protected final ProgressIndicatorBase getDumpReadIndicator() {
        return this.dumpReadIndicator;
    }

    @Override
    @NotNull
    public ProfilerState getState() {
        return this.myState;
    }

    @NotNull
    protected abstract Logger getLOG();

    protected final void initTargetProcessLifecycleListener(@NotNull ProcessHandler handler2) {
        Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
        handler2.addProcessListener((ProcessListener)new ProcessAdapter(this){
            final /* synthetic */ ProfilerProcessBase this$0;

            public void processTerminated(@NotNull ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.this$0.onTargetProcessTerminated();
            }
            {
                this.this$0 = this$0;
            }
        }, (Disposable)this);
    }

    protected final void runUnderDumpReadIndicator(@NotNull Function1<? super ProgressIndicator, Unit> process2) {
        Intrinsics.checkNotNullParameter(process2, (String)"process");
        new Task.Backgroundable(this, process2, this.getProject(), CommonProfilerBundleKt.profilerMessage("profiler.state.reading.data", new Object[0])){
            final /* synthetic */ ProfilerProcessBase this$0;
            final /* synthetic */ Function1 $process;

            public void run(@NotNull ProgressIndicator indicator2) {
                Intrinsics.checkNotNullParameter((Object)indicator2, (String)"indicator");
                this.$process.invoke((Object)indicator2);
            }
            {
                this.this$0 = this$0;
                this.$process = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3);
            }
        }.queue();
    }

    protected abstract void onTargetProcessTerminated();

    protected boolean doStop() {
        return true;
    }

    @Override
    public boolean stop() {
        if (!this.canBeStopped()) {
            return false;
        }
        if (!this.getLOG().assertTrue(this.getState() == Attached.INSTANCE, (Object)("Profiler is in " + this.getState() + " state. Should be in 'ATTACHED' state."))) {
            return false;
        }
        return this.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startNotify() {
        Lock lock2 = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        lock2.lock();
        try {
            boolean bl3 = false;
            if (this.startNotified) {
                this.getLOG().error("startNotify() was already called");
                return;
            }
            this.startNotified = true;
            this.eventsBroadcaster.submit(new Runnable(this){
                final /* synthetic */ ProfilerProcessBase this$0;
                {
                    this.this$0 = profilerProcessBase;
                }

                public final void run() {
                    Iterator<E> iterator2 = ProfilerProcessBase.access$getPendingEvents$p(this.this$0).iterator();
                    while (iterator2.hasNext()) {
                        Companion.StateTransition event;
                        Companion.StateTransition stateTransition = event = (Companion.StateTransition)iterator2.next();
                        Intrinsics.checkNotNullExpressionValue((Object)stateTransition, (String)"event");
                        ProfilerProcessBase.access$notifyListeners(this.this$0, stateTransition);
                    }
                }
            });
            this.pendingEvents.clear();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock2.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void changeStateAndNotifyAsync(@NotNull ProfilerState newState2) {
        Intrinsics.checkNotNullParameter((Object)newState2, (String)"newState");
        Lock lock2 = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        lock2.lock();
        try {
            boolean bl3 = false;
            if (this.myState instanceof Disposed) {
                return;
            }
            Companion.StateTransition event = new Companion.StateTransition(this.myState, newState2);
            this.myState = newState2;
            if (this.startNotified) {
                this.eventsBroadcaster.submit(new Runnable(event, this, newState2){
                    final /* synthetic */ Companion.StateTransition $event;
                    final /* synthetic */ ProfilerProcessBase this$0;
                    final /* synthetic */ ProfilerState $newState$inlined;
                    {
                        this.$event = stateTransition;
                        this.this$0 = profilerProcessBase;
                        this.$newState$inlined = profilerState;
                    }

                    public final void run() {
                        ProfilerProcessBase.access$notifyListeners(this.this$0, this.$event);
                    }
                });
            } else {
                this.pendingEvents.add(event);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock2.unlock();
        }
    }

    @Override
    public void addStateChangedListener(@NotNull Function2<? super ProfilerState, ? super ProfilerState, Unit> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.stateChangedListeners.add(listener2);
    }

    @Override
    public void removeStateChangedListener(@NotNull Function2<? super ProfilerState, ? super ProfilerState, Unit> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.stateChangedListeners.remove(listener2);
    }

    @Override
    public boolean terminate() {
        if (!this.getState().isActive()) {
            return false;
        }
        if (!this.dumpReadIndicator.isCanceled()) {
            this.dumpReadIndicator.cancel();
        }
        Function0 function0 = (Function0)new Function0<Unit>(this){

            public final void invoke() {
                ((ProfilerProcessBase)this.receiver).onTerminateCalled();
            }
        };
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(function0){
            private final /* synthetic */ Function0 function;
            {
                this.function = function0;
            }

            public final /* synthetic */ void run() {
                Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(), (String)"invoke(...)");
            }
        });
        this.changeStateAndNotifyAsync(Terminated.INSTANCE);
        return true;
    }

    protected void onTerminateCalled() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Lock lock2 = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        lock2.lock();
        try {
            boolean bl3 = false;
            if (this.myState instanceof Disposed) {
                return;
            }
            this.myState = Disposed.INSTANCE;
            this.eventsBroadcaster.shutdownNow();
            this.pendingEvents.clear();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock2.unlock();
        }
        this.stateChangedListeners.clear();
        if (!this.dumpReadIndicator.isCanceled()) {
            this.dumpReadIndicator.cancel();
        }
    }

    private final void notifyListeners(Companion.StateTransition state) {
        this.getLOG().info("notifyStateChangedAsync: " + state.getOld() + " -> " + state.getNew());
        Iterable $this$forEach$iv = this.stateChangedListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function2 it = (Function2)element$iv;
            boolean bl = false;
            it.invoke((Object)state.getOld(), (Object)state.getNew());
        }
    }

    @TestOnly
    public final void setEventsBroadcastingExecutorService(@NotNull ExecutorService executorService) {
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        this.eventsBroadcaster = executorService;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public TargetProcess getTargetProcess() {
        return this.targetProcess;
    }

    public ProfilerProcessBase(@NotNull Project project, @NotNull TargetProcess targetProcess) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(targetProcess, (String)"targetProcess");
        this.project = project;
        this.targetProcess = targetProcess;
        ExecutorService executorService = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"ProfilerProcessEventsBroadcaster");
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"SequentialTaskExecutor.c\u2026rocessEventsBroadcaster\")");
        this.eventsBroadcaster = executorService;
        this.pendingEvents = new ArrayList();
        this.myState = Inactive.INSTANCE;
        this.lock = new ReentrantLock();
        this.dumpReadIndicator = new ProgressIndicatorBase();
        this.stateChangedListeners = new CopyOnWriteArrayList();
        this.changeStateAndNotifyAsync(Attached.INSTANCE);
    }

    public static final /* synthetic */ ArrayList access$getPendingEvents$p(ProfilerProcessBase $this) {
        return $this.pendingEvents;
    }

    public static final /* synthetic */ void access$setPendingEvents$p(ProfilerProcessBase $this, ArrayList arrayList) {
        $this.pendingEvents = arrayList;
    }

    public static final /* synthetic */ void access$notifyListeners(ProfilerProcessBase $this, Companion.StateTransition state) {
        $this.notifyListeners(state);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/intellij/profiler/ProfilerProcessBase$Companion;", "", "()V", "StateTransition", "intellij.profiler.common"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/intellij/profiler/ProfilerProcessBase$Companion$StateTransition;", "", "old", "Lcom/intellij/profiler/api/ProfilerState;", "new", "(Lcom/intellij/profiler/api/ProfilerState;Lcom/intellij/profiler/api/ProfilerState;)V", "getNew", "()Lcom/intellij/profiler/api/ProfilerState;", "getOld", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.profiler.common"})
        public static final class StateTransition {
            @NotNull
            private final ProfilerState old;
            @NotNull
            private final ProfilerState new;

            @NotNull
            public final ProfilerState getOld() {
                return this.old;
            }

            @NotNull
            public final ProfilerState getNew() {
                return this.new;
            }

            public StateTransition(@NotNull ProfilerState old, @NotNull ProfilerState profilerState) {
                Intrinsics.checkNotNullParameter((Object)old, (String)"old");
                Intrinsics.checkNotNullParameter((Object)profilerState, (String)"new");
                this.old = old;
                this.new = profilerState;
            }

            @NotNull
            public final ProfilerState component1() {
                return this.old;
            }

            @NotNull
            public final ProfilerState component2() {
                return this.new;
            }

            @NotNull
            public final StateTransition copy(@NotNull ProfilerState old, @NotNull ProfilerState profilerState) {
                Intrinsics.checkNotNullParameter((Object)old, (String)"old");
                Intrinsics.checkNotNullParameter((Object)profilerState, (String)"new");
                return new StateTransition(old, profilerState);
            }

            public static /* synthetic */ StateTransition copy$default(StateTransition stateTransition, ProfilerState profilerState, ProfilerState profilerState2, int n, Object object) {
                if ((n & 1) != 0) {
                    profilerState = stateTransition.old;
                }
                if ((n & 2) != 0) {
                    profilerState2 = stateTransition.new;
                }
                return stateTransition.copy(profilerState, profilerState2);
            }

            @NotNull
            public String toString() {
                return "StateTransition(old=" + this.old + ", new=" + this.new + ")";
            }

            public int hashCode() {
                ProfilerState profilerState = this.old;
                ProfilerState profilerState2 = this.new;
                return (profilerState != null ? profilerState.hashCode() : 0) * 31 + (profilerState2 != null ? profilerState2.hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof StateTransition)) break block3;
                        StateTransition stateTransition = (StateTransition)object;
                        if (!Intrinsics.areEqual((Object)this.old, (Object)stateTransition.old) || !Intrinsics.areEqual((Object)this.new, (Object)stateTransition.new)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

