/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.FocusManagerImpl;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.util.ReflectionUtil;
import com.sun.jna.Native;
import java.awt.Toolkit;
import java.awt.Window;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.awt.AWTAccessor;
import sun.misc.Unsafe;

public final class X11UiUtil {
    private static final Logger LOG = Logger.getInstance(X11UiUtil.class);
    private static final int True = 1;
    private static final int False = 0;
    private static final long None = 0L;
    private static final long XA_ATOM = 4L;
    private static final long XA_WINDOW = 33L;
    private static final int CLIENT_MESSAGE = 33;
    private static final int FORMAT_BYTE = 8;
    private static final int FORMAT_LONG = 32;
    private static final long EVENT_MASK = 0x180000L;
    private static final long NET_WM_STATE_ADD = 1L;
    private static final long NET_WM_STATE_TOGGLE = 2L;
    @Nullable
    private static final Xlib X11 = Xlib.getInstance();

    @Nullable
    public static String getWmName() {
        if (X11 == null) {
            return null;
        }
        try {
            Long netWmWindow = X11.getNetWmWindow();
            if (netWmWindow != null) {
                return X11.getUtfStringProperty(netWmWindow, X11UiUtil.X11.NET_WM_NAME);
            }
        }
        catch (Throwable t) {
            LOG.info("cannot get WM name", t);
        }
        return null;
    }

    public static void patchDetectedWm(String wmName) {
        if (X11 == null || !Boolean.parseBoolean(System.getProperty("ide.x11.override.wm", "true"))) {
            return;
        }
        try {
            if ("Muffin".equals(wmName)) {
                X11UiUtil.setWM("MUTTER_WM");
            } else if ("Marco".equals(wmName)) {
                X11UiUtil.setWM("MARCO_WM", "METACITY_WM");
            } else if ("awesome".equals(wmName)) {
                String version2 = X11UiUtil.getAwesomeWMVersion();
                if (StringUtil.compareVersionNumbers((String)version2, (String)"3.5") >= 0) {
                    X11UiUtil.setWM("SAWFISH_WM");
                } else if (version2 != null) {
                    X11UiUtil.setWM("OTHER_NONREPARENTING_WM", "LG3D_WM");
                }
            }
        }
        catch (Throwable t) {
            LOG.warn(t);
        }
    }

    private static void setWM(String ... wmConstants) throws Exception {
        Class<?> xwmClass = Class.forName("sun.awt.X11.XWM");
        Object xwm = X11UiUtil.method(xwmClass, "getWM", new Class[0]).invoke(null, new Object[0]);
        if (xwm != null) {
            for (String wmConstant : wmConstants) {
                try {
                    Field wm2 = X11UiUtil.field(xwmClass, wmConstant);
                    Object id2 = wm2.get(null);
                    if (id2 == null) continue;
                    X11UiUtil.field(xwmClass, "awt_wmgr").set(null, id2);
                    X11UiUtil.field(xwmClass, "WMID").set(xwm, id2);
                    LOG.info("impersonated WM: " + wmConstant);
                    break;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
            }
        }
    }

    @Nullable
    private static String getAwesomeWMVersion() {
        try {
            Matcher m;
            String version2 = ExecUtil.execAndReadLine((GeneralCommandLine)new GeneralCommandLine(new String[]{"awesome", "--version"}));
            if (version2 != null && (m = Pattern.compile("awesome v([0-9.]+)").matcher(version2)).find()) {
                return m.group(1);
            }
        }
        catch (Throwable t) {
            LOG.warn(t);
        }
        return null;
    }

    public static boolean isFullScreenSupported() {
        if (X11 == null) {
            return false;
        }
        List<ProjectFrameHelper> frames = WindowManagerEx.getInstanceEx().getProjectFrameHelpers();
        if (frames.isEmpty()) {
            return true;
        }
        IdeFrameImpl frame = frames.get(0).getFrame();
        return X11UiUtil.hasWindowProperty(frame, X11UiUtil.X11.NET_WM_ALLOWED_ACTIONS, X11UiUtil.X11.NET_WM_ACTION_FULLSCREEN);
    }

    public static boolean isInFullScreenMode(JFrame frame) {
        return X11 != null && X11UiUtil.hasWindowProperty(frame, X11UiUtil.X11.NET_WM_STATE, X11UiUtil.X11.NET_WM_STATE_FULLSCREEN);
    }

    private static boolean hasWindowProperty(JFrame frame, long name, long expected) {
        if (X11 == null) {
            return false;
        }
        try {
            long window;
            long[] values2;
            Object peer = AWTAccessor.getComponentAccessor().getPeer(frame);
            if (peer != null && (values2 = X11.getLongArrayProperty(window = ((Long)X11UiUtil.X11.getWindow.invoke(peer, new Object[0])).longValue(), name, 4L)) != null) {
                for (long value2 : values2) {
                    if (value2 != expected) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Throwable t) {
            LOG.info("cannot check window property", t);
            return false;
        }
    }

    public static void toggleFullScreenMode(JFrame frame) {
        if (X11 == null) {
            return;
        }
        X11.sendClientMessage(frame, "toggle mode", X11UiUtil.X11.NET_WM_STATE, 2L, X11UiUtil.X11.NET_WM_STATE_FULLSCREEN);
    }

    public static void activate(@NotNull Window window) {
        if (window == null) {
            X11UiUtil.$$$reportNull$$$0(0);
        }
        if (X11 == null) {
            return;
        }
        if (FocusManagerImpl.FOCUS_REQUESTS_LOG.isDebugEnabled()) {
            FocusManagerImpl.FOCUS_REQUESTS_LOG.debug("_NET_ACTIVE_WINDOW", new Throwable());
        }
        X11.sendClientMessage(window, "activate", X11UiUtil.X11.NET_ACTIVE_WINDOW, new long[0]);
    }

    public static void requestAttention(@NotNull Window window) {
        if (window == null) {
            X11UiUtil.$$$reportNull$$$0(1);
        }
        if (X11 == null) {
            return;
        }
        X11.sendClientMessage(window, "request attention", X11UiUtil.X11.NET_WM_STATE, 1L, X11UiUtil.X11.NET_WM_STATE_DEMANDS_ATTENTION);
    }

    private static Method method(Class<?> aClass, @NonNls String name, Class<?> ... parameterTypes) throws Exception {
        while (aClass != null) {
            try {
                Method method2 = aClass.getDeclaredMethod(name, parameterTypes);
                method2.setAccessible(true);
                return method2;
            }
            catch (NoSuchMethodException e) {
                aClass = aClass.getSuperclass();
            }
        }
        throw new NoSuchMethodException(name);
    }

    private static Method method(Class<?> aClass, @NonNls String name, int parameters2) throws Exception {
        for (Method method2 : aClass.getDeclaredMethods()) {
            if (method2.getParameterCount() != parameters2 || !name.equals(method2.getName())) continue;
            method2.setAccessible(true);
            return method2;
        }
        throw new NoSuchMethodException(name);
    }

    private static Field field(Class<?> aClass, @NonNls String name) throws Exception {
        Field field = aClass.getDeclaredField(name);
        field.setAccessible(true);
        return field;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "window";
        objectArray2[1] = "com/intellij/openapi/wm/impl/X11UiUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "activate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "requestAttention";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Xlib {
        private Unsafe unsafe;
        private Method XGetWindowProperty;
        private Method XFree;
        private Method RootWindow;
        private Method XSendEvent;
        private Method getWindow;
        private Method getScreenNumber;
        private Method awtLock;
        private Method awtUnlock;
        private long display;
        private long UTF8_STRING;
        private long NET_SUPPORTING_WM_CHECK;
        private long NET_WM_NAME;
        private long NET_WM_ALLOWED_ACTIONS;
        private long NET_WM_STATE;
        private long NET_WM_ACTION_FULLSCREEN;
        private long NET_WM_STATE_FULLSCREEN;
        private long NET_WM_STATE_DEMANDS_ATTENTION;
        private long NET_ACTIVE_WINDOW;

        private Xlib() {
        }

        @Nullable
        private static Xlib getInstance() {
            Class<?> toolkitClass = Toolkit.getDefaultToolkit().getClass();
            if (!SystemInfoRt.isXWindow || !"sun.awt.X11.XToolkit".equals(toolkitClass.getName())) {
                return null;
            }
            try {
                Xlib x11 = new Xlib();
                Class<?> XlibWrapper = Class.forName("sun.awt.X11.XlibWrapper");
                x11.unsafe = (Unsafe)ReflectionUtil.getUnsafe();
                x11.XGetWindowProperty = X11UiUtil.method(XlibWrapper, "XGetWindowProperty", 12);
                x11.XFree = X11UiUtil.method(XlibWrapper, "XFree", 1);
                x11.RootWindow = X11UiUtil.method(XlibWrapper, "RootWindow", 2);
                x11.XSendEvent = X11UiUtil.method(XlibWrapper, "XSendEvent", 5);
                Class<?> XBaseWindow = Class.forName("sun.awt.X11.XBaseWindow");
                x11.getWindow = X11UiUtil.method(XBaseWindow, "getWindow", new Class[0]);
                x11.getScreenNumber = X11UiUtil.method(XBaseWindow, "getScreenNumber", new Class[0]);
                x11.display = (Long)X11UiUtil.method(toolkitClass, "getDisplay", new Class[0]).invoke(null, new Object[0]);
                x11.awtLock = X11UiUtil.method(toolkitClass, "awtLock", new Class[0]);
                x11.awtUnlock = X11UiUtil.method(toolkitClass, "awtUnlock", new Class[0]);
                Class<?> XAtom = Class.forName("sun.awt.X11.XAtom");
                Method get2 = X11UiUtil.method(XAtom, "get", String.class);
                Field atom = X11UiUtil.field(XAtom, "atom");
                x11.UTF8_STRING = (Long)atom.get(get2.invoke(null, "UTF8_STRING"));
                x11.NET_SUPPORTING_WM_CHECK = (Long)atom.get(get2.invoke(null, "_NET_SUPPORTING_WM_CHECK"));
                x11.NET_WM_NAME = (Long)atom.get(get2.invoke(null, "_NET_WM_NAME"));
                x11.NET_WM_ALLOWED_ACTIONS = (Long)atom.get(get2.invoke(null, "_NET_WM_ALLOWED_ACTIONS"));
                x11.NET_WM_STATE = (Long)atom.get(get2.invoke(null, "_NET_WM_STATE"));
                x11.NET_WM_ACTION_FULLSCREEN = (Long)atom.get(get2.invoke(null, "_NET_WM_ACTION_FULLSCREEN"));
                x11.NET_WM_STATE_FULLSCREEN = (Long)atom.get(get2.invoke(null, "_NET_WM_STATE_FULLSCREEN"));
                x11.NET_WM_STATE_DEMANDS_ATTENTION = (Long)atom.get(get2.invoke(null, "_NET_WM_STATE_DEMANDS_ATTENTION"));
                x11.NET_ACTIVE_WINDOW = (Long)atom.get(get2.invoke(null, "_NET_ACTIVE_WINDOW"));
                Long netWmWindow = x11.getNetWmWindow();
                if (netWmWindow == null) {
                    LOG.info("_NET protocol is not supported");
                    return null;
                }
                return x11;
            }
            catch (Throwable t) {
                LOG.info("cannot initialize", t);
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long getRootWindow(long screen) throws Exception {
            this.awtLock.invoke(null, new Object[0]);
            try {
                long l = (Long)this.RootWindow.invoke(null, this.display, screen);
                return l;
            }
            finally {
                this.awtUnlock.invoke(null, new Object[0]);
            }
        }

        @Nullable
        private Long getNetWmWindow() throws Exception {
            long rootWindow = this.getRootWindow(0L);
            long[] values2 = this.getLongArrayProperty(rootWindow, this.NET_SUPPORTING_WM_CHECK, 33L);
            return values2 != null && values2.length > 0 ? Long.valueOf(values2[0]) : null;
        }

        private long @Nullable [] getLongArrayProperty(long window, long name, long type) throws Exception {
            return (long[])this.getWindowProperty(window, name, type, 32L);
        }

        @Nullable
        private String getUtfStringProperty(long window, long name) throws Exception {
            byte[] bytes = (byte[])this.getWindowProperty(window, name, this.UTF8_STRING, 8L);
            return bytes != null ? new String(bytes, StandardCharsets.UTF_8) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private <T> T getWindowProperty(long window, long name, long type, long expectedFormat) throws Exception {
            long data2 = this.unsafe.allocateMemory(64L);
            this.awtLock.invoke(null, new Object[0]);
            try {
                this.unsafe.setMemory(data2, 64L, (byte)0);
                int result2 = (Integer)this.XGetWindowProperty.invoke(null, this.display, window, name, 0L, 65535L, 0L, type, data2, data2 + 8L, data2 + 16L, data2 + 24L, data2 + 32L);
                if (result2 == 0) {
                    long pointer;
                    int format2 = this.unsafe.getInt(data2 + 8L);
                    long l = pointer = Native.LONG_SIZE == 4 ? (long)this.unsafe.getInt(data2 + 32L) : this.unsafe.getLong(data2 + 32L);
                    if (pointer != 0L && (long)format2 == expectedFormat) {
                        int length;
                        int n = length = Native.LONG_SIZE == 4 ? this.unsafe.getInt(data2 + 16L) : (int)this.unsafe.getLong(data2 + 16L);
                        if (format2 == 8) {
                            byte[] bytes = new byte[length];
                            for (int i2 = 0; i2 < length; ++i2) {
                                bytes[i2] = this.unsafe.getByte(pointer + (long)i2);
                            }
                            byte[] i2 = bytes;
                            return (T)i2;
                        }
                        if (format2 == 32) {
                            long[] values2 = new long[length];
                            for (int i3 = 0; i3 < length; ++i3) {
                                values2[i3] = Native.LONG_SIZE == 4 ? (long)this.unsafe.getInt(pointer + 4L * (long)i3) : this.unsafe.getLong(pointer + 8L * (long)i3);
                            }
                            long[] lArray = values2;
                            return (T)lArray;
                        }
                        if ((long)format2 != 0L) {
                            LOG.info("unexpected format: " + format2);
                        }
                    }
                    if (pointer != 0L) {
                        this.XFree.invoke(null, pointer);
                    }
                }
            }
            finally {
                this.awtUnlock.invoke(null, new Object[0]);
                this.unsafe.freeMemory(data2);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendClientMessage(long target2, long window, long type, long ... data2) throws Exception {
            assert (data2.length <= 5);
            long event = this.unsafe.allocateMemory(128L);
            this.awtLock.invoke(null, new Object[0]);
            try {
                this.unsafe.setMemory(event, 128L, (byte)0);
                this.unsafe.putInt(event, 33);
                if (Native.LONG_SIZE == 4) {
                    this.unsafe.putInt(event + 8L, 1);
                    this.unsafe.putInt(event + 16L, (int)window);
                    this.unsafe.putInt(event + 20L, (int)type);
                    this.unsafe.putInt(event + 24L, 32);
                    for (int i2 = 0; i2 < data2.length; ++i2) {
                        this.unsafe.putInt(event + 28L + 4L * (long)i2, (int)data2[i2]);
                    }
                } else {
                    this.unsafe.putInt(event + 16L, 1);
                    this.unsafe.putLong(event + 32L, window);
                    this.unsafe.putLong(event + 40L, type);
                    this.unsafe.putInt(event + 48L, 32);
                    for (int i3 = 0; i3 < data2.length; ++i3) {
                        this.unsafe.putLong(event + 56L + 8L * (long)i3, data2[i3]);
                    }
                }
                this.XSendEvent.invoke(null, this.display, target2, false, 0x180000L, event);
            }
            finally {
                this.awtUnlock.invoke(null, new Object[0]);
                this.unsafe.freeMemory(event);
            }
        }

        private void sendClientMessage(Window window, String operation2, long type, long ... params) {
            try {
                Object peer = AWTAccessor.getComponentAccessor().getPeer(window);
                if (peer == null) {
                    throw new IllegalStateException(window + " has no peer");
                }
                long windowId = (Long)this.getWindow.invoke(peer, new Object[0]);
                long screen = (Long)this.getScreenNumber.invoke(peer, new Object[0]);
                long rootWindow = this.getRootWindow(screen);
                this.sendClientMessage(rootWindow, windowId, type, params);
            }
            catch (Throwable t) {
                LOG.info("cannot " + operation2, t);
            }
        }
    }
}

