/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.configurationStore.XmlSerializer;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponentWithModificationTracker;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowContentUiType;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.DesktopLayout;
import com.intellij.openapi.wm.impl.FrameBoundsConverter;
import com.intellij.openapi.wm.impl.FrameInfo;
import com.intellij.openapi.wm.impl.FrameInfoHelper;
import com.intellij.openapi.wm.impl.FrameTitleBuilder;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.IdeMenuBar;
import com.intellij.openapi.wm.impl.IdeRootPane;
import com.intellij.openapi.wm.impl.ProjectFrameBounds;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.openapi.wm.impl.TitleInfoProvider;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import com.intellij.openapi.wm.impl.WindowManagerImpl;
import com.intellij.openapi.wm.impl.WindowManagerImplKt;
import com.intellij.openapi.wm.impl.WindowWatcher;
import com.intellij.openapi.wm.impl.status.IdeStatusBarImpl;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ScreenUtil;
import com.sun.jna.platform.WindowUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="WindowManager", defaultStateAsResource=true, storages={@Storage(value="window.state.xml", roamingType=RoamingType.DISABLED)})
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u00d7\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\r\b\u0007\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0005\u00a2\u0006\u0002\u0010\u0004J \u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u00132\u0010\b\u0002\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u001cJ\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0014H\u0002J\u0016\u0010 \u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0013J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#H\u0016J\u0006\u0010$\u001a\u00020\u001eJ\u0010\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020'H\u0016J\n\u0010(\u001a\u0004\u0018\u00010\u0014H\u0016J\u0014\u0010)\u001a\u0004\u0018\u00010*2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0013H\u0016J\u0014\u0010+\u001a\u0004\u0018\u00010\u00142\b\u0010\u001a\u001a\u0004\u0018\u00010\u0013H\u0016J\n\u0010,\u001a\u0004\u0018\u00010-H\u0016J\u0013\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00140/H\u0016\u00a2\u0006\u0002\u00100J\u0019\u00101\u001a\t\u0018\u000102\u00a2\u0006\u0002\b32\b\u0010\u001a\u001a\u0004\u0018\u00010\u0013H\u0016J\u0017\u00101\u001a\t\u0018\u000102\u00a2\u0006\u0002\b32\u0006\u0010&\u001a\u00020'H\u0016J\u0014\u00104\u001a\u0004\u0018\u0001052\b\u0010\u001a\u001a\u0004\u0018\u00010\u0013H\u0016J\u0014\u00106\u001a\u0004\u0018\u00010\u00142\b\u0010\u001a\u001a\u0004\u0018\u00010\u0013H\u0017J\u0014\u00107\u001a\u0004\u0018\u00010*2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u00108\u001a\u00020\u0010H\u0016J\u000f\u00109\u001a\t\u0018\u00010'\u00a2\u0006\u0002\b3H\u0016J\u000e\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00140;H\u0016J\u0019\u0010<\u001a\t\u0018\u00010=\u00a2\u0006\u0002\b32\b\u0010\u001a\u001a\u0004\u0018\u00010\u0013H\u0007J\r\u0010>\u001a\u00070?\u00a2\u0006\u0002\b@H\u0016J\u0012\u0010>\u001a\u0004\u0018\u00010?2\u0006\u0010\u001a\u001a\u00020\u0013H\u0016J\b\u0010A\u001a\u00020\u0003H\u0016J\b\u0010B\u001a\u00020CH\u0016J\u0017\u0010D\u001a\t\u0018\u00010E\u00a2\u0006\u0002\b32\u0006\u0010\u001a\u001a\u00020\u0013H\u0016J\u001c\u0010D\u001a\u0004\u0018\u00010F2\u0006\u0010G\u001a\u0002022\b\u0010\u001a\u001a\u0004\u0018\u00010\u0013H\u0016J\u0010\u0010H\u001a\u00020\u00062\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010I\u001a\u00020\u0006H\u0016J\b\u0010J\u001a\u00020\u0006H\u0016J \u0010K\u001a\u00020\u00062\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020M2\u0006\u0010O\u001a\u00020MH\u0016J\u0010\u0010P\u001a\u00020\u00062\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010Q\u001a\u00020\u001e2\u0006\u0010R\u001a\u00020\u0003H\u0016J\b\u0010S\u001a\u00020\u001eH\u0016J\u0010\u0010T\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0014H\u0016J\u000f\u0010U\u001a\u0004\u0018\u00010\u0014H\u0000\u00a2\u0006\u0002\bVJ\u0010\u0010W\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020'H\u0016J\u0018\u0010X\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020'2\u0006\u0010R\u001a\u00020\u0006H\u0016J\u0018\u0010Y\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020'2\u0006\u0010Z\u001a\u00020[H\u0016J\u0010\u0010\\\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010]\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020'2\b\u0010^\u001a\u0004\u0018\u00010_H\u0016J\u0018\u0010`\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020'2\u0006\u0010a\u001a\u00020bH\u0016J\u0019\u0010c\u001a\t\u0018\u00010'\u00a2\u0006\u0002\b32\b\u0010\u001a\u001a\u0004\u0018\u00010\u0013H\u0016J\u0010\u0010d\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u0013H\u0016R\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0012\u0004\u0012\u00020\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0016X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006e"}, d2={"Lcom/intellij/openapi/wm/impl/WindowManagerImpl;", "Lcom/intellij/openapi/wm/ex/WindowManagerEx;", "Lcom/intellij/openapi/components/PersistentStateComponentWithModificationTracker;", "Lorg/jdom/Element;", "()V", "alphaModeSupported", "", "Ljava/lang/Boolean;", "defaultFrameInfoHelper", "Lcom/intellij/openapi/wm/impl/FrameInfoHelper;", "getDefaultFrameInfoHelper$intellij_platform_ide_impl", "()Lcom/intellij/openapi/wm/impl/FrameInfoHelper;", "frameStateListener", "com/intellij/openapi/wm/impl/WindowManagerImpl$frameStateListener$1", "Lcom/intellij/openapi/wm/impl/WindowManagerImpl$frameStateListener$1;", "layout", "Lcom/intellij/openapi/wm/impl/DesktopLayout;", "projectToFrame", "", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/openapi/wm/impl/ProjectFrameHelper;", "windowWatcher", "Lcom/intellij/openapi/wm/impl/WindowWatcher;", "getWindowWatcher$intellij_platform_ide_impl", "()Lcom/intellij/openapi/wm/impl/WindowWatcher;", "allocateFrame", "project", "projectFrameHelperFactory", "Ljava/util/function/Supplier;", "allocateNewFrame", "", "frameHelper", "assignFrame", "dispatchComponentEvent", "e", "Ljava/awt/event/ComponentEvent;", "disposeRootFrame", "doNotSuggestAsParent", "window", "Ljava/awt/Window;", "findFirstVisibleFrameHelper", "findFrameFor", "Lcom/intellij/openapi/wm/IdeFrame;", "findFrameHelper", "findVisibleFrame", "Ljavax/swing/JFrame;", "getAllProjectFrames", "", "()[Lcom/intellij/openapi/wm/impl/ProjectFrameHelper;", "getFocusedComponent", "Ljava/awt/Component;", "Lorg/jetbrains/annotations/Nullable;", "getFrame", "Lcom/intellij/openapi/wm/impl/IdeFrameImpl;", "getFrameHelper", "getIdeFrame", "getLayout", "getMostRecentFocusedWindow", "getProjectFrameHelpers", "", "getProjectFrameRootPane", "Lcom/intellij/openapi/wm/impl/IdeRootPane;", "getScreenBounds", "Ljava/awt/Rectangle;", "Lorg/jetbrains/annotations/NotNull;", "getState", "getStateModificationCount", "", "getStatusBar", "Lcom/intellij/openapi/wm/impl/status/IdeStatusBarImpl;", "Lcom/intellij/openapi/wm/StatusBar;", "component", "isAlphaModeEnabled", "isAlphaModeSupported", "isFullScreenSupportedInCurrentOS", "isInsideScreenBounds", "x", "", "y", "width", "isNotSuggestAsParent", "loadState", "state", "noStateLoaded", "releaseFrame", "removeAndGetRootFrame", "removeAndGetRootFrame$intellij_platform_ide_impl", "resetWindow", "setAlphaModeEnabled", "setAlphaModeRatio", "ratio", "", "setLayout", "setWindowMask", "mask", "Ljava/awt/Shape;", "setWindowShadow", "mode", "Lcom/intellij/openapi/wm/ex/WindowManagerEx$WindowShadowMode;", "suggestParentWindow", "updateDefaultFrameInfoOnProjectClose", "intellij.platform.ide.impl"})
public final class WindowManagerImpl
extends WindowManagerEx
implements PersistentStateComponentWithModificationTracker<Element> {
    private Boolean alphaModeSupported;
    @NotNull
    private final WindowWatcher windowWatcher = new WindowWatcher();
    private DesktopLayout layout = new DesktopLayout(null, 1, null);
    private final Map<Project, ProjectFrameHelper> projectToFrame = new HashMap();
    @NotNull
    private final FrameInfoHelper defaultFrameInfoHelper = new FrameInfoHelper();
    private final frameStateListener.1 frameStateListener = new ComponentAdapter(this){
        final /* synthetic */ WindowManagerImpl this$0;

        public void componentMoved(@NotNull ComponentEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.update(e);
        }

        public void componentResized(@NotNull ComponentEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.update(e);
        }

        private final void update(ComponentEvent e) {
            Component component2 = e.getComponent();
            if (component2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.wm.impl.IdeFrameImpl");
            }
            IdeFrameImpl frame = (IdeFrameImpl)component2;
            JRootPane rootPane = frame.getRootPane();
            if (rootPane != null && (Intrinsics.areEqual((Object)rootPane.getClientProperty("dispose.temporary"), (Object)true) || Intrinsics.areEqual((Object)rootPane.getClientProperty("togglingFullScreenInProgress"), (Object)true))) {
                return;
            }
            int extendedState = frame.getExtendedState();
            Rectangle bounds2 = frame.getBounds();
            if (extendedState == 0 && rootPane != null) {
                rootPane.putClientProperty("normalBounds", bounds2);
            }
            ProjectFrameHelper projectFrameHelper = ProjectFrameHelper.getFrameHelper(frame);
            if (projectFrameHelper == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)projectFrameHelper, (String)"ProjectFrameHelper.getFrameHelper(frame) ?: return");
            ProjectFrameHelper frameHelper = projectFrameHelper;
            Project project = frameHelper.getProject();
            if (project == null) {
                this.this$0.getDefaultFrameInfoHelper$intellij_platform_ide_impl().updateFrameInfo(frameHelper, frame);
            } else if (!project.isDisposed()) {
                ProjectFrameBounds.Companion.getInstance(project).markDirty(FrameInfoHelper.Companion.isMaximized(extendedState) ? null : bounds2);
            }
        }
        {
            this.this$0 = this$0;
        }
    };

    @NotNull
    public final WindowWatcher getWindowWatcher$intellij_platform_ide_impl() {
        return this.windowWatcher;
    }

    @NotNull
    public final FrameInfoHelper getDefaultFrameInfoHelper$intellij_platform_ide_impl() {
        return this.defaultFrameInfoHelper;
    }

    @NotNull
    public ProjectFrameHelper[] getAllProjectFrames() {
        Collection<ProjectFrameHelper> $this$toTypedArray$iv = this.projectToFrame.values();
        boolean $i$f$toTypedArray = false;
        Collection<ProjectFrameHelper> thisCollection$iv = $this$toTypedArray$iv;
        ProjectFrameHelper[] projectFrameHelperArray = thisCollection$iv.toArray(new ProjectFrameHelper[0]);
        if (projectFrameHelperArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return projectFrameHelperArray;
    }

    @Override
    @NotNull
    public List<ProjectFrameHelper> getProjectFrameHelpers() {
        return CollectionsKt.toList((Iterable)this.projectToFrame.values());
    }

    @Nullable
    public JFrame findVisibleFrame() {
        JFrame jFrame;
        IdeFrame ideFrame = (ProjectFrameHelper)CollectionsKt.firstOrNull((Iterable)this.projectToFrame.values());
        if (ideFrame != null && (ideFrame = ideFrame.getFrame()) != null) {
            jFrame = (JFrame)ideFrame;
        } else {
            IdeFrame ideFrame2 = WelcomeFrame.getInstance();
            if (!(ideFrame2 instanceof JFrame)) {
                ideFrame2 = null;
            }
            jFrame = (JFrame)ideFrame2;
        }
        return jFrame;
    }

    @Override
    @Nullable
    public ProjectFrameHelper findFirstVisibleFrameHelper() {
        return (ProjectFrameHelper)CollectionsKt.firstOrNull((Iterable)this.projectToFrame.values());
    }

    @Override
    @NotNull
    public Rectangle getScreenBounds() {
        Rectangle rectangle = ScreenUtil.getAllScreensRectangle();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"ScreenUtil.getAllScreensRectangle()");
        return rectangle;
    }

    @Override
    @Nullable
    public Rectangle getScreenBounds(@NotNull Project project) {
        GraphicsDevice[] devices;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        IdeFrameImpl ideFrameImpl = this.getFrame(project);
        Intrinsics.checkNotNull((Object)ideFrameImpl);
        Point onScreen = ideFrameImpl.getLocationOnScreen();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Intrinsics.checkNotNullExpressionValue((Object)graphicsEnvironment, (String)"GraphicsEnvironment.getLocalGraphicsEnvironment()");
        GraphicsDevice[] graphicsDeviceArray = devices = graphicsEnvironment.getScreenDevices();
        int n = graphicsDeviceArray.length;
        for (int j = 0; j < n; ++j) {
            GraphicsDevice device;
            GraphicsDevice graphicsDevice = device = graphicsDeviceArray[j];
            Intrinsics.checkNotNullExpressionValue((Object)graphicsDevice, (String)"device");
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)graphicsConfiguration, (String)"device.defaultConfiguration");
            Rectangle bounds2 = graphicsConfiguration.getBounds();
            if (!bounds2.contains(onScreen)) continue;
            return bounds2;
        }
        return null;
    }

    public boolean isInsideScreenBounds(int x, int y, int width) {
        return ScreenUtil.getAllScreensShape().contains(x, y, width, 1.0);
    }

    public boolean isAlphaModeSupported() {
        Boolean result2 = this.alphaModeSupported;
        if (result2 == null) {
            this.alphaModeSupported = result2 = Boolean.valueOf(WindowManagerImplKt.access$calcAlphaModelSupported());
        }
        return result2;
    }

    public void setAlphaModeRatio(@NotNull Window window, float ratio) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        boolean bl = window.isDisplayable() && window.isShowing();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "window must be displayable and showing. window=" + window;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        float f = ratio;
        boolean bl5 = f >= 0.0f && f <= 1.0f;
        bl2 = false;
        bl3 = false;
        if (!bl5) {
            boolean bl6 = false;
            String string = "ratio must be in [0..1] range. ratio=" + ratio;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (!this.isAlphaModeSupported() || !this.isAlphaModeEnabled(window)) {
            return;
        }
        WindowManagerImplKt.access$setAlphaMode(window, ratio);
    }

    @Override
    public void setWindowMask(@NotNull Window window, @Nullable Shape mask) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        try {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Intrinsics.checkNotNullExpressionValue((Object)graphicsEnvironment, (String)"GraphicsEnvironment.getLocalGraphicsEnvironment()");
            if (graphicsEnvironment.getDefaultScreenDevice().isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.PERPIXEL_TRANSPARENT)) {
                window.setShape(mask);
            } else {
                WindowUtils.setWindowMask((Window)window, (Shape)mask);
            }
        }
        catch (Throwable e) {
            WindowManagerImplKt.access$getLOG$p().debug(e);
        }
    }

    @Override
    public void setWindowShadow(@NotNull Window window, @NotNull WindowManagerEx.WindowShadowMode mode) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        if (window instanceof JWindow) {
            JRootPane root = ((JWindow)window).getRootPane();
            root.putClientProperty("Window.shadow", mode != WindowManagerEx.WindowShadowMode.DISABLED);
            root.putClientProperty("Window.style", mode == WindowManagerEx.WindowShadowMode.SMALL ? "small" : null);
        }
    }

    @Override
    public void resetWindow(@NotNull Window window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        try {
            if (!this.isAlphaModeSupported()) {
                return;
            }
            this.setWindowMask(window, null);
            WindowManagerImplKt.access$setAlphaMode(window, 0.0f);
            this.setWindowShadow(window, WindowManagerEx.WindowShadowMode.NORMAL);
        }
        catch (Throwable e) {
            WindowManagerImplKt.access$getLOG$p().debug(e);
        }
    }

    public boolean isAlphaModeEnabled(@NotNull Window window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        boolean bl = window.isDisplayable() && window.isShowing();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "window must be displayable and showing. window=" + window;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return this.isAlphaModeSupported();
    }

    public void setAlphaModeEnabled(@NotNull Window window, boolean state) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        boolean bl = window.isDisplayable() && window.isShowing();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "window must be displayable and showing. window=" + window;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public boolean isNotSuggestAsParent(@NotNull Window window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        return this.windowWatcher.isNotSuggestAsParent(window);
    }

    public void doNotSuggestAsParent(@NotNull Window window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        this.windowWatcher.doNotSuggestAsParent(window);
    }

    @Override
    public void dispatchComponentEvent(@NotNull ComponentEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.windowWatcher.dispatchComponentEvent(e);
    }

    @Nullable
    public Window suggestParentWindow(@Nullable Project project) {
        return this.windowWatcher.suggestParentWindow(project, this);
    }

    @Nullable
    public IdeStatusBarImpl getStatusBar(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ProjectFrameHelper projectFrameHelper = this.getFrameHelper(project);
        return projectFrameHelper != null ? projectFrameHelper.getStatusBar() : null;
    }

    @Nullable
    public StatusBar getStatusBar(@NotNull Component component2, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Component component3 = ComponentUtil.findUltimateParent((Component)component2);
        Intrinsics.checkNotNullExpressionValue((Object)component3, (String)"ComponentUtil.findUltimateParent(component)");
        Component parent = component3;
        if (parent instanceof IdeFrame) {
            StatusBar statusBar2 = ((IdeFrame)parent).getStatusBar();
            Intrinsics.checkNotNull((Object)statusBar2);
            return statusBar2.findChild(component2);
        }
        IdeFrame ideFrame = this.findFrameFor(project);
        if (ideFrame == null) {
            return null;
        }
        IdeFrame frame = ideFrame;
        StatusBar statusBar3 = frame.getStatusBar();
        Intrinsics.checkNotNull((Object)statusBar3);
        return statusBar3.findChild(component2);
    }

    @Override
    @Nullable
    public IdeFrame findFrameFor(@Nullable Project project) {
        IdeFrame ideFrame;
        if (project == null) {
            ProjectFrameHelper projectFrameHelper = ProjectFrameHelper.getFrameHelper(this.getMostRecentFocusedWindow());
            ideFrame = projectFrameHelper != null ? (IdeFrame)projectFrameHelper : WindowManagerImplKt.access$tryToFindTheOnlyFrame();
        } else if (project.isDefault()) {
            ideFrame = WelcomeFrame.getInstance();
        } else {
            ProjectFrameHelper projectFrameHelper = this.getFrameHelper(project);
            if (projectFrameHelper == null) {
                projectFrameHelper = this.getFrameHelper(null);
            }
            ideFrame = projectFrameHelper;
        }
        return ideFrame;
    }

    @Override
    @Nullable
    public IdeFrameImpl getFrame(@Nullable Project project) {
        ProjectFrameHelper projectFrameHelper = this.getFrameHelper(project);
        return projectFrameHelper != null ? projectFrameHelper.getFrame() : null;
    }

    @Override
    @ApiStatus.Internal
    @Nullable
    public ProjectFrameHelper getFrameHelper(@Nullable Project project) {
        return this.projectToFrame.get(project);
    }

    @Override
    @Nullable
    public ProjectFrameHelper findFrameHelper(@Nullable Project project) {
        Object object = project;
        if (object == null) {
            IdeFocusManager ideFocusManager = IdeFocusManager.getGlobalInstance();
            Intrinsics.checkNotNullExpressionValue((Object)ideFocusManager, (String)"IdeFocusManager.getGlobalInstance()");
            IdeFrame ideFrame = ideFocusManager.getLastFocusedFrame();
            object = ideFrame != null ? ideFrame.getProject() : null;
        }
        if (object == null) {
            return null;
        }
        return this.getFrameHelper((Project)object);
    }

    @ApiStatus.Internal
    @Nullable
    public final IdeRootPane getProjectFrameRootPane(@Nullable Project project) {
        ProjectFrameHelper projectFrameHelper = this.projectToFrame.get(project);
        return projectFrameHelper != null ? projectFrameHelper.getRootPane() : null;
    }

    @Nullable
    public IdeFrame getIdeFrame(@Nullable Project project) {
        if (project != null) {
            return this.getFrameHelper(project);
        }
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Intrinsics.checkNotNullExpressionValue((Object)keyboardFocusManager, (String)"KeyboardFocusManager.get\u2026entKeyboardFocusManager()");
        Window window = keyboardFocusManager.getActiveWindow();
        if (window != null) {
            Component component2 = ComponentUtil.findUltimateParent((Component)window);
            Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"ComponentUtil.findUltimateParent(window)");
            IdeFrame ideFrame = WindowManagerImplKt.access$getIdeFrame(component2);
            if (ideFrame != null) {
                IdeFrame ideFrame2 = ideFrame;
                boolean bl = false;
                boolean bl2 = false;
                IdeFrame it = ideFrame2;
                boolean bl3 = false;
                return it;
            }
        }
        Frame[] frameArray = Frame.getFrames();
        int n = frameArray.length;
        for (int j = 0; j < n; ++j) {
            Frame each;
            Frame frame = each = frameArray[j];
            Intrinsics.checkNotNullExpressionValue((Object)frame, (String)"each");
            IdeFrame ideFrame = WindowManagerImplKt.access$getIdeFrame(frame);
            if (ideFrame == null) continue;
            IdeFrame ideFrame3 = ideFrame;
            boolean bl = false;
            boolean bl4 = false;
            IdeFrame it = ideFrame3;
            boolean bl5 = false;
            return it;
        }
        return null;
    }

    @Nullable
    public final ProjectFrameHelper removeAndGetRootFrame$intellij_platform_ide_impl() {
        return this.projectToFrame.remove(null);
    }

    public final void assignFrame(@NotNull ProjectFrameHelper frameHelper, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)frameHelper, (String)"frameHelper");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        WindowManagerImplKt.access$getLOG$p().assertTrue(!this.projectToFrame.containsKey(project));
        this.projectToFrame.put(project, frameHelper);
        frameHelper.setProject(project);
        IdeFrameImpl ideFrameImpl = frameHelper.getFrame();
        Intrinsics.checkNotNull((Object)ideFrameImpl);
        Intrinsics.checkNotNullExpressionValue((Object)ideFrameImpl, (String)"frameHelper.frame!!");
        IdeFrameImpl frame = ideFrameImpl;
        frame.setTitle(FrameTitleBuilder.getInstance().getProjectTitle(project));
        frame.addComponentListener(this.frameStateListener);
    }

    @NotNull
    public final ProjectFrameHelper allocateFrame(@NotNull Project project, @NotNull Supplier<? extends ProjectFrameHelper> projectFrameHelperFactory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(projectFrameHelperFactory, (String)"projectFrameHelperFactory");
        ProjectFrameHelper frame = this.getFrameHelper(project);
        if (frame != null) {
            return frame;
        }
        frame = this.removeAndGetRootFrame$intellij_platform_ide_impl();
        if (frame == null) {
            frame = projectFrameHelperFactory.get();
            this.allocateNewFrame(project, frame);
        } else {
            frame.setProject(project);
            this.projectToFrame.put(project, frame);
        }
        return frame;
    }

    public static /* synthetic */ ProjectFrameHelper allocateFrame$default(WindowManagerImpl windowManagerImpl, Project project, Supplier supplier2, int n, Object object) {
        if ((n & 2) != 0) {
            supplier2 = allocateFrame.1.INSTANCE;
        }
        return windowManagerImpl.allocateFrame(project, supplier2);
    }

    private final void allocateNewFrame(Project project, ProjectFrameHelper frameHelper) {
        ProjectFrameHelper lastFocusedProjectFrame;
        ProjectFrameHelper projectFrameHelper;
        frameHelper.init();
        FrameInfo frameInfo = null;
        IdeFocusManager ideFocusManager = IdeFocusManager.getGlobalInstance();
        Intrinsics.checkNotNullExpressionValue((Object)ideFocusManager, (String)"IdeFocusManager.getGlobalInstance()");
        IdeFrame ideFrame = ideFocusManager.getLastFocusedFrame();
        if (ideFrame != null && (ideFrame = ideFrame.getProject()) != null) {
            IdeFrame ideFrame2 = ideFrame;
            boolean bl = false;
            boolean bl2 = false;
            IdeFrame it = ideFrame2;
            boolean bl3 = false;
            projectFrameHelper = this.getFrameHelper((Project)it);
        } else {
            projectFrameHelper = lastFocusedProjectFrame = null;
        }
        if (lastFocusedProjectFrame != null) {
            FrameInfo frameInfo2 = frameInfo = WindowManagerImplKt.access$getFrameInfoByFrameHelper(lastFocusedProjectFrame);
            if ((frameInfo2 != null ? frameInfo2.getBounds() : null) == null) {
                frameInfo = this.defaultFrameInfoHelper.getInfo();
            }
        }
        FrameInfo frameInfo3 = frameInfo;
        if ((frameInfo3 != null ? frameInfo3.getBounds() : null) != null) {
            Rectangle bounds2;
            if (frameInfo != this.defaultFrameInfoHelper.getInfo()) {
                this.defaultFrameInfoHelper.copyFrom(frameInfo);
            }
            if ((bounds2 = frameInfo.getBounds()) != null) {
                IdeFrameImpl ideFrameImpl = frameHelper.getFrame();
                Intrinsics.checkNotNull((Object)ideFrameImpl);
                Intrinsics.checkNotNullExpressionValue((Object)ideFrameImpl, (String)"frameHelper.frame!!");
                ideFrameImpl.setBounds(FrameBoundsConverter.convertFromDeviceSpaceAndFitToScreen(bounds2));
            }
        }
        frameHelper.setProject(project);
        this.projectToFrame.put(project, frameHelper);
        IdeFrameImpl ideFrameImpl = frameHelper.getFrame();
        Intrinsics.checkNotNull((Object)ideFrameImpl);
        Intrinsics.checkNotNullExpressionValue((Object)ideFrameImpl, (String)"frameHelper.frame!!");
        IdeFrameImpl uiFrame = ideFrameImpl;
        if (frameInfo != null) {
            uiFrame.setExtendedState(frameInfo.getExtendedState());
        }
        uiFrame.setVisible(true);
        if (FrameInfoHelper.Companion.isFullScreenSupportedInCurrentOs() && frameInfo != null && frameInfo.getFullScreen()) {
            frameHelper.toggleFullScreen(true);
        }
        uiFrame.addComponentListener(this.frameStateListener);
        IdeMenuBar.installAppMenuIfNeeded(uiFrame);
    }

    @Override
    public void releaseFrame(@NotNull ProjectFrameHelper frameHelper) {
        Intrinsics.checkNotNullParameter((Object)frameHelper, (String)"frameHelper");
        Project project = frameHelper.getProject();
        Intrinsics.checkNotNull((Object)project);
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"frameHelper.project!!");
        Project project2 = project;
        frameHelper.frameReleased();
        this.projectToFrame.remove(project2);
        if (this.projectToFrame.isEmpty() && !(project2 instanceof LightEditCompatible)) {
            this.projectToFrame.put(null, frameHelper);
        } else {
            IdeStatusBarImpl ideStatusBarImpl = frameHelper.getStatusBar();
            if (ideStatusBarImpl != null) {
                IdeStatusBarImpl ideStatusBarImpl2 = ideStatusBarImpl;
                boolean bl = false;
                boolean bl2 = false;
                IdeStatusBarImpl it = ideStatusBarImpl2;
                boolean bl3 = false;
                Disposer.dispose((Disposable)((Disposable)it));
            }
            Disposer.dispose((Disposable)frameHelper);
        }
    }

    public final void disposeRootFrame() {
        block1: {
            if (this.projectToFrame.size() != 1) break block1;
            ProjectFrameHelper projectFrameHelper = this.removeAndGetRootFrame$intellij_platform_ide_impl();
            if (projectFrameHelper != null) {
                ProjectFrameHelper projectFrameHelper2 = projectFrameHelper;
                boolean bl = false;
                boolean bl2 = false;
                ProjectFrameHelper it = projectFrameHelper2;
                boolean bl3 = false;
                Disposer.dispose((Disposable)it);
            }
        }
    }

    @Override
    @Nullable
    public Window getMostRecentFocusedWindow() {
        return this.windowWatcher.getFocusedWindow();
    }

    @Override
    @Nullable
    public Component getFocusedComponent(@NotNull Window window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        return this.windowWatcher.getFocusedComponent(window);
    }

    @Override
    @Nullable
    public Component getFocusedComponent(@Nullable Project project) {
        return this.windowWatcher.getFocusedComponent(project);
    }

    /*
     * WARNING - void declaration
     */
    public void noStateLoaded() {
        void order;
        void anchor2;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.LEFT;
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor, (String)"ToolWindowAnchor.LEFT");
        objectRef.element = toolWindowAnchor;
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 0;
        Function3<String, Float, ToolWindowContentUiType, WindowInfoImpl> $fun$info$1 = new Function3<String, Float, ToolWindowContentUiType, WindowInfoImpl>((Ref.ObjectRef)anchor2, (Ref.IntRef)order){
            final /* synthetic */ Ref.ObjectRef $anchor;
            final /* synthetic */ Ref.IntRef $order;

            @NotNull
            public final WindowInfoImpl invoke(@NotNull String id2, float weight2, @Nullable ToolWindowContentUiType contentUiType2) {
                Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
                WindowInfoImpl result2 = new WindowInfoImpl();
                result2.setId(id2);
                result2.setAnchor((ToolWindowAnchor)this.$anchor.element);
                if (weight2 != -1.0f) {
                    result2.setWeight(weight2);
                }
                ToolWindowContentUiType toolWindowContentUiType = contentUiType2;
                if (toolWindowContentUiType != null) {
                    ToolWindowContentUiType toolWindowContentUiType2 = toolWindowContentUiType;
                    boolean bl = false;
                    boolean bl2 = false;
                    ToolWindowContentUiType it = toolWindowContentUiType2;
                    boolean bl3 = false;
                    result2.setContentUiType(it);
                }
                int n = this.$order.element;
                this.$order.element = n + 1;
                result2.setOrder(n);
                result2.setFromPersistentSettings$intellij_platform_ide_impl(false);
                result2.resetModificationCount();
                return result2;
            }

            public static /* synthetic */ WindowInfoImpl invoke$default(noStateLoaded.1 var0, String string, float f, ToolWindowContentUiType toolWindowContentUiType, int n, Object object) {
                if ((n & 2) != 0) {
                    f = -1.0f;
                }
                if ((n & 4) != 0) {
                    toolWindowContentUiType = null;
                }
                return var0.invoke(string, f, toolWindowContentUiType);
            }
            {
                this.$anchor = objectRef;
                this.$order = intRef;
                super(3);
            }
        };
        boolean bl = false;
        List list2 = new ArrayList();
        list2.add($fun$info$1.invoke("Project", 0.25f, ToolWindowContentUiType.COMBO));
        ToolWindowAnchor toolWindowAnchor2 = ToolWindowAnchor.BOTTOM;
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor2, (String)"ToolWindowAnchor.BOTTOM");
        anchor2.element = toolWindowAnchor2;
        order.element = 0;
        list2.add(noStateLoaded.1.invoke$default($fun$info$1, "Version Control", 0.0f, null, 6, null));
        list2.add(noStateLoaded.1.invoke$default($fun$info$1, "Find", 0.0f, null, 6, null));
        list2.add(noStateLoaded.1.invoke$default($fun$info$1, "Run", 0.0f, null, 6, null));
        list2.add(noStateLoaded.1.invoke$default($fun$info$1, "Debug", 0.4f, null, 4, null));
        list2.add(noStateLoaded.1.invoke$default($fun$info$1, "Inspection", 0.4f, null, 4, null));
        for (WindowInfoImpl info2 : list2) {
            String string = info2.getId();
            Intrinsics.checkNotNull((Object)string);
            this.layout.addInfo$intellij_platform_ide_impl(string, info2);
        }
    }

    public void loadState(@NotNull Element state) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Element frameElement = state.getChild("frame");
            if (frameElement != null) {
                FrameInfo info2 = new FrameInfo();
                XmlSerializer.deserializeInto((Element)frameElement, (Object)((Object)info2));
                if ((info2.getExtendedState() & 1) > 0) {
                    info2.setExtendedState(0);
                }
                this.defaultFrameInfoHelper.copyFrom(info2);
            }
            Element element2 = state.getChild("layout");
            if (element2 == null) break block2;
            Element element3 = element2;
            boolean bl = false;
            boolean bl2 = false;
            Element it = element3;
            boolean bl3 = false;
            this.layout.readExternal(it);
        }
    }

    public long getStateModificationCount() {
        return this.defaultFrameInfoHelper.getModificationCount() + this.layout.getStateModificationCount();
    }

    @NotNull
    public Element getState() {
        Element state;
        block2: {
            FrameInfo it;
            boolean bl;
            boolean bl2;
            FrameInfo frameInfo;
            state = new Element("state");
            FrameInfo frameInfo2 = this.defaultFrameInfoHelper.getInfo();
            if (frameInfo2 != null) {
                frameInfo = frameInfo2;
                bl2 = false;
                bl = false;
                it = frameInfo;
                boolean bl3 = false;
                frameInfo2 = XmlSerializer.serialize$default((Object)((Object)it), null, (boolean)false, (int)6, null);
                if (frameInfo2 != null) {
                    frameInfo = frameInfo2;
                    bl2 = false;
                    bl = false;
                    it = frameInfo;
                    boolean bl4 = false;
                    state.addContent((Element)it);
                }
            }
            Element element2 = this.layout.writeExternal("layout");
            if (element2 == null) break block2;
            frameInfo = element2;
            bl2 = false;
            bl = false;
            it = frameInfo;
            boolean bl5 = false;
            state.addContent((Element)it);
        }
        return state;
    }

    @Override
    @NotNull
    public DesktopLayout getLayout() {
        return this.layout;
    }

    @Override
    public void setLayout(@NotNull DesktopLayout layout) {
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        this.layout = layout.copy();
    }

    public boolean isFullScreenSupportedInCurrentOS() {
        return FrameInfoHelper.Companion.isFullScreenSupportedInCurrentOs();
    }

    public void updateDefaultFrameInfoOnProjectClose(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ProjectFrameHelper projectFrameHelper = this.getFrameHelper(project);
        if (projectFrameHelper == null) {
            return;
        }
        ProjectFrameHelper frameHelper = projectFrameHelper;
        FrameInfo frameInfo = WindowManagerImplKt.access$getFrameInfoByFrameHelper(frameHelper);
        if (frameInfo == null) {
            return;
        }
        FrameInfo frameInfo2 = frameInfo;
        this.defaultFrameInfoHelper.copyFrom(frameInfo2);
    }

    public WindowManagerImpl() {
        Application app;
        Application application = app = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"app");
        if (!application.isUnitTestMode()) {
            Disposer.register((Disposable)((Disposable)app), (Disposable)new Disposable(){

                public final void dispose() {
                    this.disposeRootFrame();
                }
            });
            app.getMessageBus().connect().subscribe(TitleInfoProvider.TOPIC, (Object)new TitleInfoProvider.TitleInfoProviderListener(){

                @Override
                public void configurationChanged() {
                    for (ProjectFrameHelper frameHelper : projectToFrame.values()) {
                        frameHelper.updateTitle();
                    }
                }
            });
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusedWindow", this.windowWatcher);
    }
}

