/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.local;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class VirtualFileInfoAction
extends AnAction
implements DumbAware {
    public static final DateFormat DATE_FORMAT = SimpleDateFormat.getDateTimeInstance(1, 1);

    public void actionPerformed(@NotNull AnActionEvent e) {
        String pathToFile;
        if (e == null) {
            VirtualFileInfoAction.$$$reportNull$$$0(0);
        }
        if ((pathToFile = Messages.showInputDialog((String)"Path to file: ", (String)"Virtual File Info", (Icon)Messages.getQuestionIcon())) == null) {
            return;
        }
        VirtualFile virtualFile2 = LocalFileSystem.getInstance().findFileByIoFile(new File(pathToFile));
        if (virtualFile2 == null) {
            Messages.showErrorDialog((String)"Cannot find virtual file", (String)"Virtual File Info");
            return;
        }
        StringBuilder info2 = new StringBuilder();
        info2.append("Path: ");
        info2.append(virtualFile2.getPath());
        info2.append("\n");
        info2.append("Time stamp: ");
        info2.append(DATE_FORMAT.format(new Date(virtualFile2.getTimeStamp())));
        info2.append("\n");
        info2.append("isValid: ");
        info2.append(virtualFile2.isValid());
        info2.append("\n");
        info2.append("isWritable: ");
        info2.append(virtualFile2.isWritable());
        info2.append("\n");
        info2.append("Content: ");
        try {
            info2.append(VfsUtil.loadText((VirtualFile)virtualFile2));
        }
        catch (IOException e1) {
            info2.append("<unable to load content>");
            info2.append(e1.getMessage());
        }
        info2.append("\n");
        Messages.showMessageDialog((String)info2.toString(), (String)"Virtual File Info", (Icon)Messages.getInformationIcon());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vfs/impl/local/VirtualFileInfoAction", "actionPerformed"));
    }
}

