/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.DynamicBundle;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.impl.projectlevelman.PersistentVcsShowSettingOption;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;

public class VcsBackgroundOperationsConfigurationPanel {
    private JPanel myPanel;
    private final Project myProject;
    Map<PersistentVcsShowSettingOption, JCheckBox> myPromptOptions;
    private JCheckBox myCbUpdateInBackground;
    private JCheckBox myCbCommitInBackground;
    private JCheckBox myCbEditInBackground;
    private JCheckBox myCbAddRemoveInBackground;
    private JCheckBox myCbCheckoutInBackground;
    private JCheckBox myPerformRevertInBackgroundCheckBox;
    private JCheckBox myTrackChangedOnServer;
    private JSpinner myChangedOnServerInterval;

    public VcsBackgroundOperationsConfigurationPanel(Project project) {
        this.$$$setupUI$$$();
        this.myPromptOptions = new LinkedHashMap<PersistentVcsShowSettingOption, JCheckBox>();
        this.myProject = project;
        if (!this.myProject.isDefault()) {
            VcsConfiguration settings2 = VcsConfiguration.getInstance((Project)this.myProject);
            this.myChangedOnServerInterval.setModel(new SpinnerNumberModel(settings2.CHANGED_ON_SERVER_INTERVAL, 5, 28800, 5));
            this.myTrackChangedOnServer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VcsBackgroundOperationsConfigurationPanel.this.myChangedOnServerInterval.setEnabled(VcsBackgroundOperationsConfigurationPanel.this.myTrackChangedOnServer.isSelected());
                }
            });
        }
    }

    public void apply() throws ConfigurationException {
        boolean remoteCacheStateChanged;
        VcsConfiguration settings2 = VcsConfiguration.getInstance((Project)this.myProject);
        settings2.PERFORM_COMMIT_IN_BACKGROUND = this.myCbCommitInBackground.isSelected();
        settings2.PERFORM_UPDATE_IN_BACKGROUND = this.myCbUpdateInBackground.isSelected();
        settings2.PERFORM_CHECKOUT_IN_BACKGROUND = this.myCbCheckoutInBackground.isSelected();
        settings2.PERFORM_EDIT_IN_BACKGROUND = this.myCbEditInBackground.isSelected();
        settings2.PERFORM_ADD_REMOVE_IN_BACKGROUND = this.myCbAddRemoveInBackground.isSelected();
        settings2.PERFORM_ROLLBACK_IN_BACKGROUND = this.myPerformRevertInBackgroundCheckBox.isSelected();
        boolean bl = remoteCacheStateChanged = settings2.CHECK_LOCALLY_CHANGED_CONFLICTS_IN_BACKGROUND != this.myTrackChangedOnServer.isSelected();
        if (!this.myProject.isDefault()) {
            settings2.CHECK_LOCALLY_CHANGED_CONFLICTS_IN_BACKGROUND = this.myTrackChangedOnServer.isSelected();
            settings2.CHANGED_ON_SERVER_INTERVAL = ((Number)this.myChangedOnServerInterval.getValue()).intValue();
        }
        for (PersistentVcsShowSettingOption setting : this.myPromptOptions.keySet()) {
            setting.setValue(this.myPromptOptions.get(setting).isSelected());
        }
        RemoteRevisionsCache.getInstance(this.myProject).updateAutomaticRefreshAlarmState(remoteCacheStateChanged);
    }

    public boolean isModified() {
        VcsConfiguration settings2 = VcsConfiguration.getInstance((Project)this.myProject);
        if (settings2.PERFORM_COMMIT_IN_BACKGROUND != this.myCbCommitInBackground.isSelected()) {
            return true;
        }
        if (settings2.PERFORM_UPDATE_IN_BACKGROUND != this.myCbUpdateInBackground.isSelected()) {
            return true;
        }
        if (settings2.PERFORM_CHECKOUT_IN_BACKGROUND != this.myCbCheckoutInBackground.isSelected()) {
            return true;
        }
        if (settings2.PERFORM_EDIT_IN_BACKGROUND != this.myCbEditInBackground.isSelected()) {
            return true;
        }
        if (settings2.PERFORM_ADD_REMOVE_IN_BACKGROUND != this.myCbAddRemoveInBackground.isSelected()) {
            return true;
        }
        if (settings2.PERFORM_ROLLBACK_IN_BACKGROUND != this.myPerformRevertInBackgroundCheckBox.isSelected()) {
            return true;
        }
        if (!this.myProject.isDefault()) {
            if (settings2.CHECK_LOCALLY_CHANGED_CONFLICTS_IN_BACKGROUND != this.myTrackChangedOnServer.isSelected()) {
                return true;
            }
            if (settings2.CHANGED_ON_SERVER_INTERVAL != ((Number)this.myChangedOnServerInterval.getValue()).intValue()) {
                return true;
            }
        }
        return false;
    }

    public void reset() {
        VcsConfiguration settings2 = VcsConfiguration.getInstance((Project)this.myProject);
        this.myCbCommitInBackground.setSelected(settings2.PERFORM_COMMIT_IN_BACKGROUND);
        this.myCbUpdateInBackground.setSelected(settings2.PERFORM_UPDATE_IN_BACKGROUND);
        this.myCbCheckoutInBackground.setSelected(settings2.PERFORM_CHECKOUT_IN_BACKGROUND);
        this.myCbEditInBackground.setSelected(settings2.PERFORM_EDIT_IN_BACKGROUND);
        this.myCbAddRemoveInBackground.setSelected(settings2.PERFORM_ADD_REMOVE_IN_BACKGROUND);
        this.myPerformRevertInBackgroundCheckBox.setSelected(settings2.PERFORM_ROLLBACK_IN_BACKGROUND);
        for (PersistentVcsShowSettingOption setting : this.myPromptOptions.keySet()) {
            this.myPromptOptions.get(setting).setSelected(setting.getValue());
        }
        if (!this.myProject.isDefault()) {
            this.myTrackChangedOnServer.setSelected(settings2.CHECK_LOCALLY_CHANGED_CONFLICTS_IN_BACKGROUND);
            this.myChangedOnServerInterval.setValue(settings2.CHANGED_ON_SERVER_INTERVAL);
            this.myChangedOnServerInterval.setEnabled(this.myTrackChangedOnServer.isSelected());
        }
    }

    public JComponent getPanel() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JSpinner jSpinner;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 9, 0, 3, 3, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/VcsBundle", VcsBackgroundOperationsConfigurationPanel.class).getString("background.operations.title"), (int)0, (int)0, (Font)this.$$$getFont$$$(null, -1, -1, jPanel4.getFont()), null));
        this.myCbUpdateInBackground = jCheckBox7 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox7, DynamicBundle.getBundle((String)"messages/VcsBundle", VcsBackgroundOperationsConfigurationPanel.class).getString("perform.update.from.vcs.in.background"));
        jPanel4.add((Component)jCheckBox7, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbCommitInBackground = jCheckBox6 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox6, DynamicBundle.getBundle((String)"messages/VcsBundle", VcsBackgroundOperationsConfigurationPanel.class).getString("perform.commit.in.bacground"));
        jPanel4.add((Component)jCheckBox6, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbEditInBackground = jCheckBox5 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox5, DynamicBundle.getBundle((String)"messages/VcsBundle", VcsBackgroundOperationsConfigurationPanel.class).getString("perform.edit.in.background"));
        jPanel4.add((Component)jCheckBox5, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbAddRemoveInBackground = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, DynamicBundle.getBundle((String)"messages/VcsBundle", VcsBackgroundOperationsConfigurationPanel.class).getString("perform.add.remove.in.background"));
        jPanel4.add((Component)jCheckBox4, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbCheckoutInBackground = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle((String)"messages/VcsBundle", VcsBackgroundOperationsConfigurationPanel.class).getString("perform.checkout.from.vcs.in.background"));
        jPanel4.add((Component)jCheckBox3, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPerformRevertInBackgroundCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/VcsBundle", VcsBackgroundOperationsConfigurationPanel.class).getString("perform.rollback.in.background.option"));
        jPanel4.add((Component)jCheckBox2, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel5, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel5.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/VcsBundle", VcsBackgroundOperationsConfigurationPanel.class).getString("options.check.changed.on.server.title"), (int)0, (int)0, null, null));
        this.myTrackChangedOnServer = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/VcsBundle", VcsBackgroundOperationsConfigurationPanel.class).getString("vcs.config.track.changed.on.server"));
        jPanel5.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myChangedOnServerInterval = jSpinner = new JSpinner();
        jPanel5.add((Component)jSpinner, new GridConstraints(0, 1, 1, 1, 8, 1, 0, 0, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/VcsBundle", VcsBackgroundOperationsConfigurationPanel.class).getString("settings.check.every.minutes"));
        jPanel5.add((Component)jLabel, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2 = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        Font font3 = new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
        boolean bl = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font font4 = bl ? new Font(font3.getFamily(), font3.getStyle(), font3.getSize()) : new StyleContext().getFont(font3.getFamily(), font3.getStyle(), font3.getSize());
        return font4 instanceof FontUIResource ? font4 : new FontUIResource(font4);
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

