/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonManagerImpl;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.comparison.iterables.DiffIterable;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.tools.util.text.LineOffsetsUtil;
import com.intellij.diff.util.Range;
import com.intellij.ide.todo.TodoFilter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.checkin.StepIntersection;
import com.intellij.openapi.vcs.checkin.TodoCheckinHandler;
import com.intellij.openapi.vcs.ex.PartialCommitContent;
import com.intellij.openapi.vcs.ex.PartialLocalLineStatusTracker;
import com.intellij.openapi.vcs.impl.PartialChangesUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.PsiTodoSearchHelper;
import com.intellij.psi.search.TodoItem;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TodoCheckinHandlerWorker {
    private static final Logger LOG = Logger.getInstance(TodoCheckinHandler.class);
    private final Project myProject;
    private final Collection<? extends Change> myChanges;
    private final TodoFilter myTodoFilter;
    private final Set<TodoItem> myAddedOrEditedTodos;
    private final Set<TodoItem> myInChangedTodos;
    private final List<Pair<FilePath, String>> mySkipped;
    private static final Convertor<TodoItem, TextRange> TODO_ITEM_CONVERTOR = o -> {
        TextRange textRange = o.getTextRange();
        List additionalRanges = o.getAdditionalTextRanges();
        return new TextRange(textRange.getStartOffset(), (additionalRanges.isEmpty() ? textRange : (TextRange)additionalRanges.get(additionalRanges.size() - 1)).getEndOffset() - 1);
    };

    public TodoCheckinHandlerWorker(@NotNull Project project, @NotNull Collection<? extends Change> changes, @Nullable TodoFilter todoFilter) {
        if (project == null) {
            TodoCheckinHandlerWorker.$$$reportNull$$$0(0);
        }
        if (changes == null) {
            TodoCheckinHandlerWorker.$$$reportNull$$$0(1);
        }
        this.myAddedOrEditedTodos = new HashSet<TodoItem>();
        this.myInChangedTodos = new HashSet<TodoItem>();
        this.mySkipped = new SmartList();
        this.myProject = project;
        this.myChanges = changes;
        this.myTodoFilter = todoFilter;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            TodoCheckinHandlerWorker.$$$reportNull$$$0(2);
        }
        return project;
    }

    public void execute() {
        List changes = ContainerUtil.filter(this.myChanges, it -> it.getAfterRevision() != null);
        for (int i2 = 0; i2 < changes.size(); ++i2) {
            Change change = (Change)changes.get(i2);
            ContentRevision beforeRevision = change.getBeforeRevision();
            ContentRevision afterRevision = Objects.requireNonNull(change.getAfterRevision());
            FilePath afterFilePath = afterRevision.getFile();
            VirtualFile afterFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(afterFilePath.getPath());
            ProgressManager.progress((String)(afterFile != null ? ProjectUtil.calcRelativeToProjectPath((VirtualFile)afterFile, (Project)this.myProject) : afterFilePath.getName()));
            EditedFileProcessorBase fileProcessor = (EditedFileProcessorBase)ReadAction.compute(() -> {
                PsiFile afterPsiFile;
                if (afterFile == null || afterFile.isDirectory() || afterFile.getFileType().isBinary()) {
                    return null;
                }
                PsiFile psiFile = afterPsiFile = afterFile.isValid() ? PsiManager.getInstance((Project)this.myProject).findFile(afterFile) : null;
                if (afterPsiFile == null) {
                    this.mySkipped.add((Pair<FilePath, String>)Pair.create((Object)afterFilePath, (Object)VcsBundle.message((String)"checkin.invalid.file.s", (Object[])new Object[0])));
                    return null;
                }
                if (beforeRevision == null) {
                    List<TodoItem> newTodoItems = this.collectTodoItems(afterPsiFile, false);
                    this.myAddedOrEditedTodos.addAll(newTodoItems);
                    return null;
                }
                PartialLocalLineStatusTracker tracker2 = PartialChangesUtil.getPartialTracker(this.myProject, change);
                if (tracker2 != null && tracker2.hasPartialChangesToCommit() && change instanceof ChangeListChange) {
                    String changeListId = ((ChangeListChange)change).getChangeListId();
                    List<String> affectedChangelistIds = Collections.singletonList(changeListId);
                    PartialCommitContent partialCommitContent = tracker2.getPartialCommitContent(affectedChangelistIds, true);
                    if (partialCommitContent == null) {
                        LOG.info(String.format("Can't check todo before commit for tracker %s, isOperational - %s", tracker2, tracker2.isOperational()));
                        this.mySkipped.add((Pair<FilePath, String>)Pair.create((Object)afterFilePath, (Object)VcsBundle.message((String)"checkin.can.not.load.previous.revision", (Object[])new Object[0])));
                        return null;
                    }
                    String beforeContent = partialCommitContent.getVcsContent().toString();
                    String afterContent = partialCommitContent.getCurrentContent().toString();
                    List ranges = ContainerUtil.map(partialCommitContent.getRangesToCommit(), it -> new Range(it.getVcsLine1(), it.getVcsLine2(), it.getLine1(), it.getLine2()));
                    List<TodoItem> newTodoItems = this.collectTodoItems(afterPsiFile, false);
                    return new PartialEditedFileProcessor(this.myProject, afterFilePath, beforeContent, afterContent, newTodoItems, ranges);
                }
                String beforeContent = TodoCheckinHandlerWorker.getRevisionContent(beforeRevision);
                if (beforeContent == null) {
                    this.mySkipped.add((Pair<FilePath, String>)Pair.create((Object)afterFilePath, (Object)VcsBundle.message((String)"checkin.can.not.load.previous.revision", (Object[])new Object[0])));
                    return null;
                }
                if (afterRevision instanceof CurrentContentRevision) {
                    Document afterDocument = FileDocumentManager.getInstance().getDocument(afterFile);
                    if (afterDocument == null) {
                        this.mySkipped.add((Pair<FilePath, String>)Pair.create((Object)afterFilePath, (Object)VcsBundle.message((String)"checkin.can.not.load.current.revision", (Object[])new Object[0])));
                        return null;
                    }
                    String afterContent = afterDocument.getText();
                    List<TodoItem> newTodoItems = this.collectTodoItems(afterPsiFile, false);
                    return new SimpleEditedFileProcessor(this.myProject, afterFilePath, beforeContent, afterContent, newTodoItems);
                }
                String afterContent = TodoCheckinHandlerWorker.getRevisionContent(afterRevision);
                if (afterContent == null) {
                    this.mySkipped.add((Pair<FilePath, String>)Pair.create((Object)afterFilePath, (Object)VcsBundle.message((String)"checkin.can.not.load.current.revision", (Object[])new Object[0])));
                    return null;
                }
                PsiFile realAfterPsiFile = PsiFileFactory.getInstance((Project)this.myProject).createFileFromText("new" + afterFilePath.getName(), afterFilePath.getFileType(), (CharSequence)afterContent);
                List<TodoItem> newTodoItems = this.collectTodoItems(realAfterPsiFile, true);
                return new NonLocalEditedFileProcessor(this.myProject, afterFilePath, beforeContent, afterContent, newTodoItems);
            });
            try {
                if (fileProcessor != null) {
                    fileProcessor.process();
                }
                TodoCheckinHandlerWorker.fraction(((double)i2 + 1.0) / (double)changes.size());
                continue;
            }
            catch (DiffTooBigException e) {
                LOG.info("File " + afterFilePath.getPath() + " is too big and there are too many changes to build a diff");
                this.mySkipped.add((Pair<FilePath, String>)Pair.create((Object)afterFilePath, (Object)VcsBundle.message((String)"checkin.can.not.load.previous.revision", (Object[])new Object[0])));
            }
        }
    }

    private static void fraction(double value2) {
        ProgressIndicator indicator2 = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (indicator2 != null) {
            indicator2.setFraction(value2);
        }
    }

    @NotNull
    private List<TodoItem> collectTodoItems(@NotNull PsiFile psiFile, boolean isLight) {
        if (psiFile == null) {
            TodoCheckinHandlerWorker.$$$reportNull$$$0(3);
        }
        if (!isLight) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        PsiTodoSearchHelper searchHelper = PsiTodoSearchHelper.SERVICE.getInstance((Project)this.myProject);
        TodoItem[] todoItems = isLight ? searchHelper.findTodoItemsLight(psiFile) : searchHelper.findTodoItems(psiFile);
        List<TodoItem> list2 = TodoCheckinHandlerWorker.applyFilterAndRemoveDuplicatesAndSort(todoItems, this.myTodoFilter);
        if (list2 == null) {
            TodoCheckinHandlerWorker.$$$reportNull$$$0(4);
        }
        return list2;
    }

    private static List<TodoItem> applyFilterAndRemoveDuplicatesAndSort(TodoItem @NotNull [] items, @Nullable TodoFilter filter) {
        if (items == null) {
            TodoCheckinHandlerWorker.$$$reportNull$$$0(5);
        }
        ArrayList todoItems = ContainerUtil.newArrayList((Object[])items);
        todoItems.sort(TodoItem.BY_START_OFFSET);
        TodoItem previous = null;
        Iterator iterator2 = todoItems.iterator();
        while (iterator2.hasNext()) {
            TodoItem next = (TodoItem)iterator2.next();
            if (filter != null && !filter.contains(next.getPattern())) {
                iterator2.remove();
                continue;
            }
            if (previous != null && next.getTextRange().equals((Object)previous.getTextRange())) {
                iterator2.remove();
                continue;
            }
            previous = next;
        }
        return todoItems;
    }

    public Set<TodoItem> getAddedOrEditedTodos() {
        return this.myAddedOrEditedTodos;
    }

    public Set<TodoItem> getInChangedTodos() {
        return this.myInChangedTodos;
    }

    public List<Pair<FilePath, String>> getSkipped() {
        return this.mySkipped;
    }

    private static String getTodoText(TodoItem item, String content2) {
        StringJoiner joiner = new StringJoiner("\n");
        joiner.add(TodoCheckinHandlerWorker.getTodoPartText(content2, item.getTextRange()));
        item.getAdditionalTextRanges().forEach(r -> joiner.add(TodoCheckinHandlerWorker.getTodoPartText(content2, r)));
        return joiner.toString();
    }

    private static String getTodoPartText(String content2, TextRange textRange) {
        String fragment2 = textRange.substring(content2);
        return StringUtil.join((String[])fragment2.split("\\s"), (String)" ");
    }

    @Nullable
    private static String getRevisionContent(@NotNull ContentRevision revision) {
        if (revision == null) {
            TodoCheckinHandlerWorker.$$$reportNull$$$0(6);
        }
        try {
            String content2 = revision.getContent();
            return content2 != null ? StringUtil.convertLineSeparators((String)content2) : null;
        }
        catch (VcsException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    public Set<TodoItem> inOneList() {
        HashSet<TodoItem> set2 = new HashSet<TodoItem>();
        set2.addAll(this.getAddedOrEditedTodos());
        set2.addAll(this.getInChangedTodos());
        return set2;
    }

    public List<Change> getChanges() {
        return new ArrayList<Change>(this.myChanges);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/checkin/TodoCheckinHandlerWorker";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/checkin/TodoCheckinHandlerWorker";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTodoItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectTodoItems";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyFilterAndRemoveDuplicatesAndSort";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRevisionContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class RightLineFragmentConvertor
    implements Convertor<LineFragment, TextRange> {
        private final String myContent;

        private RightLineFragmentConvertor(String content2) {
            this.myContent = content2;
        }

        public TextRange convert(LineFragment o) {
            int start2 = o.getStartOffset2();
            int end = o.getEndOffset2();
            int prevLineStart = this.myContent.lastIndexOf(10, start2 - 2) + 1;
            return new TextRange(prevLineStart, Math.max(start2, end - 1));
        }
    }

    private static final class LeftLineFragmentConvertor
    implements Convertor<LineFragment, TextRange> {
        private final String myContent;

        private LeftLineFragmentConvertor(String content2) {
            this.myContent = content2;
        }

        public TextRange convert(LineFragment o) {
            int start2 = o.getStartOffset1();
            int end = o.getEndOffset1();
            int prevLineStart = this.myContent.lastIndexOf(10, start2 - 2) + 1;
            return new TextRange(prevLineStart, Math.max(start2, end - 1));
        }
    }

    private abstract class EditedFileProcessorBase {
        @NotNull
        protected final Project myProject;
        @NotNull
        protected final String myBeforeContent;
        @NotNull
        protected final String myAfterContent;
        @NotNull
        protected final FilePath myAfterFile;
        @NotNull
        private final List<? extends TodoItem> myNewTodoItems;

        private EditedFileProcessorBase(@NotNull Project project, @NotNull FilePath afterFilePath, @NotNull String beforeContent, @NotNull String afterContent, List<? extends TodoItem> newTodoItems) {
            if (project == null) {
                EditedFileProcessorBase.$$$reportNull$$$0(0);
            }
            if (afterFilePath == null) {
                EditedFileProcessorBase.$$$reportNull$$$0(1);
            }
            if (beforeContent == null) {
                EditedFileProcessorBase.$$$reportNull$$$0(2);
            }
            if (afterContent == null) {
                EditedFileProcessorBase.$$$reportNull$$$0(3);
            }
            if (newTodoItems == null) {
                EditedFileProcessorBase.$$$reportNull$$$0(4);
            }
            this.myProject = project;
            this.myAfterFile = afterFilePath;
            this.myBeforeContent = beforeContent;
            this.myAfterContent = afterContent;
            this.myNewTodoItems = newTodoItems;
        }

        @NotNull
        protected abstract List<LineFragment> computeFragments();

        @NotNull
        private List<TodoItem> computeOldTodoItems() {
            PsiFile beforePsiFile = (PsiFile)ReadAction.compute(() -> PsiFileFactory.getInstance((Project)this.myProject).createFileFromText("old" + this.myAfterFile.getName(), this.myAfterFile.getFileType(), (CharSequence)this.myBeforeContent));
            List<TodoItem> list2 = TodoCheckinHandlerWorker.this.collectTodoItems(beforePsiFile, true);
            if (list2 == null) {
                EditedFileProcessorBase.$$$reportNull$$$0(5);
            }
            return list2;
        }

        public void process() throws DiffTooBigException {
            List<LineFragment> lineFragments = this.computeFragments();
            ArrayList changedTodoItems = new ArrayList();
            StepIntersection.processIntersections(this.myNewTodoItems, lineFragments, TODO_ITEM_CONVERTOR, new RightLineFragmentConvertor(this.myAfterContent), (todoItem, lineFragment) -> changedTodoItems.add(Pair.create((Object)todoItem, (Object)lineFragment)));
            if (changedTodoItems.isEmpty()) {
                return;
            }
            List<TodoItem> oldTodoItems = this.computeOldTodoItems();
            if (oldTodoItems.isEmpty()) {
                for (Pair pair : changedTodoItems) {
                    TodoCheckinHandlerWorker.this.myAddedOrEditedTodos.add((TodoItem)pair.first);
                }
                return;
            }
            LineFragment lastLineFragment = null;
            HashSet oldTodoTexts = new HashSet();
            for (Pair pair : changedTodoItems) {
                String text2;
                TodoItem todoItem2 = (TodoItem)pair.first;
                LineFragment lineFragment2 = (LineFragment)pair.second;
                if (lineFragment2 != lastLineFragment) {
                    oldTodoTexts.clear();
                    StepIntersection.processElementIntersections(lineFragment2, oldTodoItems, new LeftLineFragmentConvertor(this.myBeforeContent), TODO_ITEM_CONVERTOR, (fragment2, oldTodoItem) -> oldTodoTexts.add(TodoCheckinHandlerWorker.getTodoText(oldTodoItem, this.myBeforeContent)));
                    lastLineFragment = lineFragment2;
                }
                if (!oldTodoTexts.contains(text2 = TodoCheckinHandlerWorker.getTodoText(todoItem2, this.myAfterContent))) {
                    TodoCheckinHandlerWorker.this.myAddedOrEditedTodos.add(todoItem2);
                    continue;
                }
                if (((TextRange)TODO_ITEM_CONVERTOR.convert((Object)todoItem2)).getEndOffset() < lineFragment2.getStartOffset2()) continue;
                TodoCheckinHandlerWorker.this.myInChangedTodos.add(todoItem2);
            }
            TodoCheckinHandlerWorker.this.myInChangedTodos.removeAll(TodoCheckinHandlerWorker.this.myAddedOrEditedTodos);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "afterFilePath";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "beforeContent";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "afterContent";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newTodoItems";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/checkin/TodoCheckinHandlerWorker$EditedFileProcessorBase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/checkin/TodoCheckinHandlerWorker$EditedFileProcessorBase";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computeOldTodoItems";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private final class NonLocalEditedFileProcessor
    extends EditedFileProcessorBase {
        private NonLocalEditedFileProcessor(@NotNull Project project, @NotNull FilePath afterFilePath, @NotNull String beforeContent, @NotNull String afterContent, List<? extends TodoItem> newTodoItems) {
            if (project == null) {
                NonLocalEditedFileProcessor.$$$reportNull$$$0(0);
            }
            if (afterFilePath == null) {
                NonLocalEditedFileProcessor.$$$reportNull$$$0(1);
            }
            if (beforeContent == null) {
                NonLocalEditedFileProcessor.$$$reportNull$$$0(2);
            }
            if (afterContent == null) {
                NonLocalEditedFileProcessor.$$$reportNull$$$0(3);
            }
            if (newTodoItems == null) {
                NonLocalEditedFileProcessor.$$$reportNull$$$0(4);
            }
            super(project, afterFilePath, beforeContent, afterContent, newTodoItems);
        }

        @Override
        @NotNull
        protected List<LineFragment> computeFragments() {
            ProgressIndicator indicator2 = (ProgressIndicator)ObjectUtils.notNull((Object)ProgressManager.getInstance().getProgressIndicator(), (Object)DumbProgressIndicator.INSTANCE);
            List list2 = ComparisonManager.getInstance().compareLines((CharSequence)this.myBeforeContent, (CharSequence)this.myAfterContent, ComparisonPolicy.DEFAULT, indicator2);
            if (list2 == null) {
                NonLocalEditedFileProcessor.$$$reportNull$$$0(5);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "afterFilePath";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "beforeContent";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "afterContent";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newTodoItems";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/checkin/TodoCheckinHandlerWorker$NonLocalEditedFileProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/checkin/TodoCheckinHandlerWorker$NonLocalEditedFileProcessor";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computeFragments";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class PartialEditedFileProcessor
    extends EditedFileProcessorBase {
        @NotNull
        private final List<Range> myRanges;

        private PartialEditedFileProcessor(@NotNull Project project, @NotNull FilePath afterFilePath, @NotNull String beforeContent, @NotNull String afterContent, @NotNull List<? extends TodoItem> newTodoItems, List<Range> ranges) {
            if (project == null) {
                PartialEditedFileProcessor.$$$reportNull$$$0(0);
            }
            if (afterFilePath == null) {
                PartialEditedFileProcessor.$$$reportNull$$$0(1);
            }
            if (beforeContent == null) {
                PartialEditedFileProcessor.$$$reportNull$$$0(2);
            }
            if (afterContent == null) {
                PartialEditedFileProcessor.$$$reportNull$$$0(3);
            }
            if (newTodoItems == null) {
                PartialEditedFileProcessor.$$$reportNull$$$0(4);
            }
            if (ranges == null) {
                PartialEditedFileProcessor.$$$reportNull$$$0(5);
            }
            super(project, afterFilePath, beforeContent, afterContent, newTodoItems);
            this.myRanges = ranges;
        }

        @Override
        @NotNull
        protected List<LineFragment> computeFragments() {
            LineOffsets afterLineOffsets = LineOffsetsUtil.create(this.myAfterContent);
            LineOffsets beforeLineOffsets = LineOffsetsUtil.create(this.myBeforeContent);
            DiffIterable iterable = DiffIterableUtil.create(this.myRanges, beforeLineOffsets.getLineCount(), afterLineOffsets.getLineCount());
            List<LineFragment> list2 = ComparisonManagerImpl.convertIntoLineFragments(beforeLineOffsets, afterLineOffsets, iterable);
            if (list2 == null) {
                PartialEditedFileProcessor.$$$reportNull$$$0(6);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "afterFilePath";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "beforeContent";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "afterContent";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newTodoItems";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ranges";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/checkin/TodoCheckinHandlerWorker$PartialEditedFileProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/checkin/TodoCheckinHandlerWorker$PartialEditedFileProcessor";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computeFragments";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private final class SimpleEditedFileProcessor
    extends EditedFileProcessorBase {
        private SimpleEditedFileProcessor(@NotNull Project project, @NotNull FilePath afterFilePath, @NotNull String beforeContent, @NotNull String afterContent, List<? extends TodoItem> newTodoItems) {
            if (project == null) {
                SimpleEditedFileProcessor.$$$reportNull$$$0(0);
            }
            if (afterFilePath == null) {
                SimpleEditedFileProcessor.$$$reportNull$$$0(1);
            }
            if (beforeContent == null) {
                SimpleEditedFileProcessor.$$$reportNull$$$0(2);
            }
            if (afterContent == null) {
                SimpleEditedFileProcessor.$$$reportNull$$$0(3);
            }
            if (newTodoItems == null) {
                SimpleEditedFileProcessor.$$$reportNull$$$0(4);
            }
            super(project, afterFilePath, beforeContent, afterContent, newTodoItems);
        }

        @Override
        @NotNull
        protected List<LineFragment> computeFragments() {
            ProgressIndicator indicator2 = (ProgressIndicator)ObjectUtils.notNull((Object)ProgressManager.getInstance().getProgressIndicator(), (Object)DumbProgressIndicator.INSTANCE);
            List list2 = ComparisonManager.getInstance().compareLines((CharSequence)this.myBeforeContent, (CharSequence)this.myAfterContent, ComparisonPolicy.DEFAULT, indicator2);
            if (list2 == null) {
                SimpleEditedFileProcessor.$$$reportNull$$$0(5);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "afterFilePath";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "beforeContent";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "afterContent";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newTodoItems";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/checkin/TodoCheckinHandlerWorker$SimpleEditedFileProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/checkin/TodoCheckinHandlerWorker$SimpleEditedFileProcessor";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computeFragments";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

