/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.LogicalLock;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.changes.ui.BaseChangesGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.ChangeListRemoteState;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeListNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserIgnoredFilesNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserModuleNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserSpecificFilePathsNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserStringNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserUnversionedFilesNode;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingSupport;
import com.intellij.openapi.vcs.changes.ui.ChangesViewModelBuilder;
import com.intellij.openapi.vcs.changes.ui.NoneChangesGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.RemoteStatusChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.StaticFilePath;
import com.intellij.openapi.vcs.changes.ui.TagChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.VirtualFileHierarchicalComparator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeModelBuilder
implements ChangesViewModelBuilder {
    public static final Key<Function<StaticFilePath, ChangesBrowserNode<?>>> PATH_NODE_BUILDER = Key.create((String)"ChangesTree.PathNodeBuilder");
    public static final NotNullLazyKey<Map<String, ChangesBrowserNode<?>>, ChangesBrowserNode<?>> DIRECTORY_CACHE = NotNullLazyKey.create((String)"ChangesTree.DirectoryCache", node2 -> new HashMap());
    private static final Key<ChangesGroupingPolicy> GROUPING_POLICY = Key.create((String)"ChangesTree.GroupingPolicy");
    public static final Key<Boolean> IS_CACHING_ROOT = Key.create((String)"ChangesTree.IsCachingRoot");
    @Nullable
    public final Project myProject;
    @NotNull
    public final DefaultTreeModel myModel;
    @NotNull
    public final ChangesBrowserNode<?> myRoot;
    @NotNull
    private final ChangesGroupingPolicyFactory myGroupingPolicyFactory;
    private static final Comparator<ChangesBrowserNode> BROWSER_NODE_COMPARATOR = (node1, node2) -> {
        Class<?> clazz2;
        int sortWeightDiff = Comparing.compare((int)node1.getSortWeight(), (int)node2.getSortWeight());
        if (sortWeightDiff != 0) {
            return sortWeightDiff;
        }
        Class<?> clazz1 = node1.getClass();
        if (!clazz1.equals(clazz2 = node2.getClass())) {
            return Comparing.compare((Comparable)((Object)clazz1.getName()), (Comparable)((Object)clazz2.getName()));
        }
        if (node1 instanceof Comparable) {
            return ((Comparable)((Object)node1)).compareTo(node2);
        }
        return node1.compareUserObjects(node2.getUserObject());
    };
    public static final Comparator<FilePath> PATH_COMPARATOR = Comparator.comparingInt(path2 -> path2.getPath().length());
    public static final Comparator<Change> CHANGE_COMPARATOR = Comparator.comparing(ChangesUtil::getFilePath, PATH_COMPARATOR);

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public TreeModelBuilder(@NotNull Project project, boolean showFlatten) {
        if (project == null) {
            TreeModelBuilder.$$$reportNull$$$0(0);
        }
        this(project, ChangesGroupingSupport.getFactory(showFlatten ? "none" : "directory"));
    }

    public TreeModelBuilder(@Nullable Project project, @NotNull ChangesGroupingPolicyFactory grouping2) {
        if (grouping2 == null) {
            TreeModelBuilder.$$$reportNull$$$0(1);
        }
        this.myProject = project != null && !project.isDefault() ? project : null;
        this.myRoot = ChangesBrowserNode.createRoot();
        this.myModel = new DefaultTreeModel(this.myRoot);
        this.myGroupingPolicyFactory = grouping2;
    }

    @NotNull
    public static DefaultTreeModel buildEmpty() {
        return new DefaultTreeModel(ChangesBrowserNode.createRoot());
    }

    @NotNull
    public static DefaultTreeModel buildFromChanges(@Nullable Project project, @NotNull ChangesGroupingPolicyFactory grouping2, @NotNull Collection<? extends Change> changes, @Nullable ChangeNodeDecorator changeNodeDecorator) {
        if (grouping2 == null) {
            TreeModelBuilder.$$$reportNull$$$0(2);
        }
        if (changes == null) {
            TreeModelBuilder.$$$reportNull$$$0(3);
        }
        DefaultTreeModel defaultTreeModel = new TreeModelBuilder(project, grouping2).setChanges(changes, changeNodeDecorator).build();
        if (defaultTreeModel == null) {
            TreeModelBuilder.$$$reportNull$$$0(4);
        }
        return defaultTreeModel;
    }

    @NotNull
    public static DefaultTreeModel buildFromFilePaths(@Nullable Project project, @NotNull ChangesGroupingPolicyFactory grouping2, @NotNull Collection<? extends FilePath> filePaths) {
        if (grouping2 == null) {
            TreeModelBuilder.$$$reportNull$$$0(5);
        }
        if (filePaths == null) {
            TreeModelBuilder.$$$reportNull$$$0(6);
        }
        DefaultTreeModel defaultTreeModel = new TreeModelBuilder(project, grouping2).setFilePaths(filePaths).build();
        if (defaultTreeModel == null) {
            TreeModelBuilder.$$$reportNull$$$0(7);
        }
        return defaultTreeModel;
    }

    @NotNull
    public static DefaultTreeModel buildFromChangeLists(@NotNull Project project, @NotNull ChangesGroupingPolicyFactory grouping2, @NotNull Collection<? extends ChangeList> changeLists) {
        if (project == null) {
            TreeModelBuilder.$$$reportNull$$$0(8);
        }
        if (grouping2 == null) {
            TreeModelBuilder.$$$reportNull$$$0(9);
        }
        if (changeLists == null) {
            TreeModelBuilder.$$$reportNull$$$0(10);
        }
        return TreeModelBuilder.buildFromChangeLists(project, grouping2, changeLists, false);
    }

    @NotNull
    public static DefaultTreeModel buildFromChangeLists(@NotNull Project project, @NotNull ChangesGroupingPolicyFactory grouping2, @NotNull Collection<? extends ChangeList> changeLists, boolean skipSingleDefaultChangelist) {
        if (project == null) {
            TreeModelBuilder.$$$reportNull$$$0(11);
        }
        if (grouping2 == null) {
            TreeModelBuilder.$$$reportNull$$$0(12);
        }
        if (changeLists == null) {
            TreeModelBuilder.$$$reportNull$$$0(13);
        }
        DefaultTreeModel defaultTreeModel = new TreeModelBuilder(project, grouping2).setChangeLists(changeLists, skipSingleDefaultChangelist, null).build();
        if (defaultTreeModel == null) {
            TreeModelBuilder.$$$reportNull$$$0(14);
        }
        return defaultTreeModel;
    }

    @NotNull
    public static DefaultTreeModel buildFromVirtualFiles(@Nullable Project project, @NotNull ChangesGroupingPolicyFactory grouping2, @NotNull Collection<? extends VirtualFile> virtualFiles) {
        if (grouping2 == null) {
            TreeModelBuilder.$$$reportNull$$$0(15);
        }
        if (virtualFiles == null) {
            TreeModelBuilder.$$$reportNull$$$0(16);
        }
        DefaultTreeModel defaultTreeModel = new TreeModelBuilder(project, grouping2).setVirtualFiles(virtualFiles, null).build();
        if (defaultTreeModel == null) {
            TreeModelBuilder.$$$reportNull$$$0(17);
        }
        return defaultTreeModel;
    }

    @NotNull
    public TreeModelBuilder setChanges(@NotNull Collection<? extends Change> changes, @Nullable ChangeNodeDecorator changeNodeDecorator) {
        if (changes == null) {
            TreeModelBuilder.$$$reportNull$$$0(18);
        }
        TreeModelBuilder treeModelBuilder = this.setChanges(changes, changeNodeDecorator, null);
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(19);
        }
        return treeModelBuilder;
    }

    @NotNull
    public TreeModelBuilder setChanges(@NotNull Collection<? extends Change> changes, @Nullable ChangeNodeDecorator changeNodeDecorator, @Nullable ChangesBrowserNode.Tag tag2) {
        if (changes == null) {
            TreeModelBuilder.$$$reportNull$$$0(20);
        }
        this.insertChanges(changes, this.createTagNode(tag2), changeNodeDecorator);
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(21);
        }
        return treeModelBuilder;
    }

    @Override
    public void insertChanges(@NotNull Collection<? extends Change> changes, @NotNull ChangesBrowserNode<?> subtreeRoot) {
        if (changes == null) {
            TreeModelBuilder.$$$reportNull$$$0(22);
        }
        if (subtreeRoot == null) {
            TreeModelBuilder.$$$reportNull$$$0(23);
        }
        this.insertChanges(changes, subtreeRoot, null);
    }

    public void insertChanges(@NotNull Collection<? extends Change> changes, @NotNull ChangesBrowserNode<?> subtreeRoot, @Nullable ChangeNodeDecorator changeNodeDecorator) {
        if (changes == null) {
            TreeModelBuilder.$$$reportNull$$$0(24);
        }
        if (subtreeRoot == null) {
            TreeModelBuilder.$$$reportNull$$$0(25);
        }
        for (Change change : ContainerUtil.sorted(changes, CHANGE_COMPARATOR)) {
            this.insertChangeNode(change, subtreeRoot, this.createChangeNode(change, changeNodeDecorator));
        }
    }

    @NotNull
    public TreeModelBuilder setUnversioned(@Nullable List<FilePath> unversionedFiles) {
        assert (this.myProject != null);
        if (ContainerUtil.isEmpty(unversionedFiles)) {
            TreeModelBuilder treeModelBuilder = this;
            if (treeModelBuilder == null) {
                TreeModelBuilder.$$$reportNull$$$0(26);
            }
            return treeModelBuilder;
        }
        ChangesBrowserUnversionedFilesNode node2 = new ChangesBrowserUnversionedFilesNode(this.myProject, unversionedFiles);
        return this.insertSpecificFilePathNodeToModel(unversionedFiles, node2, FileStatus.UNKNOWN);
    }

    @NotNull
    public TreeModelBuilder setIgnored(@Nullable List<FilePath> ignoredFiles) {
        assert (this.myProject != null);
        if (ContainerUtil.isEmpty(ignoredFiles)) {
            TreeModelBuilder treeModelBuilder = this;
            if (treeModelBuilder == null) {
                TreeModelBuilder.$$$reportNull$$$0(27);
            }
            return treeModelBuilder;
        }
        ChangesBrowserIgnoredFilesNode node2 = new ChangesBrowserIgnoredFilesNode(this.myProject, ignoredFiles);
        return this.insertSpecificFilePathNodeToModel(ignoredFiles, node2, FileStatus.IGNORED);
    }

    @NotNull
    private TreeModelBuilder insertSpecificFilePathNodeToModel(@NotNull List<? extends FilePath> specificFiles, @NotNull ChangesBrowserSpecificFilePathsNode node2, @NotNull FileStatus status) {
        if (specificFiles == null) {
            TreeModelBuilder.$$$reportNull$$$0(28);
        }
        if (node2 == null) {
            TreeModelBuilder.$$$reportNull$$$0(29);
        }
        if (status == null) {
            TreeModelBuilder.$$$reportNull$$$0(30);
        }
        this.insertSubtreeRoot((ChangesBrowserNode)node2);
        if (!node2.isManyFiles()) {
            node2.markAsHelperNode();
            this.insertLocalFilePathIntoNode(specificFiles, node2, status);
        }
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(31);
        }
        return treeModelBuilder;
    }

    @NotNull
    public TreeModelBuilder setChangeLists(@NotNull Collection<? extends ChangeList> changeLists, boolean skipSingleDefaultChangeList, @Nullable Function<? super ChangeNodeDecorator, ? extends ChangeNodeDecorator> changeDecoratorProvider) {
        if (changeLists == null) {
            TreeModelBuilder.$$$reportNull$$$0(32);
        }
        assert (this.myProject != null);
        RemoteRevisionsCache revisionsCache = RemoteRevisionsCache.getInstance(this.myProject);
        boolean skipChangeListNode = skipSingleDefaultChangeList && TreeModelBuilder.isSingleBlankChangeList(changeLists);
        for (ChangeList changeList : changeLists) {
            ChangesBrowserChangeListNode changesParent;
            List changes = ContainerUtil.sorted((Collection)changeList.getChanges(), CHANGE_COMPARATOR);
            ChangeListRemoteState listRemoteState = new ChangeListRemoteState(changes.size());
            if (!skipChangeListNode) {
                ChangesBrowserChangeListNode listNode = new ChangesBrowserChangeListNode(this.myProject, changeList, listRemoteState);
                listNode.markAsHelperNode();
                this.insertSubtreeRoot((ChangesBrowserNode)listNode);
                changesParent = listNode;
            } else {
                changesParent = this.myRoot;
            }
            for (int i2 = 0; i2 < changes.size(); ++i2) {
                Change change = (Change)changes.get(i2);
                RemoteStatusChangeNodeDecorator baseDecorator = new RemoteStatusChangeNodeDecorator(revisionsCache, listRemoteState, i2);
                RemoteStatusChangeNodeDecorator decorator = changeDecoratorProvider != null ? changeDecoratorProvider.apply(baseDecorator) : baseDecorator;
                this.insertChangeNode(change, changesParent, this.createChangeNode(change, decorator));
            }
        }
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(33);
        }
        return treeModelBuilder;
    }

    private static boolean isSingleBlankChangeList(Collection<? extends ChangeList> lists) {
        if (lists.size() != 1) {
            return false;
        }
        ChangeList single = lists.iterator().next();
        if (!(single instanceof LocalChangeList)) {
            return false;
        }
        return ((LocalChangeList)single).isBlank();
    }

    @NotNull
    public ChangesBrowserNode<?> createChangeNode(@NotNull Change change, @Nullable ChangeNodeDecorator decorator) {
        if (change == null) {
            TreeModelBuilder.$$$reportNull$$$0(34);
        }
        return new ChangesBrowserChangeNode(this.myProject, change, decorator);
    }

    @NotNull
    public TreeModelBuilder setLockedFolders(@Nullable List<? extends VirtualFile> lockedFolders) {
        assert (this.myProject != null);
        if (ContainerUtil.isEmpty(lockedFolders)) {
            TreeModelBuilder treeModelBuilder = this;
            if (treeModelBuilder == null) {
                TreeModelBuilder.$$$reportNull$$$0(35);
            }
            return treeModelBuilder;
        }
        this.insertFilesIntoNode(lockedFolders, ChangesBrowserNode.createLockedFolders(this.myProject));
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(36);
        }
        return treeModelBuilder;
    }

    @NotNull
    public TreeModelBuilder setModifiedWithoutEditing(@NotNull List<? extends VirtualFile> modifiedWithoutEditing) {
        if (modifiedWithoutEditing == null) {
            TreeModelBuilder.$$$reportNull$$$0(37);
        }
        return this.setVirtualFiles(modifiedWithoutEditing, ChangesBrowserNode.MODIFIED_WITHOUT_EDITING_TAG);
    }

    @NotNull
    private TreeModelBuilder setVirtualFiles(@Nullable Collection<? extends VirtualFile> files2, @Nullable ChangesBrowserNode.Tag tag2) {
        if (ContainerUtil.isEmpty(files2)) {
            TreeModelBuilder treeModelBuilder = this;
            if (treeModelBuilder == null) {
                TreeModelBuilder.$$$reportNull$$$0(38);
            }
            return treeModelBuilder;
        }
        this.insertFilesIntoNode(files2, this.createTagNode(tag2));
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(39);
        }
        return treeModelBuilder;
    }

    @NotNull
    public ChangesBrowserNode<?> createTagNode(@NotNull @Nls String tag2) {
        if (tag2 == null) {
            TreeModelBuilder.$$$reportNull$$$0(40);
        }
        ChangesBrowserNode<?> changesBrowserNode = this.createTagNode(new ChangesBrowserNode.TagImpl(tag2));
        if (changesBrowserNode == null) {
            TreeModelBuilder.$$$reportNull$$$0(41);
        }
        return changesBrowserNode;
    }

    @Deprecated
    @NotNull
    @ApiStatus.ScheduledForRemoval(inVersion="2022.1")
    public ChangesBrowserNode<?> createTagNode(@Nullable Object tag2) {
        ChangesBrowserNode<?> changesBrowserNode = this.createTagNode(ChangesBrowserNode.WrapperTag.wrap(tag2));
        if (changesBrowserNode == null) {
            TreeModelBuilder.$$$reportNull$$$0(42);
        }
        return changesBrowserNode;
    }

    @NotNull
    public ChangesBrowserNode<?> createTagNode(@Nullable ChangesBrowserNode.Tag tag2) {
        ChangesBrowserNode<?> changesBrowserNode = this.createTagNode(tag2, SimpleTextAttributes.REGULAR_ATTRIBUTES, true);
        if (changesBrowserNode == null) {
            TreeModelBuilder.$$$reportNull$$$0(43);
        }
        return changesBrowserNode;
    }

    @NotNull
    public ChangesBrowserNode<?> createTagNode(@NotNull @Nls String tag2, boolean expandByDefault) {
        if (tag2 == null) {
            TreeModelBuilder.$$$reportNull$$$0(44);
        }
        ChangesBrowserNode<?> changesBrowserNode = this.createTagNode(tag2, SimpleTextAttributes.REGULAR_ATTRIBUTES, expandByDefault);
        if (changesBrowserNode == null) {
            TreeModelBuilder.$$$reportNull$$$0(45);
        }
        return changesBrowserNode;
    }

    @NotNull
    public ChangesBrowserNode<?> createTagNode(@NotNull @Nls String tag2, @NotNull SimpleTextAttributes attributes2, boolean expandByDefault) {
        if (tag2 == null) {
            TreeModelBuilder.$$$reportNull$$$0(46);
        }
        if (attributes2 == null) {
            TreeModelBuilder.$$$reportNull$$$0(47);
        }
        ChangesBrowserNode<?> changesBrowserNode = this.createTagNode(new ChangesBrowserNode.TagImpl(tag2), attributes2, expandByDefault);
        if (changesBrowserNode == null) {
            TreeModelBuilder.$$$reportNull$$$0(48);
        }
        return changesBrowserNode;
    }

    @NotNull
    public ChangesBrowserNode<?> createTagNode(@Nullable ChangesBrowserNode.Tag tag2, @NotNull SimpleTextAttributes attributes2, boolean expandByDefault) {
        if (attributes2 == null) {
            TreeModelBuilder.$$$reportNull$$$0(49);
        }
        if (tag2 == null) {
            ChangesBrowserNode<?> changesBrowserNode = this.myRoot;
            if (changesBrowserNode == null) {
                TreeModelBuilder.$$$reportNull$$$0(50);
            }
            return changesBrowserNode;
        }
        TagChangesBrowserNode subtreeRoot = new TagChangesBrowserNode(tag2, attributes2, expandByDefault);
        subtreeRoot.markAsHelperNode();
        this.insertSubtreeRoot((ChangesBrowserNode)subtreeRoot);
        TagChangesBrowserNode tagChangesBrowserNode = subtreeRoot;
        if (tagChangesBrowserNode == null) {
            TreeModelBuilder.$$$reportNull$$$0(51);
        }
        return tagChangesBrowserNode;
    }

    @Override
    public void insertFilesIntoNode(@NotNull Collection<? extends VirtualFile> files2, @NotNull ChangesBrowserNode<?> subtreeRoot) {
        if (files2 == null) {
            TreeModelBuilder.$$$reportNull$$$0(52);
        }
        if (subtreeRoot == null) {
            TreeModelBuilder.$$$reportNull$$$0(53);
        }
        List sortedFiles = ContainerUtil.sorted(files2, (Comparator)VirtualFileHierarchicalComparator.getInstance());
        for (VirtualFile file2 : sortedFiles) {
            this.insertChangeNode(file2, subtreeRoot, ChangesBrowserNode.createFile(this.myProject, file2));
        }
    }

    private void insertLocalFilePathIntoNode(@NotNull Collection<? extends FilePath> files2, @NotNull ChangesBrowserNode<?> subtreeRoot, @NotNull FileStatus status) {
        if (files2 == null) {
            TreeModelBuilder.$$$reportNull$$$0(54);
        }
        if (subtreeRoot == null) {
            TreeModelBuilder.$$$reportNull$$$0(55);
        }
        if (status == null) {
            TreeModelBuilder.$$$reportNull$$$0(56);
        }
        List sortedFilePaths = ContainerUtil.sorted(files2, PATH_COMPARATOR);
        for (FilePath filePath : sortedFilePaths) {
            this.insertChangeNode(filePath, subtreeRoot, ChangesBrowserNode.createFilePath(filePath, status));
        }
    }

    @NotNull
    public TreeModelBuilder setLocallyDeletedPaths(@Nullable Collection<? extends LocallyDeletedChange> locallyDeletedChanges) {
        if (ContainerUtil.isEmpty(locallyDeletedChanges)) {
            TreeModelBuilder treeModelBuilder = this;
            if (treeModelBuilder == null) {
                TreeModelBuilder.$$$reportNull$$$0(57);
            }
            return treeModelBuilder;
        }
        ChangesBrowserNode<?> subtreeRoot = this.createTagNode(ChangesBrowserNode.LOCALLY_DELETED_NODE_TAG);
        for (LocallyDeletedChange change : ContainerUtil.sorted(locallyDeletedChanges, Comparator.comparing(LocallyDeletedChange::getPath, PATH_COMPARATOR))) {
            this.insertChangeNode(change, subtreeRoot, ChangesBrowserNode.createLocallyDeleted(change));
        }
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(58);
        }
        return treeModelBuilder;
    }

    @NotNull
    public TreeModelBuilder setFilePaths(@NotNull Collection<? extends FilePath> filePaths) {
        if (filePaths == null) {
            TreeModelBuilder.$$$reportNull$$$0(59);
        }
        TreeModelBuilder treeModelBuilder = this.setFilePaths(filePaths, this.myRoot);
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(60);
        }
        return treeModelBuilder;
    }

    @NotNull
    public TreeModelBuilder setFilePaths(@NotNull Collection<? extends FilePath> filePaths, @NotNull ChangesBrowserNode<?> subtreeRoot) {
        if (filePaths == null) {
            TreeModelBuilder.$$$reportNull$$$0(61);
        }
        if (subtreeRoot == null) {
            TreeModelBuilder.$$$reportNull$$$0(62);
        }
        for (FilePath file2 : ContainerUtil.sorted(filePaths, PATH_COMPARATOR)) {
            assert (file2 != null);
            this.insertChangeNode(file2, subtreeRoot, ChangesBrowserNode.createFilePath(file2));
        }
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(63);
        }
        return treeModelBuilder;
    }

    @NotNull
    public TreeModelBuilder setSwitchedRoots(@Nullable Map<VirtualFile, @NlsSafe String> switchedRoots) {
        if (ContainerUtil.isEmpty(switchedRoots)) {
            TreeModelBuilder treeModelBuilder = this;
            if (treeModelBuilder == null) {
                TreeModelBuilder.$$$reportNull$$$0(64);
            }
            return treeModelBuilder;
        }
        ChangesBrowserNode<?> rootsHeadNode = this.createTagNode(ChangesBrowserNode.SWITCHED_ROOTS_TAG, SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES, true);
        List files2 = ContainerUtil.sorted(switchedRoots.keySet(), (Comparator)VirtualFileHierarchicalComparator.getInstance());
        for (VirtualFile vf : files2) {
            CurrentContentRevision cr = new CurrentContentRevision(VcsUtil.getFilePath((VirtualFile)vf));
            Change change = new Change((ContentRevision)cr, (ContentRevision)cr, FileStatus.NOT_CHANGED);
            final String branchName = switchedRoots.get(vf);
            this.insertChangeNode(vf, rootsHeadNode, this.createChangeNode(change, new ChangeNodeDecorator(){

                @Override
                public void decorate(@NotNull Change change1, @NotNull SimpleColoredComponent component2, boolean isShowFlatten) {
                    if (change1 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (component2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                }

                @Override
                public void preDecorate(@NotNull Change change1, @NotNull ChangesBrowserNodeRenderer renderer2, boolean showFlatten) {
                    if (change1 == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (renderer2 == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    renderer2.append("[" + branchName + "] ", SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "change1";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "component";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "renderer";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "decorate";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "preDecorate";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }));
        }
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(65);
        }
        return treeModelBuilder;
    }

    @NotNull
    public TreeModelBuilder setSwitchedFiles(@NotNull MultiMap<@NlsSafe String, VirtualFile> switchedFiles) {
        if (switchedFiles == null) {
            TreeModelBuilder.$$$reportNull$$$0(66);
        }
        if (switchedFiles.isEmpty()) {
            TreeModelBuilder treeModelBuilder = this;
            if (treeModelBuilder == null) {
                TreeModelBuilder.$$$reportNull$$$0(67);
            }
            return treeModelBuilder;
        }
        ChangesBrowserNode<?> subtreeRoot = this.createTagNode(ChangesBrowserNode.SWITCHED_FILES_TAG);
        for (String branchName : switchedFiles.keySet()) {
            List switchedFileList = ContainerUtil.sorted((Collection)switchedFiles.get((Object)branchName), (Comparator)VirtualFileHierarchicalComparator.getInstance());
            if (switchedFileList.size() <= 0) continue;
            ChangesBrowserStringNode branchNode = new ChangesBrowserStringNode(branchName);
            branchNode.markAsHelperNode();
            this.insertSubtreeRoot(branchNode, subtreeRoot);
            for (VirtualFile file2 : switchedFileList) {
                this.insertChangeNode(file2, branchNode, ChangesBrowserNode.createFile(this.myProject, file2));
            }
        }
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(68);
        }
        return treeModelBuilder;
    }

    @NotNull
    public TreeModelBuilder setLogicallyLockedFiles(@Nullable Map<VirtualFile, LogicalLock> logicallyLockedFiles) {
        if (ContainerUtil.isEmpty(logicallyLockedFiles)) {
            TreeModelBuilder treeModelBuilder = this;
            if (treeModelBuilder == null) {
                TreeModelBuilder.$$$reportNull$$$0(69);
            }
            return treeModelBuilder;
        }
        ChangesBrowserNode<?> subtreeRoot = this.createTagNode(ChangesBrowserNode.LOGICALLY_LOCKED_TAG);
        List keys2 = ContainerUtil.sorted(logicallyLockedFiles.keySet(), (Comparator)VirtualFileHierarchicalComparator.getInstance());
        for (VirtualFile file2 : keys2) {
            LogicalLock lock2 = logicallyLockedFiles.get(file2);
            this.insertChangeNode(file2, subtreeRoot, ChangesBrowserNode.createLogicallyLocked(this.myProject, file2, lock2));
        }
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(70);
        }
        return treeModelBuilder;
    }

    @Override
    @NotNull
    public TreeModelBuilder insertSubtreeRoot(@NotNull ChangesBrowserNode<?> node2) {
        if (node2 == null) {
            TreeModelBuilder.$$$reportNull$$$0(71);
        }
        this.insertSubtreeRoot(node2, this.myRoot);
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(72);
        }
        return treeModelBuilder;
    }

    @NotNull
    public TreeModelBuilder insertSubtreeRoot(@NotNull ChangesBrowserNode<?> node2, @NotNull ChangesBrowserNode<?> subtreeRoot) {
        if (node2 == null) {
            TreeModelBuilder.$$$reportNull$$$0(73);
        }
        if (subtreeRoot == null) {
            TreeModelBuilder.$$$reportNull$$$0(74);
        }
        this.myModel.insertNodeInto(node2, subtreeRoot, subtreeRoot.getChildCount());
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(75);
        }
        return treeModelBuilder;
    }

    public void insertChangeNode(@NotNull Object change, @NotNull ChangesBrowserNode<?> subtreeRoot, @NotNull ChangesBrowserNode<?> node2) {
        if (change == null) {
            TreeModelBuilder.$$$reportNull$$$0(76);
        }
        if (subtreeRoot == null) {
            TreeModelBuilder.$$$reportNull$$$0(77);
        }
        if (node2 == null) {
            TreeModelBuilder.$$$reportNull$$$0(78);
        }
        this.insertChangeNode(change, subtreeRoot, node2, TreeModelBuilder::createPathNode);
    }

    protected void insertChangeNode(@NotNull Object change, @NotNull ChangesBrowserNode<?> subtreeRoot, @NotNull ChangesBrowserNode<?> node2, @NotNull Function<StaticFilePath, ChangesBrowserNode<?>> nodeBuilder) {
        if (change == null) {
            TreeModelBuilder.$$$reportNull$$$0(79);
        }
        if (subtreeRoot == null) {
            TreeModelBuilder.$$$reportNull$$$0(80);
        }
        if (node2 == null) {
            TreeModelBuilder.$$$reportNull$$$0(81);
        }
        if (nodeBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(82);
        }
        PATH_NODE_BUILDER.set(subtreeRoot, nodeBuilder);
        if (!GROUPING_POLICY.isIn(subtreeRoot)) {
            NoneChangesGroupingPolicy policy = this.myProject != null ? this.myGroupingPolicyFactory.createGroupingPolicy(this.myProject, this.myModel) : NoneChangesGroupingPolicy.INSTANCE;
            GROUPING_POLICY.set(subtreeRoot, (Object)policy);
        }
        StaticFilePath pathKey = TreeModelBuilder.getKey(change);
        ChangesBrowserNode parentNode = (ChangesBrowserNode)ReadAction.compute(() -> (ChangesBrowserNode)ObjectUtils.notNull((Object)((ChangesGroupingPolicy)GROUPING_POLICY.getRequired((UserDataHolder)subtreeRoot)).getParentNodeFor(pathKey, subtreeRoot), (Object)subtreeRoot));
        ChangesBrowserNode<?> cachingRoot = BaseChangesGroupingPolicy.getCachingRoot(parentNode, subtreeRoot);
        this.myModel.insertNodeInto(node2, parentNode, this.myModel.getChildCount(parentNode));
        if (pathKey.isDirectory()) {
            ((Map)DIRECTORY_CACHE.getValue(cachingRoot)).put(pathKey.getKey(), node2);
        }
    }

    @NotNull
    public DefaultTreeModel build() {
        TreeUtil.sort((DefaultTreeModel)this.myModel, BROWSER_NODE_COMPARATOR);
        TreeModelBuilder.collapseDirectories(this.myModel, this.myRoot);
        this.myModel.nodeStructureChanged((TreeNode)this.myModel.getRoot());
        DefaultTreeModel defaultTreeModel = this.myModel;
        if (defaultTreeModel == null) {
            TreeModelBuilder.$$$reportNull$$$0(83);
        }
        return defaultTreeModel;
    }

    private static void collapseDirectories(@NotNull DefaultTreeModel model2, @NotNull ChangesBrowserNode<?> node2) {
        ChangesBrowserNode child2;
        ChangesBrowserNode<?> collapsed;
        if (model2 == null) {
            TreeModelBuilder.$$$reportNull$$$0(84);
        }
        if (node2 == null) {
            TreeModelBuilder.$$$reportNull$$$0(85);
        }
        ChangesBrowserNode<?> collapsedNode = node2;
        while (collapsedNode.getChildCount() == 1 && (collapsed = TreeModelBuilder.collapseParentWithOnlyChild(collapsedNode, child2 = (ChangesBrowserNode)collapsedNode.getChildAt(0))) != null) {
            collapsedNode = collapsed;
        }
        if (collapsedNode != node2) {
            TreeNode parent = node2.getParent();
            int idx = ((DefaultMutableTreeNode)parent).getIndex(node2);
            model2.removeNodeFromParent(node2);
            model2.insertNodeInto(collapsedNode, (MutableTreeNode)parent, idx);
            node2 = collapsedNode;
        }
        Enumeration<TreeNode> children2 = node2.children();
        while (children2.hasMoreElements()) {
            ChangesBrowserNode child3 = (ChangesBrowserNode)children2.nextElement();
            TreeModelBuilder.collapseDirectories(model2, child3);
        }
    }

    @Nullable
    private static ChangesBrowserNode<?> collapseParentWithOnlyChild(@NotNull ChangesBrowserNode<?> parent, @NotNull ChangesBrowserNode<?> child2) {
        if (parent == null) {
            TreeModelBuilder.$$$reportNull$$$0(86);
        }
        if (child2 == null) {
            TreeModelBuilder.$$$reportNull$$$0(87);
        }
        if (child2.isLeaf()) {
            return null;
        }
        Object parentUserObject = parent.getUserObject();
        Object childUserObject = child2.getUserObject();
        if (parentUserObject instanceof FilePath && childUserObject instanceof FilePath) {
            return child2;
        }
        if (parent instanceof ChangesBrowserModuleNode && childUserObject instanceof FilePath) {
            FilePath childPath;
            FilePath parentPath = ((ChangesBrowserModuleNode)parent).getModuleRoot();
            if (!parentPath.equals(childPath = (FilePath)childUserObject)) {
                return null;
            }
            parent.remove(0);
            Enumeration<TreeNode> children2 = child2.children();
            for (ChangesBrowserNode childNode : ContainerUtil.toList(children2)) {
                parent.add(childNode);
            }
            return parent;
        }
        return null;
    }

    @NotNull
    private static StaticFilePath getKey(@NotNull Object o) {
        if (o == null) {
            TreeModelBuilder.$$$reportNull$$$0(88);
        }
        if (o instanceof Change) {
            return TreeModelBuilder.staticFrom(ChangesUtil.getFilePath((Change)((Change)o)));
        }
        if (o instanceof VirtualFile) {
            return TreeModelBuilder.staticFrom((VirtualFile)o);
        }
        if (o instanceof FilePath) {
            return TreeModelBuilder.staticFrom((FilePath)o);
        }
        if (o instanceof LocallyDeletedChange) {
            return TreeModelBuilder.staticFrom(((LocallyDeletedChange)o).getPath());
        }
        throw new IllegalArgumentException("Unknown type - " + o.getClass());
    }

    @NotNull
    public static StaticFilePath staticFrom(@NotNull FilePath fp) {
        if (fp == null) {
            TreeModelBuilder.$$$reportNull$$$0(89);
        }
        return new StaticFilePath(fp.isDirectory(), fp.getPath(), fp.getVirtualFile());
    }

    @NotNull
    public static StaticFilePath staticFrom(@NotNull VirtualFile vf) {
        if (vf == null) {
            TreeModelBuilder.$$$reportNull$$$0(90);
        }
        return new StaticFilePath(vf.isDirectory(), vf.getPath(), vf);
    }

    @NotNull
    public static FilePath getPathForObject(@NotNull Object o) {
        if (o == null) {
            TreeModelBuilder.$$$reportNull$$$0(91);
        }
        if (o instanceof Change) {
            FilePath filePath = ChangesUtil.getFilePath((Change)((Change)o));
            if (filePath == null) {
                TreeModelBuilder.$$$reportNull$$$0(92);
            }
            return filePath;
        }
        if (o instanceof VirtualFile) {
            FilePath filePath = VcsUtil.getFilePath((VirtualFile)((VirtualFile)o));
            if (filePath == null) {
                TreeModelBuilder.$$$reportNull$$$0(93);
            }
            return filePath;
        }
        if (o instanceof FilePath) {
            FilePath filePath = (FilePath)o;
            if (filePath == null) {
                TreeModelBuilder.$$$reportNull$$$0(94);
            }
            return filePath;
        }
        if (o instanceof LocallyDeletedChange) {
            FilePath filePath = ((LocallyDeletedChange)o).getPath();
            if (filePath == null) {
                TreeModelBuilder.$$$reportNull$$$0(95);
            }
            return filePath;
        }
        throw new IllegalArgumentException("Unknown type - " + o.getClass());
    }

    @NotNull
    private static ChangesBrowserNode<?> createPathNode(@NotNull StaticFilePath path2) {
        if (path2 == null) {
            TreeModelBuilder.$$$reportNull$$$0(96);
        }
        ChangesBrowserNode changesBrowserNode = ChangesBrowserNode.createFilePath(path2.getFilePath());
        if (changesBrowserNode == null) {
            TreeModelBuilder.$$$reportNull$$$0(97);
        }
        return changesBrowserNode;
    }

    public boolean isEmpty() {
        return this.myModel.getChildCount(this.myRoot) == 0;
    }

    @Deprecated
    @NotNull
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public DefaultTreeModel buildModel(@NotNull List<? extends Change> changes, @Nullable ChangeNodeDecorator changeNodeDecorator) {
        if (changes == null) {
            TreeModelBuilder.$$$reportNull$$$0(98);
        }
        DefaultTreeModel defaultTreeModel = this.setChanges(changes, changeNodeDecorator).build();
        if (defaultTreeModel == null) {
            TreeModelBuilder.$$$reportNull$$$0(99);
        }
        return defaultTreeModel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 26: 
            case 27: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 48: 
            case 50: 
            case 51: 
            case 57: 
            case 58: 
            case 60: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 72: 
            case 75: 
            case 83: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 97: 
            case 99: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 26: 
            case 27: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 48: 
            case 50: 
            case 51: 
            case 57: 
            case 58: 
            case 60: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 72: 
            case 75: 
            case 83: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 97: 
            case 99: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 9: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grouping";
                break;
            }
            case 3: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 4: 
            case 7: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 26: 
            case 27: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 48: 
            case 50: 
            case 51: 
            case 57: 
            case 58: 
            case 60: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 72: 
            case 75: 
            case 83: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 97: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder";
                break;
            }
            case 6: 
            case 59: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
            case 10: 
            case 13: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeLists";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFiles";
                break;
            }
            case 23: 
            case 25: 
            case 53: 
            case 55: 
            case 62: 
            case 74: 
            case 77: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subtreeRoot";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specificFiles";
                break;
            }
            case 29: 
            case 71: 
            case 73: 
            case 78: 
            case 81: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 30: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 34: 
            case 76: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiedWithoutEditing";
                break;
            }
            case 40: 
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 47: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 52: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchedFiles";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeBuilder";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 88: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fp";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vf";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFromChanges";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFromFilePaths";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFromChangeLists";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFromVirtualFiles";
                break;
            }
            case 19: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "setChanges";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "setUnversioned";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "setIgnored";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "insertSpecificFilePathNodeToModel";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "setChangeLists";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "setLockedFolders";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "setVirtualFiles";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 48: 
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "createTagNode";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "setLocallyDeletedPaths";
                break;
            }
            case 60: 
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "setFilePaths";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "setSwitchedRoots";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "setSwitchedFiles";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "setLogicallyLockedFiles";
                break;
            }
            case 72: 
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "insertSubtreeRoot";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathForObject";
                break;
            }
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "createPathNode";
                break;
            }
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "buildModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildFromChanges";
                break;
            }
            case 4: 
            case 7: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 26: 
            case 27: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 48: 
            case 50: 
            case 51: 
            case 57: 
            case 58: 
            case 60: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 72: 
            case 75: 
            case 83: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 97: 
            case 99: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildFromFilePaths";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "buildFromChangeLists";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "buildFromVirtualFiles";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setChanges";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "insertChanges";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "insertSpecificFilePathNodeToModel";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setChangeLists";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createChangeNode";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "setModifiedWithoutEditing";
                break;
            }
            case 40: 
            case 44: 
            case 46: 
            case 47: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "createTagNode";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "insertFilesIntoNode";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "insertLocalFilePathIntoNode";
                break;
            }
            case 59: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "setFilePaths";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "setSwitchedFiles";
                break;
            }
            case 71: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "insertSubtreeRoot";
                break;
            }
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "insertChangeNode";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "collapseDirectories";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "collapseParentWithOnlyChild";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "getKey";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "staticFrom";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "getPathForObject";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "createPathNode";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "buildModel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 26: 
            case 27: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 48: 
            case 50: 
            case 51: 
            case 57: 
            case 58: 
            case 60: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 72: 
            case 75: 
            case 83: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 97: 
            case 99: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

