/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch.tool;

import com.intellij.diff.comparison.ByWord;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.tools.fragmented.LineNumberConvertor;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.tools.util.text.LineOffsetsUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.vcs.changes.patch.AppliedTextPatch;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PatchChangeBuilder {
    @NotNull
    private final StringBuilder myBuilder = new StringBuilder();
    @NotNull
    private final List<Hunk> myHunks = new ArrayList<Hunk>();
    @NotNull
    private final LineNumberConvertor.Builder myConvertor1 = new LineNumberConvertor.Builder();
    @NotNull
    private final LineNumberConvertor.Builder myConvertor2 = new LineNumberConvertor.Builder();
    @NotNull
    private final IntList myChangedLines = new IntArrayList();
    private int totalLines = 0;

    public void exec(@NotNull List<? extends AppliedTextPatch.AppliedSplitPatchHunk> splitHunks) {
        if (splitHunks == null) {
            PatchChangeBuilder.$$$reportNull$$$0(0);
        }
        int lastBeforeLine = -1;
        for (AppliedTextPatch.AppliedSplitPatchHunk appliedSplitPatchHunk : splitHunks) {
            List<String> contextBefore = appliedSplitPatchHunk.getContextBefore();
            List<String> contextAfter = appliedSplitPatchHunk.getContextAfter();
            LineRange beforeRange = appliedSplitPatchHunk.getLineRangeBefore();
            LineRange afterRange = appliedSplitPatchHunk.getLineRangeAfter();
            int overlappedContext = 0;
            if (lastBeforeLine != -1) {
                if (lastBeforeLine >= beforeRange.start) {
                    overlappedContext = lastBeforeLine - beforeRange.start + 1;
                } else if (lastBeforeLine < beforeRange.start - 1) {
                    this.appendSeparator();
                }
            }
            List<String> trimContext = contextBefore.subList(overlappedContext, contextBefore.size());
            this.addContext(trimContext, beforeRange.start + overlappedContext, afterRange.start + overlappedContext);
            int deletion = this.totalLines;
            this.appendLines(appliedSplitPatchHunk.getDeletedLines());
            int insertion = this.totalLines;
            this.appendLines(appliedSplitPatchHunk.getInsertedLines());
            int hunkEnd = this.totalLines;
            this.myConvertor1.put(deletion, beforeRange.start + contextBefore.size(), insertion - deletion);
            this.myConvertor2.put(insertion, afterRange.start + contextBefore.size(), hunkEnd - insertion);
            this.addContext(contextAfter, beforeRange.end - contextAfter.size(), afterRange.end - contextAfter.size());
            lastBeforeLine = beforeRange.end - 1;
            LineRange deletionRange = new LineRange(deletion, insertion);
            LineRange insertionRange = new LineRange(insertion, hunkEnd);
            this.myHunks.add(new Hunk(appliedSplitPatchHunk.getInsertedLines(), deletionRange, insertionRange, appliedSplitPatchHunk.getAppliedTo(), appliedSplitPatchHunk.getStatus()));
        }
    }

    private void addContext(@NotNull List<String> context2, int beforeLineNumber, int afterLineNumber) {
        if (context2 == null) {
            PatchChangeBuilder.$$$reportNull$$$0(1);
        }
        this.myConvertor1.put(this.totalLines, beforeLineNumber, context2.size());
        this.myConvertor2.put(this.totalLines, afterLineNumber, context2.size());
        this.appendLines(context2);
    }

    private void appendLines(@NotNull List<String> lines2) {
        if (lines2 == null) {
            PatchChangeBuilder.$$$reportNull$$$0(2);
        }
        for (String line : lines2) {
            this.myBuilder.append(line).append("\n");
        }
        this.totalLines += lines2.size();
    }

    private void appendSeparator() {
        this.myChangedLines.add(this.totalLines);
        this.myBuilder.append("\n");
        ++this.totalLines;
    }

    @NotNull
    public CharSequence getPatchContent() {
        StringBuilder stringBuilder = this.myBuilder;
        if (stringBuilder == null) {
            PatchChangeBuilder.$$$reportNull$$$0(3);
        }
        return stringBuilder;
    }

    @NotNull
    public List<Hunk> getHunks() {
        List<Hunk> list2 = this.myHunks;
        if (list2 == null) {
            PatchChangeBuilder.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @NotNull
    public LineNumberConvertor getLineConvertor1() {
        LineNumberConvertor lineNumberConvertor = this.myConvertor1.build();
        if (lineNumberConvertor == null) {
            PatchChangeBuilder.$$$reportNull$$$0(5);
        }
        return lineNumberConvertor;
    }

    @NotNull
    public LineNumberConvertor getLineConvertor2() {
        LineNumberConvertor lineNumberConvertor = this.myConvertor2.build();
        if (lineNumberConvertor == null) {
            PatchChangeBuilder.$$$reportNull$$$0(6);
        }
        return lineNumberConvertor;
    }

    @NotNull
    public IntList getSeparatorLines() {
        IntList intList = this.myChangedLines;
        if (intList == null) {
            PatchChangeBuilder.$$$reportNull$$$0(7);
        }
        return intList;
    }

    @Nullable
    public static List<DiffFragment> computeInnerDifferences(@NotNull Document patchContent, @NotNull Hunk hunk) {
        if (patchContent == null) {
            PatchChangeBuilder.$$$reportNull$$$0(8);
        }
        if (hunk == null) {
            PatchChangeBuilder.$$$reportNull$$$0(9);
        }
        return PatchChangeBuilder.computeInnerDifferences(patchContent.getImmutableCharSequence(), LineOffsetsUtil.create(patchContent), hunk);
    }

    @Nullable
    public static List<DiffFragment> computeInnerDifferences(@NotNull CharSequence patchContent, @NotNull LineOffsets lineOffsets, @NotNull Hunk hunk) {
        if (patchContent == null) {
            PatchChangeBuilder.$$$reportNull$$$0(10);
        }
        if (lineOffsets == null) {
            PatchChangeBuilder.$$$reportNull$$$0(11);
        }
        if (hunk == null) {
            PatchChangeBuilder.$$$reportNull$$$0(12);
        }
        LineRange deletionRange = hunk.getPatchDeletionRange();
        LineRange insertionRange = hunk.getPatchInsertionRange();
        if (deletionRange.isEmpty() || insertionRange.isEmpty()) {
            return null;
        }
        try {
            CharSequence deleted = DiffUtil.getLinesContent(patchContent, lineOffsets, deletionRange.start, deletionRange.end);
            CharSequence inserted = DiffUtil.getLinesContent(patchContent, lineOffsets, insertionRange.start, insertionRange.end);
            return ByWord.compare(deleted, inserted, ComparisonPolicy.DEFAULT, (ProgressIndicator)DumbProgressIndicator.INSTANCE);
        }
        catch (DiffTooBigException ignore) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "splitHunks";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patchContent";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hunk";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineOffsets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatchContent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getHunks";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineConvertor1";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineConvertor2";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeparatorLines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "exec";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addContext";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "appendLines";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "computeInnerDifferences";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Hunk {
        @NotNull
        private final List<String> myInsertedLines;
        @NotNull
        private final LineRange myPatchDeletionRange;
        @NotNull
        private final LineRange myPatchInsertionRange;
        @Nullable
        private final LineRange myAppliedToLines;
        @NotNull
        private final AppliedTextPatch.HunkStatus myStatus;

        public Hunk(@NotNull List<String> insertedLines, @NotNull LineRange patchDeletionRange, @NotNull LineRange patchInsertionRange, @Nullable LineRange appliedToLines, @NotNull AppliedTextPatch.HunkStatus status) {
            if (insertedLines == null) {
                Hunk.$$$reportNull$$$0(0);
            }
            if (patchDeletionRange == null) {
                Hunk.$$$reportNull$$$0(1);
            }
            if (patchInsertionRange == null) {
                Hunk.$$$reportNull$$$0(2);
            }
            if (status == null) {
                Hunk.$$$reportNull$$$0(3);
            }
            this.myInsertedLines = insertedLines;
            this.myPatchDeletionRange = patchDeletionRange;
            this.myPatchInsertionRange = patchInsertionRange;
            this.myAppliedToLines = appliedToLines;
            this.myStatus = status;
        }

        @NotNull
        public LineRange getPatchDeletionRange() {
            LineRange lineRange = this.myPatchDeletionRange;
            if (lineRange == null) {
                Hunk.$$$reportNull$$$0(4);
            }
            return lineRange;
        }

        @NotNull
        public LineRange getPatchInsertionRange() {
            LineRange lineRange = this.myPatchInsertionRange;
            if (lineRange == null) {
                Hunk.$$$reportNull$$$0(5);
            }
            return lineRange;
        }

        @NotNull
        public AppliedTextPatch.HunkStatus getStatus() {
            AppliedTextPatch.HunkStatus hunkStatus = this.myStatus;
            if (hunkStatus == null) {
                Hunk.$$$reportNull$$$0(6);
            }
            return hunkStatus;
        }

        @Nullable
        public LineRange getAppliedToLines() {
            return this.myAppliedToLines;
        }

        @NotNull
        private List<String> getInsertedLines() {
            List<String> list2 = this.myInsertedLines;
            if (list2 == null) {
                Hunk.$$$reportNull$$$0(7);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "insertedLines";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "patchDeletionRange";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "patchInsertionRange";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "status";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder$Hunk";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder$Hunk";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPatchDeletionRange";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPatchInsertionRange";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatus";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInsertedLines";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

