/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.conflicts;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.BulkAwareDocumentListener;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.ZipperUpdater;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictResolution;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public final class ChangelistConflictTracker {
    private final Map<String, Conflict> myConflicts;
    private final Options myOptions;
    private final Project myProject;
    private final ChangeListManager myChangeListManager;
    private final ChangeListAdapter myChangeListListener;
    private final DocumentListener myDocumentListener;
    private final Set<VirtualFile> myCheckSet;
    private final Object myCheckSetLock;
    private final AtomicBoolean myShouldIgnoreModifications;

    @NotNull
    public static ChangelistConflictTracker getInstance(@NotNull Project project) {
        if (project == null) {
            ChangelistConflictTracker.$$$reportNull$$$0(0);
        }
        ChangelistConflictTracker changelistConflictTracker = ChangeListManagerImpl.getInstanceImpl(project).getConflictTracker();
        if (changelistConflictTracker == null) {
            ChangelistConflictTracker.$$$reportNull$$$0(1);
        }
        return changelistConflictTracker;
    }

    public ChangelistConflictTracker(@NotNull Project project, @NotNull ChangeListManager changeListManager) {
        if (project == null) {
            ChangelistConflictTracker.$$$reportNull$$$0(2);
        }
        if (changeListManager == null) {
            ChangelistConflictTracker.$$$reportNull$$$0(3);
        }
        this.myConflicts = Collections.synchronizedMap(new LinkedHashMap());
        this.myOptions = new Options();
        this.myShouldIgnoreModifications = new AtomicBoolean(false);
        this.myProject = project;
        this.myChangeListManager = changeListManager;
        this.myCheckSetLock = new Object();
        this.myCheckSet = new HashSet<VirtualFile>();
        final ZipperUpdater zipperUpdater = new ZipperUpdater(300, Alarm.ThreadToUse.SWING_THREAD, (Disposable)project);
        this.myDocumentListener = new BulkAwareDocumentListener.Simple(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void afterDocumentChange(@NotNull Document document) {
                if (document == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!ChangelistConflictTracker.this.myOptions.isTrackingEnabled() || ChangelistConflictTracker.this.myShouldIgnoreModifications.get() || !ChangelistConflictTracker.this.myChangeListManager.areChangeListsEnabled()) {
                    return;
                }
                VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
                if (file2 != null && file2.isInLocalFileSystem() && ProjectUtil.guessProjectForFile((VirtualFile)file2) == ChangelistConflictTracker.this.myProject) {
                    Object object = ChangelistConflictTracker.this.myCheckSetLock;
                    synchronized (object) {
                        ChangelistConflictTracker.this.myCheckSet.add(file2);
                    }
                    zipperUpdater.queue(() -> ChangelistConflictTracker.this.checkFiles());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/vcs/changes/conflicts/ChangelistConflictTracker$1", "afterDocumentChange"));
            }
        };
        this.myChangeListListener = new ChangeListAdapter(){

            public void changeListChanged(ChangeList list2) {
                if (((LocalChangeList)list2).isDefault()) {
                    ChangelistConflictTracker.this.clearChanges(list2.getChanges());
                }
            }

            public void changesMoved(Collection<Change> changes, ChangeList fromList, ChangeList toList) {
                if (((LocalChangeList)toList).isDefault() || ((LocalChangeList)fromList).isDefault()) {
                    ChangelistConflictTracker.this.clearChanges(changes);
                }
            }

            public void changesRemoved(Collection<Change> changes, ChangeList fromList) {
                ChangelistConflictTracker.this.clearChanges(changes);
            }

            public void defaultListChanged(ChangeList oldDefaultList, ChangeList newDefaultList) {
                ChangelistConflictTracker.this.clearChanges(newDefaultList.getChanges());
            }

            public void changeListAvailabilityChanged() {
                ChangelistConflictTracker.this.optionsChanged();
            }
        };
    }

    public void setIgnoreModifications(boolean value2) {
        this.myShouldIgnoreModifications.set(value2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFiles() {
        List files2;
        if (this.myProject.isDisposed() || !this.myProject.isOpen()) {
            return;
        }
        Object object = this.myCheckSetLock;
        synchronized (object) {
            files2 = ContainerUtil.filter(this.myCheckSet, file2 -> VcsUtil.getVcsFor((Project)this.myProject, (VirtualFile)file2) != null);
            this.myCheckSet.clear();
        }
        if (files2.isEmpty()) {
            return;
        }
        this.myChangeListManager.invokeAfterUpdate(true, () -> {
            LocalChangeList list2 = this.myChangeListManager.getDefaultChangeList();
            for (VirtualFile file2 : files2) {
                this.checkOneFile(file2, list2);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkOneFile(@NotNull VirtualFile file2, @NotNull LocalChangeList defaultList) {
        if (file2 == null) {
            ChangelistConflictTracker.$$$reportNull$$$0(4);
        }
        if (defaultList == null) {
            ChangelistConflictTracker.$$$reportNull$$$0(5);
        }
        if (!this.shouldDetectConflictsFor(file2)) {
            return;
        }
        LocalChangeList changeList = this.myChangeListManager.getChangeList(file2);
        if (changeList == null || Comparing.equal((Object)changeList, (Object)defaultList) || ChangesUtil.isInternalOperation((VirtualFile)file2)) {
            return;
        }
        String path2 = file2.getPath();
        boolean newConflict = false;
        Map<String, Conflict> map2 = this.myConflicts;
        synchronized (map2) {
            Conflict conflict = this.myConflicts.get(path2);
            if (conflict == null) {
                conflict = new Conflict();
                this.myConflicts.put(path2, conflict);
                newConflict = true;
            }
        }
        if (newConflict && this.myOptions.HIGHLIGHT_CONFLICTS) {
            FileStatusManager.getInstance((Project)this.myProject).fileStatusChanged(file2);
            EditorNotifications.getInstance((Project)this.myProject).updateNotifications(file2);
        }
    }

    public boolean isWritingAllowed(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ChangelistConflictTracker.$$$reportNull$$$0(6);
        }
        if (this.isFromActiveChangelist(file2)) {
            return true;
        }
        Conflict conflict = this.myConflicts.get(file2.getPath());
        return conflict != null && conflict.ignored;
    }

    public boolean isFromActiveChangelist(VirtualFile file2) {
        List changeLists = this.myChangeListManager.getChangeLists(file2);
        return changeLists.isEmpty() || ContainerUtil.exists((Iterable)changeLists, list2 -> list2.isDefault());
    }

    public boolean shouldDetectConflictsFor(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ChangelistConflictTracker.$$$reportNull$$$0(7);
        }
        return !LineStatusTrackerManager.getInstance(this.myProject).arePartialChangelistsEnabled(file2);
    }

    private void clearChanges(Collection<? extends Change> changes) {
        for (Change change : changes) {
            ContentRevision revision = change.getAfterRevision();
            if (revision == null) continue;
            FilePath filePath = revision.getFile();
            String path2 = filePath.getPath();
            Conflict wasRemoved = this.myConflicts.remove(path2);
            VirtualFile file2 = filePath.getVirtualFile();
            if (file2 == null) continue;
            if (wasRemoved != null) {
                EditorNotifications.getInstance((Project)this.myProject).updateNotifications(file2);
            }
            FileStatusManager.getInstance((Project)this.myProject).fileStatusChanged(file2);
        }
    }

    public void startTracking() {
        this.myProject.getMessageBus().connect().subscribe(ChangeListListener.TOPIC, (Object)this.myChangeListListener);
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener(this.myDocumentListener, (Disposable)this.myProject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveState(Element to) {
        Map<String, Conflict> map2 = this.myConflicts;
        synchronized (map2) {
            for (Map.Entry<String, Conflict> entry2 : this.myConflicts.entrySet()) {
                Element fileElement = new Element("file");
                fileElement.setAttribute("path", entry2.getKey());
                fileElement.setAttribute("ignored", Boolean.toString(entry2.getValue().ignored));
                to.addContent(fileElement);
            }
        }
        XmlSerializer.serializeInto((Object)this.myOptions, (Element)to);
    }

    public void loadState(@NotNull Element from2) {
        if (from2 == null) {
            ChangelistConflictTracker.$$$reportNull$$$0(8);
        }
        this.myConflicts.clear();
        List files2 = from2.getChildren("file");
        for (Element element2 : files2) {
            VirtualFile vf;
            String path2 = element2.getAttributeValue("path");
            if (path2 == null || (vf = LocalFileSystem.getInstance().findFileByIoFile(new File(path2))) == null || this.myChangeListManager.getChangeList(vf) == null) continue;
            Conflict conflict = new Conflict();
            conflict.ignored = Boolean.parseBoolean(element2.getAttributeValue("ignored"));
            this.myConflicts.put(path2, conflict);
        }
        XmlSerializer.deserializeInto((Object)this.myOptions, (Element)from2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optionsChanged() {
        HashMap<String, Conflict> copyMap;
        Map<String, Conflict> map2 = this.myConflicts;
        synchronized (map2) {
            copyMap = new HashMap<String, Conflict>(this.myConflicts);
        }
        for (Map.Entry entry2 : copyMap.entrySet()) {
            VirtualFile file2 = LocalFileSystem.getInstance().findFileByPath((String)entry2.getKey());
            if (file2 == null) continue;
            FileStatusManager.getInstance((Project)this.myProject).fileStatusChanged(file2);
            EditorNotifications.getInstance((Project)this.myProject).updateNotifications(file2);
        }
    }

    public Map<String, Conflict> getConflicts() {
        return this.myConflicts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getIgnoredConflicts() {
        Map<String, Conflict> map2 = this.myConflicts;
        synchronized (map2) {
            return ContainerUtil.mapNotNull(this.myConflicts.entrySet(), entry2 -> ((Conflict)entry2.getValue()).ignored ? (String)entry2.getKey() : null);
        }
    }

    public boolean hasConflict(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ChangelistConflictTracker.$$$reportNull$$$0(9);
        }
        if (!this.myOptions.isTrackingEnabled() || !this.myChangeListManager.areChangeListsEnabled()) {
            return false;
        }
        String path2 = file2.getPath();
        Conflict conflict = this.myConflicts.get(path2);
        if (conflict != null && !conflict.ignored) {
            if (!this.shouldDetectConflictsFor(file2) || this.isFromActiveChangelist(file2)) {
                this.myConflicts.remove(path2);
                return false;
            }
            return true;
        }
        return false;
    }

    public void ignoreConflict(@NotNull VirtualFile file2, boolean ignore) {
        String path2;
        Conflict conflict;
        if (file2 == null) {
            ChangelistConflictTracker.$$$reportNull$$$0(10);
        }
        if ((conflict = this.myConflicts.get(path2 = file2.getPath())) == null) {
            conflict = new Conflict();
            this.myConflicts.put(path2, conflict);
        }
        conflict.ignored = ignore;
        EditorNotifications.getInstance((Project)this.myProject).updateNotifications(file2);
        FileStatusManager.getInstance((Project)this.myProject).fileStatusChanged(file2);
    }

    public Project getProject() {
        return this.myProject;
    }

    public ChangeListManager getChangeListManager() {
        return this.myChangeListManager;
    }

    public Options getOptions() {
        return this.myOptions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/conflicts/ChangelistConflictTracker";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeListManager";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultList";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/conflicts/ChangelistConflictTracker";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkOneFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isWritingAllowed";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "shouldDetectConflictsFor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "hasConflict";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "ignoreConflict";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class Options {
        public boolean SHOW_DIALOG = false;
        public boolean HIGHLIGHT_CONFLICTS = true;
        public boolean HIGHLIGHT_NON_ACTIVE_CHANGELIST = false;
        public ChangelistConflictResolution LAST_RESOLUTION = ChangelistConflictResolution.IGNORE;

        public boolean isTrackingEnabled() {
            return this.SHOW_DIALOG || this.HIGHLIGHT_CONFLICTS;
        }
    }

    public static class Conflict {
        boolean ignored;
    }
}

