/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListData;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.FakeRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocalChangeListImpl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jdom.Verifier;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ChangeListManagerSerialization {
    private static final int DISABLED_CHANGES_THRESHOLD = 100;
    @NonNls
    private static final String ATT_ID = "id";
    @NonNls
    private static final String ATT_NAME = "name";
    @NonNls
    private static final String ATT_COMMENT = "comment";
    @NonNls
    private static final String ATT_DEFAULT = "default";
    @NonNls
    private static final String ATT_VALUE_TRUE = "true";
    @NonNls
    private static final String ATT_CHANGE_BEFORE_PATH = "beforePath";
    @NonNls
    private static final String ATT_CHANGE_AFTER_PATH = "afterPath";
    @NonNls
    private static final String ATT_CHANGE_BEFORE_PATH_ESCAPED = "beforePathEscaped";
    @NonNls
    private static final String ATT_CHANGE_AFTER_PATH_ESCAPED = "afterPathEscaped";
    @NonNls
    private static final String ATT_CHANGE_BEFORE_PATH_IS_DIR = "beforeDir";
    @NonNls
    private static final String ATT_CHANGE_AFTER_PATH_IS_DIR = "afterDir";
    @NonNls
    private static final String NODE_LIST = "list";
    @NonNls
    private static final String NODE_CHANGE = "change";

    ChangeListManagerSerialization() {
    }

    static void writeExternal(@NotNull Element element2, @Nullable List<? extends LocalChangeList> changeLists, boolean areChangeListsEnabled) {
        if (element2 == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(0);
        }
        if (changeLists == null) {
            return;
        }
        for (LocalChangeList localChangeList : changeLists) {
            element2.addContent(ChangeListManagerSerialization.writeChangeList(localChangeList, areChangeListsEnabled));
        }
    }

    @NotNull
    static List<LocalChangeListImpl> readExternal(@NotNull Element element2, @NotNull Project project) {
        if (element2 == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(1);
        }
        if (project == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(2);
        }
        ArrayList<LocalChangeListImpl> lists = new ArrayList<LocalChangeListImpl>();
        for (Element listNode : element2.getChildren(NODE_LIST)) {
            lists.add(ChangeListManagerSerialization.readChangeList(listNode, project));
        }
        return new ArrayList<LocalChangeListImpl>(ChangeListManagerSerialization.removeDuplicatedLists(lists));
    }

    @NotNull
    private static Collection<LocalChangeListImpl> removeDuplicatedLists(@NotNull List<LocalChangeListImpl> lists) {
        if (lists == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(3);
        }
        boolean hasDefault = false;
        HashMap<String, LocalChangeListImpl> map2 = new HashMap<String, LocalChangeListImpl>();
        for (LocalChangeListImpl list2 : lists) {
            if (list2.isDefault() && hasDefault) {
                list2 = new LocalChangeListImpl.Builder(list2).setDefault(false).build();
            }
            hasDefault |= list2.isDefault();
            LocalChangeListImpl otherList = (LocalChangeListImpl)((Object)map2.get(list2.getName()));
            if (otherList != null) {
                list2 = new LocalChangeListImpl.Builder(otherList).setChanges(ContainerUtil.union((Set)list2.getChanges(), (Set)otherList.getChanges())).setDefault(list2.isDefault() || otherList.isDefault()).build();
            }
            map2.put(list2.getName(), list2);
        }
        Collection<LocalChangeListImpl> collection = map2.values();
        if (collection == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @NotNull
    private static Element writeChangeList(@NotNull LocalChangeList list2, boolean areChangeListsEnabled) {
        Object listData;
        if (list2 == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(5);
        }
        Element listNode = new Element(NODE_LIST);
        if (list2.isDefault()) {
            listNode.setAttribute(ATT_DEFAULT, ATT_VALUE_TRUE);
        }
        listNode.setAttribute(ATT_ID, list2.getId());
        listNode.setAttribute(ATT_NAME, list2.getName());
        String comment = list2.getComment();
        if (comment != null) {
            listNode.setAttribute(ATT_COMMENT, comment);
        }
        if ((listData = list2.getData()) instanceof ChangeListData) {
            listNode.addContent(ChangeListData.writeExternal((ChangeListData)listData));
        }
        Collection changes = list2.getChanges();
        if (areChangeListsEnabled || changes.size() < 100) {
            List sortedChanges = ContainerUtil.sorted((Collection)changes, (Comparator)new ChangeComparator());
            for (Change change : sortedChanges) {
                listNode.addContent(ChangeListManagerSerialization.writeChange(change));
            }
        }
        Element element2 = listNode;
        if (element2 == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(6);
        }
        return element2;
    }

    @NotNull
    private static LocalChangeListImpl readChangeList(@NotNull Element listNode, @NotNull Project project) {
        if (listNode == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(7);
        }
        if (project == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(8);
        }
        String id2 = listNode.getAttributeValue(ATT_ID);
        String name = StringUtil.notNullize((String)listNode.getAttributeValue(ATT_NAME), (String)LocalChangeList.getDefaultName());
        String comment = StringUtil.notNullize((String)listNode.getAttributeValue(ATT_COMMENT));
        ChangeListData data2 = ChangeListData.readExternal(listNode);
        boolean isDefault = ATT_VALUE_TRUE.equals(listNode.getAttributeValue(ATT_DEFAULT));
        ArrayList<Change> changes = new ArrayList<Change>();
        for (Element changeNode : listNode.getChildren(NODE_CHANGE)) {
            changes.add(ChangeListManagerSerialization.readChange(changeNode));
        }
        LocalChangeListImpl localChangeListImpl = new LocalChangeListImpl.Builder(project, name).setId(id2).setComment(comment).setChanges(changes).setData(data2).setDefault(isDefault).build();
        if (localChangeListImpl == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(9);
        }
        return localChangeListImpl;
    }

    @NotNull
    private static Element writeChange(@NotNull Change change) {
        if (change == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(10);
        }
        Element changeNode = new Element(NODE_CHANGE);
        ChangeListManagerSerialization.writeContentRevision(changeNode, change.getBeforeRevision(), RevisionSide.BEFORE);
        ChangeListManagerSerialization.writeContentRevision(changeNode, change.getAfterRevision(), RevisionSide.AFTER);
        Element element2 = changeNode;
        if (element2 == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(11);
        }
        return element2;
    }

    @NotNull
    private static Change readChange(@NotNull Element changeNode) {
        if (changeNode == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(12);
        }
        FakeRevision bRev = ChangeListManagerSerialization.readContentRevision(changeNode, RevisionSide.BEFORE);
        FakeRevision aRev = ChangeListManagerSerialization.readContentRevision(changeNode, RevisionSide.AFTER);
        return new Change((ContentRevision)bRev, (ContentRevision)aRev);
    }

    private static void writeContentRevision(@NotNull Element changeNode, @Nullable ContentRevision rev, @NotNull RevisionSide side) {
        if (changeNode == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(13);
        }
        if (side == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(14);
        }
        if (rev == null) {
            return;
        }
        FilePath filePath = rev.getFile();
        String path2 = filePath.getPath();
        if (ChangeListManagerSerialization.hasIllegalXmlChars(path2)) {
            changeNode.setAttribute(side.getPathKey(), JDOMUtil.removeControlChars((String)path2));
            changeNode.setAttribute(side.getEscapedPathKey(), XmlStringUtil.escapeIllegalXmlChars((String)path2));
        } else {
            changeNode.setAttribute(side.getPathKey(), path2);
        }
        changeNode.setAttribute(side.getIsDirKey(), String.valueOf(filePath.isDirectory()));
    }

    @Nullable
    private static FakeRevision readContentRevision(@NotNull Element changeNode, @NotNull RevisionSide side) {
        String path2;
        if (changeNode == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(15);
        }
        if (side == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(16);
        }
        String plainPath = changeNode.getAttributeValue(side.getPathKey());
        String escapedPath = changeNode.getAttributeValue(side.getEscapedPathKey());
        String string = path2 = escapedPath != null ? XmlStringUtil.unescapeIllegalXmlChars((String)escapedPath) : plainPath;
        if (StringUtil.isEmpty((String)path2)) {
            return null;
        }
        String value2 = changeNode.getAttributeValue(side.getIsDirKey());
        if (value2 != null) {
            boolean isDirectory = Boolean.parseBoolean(value2);
            return new FakeRevision(VcsUtil.getFilePath((String)path2, (boolean)isDirectory));
        }
        return new FakeRevision(VcsUtil.getFilePath((String)path2));
    }

    private static boolean hasIllegalXmlChars(@NotNull String text2) {
        if (text2 == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(17);
        }
        return text2.chars().anyMatch(c -> !Verifier.isXMLCharacter((int)c));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lists";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangeListManagerSerialization";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = NODE_LIST;
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listNode";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = NODE_CHANGE;
                break;
            }
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeNode";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeListManagerSerialization";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "removeDuplicatedLists";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "writeChangeList";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "readChangeList";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "writeChange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicatedLists";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeChangeList";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "readChangeList";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "writeChange";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "readChange";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "writeContentRevision";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "readContentRevision";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "hasIllegalXmlChars";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum RevisionSide {
        BEFORE("beforePath", "beforePathEscaped", "beforeDir"),
        AFTER("afterPath", "afterPathEscaped", "afterDir");

        @NotNull
        private final String myPathKey;
        @NotNull
        private final String myEscapedPathKey;
        @NotNull
        private final String myIsDirKey;

        private RevisionSide(@NotNull String pathKey, String escapedPathKey, String isDirKey) {
            if (pathKey == null) {
                RevisionSide.$$$reportNull$$$0(0);
            }
            if (escapedPathKey == null) {
                RevisionSide.$$$reportNull$$$0(1);
            }
            if (isDirKey == null) {
                RevisionSide.$$$reportNull$$$0(2);
            }
            this.myPathKey = pathKey;
            this.myEscapedPathKey = escapedPathKey;
            this.myIsDirKey = isDirKey;
        }

        @NotNull
        public String getPathKey() {
            String string = this.myPathKey;
            if (string == null) {
                RevisionSide.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        String getEscapedPathKey() {
            String string = this.myEscapedPathKey;
            if (string == null) {
                RevisionSide.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public String getIsDirKey() {
            String string = this.myIsDirKey;
            if (string == null) {
                RevisionSide.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pathKey";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "escapedPathKey";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "isDirKey";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangeListManagerSerialization$RevisionSide";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeListManagerSerialization$RevisionSide";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPathKey";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEscapedPathKey";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIsDirKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ChangeComparator
    implements Comparator<Change> {
        private ChangeComparator() {
        }

        @Override
        public int compare(Change o1, Change o2) {
            ContentRevision bRev2;
            ContentRevision bRev1 = o1.getBeforeRevision();
            int delta = ChangeComparator.compareRevisions(bRev1, bRev2 = o2.getBeforeRevision());
            if (delta != 0) {
                return delta;
            }
            ContentRevision aRev1 = o1.getAfterRevision();
            ContentRevision aRev2 = o2.getAfterRevision();
            return ChangeComparator.compareRevisions(aRev1, aRev2);
        }

        private static int compareRevisions(@Nullable ContentRevision bRev1, @Nullable ContentRevision bRev2) {
            if (bRev1 == null && bRev2 == null) {
                return 0;
            }
            if (bRev1 == null) {
                return -1;
            }
            if (bRev2 == null) {
                return 1;
            }
            String path1 = bRev1.getFile().getPath();
            String path2 = bRev2.getFile().getPath();
            return path1.compareTo(path2);
        }
    }
}

