/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.PreviewPanel;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.LineStatusMarkerDrawUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.TextAnnotationGutterProvider;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.markup.ActiveGutterRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.AnnotationsSettings;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.util.EventDispatcher;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class VcsPreviewPanel
implements PreviewPanel {
    private final EventDispatcher<ColorAndFontSettingsListener> myDispatcher = EventDispatcher.create(ColorAndFontSettingsListener.class);
    private final EditorEx myEditor;

    VcsPreviewPanel() {
        DocumentImpl document = new DocumentImpl("", true);
        this.myEditor = (EditorEx)EditorFactory.getInstance().createViewer((Document)document);
        this.myEditor.getGutterComponentEx().setForceShowRightFreePaintersArea(true);
        this.myEditor.getSettings().setFoldingOutlineShown(true);
    }

    @Override
    public void disposeUIResources() {
        EditorFactory.getInstance().releaseEditor((Editor)this.myEditor);
    }

    @Override
    public JComponent getPanel() {
        return this.myEditor.getComponent();
    }

    @Override
    public void blinkSelectedHighlightType(Object selected2) {
    }

    @Override
    public void updateView() {
        EditorColorsScheme colorsScheme = this.myEditor.getColorsScheme();
        StringBuilder sb = new StringBuilder();
        String nn = "\n\n";
        String n = "\n";
        sb.append(VcsBundle.message((String)"vcs.preview.panel.deleted.line.below", (Object[])new Object[0])).append(nn).append(VcsBundle.message((String)"vcs.preview.panel.modified.line", (Object[])new Object[0])).append(nn).append(VcsBundle.message((String)"vcs.preview.panel.added.line", (Object[])new Object[0])).append(nn).append(VcsBundle.message((String)"vcs.preview.panel.line.with.modified.whitespaces", (Object[])new Object[0])).append(nn).append(VcsBundle.message((String)"vcs.preview.panel.added.line", (Object[])new Object[0])).append(n).append(VcsBundle.message((String)"vcs.preview.panel.line.with.modified.whitespaces.and.deletion.after", (Object[])new Object[0])).append(nn).append(VcsBundle.message((String)"vcs.preview.panel.deleted.ignored.line.below", (Object[])new Object[0])).append(nn).append(VcsBundle.message((String)"vcs.preview.panel.modified.ignored.line", (Object[])new Object[0])).append(nn).append(VcsBundle.message((String)"vcs.preview.panel.added.ignored.line", (Object[])new Object[0])).append(nn);
        int additionalLines = Math.max(0, AnnotationsSettings.getInstance().getOrderedColors(colorsScheme).size() - StringUtil.countNewLines((CharSequence)sb));
        sb.append(StringUtil.repeat((String)n, (int)additionalLines));
        this.myEditor.getDocument().setText(sb);
        this.myEditor.getMarkupModel().removeAllHighlighters();
        this.myEditor.getGutterComponentEx().closeAllAnnotations();
        this.addHighlighter(new Range(1, 1, 0, 1), false, EditorColors.DELETED_LINES_COLOR);
        this.addHighlighter(VcsPreviewPanel.createModifiedRange(2, 1), false, EditorColors.MODIFIED_LINES_COLOR);
        this.addHighlighter(VcsPreviewPanel.createModifiedRange(4, 2), false, EditorColors.ADDED_LINES_COLOR);
        this.addHighlighter(VcsPreviewPanel.createModifiedRange(6, 0), false, EditorColors.WHITESPACES_MODIFIED_LINES_COLOR);
        this.addHighlighter(VcsPreviewPanel.createModifiedRange(8, 2, 0, 3), false, EditorColors.WHITESPACES_MODIFIED_LINES_COLOR);
        this.addHighlighter(new Range(12, 12, 0, 1), true, EditorColors.IGNORED_DELETED_LINES_BORDER_COLOR);
        this.addHighlighter(VcsPreviewPanel.createModifiedRange(13, 1), true, EditorColors.IGNORED_MODIFIED_LINES_BORDER_COLOR);
        this.addHighlighter(new Range(15, 16, 0, 0), true, EditorColors.IGNORED_ADDED_LINES_BORDER_COLOR);
        List<Color> annotationColors = AnnotationsSettings.getInstance().getOrderedColors(colorsScheme);
        List<Integer> anchorIndexes = AnnotationsSettings.getInstance().getAnchorIndexes(colorsScheme);
        this.myEditor.getGutterComponentEx().registerTextAnnotation(new MyTextAnnotationGutterProvider(annotationColors, anchorIndexes));
    }

    @NotNull
    private static Range createModifiedRange(int currentLine, byte ... inner) {
        ArrayList<Range.InnerRange> innerRanges = new ArrayList<Range.InnerRange>();
        int currentInnerLine = 0;
        block4: for (byte type : inner) {
            switch (type) {
                case 0: 
                case 1: 
                case 2: {
                    innerRanges.add(new Range.InnerRange(currentInnerLine, currentInnerLine + 1, type));
                    ++currentInnerLine;
                    continue block4;
                }
                case 3: {
                    innerRanges.add(new Range.InnerRange(currentInnerLine, currentInnerLine, type));
                }
            }
        }
        return new Range(currentLine, currentLine + currentInnerLine, 0, 1, innerRanges);
    }

    private void addHighlighter(final @NotNull Range range2, final boolean isIgnored, final @NotNull ColorKey colorKey) {
        if (range2 == null) {
            VcsPreviewPanel.$$$reportNull$$$0(0);
        }
        if (colorKey == null) {
            VcsPreviewPanel.$$$reportNull$$$0(1);
        }
        TextRange textRange = DiffUtil.getLinesRange(this.myEditor.getDocument(), range2.getLine1(), range2.getLine2(), false);
        LineStatusMarkerDrawUtil.DiffStripeTextAttributes textAttributes = new LineStatusMarkerDrawUtil.DiffStripeTextAttributes(range2.getType());
        RangeHighlighter highlighter = this.myEditor.getMarkupModel().addRangeHighlighter(textRange.getStartOffset(), textRange.getEndOffset(), 5999, textAttributes, HighlighterTargetArea.LINES_IN_RANGE);
        highlighter.setThinErrorStripeMark(true);
        highlighter.setLineMarkerRenderer((LineMarkerRenderer)new ActiveGutterRenderer(){

            public void paint(@NotNull Editor editor, @NotNull Graphics g, @NotNull Rectangle r) {
                if (editor == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (g == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (r == null) {
                    1.$$$reportNull$$$0(2);
                }
                LineStatusMarkerDrawUtil.paintRange(g, VcsPreviewPanel.this.myEditor, range2, 0, isIgnored);
            }

            public boolean canDoAction(@NotNull MouseEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(3);
                }
                return LineStatusMarkerDrawUtil.isInsideMarkerArea(e);
            }

            public void doAction(@NotNull Editor editor, @NotNull MouseEvent e) {
                if (editor == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (e == null) {
                    1.$$$reportNull$$$0(5);
                }
                ((ColorAndFontSettingsListener)VcsPreviewPanel.this.myDispatcher.getMulticaster()).selectionInPreviewChanged(colorKey.getExternalName());
            }

            @NotNull
            public String getAccessibleName() {
                String string = DiffBundle.message((String)"vcs.marker.changed.line", (Object[])new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(6);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 6: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 6: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "g";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "r";
                        break;
                    }
                    case 3: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/vcs/actions/VcsPreviewPanel$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/vcs/actions/VcsPreviewPanel$1";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAccessibleName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "paint";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "canDoAction";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "doAction";
                        break;
                    }
                    case 6: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 6: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    @Override
    public void addListener(@NotNull ColorAndFontSettingsListener listener2) {
        if (listener2 == null) {
            VcsPreviewPanel.$$$reportNull$$$0(2);
        }
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public void setColorScheme(EditorColorsScheme highlighterSettings) {
        this.myEditor.setColorsScheme(highlighterSettings);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorKey";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/actions/VcsPreviewPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addHighlighter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyTextAnnotationGutterProvider
    implements TextAnnotationGutterProvider {
        @NotNull
        private final List<? extends Color> myBackgroundColors;
        @NotNull
        private final List<Integer> myAnchorIndexes;

        MyTextAnnotationGutterProvider(@NotNull List<? extends Color> backgroundColors, @NotNull List<Integer> anchorIndexes) {
            if (backgroundColors == null) {
                MyTextAnnotationGutterProvider.$$$reportNull$$$0(0);
            }
            if (anchorIndexes == null) {
                MyTextAnnotationGutterProvider.$$$reportNull$$$0(1);
            }
            this.myBackgroundColors = backgroundColors;
            this.myAnchorIndexes = anchorIndexes;
        }

        @Nullable
        public String getLineText(int line, Editor editor) {
            if (line < this.myBackgroundColors.size()) {
                int anchorIndex = this.myAnchorIndexes.indexOf(line);
                Object text2 = VcsBundle.message((String)"annotation.background", (Object[])new Object[0]);
                if (anchorIndex != -1) {
                    text2 = (String)text2 + " #" + (anchorIndex + 1);
                }
                return text2;
            }
            return null;
        }

        @Nullable
        public String getToolTip(int line, Editor editor) {
            return null;
        }

        public EditorFontType getStyle(int line, Editor editor) {
            return null;
        }

        @Nullable
        public ColorKey getColor(int line, Editor editor) {
            return EditorColors.ANNOTATIONS_COLOR;
        }

        @Nullable
        public Color getBgColor(int line, Editor editor) {
            if (line < this.myBackgroundColors.size()) {
                return this.myBackgroundColors.get(line);
            }
            return null;
        }

        public List<AnAction> getPopupActions(int line, Editor editor) {
            return Collections.emptyList();
        }

        public void gutterClosed() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "backgroundColors";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "anchorIndexes";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/actions/VcsPreviewPanel$MyTextAnnotationGutterProvider";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

