/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.AnnotationFieldGutter;
import com.intellij.openapi.vcs.actions.ShowAnnotationColorsAction;
import com.intellij.openapi.vcs.actions.ShowHideAspectAction;
import com.intellij.openapi.vcs.actions.ShowShortenNames;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotateActionGroup
extends ActionGroup
implements DumbAware {
    private final AnAction[] myActions;

    public AnnotateActionGroup(@NotNull List<AnnotationFieldGutter> gutters, @Nullable Couple<Map<VcsRevisionNumber, Color>> bgColorMap) {
        if (gutters == null) {
            AnnotateActionGroup.$$$reportNull$$$0(0);
        }
        super(VcsBundle.message((String)"annotate.action.view.group.text", (Object[])new Object[0]), true);
        ArrayList<DumbAware> actions2 = new ArrayList<DumbAware>();
        for (AnnotationFieldGutter g : gutters) {
            if (g.getID() == null || g.getDisplayName() == null) continue;
            actions2.add(new ShowHideAspectAction(g));
        }
        actions2.add((DumbAware)Separator.getInstance());
        if (bgColorMap != null) {
            actions2.add(new ShowAnnotationColorsAction());
        }
        actions2.add(new ShowShortenNames());
        this.myActions = actions2.toArray(AnAction.EMPTY_ARRAY);
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        if (this.myActions == null) {
            AnnotateActionGroup.$$$reportNull$$$0(1);
        }
        return this.myActions;
    }

    static void revalidateMarkupInAllEditors() {
        for (Editor editor : EditorFactory.getInstance().getAllEditors()) {
            if (!(editor.getGutter() instanceof EditorGutterComponentEx)) continue;
            ((EditorGutterComponentEx)editor.getGutter()).revalidateMarkup();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gutters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/actions/AnnotateActionGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/actions/AnnotateActionGroup";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

