/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.completion.PlainTextSymbolCompletionContributor;
import com.intellij.codeInsight.completion.PlainTextSymbolCompletionContributorEP;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import java.util.Iterator;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class ChangedFilesCommitCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet result2) {
        PsiFile file2;
        Project project;
        Document document;
        if (parameters2 == null) {
            ChangedFilesCommitCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            ChangedFilesCommitCompletionContributor.$$$reportNull$$$0(1);
        }
        if ((document = PsiDocumentManager.getInstance((Project)(project = (file2 = parameters2.getOriginalFile()).getProject())).getDocument(file2)) == null) {
            return;
        }
        Supplier changesSupplier = (Supplier)document.getUserData(CommitMessage.CHANGES_SUPPLIER_KEY);
        if (changesSupplier == null) {
            return;
        }
        result2.stopHere();
        int count = parameters2.getInvocationCount();
        Iterator changeIterator = ((Iterable)changesSupplier.get()).iterator();
        if (!changeIterator.hasNext()) {
            return;
        }
        String prefix2 = TextFieldWithAutoCompletionListProvider.getCompletionPrefix(parameters2);
        if (count == 0 && prefix2.length() < 5) {
            result2.restartCompletionOnPrefixChange((ElementPattern)StandardPatterns.string().withLength(5));
            return;
        }
        CompletionResultSet resultSet = result2.caseInsensitive().withPrefixMatcher((PrefixMatcher)(count == 0 ? new PlainPrefixMatcher(prefix2, true) : new CamelHumpMatcher(prefix2)));
        CompletionResultSet prefixed = result2.withPrefixMatcher((PrefixMatcher)new PlainPrefixMatcher(prefix2, count == 0));
        while (changeIterator.hasNext()) {
            ProgressManager.checkCanceled();
            Change change = (Change)changeIterator.next();
            FilePath beforePath = ChangesUtil.getBeforePath((Change)change);
            FilePath afterPath = ChangesUtil.getAfterPath((Change)change);
            if (afterPath != null) {
                ChangedFilesCommitCompletionContributor.addFilePathName(resultSet, afterPath, false);
                ChangedFilesCommitCompletionContributor.addLanguageSpecificElements(project, count, prefixed, afterPath);
            }
            if (beforePath == null || afterPath != null && beforePath.getName().equals(afterPath.getName())) continue;
            ChangedFilesCommitCompletionContributor.addFilePathName(resultSet, beforePath, true);
        }
    }

    private static void addFilePathName(CompletionResultSet resultSet, FilePath filePath, boolean strikeout) {
        resultSet.addElement((LookupElement)LookupElementBuilder.create((String)filePath.getName()).withIcon(filePath.getFileType().getIcon()).withStrikeoutness(strikeout));
    }

    private static void addLanguageSpecificElements(Project project, int count, CompletionResultSet prefixed, FilePath filePath) {
        VirtualFile vFile = filePath.getVirtualFile();
        if (vFile == null) {
            return;
        }
        PsiFile psiFile = PsiManagerEx.getInstanceEx(project).findFile(vFile);
        if (psiFile == null) {
            return;
        }
        PlainTextSymbolCompletionContributor contributor = PlainTextSymbolCompletionContributorEP.forLanguage((Language)psiFile.getLanguage());
        if (contributor == null) {
            return;
        }
        prefixed.addAllElements((Iterable)contributor.getLookupElements(psiFile, count, prefixed.getPrefixMatcher().getPrefix()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/vcs/ChangedFilesCommitCompletionContributor";
        objectArray[2] = "fillCompletionVariants";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

