/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl.pluginsAdvertisement;

import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.advertiser.PluginData;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.FUSEventSource;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginAdvertiserExtensionsData;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginAdvertiserExtensionsStateService;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PluginAdvertiserEditorNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel>
implements DumbAware {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"file.type.associations.detected");
    private static final Logger LOG = Logger.getInstance(PluginsAdvertiser.class);

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            PluginAdvertiserEditorNotificationProvider.$$$reportNull$$$0(0);
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor, @NotNull Project project) {
        if (file2 == null) {
            PluginAdvertiserEditorNotificationProvider.$$$reportNull$$$0(1);
        }
        if (fileEditor == null) {
            PluginAdvertiserEditorNotificationProvider.$$$reportNull$$$0(2);
        }
        if (project == null) {
            PluginAdvertiserEditorNotificationProvider.$$$reportNull$$$0(3);
        }
        PluginAdvertiserExtensionsStateService extensionsStateService = PluginAdvertiserExtensionsStateService.getInstance();
        PluginAdvertiserExtensionsStateService.ExtensionDataProvider pluginAdvertiserExtensionsState = extensionsStateService.createExtensionDataProvider(project);
        PluginAdvertiserExtensionsData extensionsData = pluginAdvertiserExtensionsState.requestExtensionData(file2);
        Set<String> jbPluginsIds = MarketplaceRequests.getInstance().getJetBrainsPluginsIds();
        if (extensionsData == null || jbPluginsIds == null) {
            ProcessIOExecutorService.INSTANCE.execute(() -> {
                MarketplaceRequests.getInstance().loadJetBrainsPluginsIds();
                boolean shouldUpdateNotifications = extensionsStateService.updateCache(file2.getName());
                String fullExtension = PluginAdvertiserExtensionsStateService.getFullExtension(file2);
                if (fullExtension != null) {
                    boolean bl = shouldUpdateNotifications = extensionsStateService.updateCache(fullExtension) || shouldUpdateNotifications;
                }
                if (shouldUpdateNotifications) {
                    ApplicationManager.getApplication().invokeLater(() -> EditorNotifications.getInstance((Project)project).updateNotifications(file2), project.getDisposed());
                }
                LOG.debug(String.format("Tried to update extensions cache for file '%s'. shouldUpdateNotifications=%s", file2.getName(), shouldUpdateNotifications));
            });
            return null;
        }
        String extensionOrFileName = extensionsData.getExtensionOrFileName();
        Set<PluginData> dataSet = extensionsData.getPlugins();
        EditorNotificationPanel panel2 = new EditorNotificationPanel(fileEditor);
        panel2.setText(IdeBundle.message((String)"plugins.advertiser.plugins.found", (Object[])new Object[]{extensionOrFileName}));
        Runnable onPluginsInstalled = () -> {
            pluginAdvertiserExtensionsState.addEnabledExtensionOrFileNameAndInvalidateCache(extensionOrFileName);
            PluginAdvertiserEditorNotificationProvider.updateAllNotifications(project);
        };
        PluginsToInstall pluginsToInstall = new PluginsToInstall(dataSet, jbPluginsIds);
        IdeaPluginDescriptor disabledPlugin = pluginsToInstall.myDisabledPlugin;
        if (disabledPlugin != null) {
            panel2.createActionLabel(IdeBundle.message((String)"plugins.advertiser.action.enable.plugin", (Object[])new Object[]{disabledPlugin.getName()}), () -> {
                pluginAdvertiserExtensionsState.addEnabledExtensionOrFileNameAndInvalidateCache(extensionOrFileName);
                PluginAdvertiserEditorNotificationProvider.updateAllNotifications(project);
                FUSEventSource.EDITOR.logEnablePlugins(List.of(disabledPlugin.getPluginId().getIdString()), project);
                PluginManagerConfigurable.showPluginConfigurableAndEnable(project, Set.of(disabledPlugin));
            });
        } else if (!pluginsToInstall.myJbProduced.isEmpty()) {
            PluginAdvertiserEditorNotificationProvider.createInstallActionLabel(panel2, pluginsToInstall.myJbProduced, onPluginsInstalled);
        } else if (!PluginsAdvertiser.getBundledPluginToInstall(dataSet).isEmpty()) {
            if (PluginsAdvertiser.isIgnoreUltimate()) {
                return null;
            }
            panel2.setText(IdeBundle.message((String)"plugins.advertiser.extensions.supported.in.ultimate", (Object[])new Object[]{extensionOrFileName}));
            panel2.createActionLabel(IdeBundle.message((String)"plugins.advertiser.action.try.ultimate", (Object[])new Object[0]), () -> {
                pluginAdvertiserExtensionsState.addEnabledExtensionOrFileNameAndInvalidateCache(extensionOrFileName);
                FUSEventSource.EDITOR.openDownloadPageAndLog(project);
            });
            panel2.createActionLabel(IdeBundle.message((String)"plugins.advertiser.action.ignore.ultimate", (Object[])new Object[0]), () -> {
                FUSEventSource.EDITOR.doIgnoreUltimateAndLog(project);
                PluginAdvertiserEditorNotificationProvider.updateAllNotifications(project);
            });
        } else if (!pluginsToInstall.myThirdParty.isEmpty()) {
            PluginAdvertiserEditorNotificationProvider.createInstallActionLabel(panel2, pluginsToInstall.myThirdParty, onPluginsInstalled);
        } else {
            return null;
        }
        panel2.createActionLabel(IdeBundle.message((String)"plugins.advertiser.action.ignore.extension", (Object[])new Object[0]), () -> {
            FUSEventSource.EDITOR.logIgnoreExtension(project);
            pluginAdvertiserExtensionsState.ignoreExtensionOrFileNameAndInvalidateCache(extensionOrFileName);
            PluginAdvertiserEditorNotificationProvider.updateAllNotifications(project);
        });
        return panel2;
    }

    private static void createInstallActionLabel(@NotNull EditorNotificationPanel panel2, @NotNull Set<PluginData> dataSet, @NotNull Runnable onSuccess2) {
        if (panel2 == null) {
            PluginAdvertiserEditorNotificationProvider.$$$reportNull$$$0(4);
        }
        if (dataSet == null) {
            PluginAdvertiserEditorNotificationProvider.$$$reportNull$$$0(5);
        }
        if (onSuccess2 == null) {
            PluginAdvertiserEditorNotificationProvider.$$$reportNull$$$0(6);
        }
        Set pluginIds2 = ContainerUtil.map2Set(dataSet, PluginData::getPluginId);
        panel2.createActionLabel(IdeBundle.message((String)"plugins.advertiser.action.install.plugins", (Object[])new Object[0]), () -> {
            FUSEventSource.EDITOR.logInstallPlugins(ContainerUtil.map((Collection)pluginIds2, PluginId::getIdString));
            PluginsAdvertiser.installAndEnable(pluginIds2, onSuccess2);
        });
    }

    private static void updateAllNotifications(@NotNull Project project) {
        if (project == null) {
            PluginAdvertiserEditorNotificationProvider.$$$reportNull$$$0(7);
        }
        EditorNotifications.getInstance((Project)project).updateAllNotifications();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginAdvertiserEditorNotificationProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSet";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onSuccess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginAdvertiserEditorNotificationProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createInstallActionLabel";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateAllNotifications";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PluginsToInstall {
        private IdeaPluginDescriptor myDisabledPlugin;
        private final Set<PluginData> myJbProduced;
        private final Set<PluginData> myThirdParty;

        private PluginsToInstall(@NotNull Set<PluginData> dataSet, @NotNull Set<String> jbPluginsIds) {
            if (dataSet == null) {
                PluginsToInstall.$$$reportNull$$$0(0);
            }
            if (jbPluginsIds == null) {
                PluginsToInstall.$$$reportNull$$$0(1);
            }
            this.myDisabledPlugin = null;
            this.myJbProduced = new HashSet<PluginData>();
            this.myThirdParty = new HashSet<PluginData>();
            Map<PluginId, IdeaPluginDescriptorImpl> descriptorsById = PluginManagerCore.buildPluginIdMap();
            for (PluginData data2 : dataSet) {
                IdeaPluginDescriptor installedPlugin = descriptorsById.get(data2.getPluginId());
                if (installedPlugin != null) {
                    if (installedPlugin.isEnabled() || this.myDisabledPlugin != null) continue;
                    this.myDisabledPlugin = installedPlugin;
                    continue;
                }
                if (data2.isBundled()) continue;
                this.myThirdParty.add(data2);
                if (!jbPluginsIds.contains(data2.getPluginIdString())) continue;
                this.myJbProduced.add(data2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dataSet";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "jbPluginsIds";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginAdvertiserEditorNotificationProvider$PluginsToInstall";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

