/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.WhatsNewAction;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ConfigImportHelper;
import com.intellij.openapi.application.OldDirectoryCleaner;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.updateSettings.UpdateStrategyCustomization;
import com.intellij.openapi.updateSettings.impl.BuildInfo;
import com.intellij.openapi.updateSettings.impl.ChannelStatus;
import com.intellij.openapi.updateSettings.impl.ExternalUpdateManager;
import com.intellij.openapi.updateSettings.impl.IdeUpdateUsageTriggerCollector;
import com.intellij.openapi.updateSettings.impl.Product;
import com.intellij.openapi.updateSettings.impl.UpdateChannel;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateInstaller;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.text.DateFormatUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class UpdateCheckerService {
    static final String SELF_UPDATE_STARTED_FOR_BUILD_PROPERTY = "ide.self.update.started.for.build";
    private static final Logger LOG = Logger.getInstance(UpdateCheckerService.class);
    private static final long CHECK_INTERVAL = 86400000L;
    private static final String ERROR_LOG_FILE_NAME = "idea_updater_error.log";
    private static final String PREVIOUS_BUILD_NUMBER_PROPERTY = "ide.updates.previous.build.number";
    private static final String WHATS_NEW_SHOWN_FOR_PROPERTY = "ide.updates.whats.new.shown.for";
    private static final String OLD_DIRECTORIES_SCAN_SCHEDULED = "ide.updates.old.dirs.scan.scheduled";
    private static final int OLD_DIRECTORIES_SCAN_DELAY_DAYS = 7;
    private static final int OLD_DIRECTORIES_SHELF_LIFE_DAYS = 180;
    private volatile ScheduledFuture<?> myScheduledCheck;

    UpdateCheckerService() {
    }

    public static UpdateCheckerService getInstance() {
        return (UpdateCheckerService)ApplicationManager.getApplication().getService(UpdateCheckerService.class);
    }

    public void queueNextCheck() {
        this.queueNextCheck(86400000L);
    }

    public void cancelChecks() {
        ScheduledFuture<?> future2 = this.myScheduledCheck;
        if (future2 != null) {
            future2.cancel(false);
        }
    }

    private void appStarted() {
        UpdateSettings settings2 = UpdateSettings.getInstance();
        UpdateCheckerService.updateDefaultChannel(settings2);
        if (settings2.isCheckNeeded() || settings2.isPluginsCheckNeeded()) {
            this.scheduleFirstCheck(settings2);
        }
    }

    private static void updateDefaultChannel(UpdateSettings settings2) {
        ChannelStatus current2 = settings2.getSelectedChannelStatus();
        LOG.info("channel: " + current2.getCode());
        boolean eap = ApplicationInfoEx.getInstanceEx().isMajorEAP();
        if (eap && current2 != ChannelStatus.EAP && UpdateStrategyCustomization.getInstance().forceEapUpdateChannelForEapBuilds()) {
            settings2.setSelectedChannelStatus(ChannelStatus.EAP);
            LOG.info("channel forced to 'eap'");
            if (!ConfigImportHelper.isFirstSession()) {
                String title2 = IdeBundle.message((String)"updates.notification.title", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
                String message2 = IdeBundle.message((String)"update.channel.enforced", (Object[])new Object[]{ChannelStatus.EAP});
                UpdateChecker.getNotificationGroup().createNotification(title2, message2, NotificationType.INFORMATION).setDisplayId("ide.update.channel.switched").notify(null);
            }
        }
        if (!eap && current2 == ChannelStatus.EAP && ConfigImportHelper.isConfigImported()) {
            settings2.setSelectedChannelStatus(ChannelStatus.RELEASE);
            LOG.info("channel set to 'release'");
        }
    }

    private void scheduleFirstCheck(UpdateSettings settings2) {
        BuildNumber currentBuild = ApplicationInfo.getInstance().getBuild();
        BuildNumber lastBuildChecked = BuildNumber.fromString((String)settings2.getLastBuildChecked());
        long timeSinceLastCheck = Math.max(System.currentTimeMillis() - settings2.getLastTimeChecked(), 0L);
        if (lastBuildChecked == null || currentBuild.compareTo(lastBuildChecked) > 0 || timeSinceLastCheck >= 86400000L) {
            this.checkUpdates();
        } else {
            this.queueNextCheck(86400000L - timeSinceLastCheck);
        }
    }

    private void queueNextCheck(long delay) {
        this.myScheduledCheck = AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> this.checkUpdates(), delay, TimeUnit.MILLISECONDS);
    }

    private void checkUpdates() {
        UpdateSettings settings2 = UpdateSettings.getInstance();
        if (settings2.isCheckNeeded() || settings2.isPluginsCheckNeeded()) {
            UpdateChecker.updateAndShowResult().doWhenProcessed(() -> this.queueNextCheck());
        }
    }

    private static void checkIfPreviousUpdateFailed() {
        PropertiesComponent properties = PropertiesComponent.getInstance();
        if (ApplicationInfo.getInstance().getBuild().asString().equals(properties.getValue(SELF_UPDATE_STARTED_FOR_BUILD_PROPERTY)) && new File(PathManager.getLogPath(), ERROR_LOG_FILE_NAME).length() > 0L) {
            IdeUpdateUsageTriggerCollector.trigger("update.failed");
            LOG.info("The previous IDE update failed");
        }
        properties.unsetValue(SELF_UPDATE_STARTED_FOR_BUILD_PROPERTY);
    }

    private static void showWhatsNew(Project project, @Nullable BuildNumber previous, BuildNumber current2) {
        if (!WhatsNewAction.isAvailable() || !UpdateSettings.getInstance().isShowWhatsNewEditor()) {
            return;
        }
        if (previous == null || previous.getBaselineVersion() > current2.getBaselineVersion()) {
            return;
        }
        if (ApplicationInfoEx.getInstanceEx().isMajorEAP()) {
            return;
        }
        int shownFor = PropertiesComponent.getInstance().getInt(WHATS_NEW_SHOWN_FOR_PROPERTY, 0);
        if (shownFor == current2.getBaselineVersion()) {
            return;
        }
        String url = ApplicationInfoEx.getInstanceEx().getWhatsNewUrl();
        if (url == null) {
            return;
        }
        Product product = UpdateCheckerService.loadProductData();
        if (product == null) {
            return;
        }
        int lastRelease = 0;
        String announce = null;
        String releaseVersion = ApplicationInfo.getInstance().getShortVersion();
        for (UpdateChannel updateChannel : product.getChannels()) {
            if (updateChannel.getLicensing() != UpdateChannel.Licensing.RELEASE || updateChannel.getStatus() != ChannelStatus.RELEASE) continue;
            for (BuildInfo buildInfo : updateChannel.getBuilds()) {
                lastRelease = Math.max(lastRelease, buildInfo.getNumber().getBaselineVersion());
                announce = releaseVersion.equals(buildInfo.getVersion()) && announce == null ? buildInfo.getMessage() : announce;
            }
        }
        if (lastRelease < current2.getBaselineVersion()) {
            return;
        }
        if (lastRelease > current2.getBaselineVersion()) {
            url = null;
        }
        PropertiesComponent.getInstance().setValue(WHATS_NEW_SHOWN_FOR_PROPERTY, current2.getBaselineVersion(), 0);
        if (url != null || announce != null) {
            String _url = url;
            String _announce = announce;
            ApplicationManager.getApplication().invokeLater(() -> WhatsNewAction.openWhatsNewFile(project, _url, _announce));
            IdeUpdateUsageTriggerCollector.trigger("update.whats.new");
        } else {
            LOG.info("neither URL nor message available for " + current2);
        }
    }

    private static void showSnapUpdateNotification(Project project, @Nullable BuildNumber previous, BuildNumber current2) {
        if (ExternalUpdateManager.ACTUAL != ExternalUpdateManager.SNAP || previous == null || current2.equals((Object)previous)) {
            return;
        }
        String blogPost = null;
        Product product = UpdateCheckerService.loadProductData();
        if (product != null) {
            blogPost = product.getChannels().stream().flatMap(channel2 -> channel2.getBuilds().stream()).filter(build2 -> current2.equals((Object)build2.getNumber())).findFirst().map(BuildInfo::getBlogPost).orElse(null);
        }
        String title2 = IdeBundle.message((String)"updates.notification.title", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
        String message2 = blogPost == null ? IdeBundle.message((String)"update.snap.message", (Object[])new Object[0]) : IdeBundle.message((String)"update.snap.message.with.blog.post", (Object[])new Object[]{StringUtil.escapeXmlEntities((String)blogPost)});
        UpdateChecker.getNotificationGroup().createNotification(title2, message2, NotificationType.INFORMATION).setListener(NotificationListener.URL_OPENING_LISTENER).setDisplayId("ide.updated.by.snap").notify(project);
    }

    @Nullable
    private static Product loadProductData() {
        try {
            return UpdateChecker.loadProductData(null);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private static void showUpdatedPluginsNotification(Project project) {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

            @Override
            public void appWillBeClosed(boolean isRestart) {
                Collection<PluginId> plugins2 = InstalledPluginsState.getInstance().getUpdatedPlugins();
                if (plugins2.isEmpty()) {
                    return;
                }
                Set<String> idStrings = UpdateCheckerService.getUpdatedPlugins();
                for (PluginId plugin2 : plugins2) {
                    idStrings.add(plugin2.getIdString());
                }
                try {
                    Files.write(UpdateCheckerService.getUpdatedPluginsFile(), idStrings, new OpenOption[0]);
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                }
            }
        });
        ArrayList<HtmlChunk.Element> links = new ArrayList<HtmlChunk.Element>();
        for (String id2 : UpdateCheckerService.getUpdatedPlugins()) {
            IdeaPluginDescriptor descriptor2;
            PluginId pluginId = PluginId.findId((String)id2);
            if (pluginId == null || (descriptor2 = PluginManagerCore.getPlugin(pluginId)) == null) continue;
            links.add(HtmlChunk.link((String)id2, (String)descriptor2.getName()));
        }
        if (links.isEmpty()) {
            return;
        }
        String title2 = IdeBundle.message((String)"update.installed.notification.title", (Object[])new Object[0]);
        String text2 = new HtmlBuilder().appendWithSeparators(HtmlChunk.text((String)", "), links).wrapWith("html").toString();
        UpdateChecker.getNotificationGroupForUpdateResults().createNotification(title2, text2, NotificationType.INFORMATION).setListener((__, e) -> UpdateCheckerService.showPluginConfigurable(e, project)).setDisplayId("plugins.updated.after.restart").notify(project);
    }

    private static void showPluginConfigurable(HyperlinkEvent event, Project project) {
        PluginId pluginId;
        String id2 = event.getDescription();
        if (id2 != null && (pluginId = PluginId.findId((String)id2)) != null) {
            PluginManagerConfigurable.showPluginConfigurable(project, List.of(pluginId));
        }
    }

    private static Set<String> getUpdatedPlugins() {
        try {
            Path file2 = UpdateCheckerService.getUpdatedPluginsFile();
            if (Files.isRegularFile(file2, new LinkOption[0])) {
                List<String> list2 = Files.readAllLines(file2);
                Files.delete(file2);
                return new HashSet<String>(list2);
            }
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
        return new HashSet<String>();
    }

    private static Path getUpdatedPluginsFile() {
        return Path.of(PathManager.getConfigPath(), ".updated_plugins_list");
    }

    private static void deleteOldApplicationDirectories() {
        if (ConfigImportHelper.isConfigImported()) {
            long scheduledAt = System.currentTimeMillis() + TimeUnit.DAYS.toMillis(7L);
            LOG.info("scheduling old directories scan after " + DateFormatUtil.formatDateTime((long)scheduledAt));
            PropertiesComponent.getInstance().setValue(OLD_DIRECTORIES_SCAN_SCHEDULED, Long.toString(scheduledAt));
            OldDirectoryCleaner.Stats.scheduled();
        } else {
            long now;
            long scheduledAt = PropertiesComponent.getInstance().getLong(OLD_DIRECTORIES_SCAN_SCHEDULED, 0L);
            if (scheduledAt != 0L && (now = System.currentTimeMillis()) >= scheduledAt) {
                OldDirectoryCleaner.Stats.started((int)TimeUnit.MILLISECONDS.toDays(now - scheduledAt) + 7);
                LOG.info("starting old directories scan");
                long expireAfter = now - TimeUnit.DAYS.toMillis(180L);
                ProcessIOExecutorService.INSTANCE.execute(() -> new OldDirectoryCleaner(expireAfter).seekAndDestroy(null, null));
                PropertiesComponent.getInstance().unsetValue(OLD_DIRECTORIES_SCAN_SCHEDULED);
                LOG.info("old directories scan complete");
            }
        }
    }

    static final class MyActivity
    implements StartupActivity.DumbAware {
        private static final AtomicBoolean ourStarted = new AtomicBoolean(false);

        MyActivity() {
            Application app = ApplicationManager.getApplication();
            if (app.isCommandLine() || app.isHeadlessEnvironment() || app.isUnitTestMode()) {
                throw ExtensionNotApplicableException.INSTANCE;
            }
        }

        public void runActivity(@NotNull Project project) {
            if (project == null) {
                MyActivity.$$$reportNull$$$0(0);
            }
            if (ourStarted.getAndSet(true)) {
                return;
            }
            UpdateCheckerService.checkIfPreviousUpdateFailed();
            PropertiesComponent properties = PropertiesComponent.getInstance();
            BuildNumber previous = BuildNumber.fromString((String)properties.getValue(UpdateCheckerService.PREVIOUS_BUILD_NUMBER_PROPERTY));
            BuildNumber current2 = ApplicationInfo.getInstance().getBuild();
            properties.setValue(UpdateCheckerService.PREVIOUS_BUILD_NUMBER_PROPERTY, current2.asString());
            UpdateCheckerService.showWhatsNew(project, previous, current2);
            UpdateCheckerService.showSnapUpdateNotification(project, previous, current2);
            UpdateCheckerService.showUpdatedPluginsNotification(project);
            ProcessIOExecutorService.INSTANCE.execute(() -> UpdateInstaller.cleanupPatch());
            UpdateCheckerService.deleteOldApplicationDirectories();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/updateSettings/impl/UpdateCheckerService$MyActivity", "runActivity"));
        }
    }

    static final class MyAppLifecycleListener
    implements AppLifecycleListener {
        MyAppLifecycleListener() {
        }

        @Override
        public void appStarted() {
            Application app = ApplicationManager.getApplication();
            if (!(app.isCommandLine() || app.isHeadlessEnvironment() || app.isUnitTestMode())) {
                UpdateCheckerService.getInstance().appStarted();
            }
        }
    }
}

