/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.projectRoots.impl.JavaHomeFinderBasic;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JavaHomeFinderMac
extends JavaHomeFinderBasic {
    public static final String JAVA_HOME_FIND_UTIL = "/usr/libexec/java_home";
    static String defaultJavaLocation = "/Library/Java/JavaVirtualMachines";

    JavaHomeFinderMac(boolean forceEmbeddedJava) {
        super(forceEmbeddedJava, defaultJavaLocation, "/System/Library/Java/JavaVirtualMachines", FileUtil.expandUserHome((String)"~/Library/Java/JavaVirtualMachines"));
        this.registerFinder(() -> this.scanAll(JavaHomeFinderMac.getSystemDefaultJavaHome(), false));
    }

    @Nullable
    private static Path getSystemDefaultJavaHome() {
        String homePath = null;
        if (new File(JAVA_HOME_FIND_UTIL).canExecute()) {
            homePath = ExecUtil.execAndReadLine((GeneralCommandLine)new GeneralCommandLine(new String[]{JAVA_HOME_FIND_UTIL}));
        }
        if (homePath != null) {
            return Paths.get(homePath, new String[0]);
        }
        return null;
    }

    @Override
    @NotNull
    protected List<File> listPossibleJdkHomesFromInstallRoot(@NotNull File file2) {
        if (file2 == null) {
            JavaHomeFinderMac.$$$reportNull$$$0(0);
        }
        List<File> list2 = Arrays.asList(file2, new File(file2, "/Home"), new File(file2, "Contents/Home"));
        if (list2 == null) {
            JavaHomeFinderMac.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @Override
    @NotNull
    protected List<Path> listPossibleJdkInstallRootsFromHomes(@NotNull Path file2) {
        Path parentFile;
        if (file2 == null) {
            JavaHomeFinderMac.$$$reportNull$$$0(2);
        }
        ArrayList<Path> result2 = new ArrayList<Path>();
        result2.add(file2);
        Path home2 = file2.getFileName();
        if (home2 != null && home2.toString().equalsIgnoreCase("Home") && (parentFile = file2.getParent()) != null) {
            Path parentParentFile;
            result2.add(parentFile);
            Path contents = parentFile.getFileName();
            if (contents != null && contents.toString().equalsIgnoreCase("Contents") && (parentParentFile = parentFile.getParent()) != null) {
                result2.add(parentParentFile);
            }
        }
        ArrayList<Path> arrayList = result2;
        if (arrayList == null) {
            JavaHomeFinderMac.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/impl/JavaHomeFinderMac";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/impl/JavaHomeFinderMac";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "listPossibleJdkHomesFromInstallRoot";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "listPossibleJdkInstallRootsFromHomes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "listPossibleJdkHomesFromInstallRoot";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "listPossibleJdkInstallRootsFromHomes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

