/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.openapi.module.ConfigurationErrorDescription;
import com.intellij.openapi.module.ConfigurationErrorType;
import com.intellij.openapi.module.impl.ModuleManagerImpl;
import com.intellij.openapi.module.impl.ModulePath;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.projectModel.ProjectModelBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class ModuleLoadingErrorDescription
extends ConfigurationErrorDescription {
    public static final ConfigurationErrorType MODULE_ERROR = new ConfigurationErrorType(false){

        @Override
        @Nls
        @NotNull
        public String getErrorText(int errorCount, @NlsSafe String firstElementName) {
            String string = ProjectModelBundle.message((String)"module.configuration.problem.text", (Object[])new Object[]{errorCount, firstElementName});
            if (string == null) {
                1.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleLoadingErrorDescription$1", "getErrorText"));
        }
    };
    private final ModulePath myModulePath;
    private final ModuleManagerImpl myModuleManager;

    ModuleLoadingErrorDescription(@NlsContexts.DetailedDescription String description2, @NotNull ModulePath modulePath, @NotNull ModuleManagerImpl moduleManager) {
        if (modulePath == null) {
            ModuleLoadingErrorDescription.$$$reportNull$$$0(0);
        }
        if (moduleManager == null) {
            ModuleLoadingErrorDescription.$$$reportNull$$$0(1);
        }
        super(modulePath.getModuleName(), description2, MODULE_ERROR);
        this.myModulePath = modulePath;
        this.myModuleManager = moduleManager;
    }

    @NotNull
    public ModulePath getModulePath() {
        ModulePath modulePath = this.myModulePath;
        if (modulePath == null) {
            ModuleLoadingErrorDescription.$$$reportNull$$$0(2);
        }
        return modulePath;
    }

    @Override
    public void ignoreInvalidElement() {
        this.myModuleManager.removeFailedModulePath(this.myModulePath);
    }

    @Override
    @NotNull
    public String getIgnoreConfirmationMessage() {
        String string = ProjectModelBundle.message((String)"module.remove.from.project.confirmation", (Object[])new Object[]{this.getElementName()});
        if (string == null) {
            ModuleLoadingErrorDescription.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulePath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleManager";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/module/impl/ModuleLoadingErrorDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/module/impl/ModuleLoadingErrorDescription";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulePath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoreConfirmationMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

