/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.KeyStrokeAdapter;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultCaret;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ShortcutTextField
extends ExtendableTextField {
    private KeyStroke myKeyStroke;
    private int myLastPressedKeyCode = 0;

    ShortcutTextField(boolean isFocusTraversalKeysEnabled) {
        this.enableEvents(8L);
        this.setFocusTraversalKeysEnabled(isFocusTraversalKeysEnabled);
        if (isFocusTraversalKeysEnabled) {
            this.setExtensions(new ExtendableTextComponent.Extension[]{ExtendableTextComponent.Extension.create((Icon)AllIcons.General.InlineAdd, (Icon)AllIcons.General.InlineAddHover, (String)this.getPopupTooltip(), this::showPopup)});
        }
        this.setCaret(new DefaultCaret(){

            @Override
            public boolean isVisible() {
                return false;
            }
        });
    }

    private static boolean absolutelyUnknownKey(KeyEvent e) {
        return e.getKeyCode() == 0 && e.getKeyChar() == '\uffff' && e.getKeyLocation() == 0 && e.getExtendedKeyCode() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processKeyEvent(KeyEvent e) {
        boolean isNotModifierKey;
        int keyCode = e.getKeyCode();
        if (this.getFocusTraversalKeysEnabled() && e.getModifiers() == 0 && e.getModifiersEx() == 0 && (keyCode == 27 || keyCode == 10 && this.myKeyStroke != null)) {
            super.processKeyEvent(e);
            return;
        }
        boolean bl = isNotModifierKey = keyCode != 16 && keyCode != 18 && keyCode != 17 && keyCode != 65406 && keyCode != 157 && !ShortcutTextField.absolutelyUnknownKey(e);
        if (isNotModifierKey) {
            if (e.getID() == 401 || e.getID() == 402 && SystemInfo.isLinux && (e.isAltDown() || e.isAltGraphDown()) && this.myLastPressedKeyCode != keyCode) {
                this.setKeyStroke(KeyStrokeAdapter.getDefaultKeyStroke(e));
            }
            if (e.getID() == 401) {
                this.myLastPressedKeyCode = keyCode;
            }
        }
        if (!this.getFocusTraversalKeysEnabled() && ScreenReader.isActive()) {
            this.setFocusTraversalKeysEnabled(true);
            try {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().processKeyEvent((Component)((Object)this), e);
            }
            finally {
                this.setFocusTraversalKeysEnabled(false);
            }
        }
    }

    void setKeyStroke(KeyStroke keyStroke) {
        KeyStroke old = this.myKeyStroke;
        if (old != null || keyStroke != null) {
            this.myKeyStroke = keyStroke;
            super.setText(KeymapUtil.getKeystrokeText((KeyStroke)keyStroke));
            this.setCaretPosition(0);
            this.firePropertyChange("keyStroke", old, keyStroke);
        }
    }

    KeyStroke getKeyStroke() {
        return this.myKeyStroke;
    }

    public void enableInputMethods(boolean enable2) {
        super.enableInputMethods(enable2 && Registry.is((String)"ide.settings.keymap.input.method.enabled"));
    }

    public void setText(String text2) {
        super.setText(text2);
        this.setCaretPosition(0);
        if (text2 == null || text2.isEmpty()) {
            this.myKeyStroke = null;
            this.firePropertyChange("keyStroke", null, null);
        }
    }

    private void showPopup() {
        JBPopupMenu menu = new JBPopupMenu();
        this.getKeyStrokes().forEach(stroke -> menu.add(this.getPopupAction((KeyStroke)stroke)));
        Insets insets = this.getInsets();
        menu.show((Component)((Object)this), this.getWidth() - insets.right, insets.top);
    }

    @NotNull
    private Action getPopupAction(final @NotNull KeyStroke stroke) {
        if (stroke == null) {
            ShortcutTextField.$$$reportNull$$$0(0);
        }
        return new AbstractAction(IdeBundle.message((String)"button.set.0", (Object[])new Object[]{KeymapUtil.getKeystrokeText((KeyStroke)stroke)})){

            @Override
            public void actionPerformed(ActionEvent event) {
                ShortcutTextField.this.setKeyStroke(stroke);
            }
        };
    }

    @NotNull
    @NlsContexts.Tooltip
    private String getPopupTooltip() {
        StringBuilder sb = new StringBuilder();
        String prefix2 = "";
        for (KeyStroke stroke : this.getKeyStrokes()) {
            if (0 != stroke.getModifiers()) continue;
            sb.append(prefix2).append(KeymapUtil.getKeystrokeText((KeyStroke)stroke));
            prefix2 = ", ";
        }
        String string = IdeBundle.message((String)"tooltip.text.add.shortcut.with.special.keys", (Object[])new Object[]{sb.toString()});
        if (string == null) {
            ShortcutTextField.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    private Iterable<KeyStroke> getKeyStrokes() {
        ArrayList<KeyStroke> list2 = new ArrayList<KeyStroke>();
        ShortcutTextField.addKeyStrokes(list2, this.getFocusTraversalKeys(0));
        ShortcutTextField.addKeyStrokes(list2, this.getFocusTraversalKeys(1));
        ShortcutTextField.addKeyStrokes(list2, this.getFocusTraversalKeys(2));
        ShortcutTextField.addKeyStrokes(list2, this.getFocusTraversalKeys(3));
        list2.add(0, KeyStroke.getKeyStroke(10, 0));
        list2.add(1, KeyStroke.getKeyStroke(27, 0));
        ArrayList<KeyStroke> arrayList = list2;
        if (arrayList == null) {
            ShortcutTextField.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static void addKeyStrokes(@NotNull ArrayList<? super KeyStroke> list2, @Nullable Iterable<? extends AWTKeyStroke> strokes) {
        if (list2 == null) {
            ShortcutTextField.$$$reportNull$$$0(3);
        }
        if (strokes != null) {
            for (AWTKeyStroke aWTKeyStroke : strokes) {
                int keyCode = aWTKeyStroke.getKeyCode();
                if (keyCode == 0) continue;
                list2.add(aWTKeyStroke instanceof KeyStroke ? (KeyStroke)aWTKeyStroke : KeyStroke.getKeyStroke(keyCode, aWTKeyStroke.getModifiers(), aWTKeyStroke.isOnKeyRelease()));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stroke";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/keymap/impl/ui/ShortcutTextField";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/keymap/impl/ui/ShortcutTextField";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPopupTooltip";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyStrokes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPopupAction";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addKeyStrokes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

