/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.ToggleDistractionFreeModeAction;
import com.intellij.ide.ui.UISettings;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.EditorTabPresentationUtil;
import com.intellij.openapi.fileEditor.impl.EditorTabbedContainer;
import com.intellij.openapi.fileEditor.impl.EditorWindowHolder;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.FileEditorOpenOptions;
import com.intellij.openapi.fileEditor.impl.HistoryEntry;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.AbstractPainter;
import com.intellij.openapi.ui.Painter;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.KeyWithDefaultValue;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.tabsLayout.TabsLayoutInfo;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SlowOperations;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.Stack;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBRectangle;
import com.intellij.util.ui.JBScalableIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditorWindow {
    private static final Logger LOG = Logger.getInstance(EditorWindow.class);
    public static final DataKey<EditorWindow> DATA_KEY = DataKey.create("editorWindow");
    public static final Key<Boolean> HIDE_TABS = Key.create((String)"HIDE_TABS");
    JPanel myPanel;
    @NotNull
    private final EditorTabbedContainer myTabbedPane;
    @NotNull
    private final EditorsSplitters myOwner;
    private boolean myIsDisposed;
    @Deprecated
    public static final Key<Integer> INITIAL_INDEX_KEY = Key.create((String)"initial editor index");
    public static final Key<Integer> DRAG_START_INDEX_KEY = KeyWithDefaultValue.create((String)"drag start editor index", (Object)-1);
    public static final Key<Integer> DRAG_START_LOCATION_HASH_KEY = KeyWithDefaultValue.create((String)"drag start editor location hash", (Object)0);
    public static final Key<Boolean> DRAG_START_PINNED_KEY = Key.create((String)"drag start editor pinned state");
    private final Stack<Pair<String, FileEditorOpenOptions>> myRemovedTabs;
    private MySplitPainter myPainter;

    EditorWindow(@NotNull EditorsSplitters owner, @NotNull Disposable parentDisposable) {
        if (owner == null) {
            EditorWindow.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            EditorWindow.$$$reportNull$$$0(1);
        }
        this.myRemovedTabs = new Stack<Pair<String, FileEditorOpenOptions>>(){

            public void push(Pair<String, FileEditorOpenOptions> pair) {
                if (this.size() >= EditorWindow.getTabLimit()) {
                    this.remove(0);
                }
                super.push(pair);
            }
        };
        this.myPainter = null;
        this.myOwner = owner;
        this.myPanel = new JPanel(new BorderLayout());
        this.myPanel.setOpaque(false);
        this.myPanel.setFocusable(false);
        this.myTabbedPane = new EditorTabbedContainer(this, this.getManager().getProject(), parentDisposable);
        this.myPanel.add((Component)this.myTabbedPane.getComponent(), "Center");
        if (UISettings.getInstance().getScrollTabLayoutInEditor()) {
            this.setTabLayoutPolicy(1);
        } else {
            this.setTabLayoutPolicy(0);
        }
        this.myOwner.addWindow(this);
        if (this.myOwner.getCurrentWindow() == null) {
            this.myOwner.setCurrentWindow(this, false);
        }
        this.updateTabsVisibility();
    }

    void updateTabsVisibility() {
        this.updateTabsVisibility(UISettings.getInstance());
    }

    void updateTabsVisibility(@NotNull UISettings settings2) {
        if (settings2 == null) {
            EditorWindow.$$$reportNull$$$0(2);
        }
        this.myTabbedPane.getTabs().getPresentation().setHideTabs(this.myOwner.isFloating() && EditorWindow.shouldHideTabs(this.getSelectedEditor()) || settings2.getEditorTabPlacement() == 0 || settings2.getPresentationMode());
    }

    private static boolean shouldHideTabs(@Nullable EditorWithProviderComposite selectedEditor) {
        return selectedEditor != null && ContainerUtil.exists((Object[])selectedEditor.getEditors(), e -> (Boolean)HIDE_TABS.get((UserDataHolder)e, (Object)false));
    }

    public boolean isShowing() {
        return this.myPanel.isShowing();
    }

    public void closeAllExcept(@Nullable VirtualFile selectedFile) {
        FileEditorManagerImpl.runBulkTabChange(this.myOwner, __ -> {
            for (VirtualFile file2 : this.getFiles()) {
                if (Comparing.equal((Object)file2, (Object)selectedFile) || this.isFilePinned(file2)) continue;
                this.closeFile(file2);
            }
        });
    }

    void dispose() {
        try {
            this.myOwner.removeWindow(this);
        }
        finally {
            this.myIsDisposed = true;
        }
    }

    public boolean isDisposed() {
        return this.myIsDisposed;
    }

    public void closeFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            EditorWindow.$$$reportNull$$$0(3);
        }
        this.closeFile(file2, true);
    }

    public void closeFile(@NotNull VirtualFile file2, boolean disposeIfNeeded) {
        if (file2 == null) {
            EditorWindow.$$$reportNull$$$0(4);
        }
        this.closeFile(file2, disposeIfNeeded, true);
    }

    boolean hasClosedTabs() {
        return !this.myRemovedTabs.empty();
    }

    void restoreClosedTab() {
        assert (this.hasClosedTabs()) : "Nothing to restore";
        Pair info2 = (Pair)this.myRemovedTabs.pop();
        VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl((String)info2.getFirst());
        if (file2 != null) {
            this.getManager().openFileImpl4(this, file2, null, ((FileEditorOpenOptions)info2.getSecond()).clone().withSelectAsCurrent().withRequestFocus());
        }
    }

    public void closeFile(@NotNull VirtualFile file2, boolean disposeIfNeeded, boolean transferFocus) {
        if (file2 == null) {
            EditorWindow.$$$reportNull$$$0(5);
        }
        FileEditorManagerImpl editorManager = this.getManager();
        FileEditorManagerImpl.runBulkTabChange(this.myOwner, splitters -> {
            List<EditorWithProviderComposite> editors2 = splitters.findEditorComposites(file2);
            if (!this.isDisposed() && editors2.isEmpty()) {
                return;
            }
            try {
                EditorWithProviderComposite editor = this.findFileComposite(file2);
                FileEditorManagerListener.Before beforePublisher = (FileEditorManagerListener.Before)editorManager.getProject().getMessageBus().syncPublisher(FileEditorManagerListener.Before.FILE_EDITOR_MANAGER);
                beforePublisher.beforeFileClosed((FileEditorManager)editorManager, file2);
                if (editor != null) {
                    int componentIndex = this.findComponentIndex(editor.getComponent());
                    if (componentIndex >= 0) {
                        int indexToSelect = this.calcIndexToSelect(file2, componentIndex);
                        FileEditorOpenOptions options2 = new FileEditorOpenOptions().withIndex(componentIndex).withPin(editor.isPinned());
                        Pair pair = Pair.create((Object)file2.getUrl(), (Object)options2);
                        this.myRemovedTabs.push((Object)pair);
                        this.myTabbedPane.removeTabAt(componentIndex, indexToSelect, transferFocus);
                        editorManager.disposeComposite(editor);
                    }
                } else {
                    Splitter splitter;
                    JComponent otherComponent;
                    if (this.inSplitter() && (otherComponent = (splitter = (Splitter)this.myPanel.getParent()).getOtherComponent((Component)this.myPanel)) != null) {
                        IdeFocusManager.findInstance().requestFocus((Component)otherComponent, true);
                    }
                    this.myPanel.removeAll();
                }
                if (disposeIfNeeded && this.getTabCount() == 0) {
                    this.removeFromSplitter();
                } else {
                    this.myPanel.revalidate();
                }
            }
            finally {
                editorManager.removeSelectionRecord(file2, this);
                ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
                editorManager.notifyPublisher(() -> {
                    Project project = editorManager.getProject();
                    if (!project.isDisposed()) {
                        FileEditorManagerListener afterPublisher = (FileEditorManagerListener)project.getMessageBus().syncPublisher(FileEditorManagerListener.FILE_EDITOR_MANAGER);
                        afterPublisher.fileClosed((FileEditorManager)editorManager, file2);
                    }
                });
                splitters.afterFileClosed(file2);
            }
        });
    }

    void removeFromSplitter() {
        if (!this.inSplitter()) {
            return;
        }
        if (this.myOwner.getCurrentWindow() == this) {
            EditorWindow[] siblings = this.findSiblings();
            this.myOwner.setCurrentWindow(siblings[0], true);
        }
        Splitter splitter = (Splitter)this.myPanel.getParent();
        JComponent otherComponent = splitter.getOtherComponent((Component)this.myPanel);
        Container parent = splitter.getParent().getParent();
        if (parent instanceof Splitter) {
            Splitter parentSplitter = (Splitter)parent;
            if (parentSplitter.getFirstComponent() == splitter.getParent()) {
                parentSplitter.setFirstComponent(otherComponent);
            } else {
                parentSplitter.setSecondComponent(otherComponent);
            }
        } else if (parent instanceof EditorsSplitters) {
            Component currentFocusComponent = IdeFocusManager.getGlobalInstance().getFocusedDescendantFor((Component)parent);
            parent.removeAll();
            parent.add((Component)otherComponent, "Center");
            parent.revalidate();
            if (currentFocusComponent != null) {
                currentFocusComponent.requestFocusInWindow();
            }
        } else {
            throw new IllegalStateException("Unknown container: " + parent);
        }
        this.dispose();
    }

    int calcIndexToSelect(@NotNull VirtualFile fileBeingClosed, int fileIndex) {
        int currentlySelectedIndex;
        if (fileBeingClosed == null) {
            EditorWindow.$$$reportNull$$$0(6);
        }
        if ((currentlySelectedIndex = this.myTabbedPane.getSelectedIndex()) != fileIndex) {
            return currentlySelectedIndex;
        }
        UISettings uiSettings = UISettings.getInstance();
        if (uiSettings.getState().getActiveMruEditorOnClose()) {
            List<VirtualFile> histFiles = EditorHistoryManager.getInstance(this.getManager().getProject()).getFileList();
            for (int idx = histFiles.size() - 1; idx >= 0; --idx) {
                int histFileIndex;
                EditorWithProviderComposite editor;
                VirtualFile histFile = histFiles.get(idx);
                if (histFile.equals(fileBeingClosed) || (editor = this.findFileComposite(histFile)) == null || (histFileIndex = this.findComponentIndex(editor.getComponent())) < 0) continue;
                return histFileIndex;
            }
        } else if (uiSettings.getActiveRightEditorOnClose() && fileIndex + 1 < this.myTabbedPane.getTabCount()) {
            return fileIndex + 1;
        }
        if (fileIndex > 0) {
            return fileIndex - 1;
        }
        return -1;
    }

    @NotNull
    public FileEditorManagerImpl getManager() {
        FileEditorManagerImpl fileEditorManagerImpl = this.myOwner.getManager();
        if (fileEditorManagerImpl == null) {
            EditorWindow.$$$reportNull$$$0(7);
        }
        return fileEditorManagerImpl;
    }

    public int getTabCount() {
        return this.myTabbedPane.getTabCount();
    }

    void setForegroundAt(int index2, @NotNull Color color) {
        if (color == null) {
            EditorWindow.$$$reportNull$$$0(8);
        }
        this.myTabbedPane.setForegroundAt(index2, color);
    }

    void setTextAttributes(int index2, @Nullable TextAttributes attributes2) {
        this.myTabbedPane.setTextAttributes(index2, attributes2);
    }

    private void setTitleAt(int index2, @NlsContexts.TabTitle @NotNull String text2) {
        if (text2 == null) {
            EditorWindow.$$$reportNull$$$0(9);
        }
        this.myTabbedPane.setTitleAt(index2, text2);
    }

    private void setBackgroundColorAt(int index2, @Nullable Color color) {
        this.myTabbedPane.setBackgroundColorAt(index2, color);
    }

    private void setToolTipTextAt(int index2, @Nullable @NlsContexts.Tooltip String text2) {
        this.myTabbedPane.setToolTipTextAt(index2, text2);
    }

    void setTabLayoutPolicy(int policy) {
        this.myTabbedPane.setTabLayoutPolicy(policy);
    }

    void setTabsPlacement(int tabPlacement) {
        this.myTabbedPane.setTabPlacement(tabPlacement);
    }

    void updateTabsLayout(@NotNull TabsLayoutInfo newTabsLayoutInfo) {
        if (newTabsLayoutInfo == null) {
            EditorWindow.$$$reportNull$$$0(10);
        }
        this.myTabbedPane.updateTabsLayout(newTabsLayoutInfo);
    }

    public void setAsCurrentWindow(boolean requestFocus) {
        this.myOwner.setCurrentWindow(this, requestFocus);
    }

    void updateFileBackgroundColor(@NotNull VirtualFile file2) {
        int index2;
        if (file2 == null) {
            EditorWindow.$$$reportNull$$$0(11);
        }
        if ((index2 = this.findFileEditorIndex(file2)) != -1) {
            Color color = EditorTabPresentationUtil.getEditorTabBackgroundColor(this.getManager().getProject(), file2, this);
            this.setBackgroundColorAt(index2, color);
        }
    }

    @NotNull
    public EditorsSplitters getOwner() {
        EditorsSplitters editorsSplitters = this.myOwner;
        if (editorsSplitters == null) {
            EditorWindow.$$$reportNull$$$0(12);
        }
        return editorsSplitters;
    }

    boolean isEmptyVisible() {
        return this.myTabbedPane.isEmptyVisible();
    }

    public Dimension getSize() {
        return this.myPanel.getSize();
    }

    @NotNull
    public EditorTabbedContainer getTabbedPane() {
        EditorTabbedContainer editorTabbedContainer = this.myTabbedPane;
        if (editorTabbedContainer == null) {
            EditorWindow.$$$reportNull$$$0(13);
        }
        return editorTabbedContainer;
    }

    public void requestFocus(boolean forced) {
        this.myTabbedPane.requestFocus(forced);
    }

    public void toFront() {
        Window window = UIUtil.getWindow((Component)this.myTabbedPane.getComponent());
        UIUtil.toFront((Window)window);
    }

    private void checkConsistency() {
        LOG.assertTrue(this.myOwner.containsWindow(this), (Object)"EditorWindow not in collection");
    }

    @Nullable
    public EditorWithProviderComposite getSelectedEditor() {
        return this.getSelectedEditor(false);
    }

    @Nullable
    public EditorWithProviderComposite getSelectedEditor(boolean ignorePopup) {
        TComp comp = (TComp)ObjectUtils.tryCast((Object)this.myTabbedPane.getSelectedComponent(ignorePopup), TComp.class);
        return comp == null ? null : comp.myEditor;
    }

    public EditorWithProviderComposite @NotNull [] getEditors() {
        int tabCount = this.getTabCount();
        EditorWithProviderComposite[] res2 = new EditorWithProviderComposite[tabCount];
        for (int i2 = 0; i2 != tabCount; ++i2) {
            res2[i2] = this.getEditorAt(i2);
        }
        if (res2 == null) {
            EditorWindow.$$$reportNull$$$0(14);
        }
        return res2;
    }

    public VirtualFile @NotNull [] getFiles() {
        int tabCount = this.getTabCount();
        VirtualFile[] res2 = new VirtualFile[tabCount];
        for (int i2 = 0; i2 != tabCount; ++i2) {
            res2[i2] = this.getEditorAt(i2).getFile();
        }
        if (res2 == null) {
            EditorWindow.$$$reportNull$$$0(15);
        }
        return res2;
    }

    public void setSelectedEditor(@NotNull EditorComposite editor, boolean focusEditor) {
        int index2;
        if (editor == null) {
            EditorWindow.$$$reportNull$$$0(16);
        }
        if ((index2 = this.findFileIndex(editor.getFile())) != -1 && !this.isDisposed()) {
            this.myTabbedPane.setSelectedIndex(index2, focusEditor);
        }
    }

    public void setEditor(@NotNull EditorWithProviderComposite editor, boolean focusEditor) {
        if (editor == null) {
            EditorWindow.$$$reportNull$$$0(17);
        }
        this.setEditor(editor, new FileEditorOpenOptions().withRequestFocus(focusEditor));
    }

    public void setEditor(@NotNull EditorWithProviderComposite editor, @NotNull FileEditorOpenOptions options2) {
        if (editor == null) {
            EditorWindow.$$$reportNull$$$0(18);
        }
        if (options2 == null) {
            EditorWindow.$$$reportNull$$$0(19);
        }
        boolean isNewEditor = this.findEditorIndex(editor) == -1;
        boolean isPreviewMode = (isNewEditor || editor.isPreview()) && this.shouldReservePreview(editor.getFile(), options2);
        editor.setPreview(isPreviewMode);
        if (isNewEditor) {
            Boolean initialPinned;
            int indexToInsert = options2.getIndex();
            if (indexToInsert == -1 && isPreviewMode) {
                indexToInsert = this.findPreviewIndex();
            }
            if (indexToInsert == -1) {
                indexToInsert = UISettings.getInstance().getOpenTabsAtTheEnd() ? this.myTabbedPane.getTabCount() : this.myTabbedPane.getSelectedIndex() + 1;
            }
            VirtualFile file2 = editor.getFile();
            Icon template = AllIcons.FileTypes.Text;
            EmptyIcon emptyIcon = EmptyIcon.create((int)template.getIconWidth(), (int)template.getIconHeight());
            this.myTabbedPane.insertTab(file2, (Icon)emptyIcon, new TComp(this, editor), null, indexToInsert, editor);
            Integer dragStartIndex = null;
            Integer hash = (Integer)file2.getUserData(DRAG_START_LOCATION_HASH_KEY);
            if (hash != null && System.identityHashCode(this.myTabbedPane.getTabs()) == hash) {
                dragStartIndex = (Integer)file2.getUserData(DRAG_START_INDEX_KEY);
            }
            if ((dragStartIndex == null || dragStartIndex != -1) && (initialPinned = (Boolean)file2.getUserData(DRAG_START_PINNED_KEY)) != null) {
                editor.setPinned(initialPinned);
            }
            file2.putUserData(DRAG_START_LOCATION_HASH_KEY, null);
            file2.putUserData(DRAG_START_INDEX_KEY, null);
            file2.putUserData(DRAG_START_PINNED_KEY, null);
            this.trimToSize(file2, false);
            this.myOwner.updateFileIconImmediately(file2, IconUtil.computeBaseFileIcon(file2));
            this.myOwner.updateFileIconLater(file2);
            this.myOwner.updateFileColor(file2);
        }
        this.myOwner.updateFileColor(editor.getFile());
        if (options2.getSelectAsCurrent()) {
            this.setSelectedEditor(editor, options2.getRequestFocus());
        }
        this.updateTabsVisibility();
        this.myOwner.validate();
    }

    private boolean splitAvailable() {
        return this.getTabCount() >= 1;
    }

    @Nullable
    public EditorWindow split(int orientation, boolean forceSplit, @Nullable VirtualFile virtualFile2, boolean focusNew) {
        return this.split(orientation, forceSplit, virtualFile2, focusNew, true);
    }

    @Nullable
    public EditorWindow split(int orientation, boolean forceSplit, @Nullable VirtualFile virtualFile2, boolean focusNew, boolean fileIsSecondaryComponent) {
        this.checkConsistency();
        if (!this.splitAvailable()) {
            return null;
        }
        FileEditorManagerImpl fileEditorManager = this.myOwner.getManager();
        if (!forceSplit && this.inSplitter()) {
            EditorWindow[] siblings = this.findSiblings();
            EditorWindow target2 = siblings[0];
            if (virtualFile2 != null) {
                FileEditor[] editors2 = (FileEditor[])fileEditorManager.openFileImpl3((EditorWindow)target2, (VirtualFile)virtualFile2, (boolean)focusNew, null).first;
                this.syncCaretIfPossible(editors2);
            }
            return target2;
        }
        JPanel panel2 = this.myPanel;
        panel2.setBorder(null);
        int tabCount = this.getTabCount();
        if (tabCount != 0) {
            this.myPanel = new JPanel(new BorderLayout());
            this.myPanel.setOpaque(false);
            OnePixelSplitter splitter = new OnePixelSplitter(orientation == 0, 0.5f, 0.1f, 0.9f);
            splitter.putClientProperty((Object)"EditorsSplitters", (Object)Boolean.TRUE);
            EditorWindow res2 = new EditorWindow(this.myOwner, this.myOwner.parentDisposable);
            EditorWithProviderComposite selectedEditor = this.getSelectedEditor();
            panel2.remove(this.myTabbedPane.getComponent());
            panel2.add((Component)splitter, "Center");
            if (fileIsSecondaryComponent) {
                splitter.setFirstComponent((JComponent)this.myPanel);
            } else {
                splitter.setSecondComponent((JComponent)this.myPanel);
            }
            this.myPanel.add((Component)this.myTabbedPane.getComponent(), "Center");
            if (fileIsSecondaryComponent) {
                splitter.setSecondComponent((JComponent)res2.myPanel);
            } else {
                splitter.setFirstComponent((JComponent)res2.myPanel);
            }
            VirtualFile file2 = selectedEditor.getFile();
            VirtualFile nextFile = virtualFile2 == null ? file2 : virtualFile2;
            HistoryEntry currentState = selectedEditor.currentStateAsHistoryEntry();
            VirtualFile currentStateFile = currentState.getFile();
            if (currentStateFile == null || !currentStateFile.equals(nextFile)) {
                currentState = null;
            }
            FileEditorOpenOptions openOptions = new FileEditorOpenOptions().withRequestFocus(focusNew).withExactState();
            FileEditor[] editors3 = (FileEditor[])fileEditorManager.openFileImpl4((EditorWindow)res2, (VirtualFile)nextFile, (HistoryEntry)currentState, (FileEditorOpenOptions)openOptions).first;
            this.syncCaretIfPossible(editors3);
            if (this.isFileOpen(nextFile)) {
                res2.setFilePinned(nextFile, this.isFilePinned(nextFile));
            }
            if (!focusNew) {
                res2.setSelectedEditor(selectedEditor, true);
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> {
                    JComponent focusComponent = selectedEditor.getFocusComponent();
                    if (focusComponent != null) {
                        IdeFocusManager.getGlobalInstance().requestFocus((Component)focusComponent, true);
                    }
                });
            }
            panel2.revalidate();
            return res2;
        }
        return null;
    }

    private void syncCaretIfPossible(FileEditor @NotNull [] toSync) {
        EditorWithProviderComposite from2;
        if (toSync == null) {
            EditorWindow.$$$reportNull$$$0(20);
        }
        if ((from2 = this.getSelectedEditor()) == null) {
            return;
        }
        FileEditor caretSource = from2.getSelectedEditor();
        if (!(caretSource instanceof TextEditor)) {
            return;
        }
        Editor editorFrom = ((TextEditor)caretSource).getEditor();
        int offset = editorFrom.getCaretModel().getOffset();
        if (offset <= 0) {
            return;
        }
        int scrollOffset = editorFrom.getScrollingModel().getVerticalScrollOffset();
        for (FileEditor fileEditor : toSync) {
            if (!(fileEditor instanceof TextEditor)) continue;
            Editor editor = ((TextEditor)fileEditor).getEditor();
            if (editorFrom.getDocument() != editor.getDocument()) continue;
            editor.getCaretModel().moveToOffset(offset);
            ScrollingModel scrollingModel = editor.getScrollingModel();
            scrollingModel.scrollVertically(scrollOffset);
            SwingUtilities.invokeLater(() -> {
                if (!editor.isDisposed()) {
                    scrollingModel.scrollToCaret(ScrollType.MAKE_VISIBLE);
                }
            });
        }
    }

    public EditorWindow @NotNull [] findSiblings() {
        this.checkConsistency();
        ArrayList<EditorWindow> res2 = new ArrayList<EditorWindow>();
        if (this.myPanel.getParent() instanceof Splitter) {
            Splitter splitter = (Splitter)this.myPanel.getParent();
            for (EditorWindow win : this.myOwner.getWindows()) {
                if (win == this || !SwingUtilities.isDescendingFrom(win.myPanel, (Component)splitter)) continue;
                res2.add(win);
            }
        }
        EditorWindow[] editorWindowArray = res2.toArray(new EditorWindow[0]);
        if (editorWindowArray == null) {
            EditorWindow.$$$reportNull$$$0(21);
        }
        return editorWindowArray;
    }

    @NotNull
    public Map<RelativePosition, EditorWindow> getAdjacentEditors() {
        this.checkConsistency();
        HashMap<RelativePosition, EditorWindow> adjacentEditors = new HashMap<RelativePosition, EditorWindow>(4);
        List<EditorWindow> windows = this.myOwner.getOrderedWindows();
        windows.remove(this);
        HashMap<JPanel, EditorWindow> panel2Window = new HashMap<JPanel, EditorWindow>();
        for (EditorWindow win : windows) {
            panel2Window.put(win.myPanel, win);
        }
        RelativePoint relativePoint = new RelativePoint(this.myPanel.getLocationOnScreen());
        Point point = relativePoint.getPoint((Component)((Object)this.myOwner));
        BiFunction<Integer, Integer, Component> nearestComponent = (x, y) -> SwingUtilities.getDeepestComponentAt((Component)((Object)this.myOwner), x, y);
        Function<Component, EditorWindow> findAdjacentEditor = component2 -> {
            while (component2 != this.myOwner && component2 != null) {
                if (panel2Window.containsKey(component2)) {
                    return (EditorWindow)panel2Window.get(component2);
                }
                component2 = component2.getParent();
            }
            return null;
        };
        BiConsumer<EditorWindow, RelativePosition> biConsumer = (window, position) -> {
            if (window == null) {
                return;
            }
            adjacentEditors.put((RelativePosition)((Object)position), (EditorWindow)window);
        };
        int x2 = point.x + this.myPanel.getWidth() / 4;
        int searchStep = 2;
        biConsumer.accept(findAdjacentEditor.apply(nearestComponent.apply(x2, point.y - searchStep)), RelativePosition.UP);
        biConsumer.accept(findAdjacentEditor.apply(nearestComponent.apply(x2, point.y + this.myPanel.getHeight() + searchStep)), RelativePosition.DOWN);
        biConsumer.accept(findAdjacentEditor.apply(nearestComponent.apply(point.x - searchStep, point.y)), RelativePosition.LEFT);
        biConsumer.accept(findAdjacentEditor.apply(nearestComponent.apply(point.x + this.myPanel.getWidth() + searchStep, point.y)), RelativePosition.RIGHT);
        HashMap<RelativePosition, EditorWindow> hashMap = adjacentEditors;
        if (hashMap == null) {
            EditorWindow.$$$reportNull$$$0(22);
        }
        return hashMap;
    }

    private Runnable showSplitChooser(boolean showInfoPanel) {
        this.myPainter = new MySplitPainter(showInfoPanel);
        Disposable disposable2 = Disposer.newDisposable((String)"GlassPaneListeners");
        IdeGlassPaneUtil.find((Component)this.myPanel).addPainter((Component)this.myPanel, (Painter)this.myPainter, disposable2);
        this.myPanel.repaint();
        this.myPanel.setFocusable(true);
        this.myPanel.grabFocus();
        this.myPanel.setFocusTraversalKeysEnabled(false);
        FocusAdapter focusAdapter2 = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                EditorWindow.this.myPanel.removeFocusListener(this);
                if (SplitterService.getInstance().myActiveWindow == EditorWindow.this) {
                    SplitterService.getInstance().stopSplitChooser(true);
                }
            }
        };
        this.myPanel.addFocusListener(focusAdapter2);
        return () -> {
            this.myPainter.myRectangle = null;
            this.myPainter = null;
            this.myPanel.removeFocusListener(focusAdapter2);
            this.myPanel.setFocusable(false);
            this.myPanel.repaint();
            Disposer.dispose((Disposable)disposable2);
        };
    }

    void changeOrientation() {
        this.checkConsistency();
        Container parent = this.myPanel.getParent();
        if (parent instanceof Splitter) {
            Splitter splitter;
            splitter.setOrientation(!(splitter = (Splitter)parent).getOrientation());
        }
    }

    private int findFileEditorIndex(@NotNull VirtualFile file2) {
        EditorWithProviderComposite composite2;
        if (file2 == null) {
            EditorWindow.$$$reportNull$$$0(23);
        }
        return (composite2 = this.findFileComposite(file2)) == null ? -1 : this.findEditorIndex(composite2);
    }

    void updateFileIcon(@NotNull VirtualFile file2, @NotNull Icon icon2) {
        EditorWithProviderComposite composite2;
        if (file2 == null) {
            EditorWindow.$$$reportNull$$$0(24);
        }
        if (icon2 == null) {
            EditorWindow.$$$reportNull$$$0(25);
        }
        if ((composite2 = this.findFileComposite(file2)) == null) {
            return;
        }
        int index2 = this.findEditorIndex(composite2);
        if (index2 < 0) {
            return;
        }
        this.myTabbedPane.setIconAt(index2, EditorWindow.decorateFileIcon(composite2, icon2));
    }

    void updateFileName(@NotNull VirtualFile file2) {
        int index2;
        if (file2 == null) {
            EditorWindow.$$$reportNull$$$0(26);
        }
        if ((index2 = this.findFileEditorIndex(file2)) != -1) {
            this.setTitleAt(index2, (String)SlowOperations.allowSlowOperations(() -> EditorTabPresentationUtil.getEditorTabTitle(this.getManager().getProject(), file2, this)));
            this.setToolTipTextAt(index2, UISettings.getInstance().getShowTabsTooltips() ? this.getManager().getFileTooltipText(file2) : null);
        }
    }

    @Nullable
    private static Icon decorateFileIcon(@NotNull EditorComposite composite2, @NotNull Icon baseIcon) {
        UISettings settings2;
        if (composite2 == null) {
            EditorWindow.$$$reportNull$$$0(27);
        }
        if (baseIcon == null) {
            EditorWindow.$$$reportNull$$$0(28);
        }
        boolean showAsterisk = (settings2 = UISettings.getInstance()).getMarkModifiedTabsWithAsterisk() && composite2.isModified();
        boolean showFileIconInTabs = UISettings.getInstance().getShowFileIconInTabs();
        if (!showAsterisk) {
            return showFileIconInTabs ? baseIcon : null;
        }
        Icon modifiedIcon = IconUtil.cropIcon(AllIcons.General.Modified, (Rectangle)new JBRectangle(3, 3, 7, 7));
        LayeredIcon result2 = new LayeredIcon(2);
        if (showFileIconInTabs) {
            result2.setIcon(baseIcon, 0);
            result2.setIcon(modifiedIcon, 1, -modifiedIcon.getIconWidth() / 2, 0);
        } else {
            result2.setIcon((Icon)EmptyIcon.create((int)modifiedIcon.getIconWidth(), (int)baseIcon.getIconHeight()), 0);
            result2.setIcon(modifiedIcon, 1, 0, 0);
        }
        return JBUIScale.scaleIcon((JBScalableIcon)result2);
    }

    public void unsplit(boolean setCurrent) {
        this.checkConsistency();
        Container splitter = this.myPanel.getParent();
        if (!(splitter instanceof Splitter)) {
            return;
        }
        EditorWithProviderComposite editorToSelect = this.getSelectedEditor();
        EditorWindow[] siblings = this.findSiblings();
        JPanel parent = (JPanel)splitter.getParent();
        for (EditorWindow eachSibling : siblings) {
            EditorWithProviderComposite selected2 = eachSibling.getSelectedEditor();
            if (editorToSelect != null || selected2 == null) continue;
            editorToSelect = selected2;
            break;
        }
        FileEditorOpenOptions openOptions = new FileEditorOpenOptions().withSelectAsCurrent(false).withRequestFocus(false);
        for (EditorWindow sibling : siblings) {
            EditorWithProviderComposite[] siblingEditors;
            for (EditorWithProviderComposite siblingEditor : siblingEditors = sibling.getEditors()) {
                if (editorToSelect == null) {
                    editorToSelect = siblingEditor;
                }
                this.processSiblingEditor(siblingEditor, openOptions);
            }
            LOG.assertTrue(sibling != this);
            sibling.dispose();
        }
        parent.remove(splitter);
        parent.add((Component)this.myTabbedPane.getComponent(), "Center");
        parent.revalidate();
        this.myPanel = parent;
        if (editorToSelect != null) {
            this.setSelectedEditor(editorToSelect, true);
        }
        if (setCurrent) {
            this.myOwner.setCurrentWindow(this, false);
        }
    }

    private void processSiblingEditor(@NotNull EditorWithProviderComposite siblingEditor, @NotNull FileEditorOpenOptions openOptions) {
        if (siblingEditor == null) {
            EditorWindow.$$$reportNull$$$0(29);
        }
        if (openOptions == null) {
            EditorWindow.$$$reportNull$$$0(30);
        }
        if (this.getTabCount() < UISettings.getInstance().getState().getEditorTabLimit() && this.findFileComposite(siblingEditor.getFile()) == null) {
            this.setEditor(siblingEditor, openOptions);
        } else {
            this.getManager().disposeComposite(siblingEditor);
        }
    }

    void unsplitAll() {
        this.checkConsistency();
        while (this.inSplitter()) {
            this.unsplit(true);
        }
    }

    public boolean inSplitter() {
        this.checkConsistency();
        return this.myPanel.getParent() instanceof Splitter;
    }

    public VirtualFile getSelectedFile() {
        this.checkConsistency();
        EditorWithProviderComposite editor = this.getSelectedEditor();
        return editor == null ? null : editor.getFile();
    }

    @Nullable
    public EditorWithProviderComposite findFileComposite(@NotNull VirtualFile file2) {
        if (file2 == null) {
            EditorWindow.$$$reportNull$$$0(31);
        }
        if (file2 instanceof BackedVirtualFile) {
            file2 = ((BackedVirtualFile)file2).getOriginFile();
        }
        for (int i2 = 0; i2 != this.getTabCount(); ++i2) {
            EditorWithProviderComposite editor = this.getEditorAt(i2);
            if (!editor.getFile().equals(file2)) continue;
            return editor;
        }
        return null;
    }

    private int findComponentIndex(@NotNull Component component2) {
        if (component2 == null) {
            EditorWindow.$$$reportNull$$$0(32);
        }
        for (int i2 = 0; i2 != this.getTabCount(); ++i2) {
            EditorWithProviderComposite editor = this.getEditorAt(i2);
            if (!editor.getComponent().equals(component2)) continue;
            return i2;
        }
        return -1;
    }

    private int findPreviewIndex() {
        for (int i2 = this.getTabCount() - 1; i2 >= 0; --i2) {
            EditorWithProviderComposite editor = this.getEditorAt(i2);
            if (!editor.isPreview()) continue;
            return i2;
        }
        return -1;
    }

    int findEditorIndex(@NotNull EditorComposite editorToFind) {
        if (editorToFind == null) {
            EditorWindow.$$$reportNull$$$0(33);
        }
        for (int i2 = 0; i2 != this.getTabCount(); ++i2) {
            EditorWithProviderComposite editor = this.getEditorAt(i2);
            if (!editor.equals(editorToFind)) continue;
            return i2;
        }
        return -1;
    }

    int findFileIndex(@NotNull VirtualFile fileToFind) {
        if (fileToFind == null) {
            EditorWindow.$$$reportNull$$$0(34);
        }
        for (int i2 = 0; i2 != this.getTabCount(); ++i2) {
            VirtualFile file2 = this.getFileAt(i2);
            if (!file2.equals(fileToFind)) continue;
            return i2;
        }
        return -1;
    }

    @NotNull
    private EditorWithProviderComposite getEditorAt(int i2) {
        EditorWithProviderComposite editorWithProviderComposite = ((TComp)this.myTabbedPane.getComponentAt((int)i2)).myEditor;
        if (editorWithProviderComposite == null) {
            EditorWindow.$$$reportNull$$$0(35);
        }
        return editorWithProviderComposite;
    }

    public boolean isFileOpen(@NotNull VirtualFile file2) {
        if (file2 == null) {
            EditorWindow.$$$reportNull$$$0(36);
        }
        return this.findFileComposite(file2) != null;
    }

    public boolean isFilePinned(@NotNull VirtualFile file2) {
        EditorWithProviderComposite editorComposite;
        if (file2 == null) {
            EditorWindow.$$$reportNull$$$0(37);
        }
        if ((editorComposite = this.findFileComposite(file2)) == null) {
            throw new IllegalArgumentException("file is not open: " + file2.getPath());
        }
        return editorComposite.isPinned();
    }

    public void setFilePinned(@NotNull VirtualFile file2, boolean pinned) {
        EditorWithProviderComposite editorComposite;
        if (file2 == null) {
            EditorWindow.$$$reportNull$$$0(38);
        }
        if ((editorComposite = this.findFileComposite(file2)) == null) {
            throw new IllegalArgumentException("file is not open: " + file2.getPath());
        }
        boolean wasPinned = editorComposite.isPinned();
        editorComposite.setPinned(pinned);
        if (editorComposite.isPreview()) {
            editorComposite.setPreview(false);
            this.myOwner.updateFileColor(file2);
        }
        if (wasPinned != pinned && ApplicationManager.getApplication().isDispatchThread()) {
            ObjectUtils.consumeIfCast((Object)this.getTabbedPane().getTabs(), JBTabsImpl.class, JBTabsImpl::doLayout);
        }
    }

    void trimToSize(@Nullable VirtualFile fileToIgnore, boolean transferFocus) {
        this.getManager().getReady(this).doWhenDone(() -> {
            if (!this.isDisposed()) {
                this.doTrimSize(fileToIgnore, UISettings.getInstance().getState().getCloseNonModifiedFilesFirst(), transferFocus);
            }
        });
    }

    private void doTrimSize(@Nullable VirtualFile fileToIgnore, boolean closeNonModifiedFilesFirst, boolean transferFocus) {
        Set previews;
        int limit = EditorWindow.getTabLimit();
        Set<VirtualFile> closingOrder = this.getTabClosingOrder(closeNonModifiedFilesFirst);
        VirtualFile selectedFile = this.getSelectedFile();
        if (selectedFile != null && this.shouldCloseSelected(selectedFile, fileToIgnore)) {
            this.defaultCloseFile(selectedFile, transferFocus);
            closingOrder.remove(selectedFile);
        }
        VirtualFile survivedPreviewFile = (previews = Arrays.stream(this.getEditors()).filter(EditorComposite::isPreview).map(EditorComposite::getFile).collect(Collectors.toSet())).contains(fileToIgnore) ? fileToIgnore : (VirtualFile)previews.stream().findAny().orElse(null);
        for (VirtualFile preview2 : previews) {
            if (Objects.equals(preview2, survivedPreviewFile)) continue;
            this.defaultCloseFile(preview2, transferFocus);
        }
        for (VirtualFile file2 : closingOrder) {
            if (this.myTabbedPane.getTabCount() <= limit || this.myTabbedPane.getTabCount() == 0 || this.areAllTabsPinned(fileToIgnore)) {
                return;
            }
            if (!this.fileCanBeClosed(file2, fileToIgnore)) continue;
            this.defaultCloseFile(file2, transferFocus);
        }
    }

    public static int getTabLimit() {
        int limit = UISettings.getInstance().getEditorTabLimit();
        if (ToggleDistractionFreeModeAction.isDistractionFreeModeEnabled() && ToggleDistractionFreeModeAction.getStandardTabPlacement() == 0) {
            limit = 1;
        }
        return limit;
    }

    @NotNull
    private Set<VirtualFile> getTabClosingOrder(boolean closeNonModifiedFilesFirst) {
        VirtualFile[] allFiles = this.getFiles();
        List<VirtualFile> histFiles = EditorHistoryManager.getInstance(this.getManager().getProject()).getFileList();
        LinkedHashSet<VirtualFile> closingOrder = new LinkedHashSet<VirtualFile>();
        for (VirtualFile file2 : allFiles) {
            if (histFiles.contains(file2)) continue;
            closingOrder.add(file2);
        }
        if (closeNonModifiedFilesFirst) {
            for (VirtualFile file3 : histFiles) {
                EditorWithProviderComposite composite2 = this.findFileComposite(file3);
                if (composite2 == null || this.myOwner.getManager().isChanged(composite2)) continue;
                closingOrder.add(file3);
            }
            for (int i2 = 0; i2 < this.myTabbedPane.getTabCount(); ++i2) {
                VirtualFile file4 = this.getFileAt(i2);
                if (this.myOwner.getManager().isChanged(this.getEditorAt(i2))) continue;
                closingOrder.add(file4);
            }
        }
        closingOrder.addAll(histFiles);
        for (int i3 = 0; i3 < this.myTabbedPane.getTabCount(); ++i3) {
            closingOrder.add(this.getFileAt(i3));
        }
        VirtualFile selectedFile = this.getSelectedFile();
        closingOrder.remove(selectedFile);
        closingOrder.add(selectedFile);
        LinkedHashSet<VirtualFile> linkedHashSet = closingOrder;
        if (linkedHashSet == null) {
            EditorWindow.$$$reportNull$$$0(39);
        }
        return linkedHashSet;
    }

    private boolean shouldCloseSelected(@NotNull VirtualFile file2, @Nullable VirtualFile fileToIgnore) {
        if (file2 == null) {
            EditorWindow.$$$reportNull$$$0(40);
        }
        if (!UISettings.getInstance().getReuseNotModifiedTabs() || !this.myOwner.getManager().getProject().isInitialized()) {
            return false;
        }
        if (!this.isFileOpen(file2) || this.isFilePinned(file2)) {
            return false;
        }
        if (file2.equals(fileToIgnore)) {
            return false;
        }
        EditorWithProviderComposite composite2 = this.findFileComposite(file2);
        if (composite2 == null) {
            return false;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            JComponent selectedEditorComponent = composite2.getSelectedEditor().getComponent();
            JComponent owner = IdeFocusManager.getInstance((Project)this.myOwner.getManager().getProject()).getFocusTargetFor(selectedEditorComponent);
            if (owner == null || !SwingUtilities.isDescendingFrom(owner, selectedEditorComponent)) {
                return false;
            }
        }
        return !this.myOwner.getManager().isChanged(composite2);
    }

    private boolean areAllTabsPinned(@Nullable VirtualFile fileToIgnore) {
        for (int i2 = this.myTabbedPane.getTabCount() - 1; i2 >= 0; --i2) {
            if (!this.fileCanBeClosed(this.getFileAt(i2), fileToIgnore)) continue;
            return false;
        }
        return true;
    }

    private boolean shouldReservePreview(@NotNull VirtualFile file2, @NotNull FileEditorOpenOptions options2) {
        if (file2 == null) {
            EditorWindow.$$$reportNull$$$0(41);
        }
        if (options2 == null) {
            EditorWindow.$$$reportNull$$$0(42);
        }
        if (!UISettings.getInstance().getOpenInPreviewTabIfPossible()) {
            return false;
        }
        if (((Boolean)FileEditorManagerImpl.FORBID_PREVIEW_TAB.get((UserDataHolder)file2, (Object)false)).booleanValue()) {
            return false;
        }
        if (options2.getUsePreviewTab()) {
            return true;
        }
        if (!options2.getSelectAsCurrent() || options2.getRequestFocus()) {
            return false;
        }
        Component focusOwner = IdeFocusManager.getInstance((Project)this.myOwner.getManager().getProject()).getFocusOwner();
        return EditorWindow.hasClientPropertyInHierarchy(focusOwner, FileEditorManagerImpl.OPEN_IN_PREVIEW_TAB);
    }

    private static boolean hasClientPropertyInHierarchy(@Nullable Component owner, @NotNull Key<Boolean> propertyKey) {
        Component parent;
        if (propertyKey == null) {
            EditorWindow.$$$reportNull$$$0(43);
        }
        return (parent = (Component)JBIterable.generate((Object)owner, child2 -> child2.getParent()).find(component2 -> {
            if (component2 instanceof JComponent) {
                return Boolean.TRUE.equals(((JComponent)component2).getClientProperty(propertyKey));
            }
            return false;
        })) != null;
    }

    private void defaultCloseFile(@NotNull VirtualFile file2, boolean transferFocus) {
        if (file2 == null) {
            EditorWindow.$$$reportNull$$$0(44);
        }
        this.closeFile(file2, true, transferFocus);
    }

    private boolean fileCanBeClosed(@NotNull VirtualFile file2, @Nullable VirtualFile fileToIgnore) {
        if (file2 == null) {
            EditorWindow.$$$reportNull$$$0(45);
        }
        return this.isFileOpen(file2) && !file2.equals(fileToIgnore) && !this.isFilePinned(file2);
    }

    @NotNull
    VirtualFile getFileAt(int i2) {
        VirtualFile virtualFile2 = this.getEditorAt(i2).getFile();
        if (virtualFile2 == null) {
            EditorWindow.$$$reportNull$$$0(46);
        }
        return virtualFile2;
    }

    public String toString() {
        return "EditorWindow: files=" + Arrays.asList(this.getFiles());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 21: 
            case 22: 
            case 35: 
            case 39: 
            case 46: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 21: 
            case 22: 
            case 35: 
            case 39: 
            case 46: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 23: 
            case 24: 
            case 26: 
            case 31: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileBeingClosed";
                break;
            }
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 21: 
            case 22: 
            case 35: 
            case 39: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/EditorWindow";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTabsLayoutInfo";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 19: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toSync";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "composite";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseIcon";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "siblingEditor";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "openOptions";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorToFind";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToFind";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/EditorWindow";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getManager";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwner";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabbedPane";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditors";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "findSiblings";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdjacentEditors";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorAt";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabClosingOrder";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileAt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateTabsVisibility";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "closeFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "calcIndexToSelect";
                break;
            }
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 21: 
            case 22: 
            case 35: 
            case 39: 
            case 46: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setForegroundAt";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setTitleAt";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updateTabsLayout";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateFileBackgroundColor";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedEditor";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setEditor";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "syncCaretIfPossible";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findFileEditorIndex";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "updateFileIcon";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "updateFileName";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "decorateFileIcon";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "processSiblingEditor";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "findFileComposite";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findComponentIndex";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "findEditorIndex";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findFileIndex";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isFileOpen";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isFilePinned";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "setFilePinned";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "shouldCloseSelected";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "shouldReservePreview";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "hasClientPropertyInHierarchy";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "defaultCloseFile";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "fileCanBeClosed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 21: 
            case 22: 
            case 35: 
            case 39: 
            case 46: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Service
    public static final class SplitterService {
        private EditorWindow myActiveWindow = null;
        private VirtualFile myFile = null;
        private Runnable mySplitChooserDisposer = null;
        private EditorWindow myInitialEditorWindow = null;

        public void activateSplitChooser(@NotNull EditorWindow window, @NotNull VirtualFile file2, boolean openedFromEditor) {
            if (window == null) {
                SplitterService.$$$reportNull$$$0(0);
            }
            if (file2 == null) {
                SplitterService.$$$reportNull$$$0(1);
            }
            if (this.isActive()) {
                this.stopSplitChooser(true);
            }
            this.myActiveWindow = window;
            this.myFile = file2;
            if (openedFromEditor) {
                this.myInitialEditorWindow = this.myActiveWindow;
            }
            this.mySplitChooserDisposer = this.myActiveWindow.showSplitChooser(true);
        }

        public void switchWindow(@NotNull EditorWindow window) {
            if (window == null) {
                SplitterService.$$$reportNull$$$0(2);
            }
            if (this.mySplitChooserDisposer != null) {
                this.mySplitChooserDisposer.run();
            }
            this.myActiveWindow = window;
            this.mySplitChooserDisposer = this.myActiveWindow.showSplitChooser(false);
        }

        public void stopSplitChooser(boolean interrupted) {
            EditorWindow activeWindow = this.myActiveWindow;
            this.myActiveWindow = null;
            this.myFile = null;
            this.mySplitChooserDisposer.run();
            this.mySplitChooserDisposer = null;
            this.myInitialEditorWindow = null;
            if (!interrupted) {
                activeWindow.requestFocus(true);
            }
        }

        public static SplitterService getInstance() {
            return (SplitterService)ApplicationManager.getApplication().getService(SplitterService.class);
        }

        public boolean isActive() {
            return this.myActiveWindow != null;
        }

        public void nextWindow() {
            if (!this.isActive()) {
                return;
            }
            List<EditorWindow> orderedWindows = this.myActiveWindow.getOwner().getOrderedWindows();
            int index2 = (orderedWindows.indexOf(this.myActiveWindow) + 1) % orderedWindows.size();
            this.switchWindow(orderedWindows.get(index2));
        }

        public void previousWindow() {
            if (!this.isActive()) {
                return;
            }
            List<EditorWindow> orderedWindows = this.myActiveWindow.getOwner().getOrderedWindows();
            int index2 = orderedWindows.indexOf(this.myActiveWindow) - 1;
            index2 = index2 < 0 ? orderedWindows.size() - 1 : index2;
            this.switchWindow(orderedWindows.get(index2));
        }

        public void split(boolean move) {
            EditorWindow activeWindow = this.myActiveWindow;
            EditorWindow initialWindow = this.myInitialEditorWindow;
            VirtualFile file2 = this.myFile;
            RelativePosition position = activeWindow.myPainter.myPosition;
            this.stopSplitChooser(false);
            if (position != RelativePosition.CENTER || initialWindow != activeWindow) {
                if (position == RelativePosition.CENTER) {
                    FileEditorManagerImpl fileEditorManager = activeWindow.getManager();
                    fileEditorManager.openFile(file2, true);
                } else {
                    activeWindow.split(position == RelativePosition.UP || position == RelativePosition.DOWN ? 0 : 1, true, file2, true, position != RelativePosition.LEFT && position != RelativePosition.UP);
                }
                if (initialWindow != null && move) {
                    initialWindow.closeFile(file2, true, false);
                }
            }
        }

        public void setSplitSide(RelativePosition side) {
            if (side != this.myActiveWindow.myPainter.myPosition) {
                this.myActiveWindow.myPainter.positionChanged(side);
            } else {
                Map<RelativePosition, EditorWindow> editors2 = this.myActiveWindow.getAdjacentEditors();
                if (editors2.containsKey((Object)side)) {
                    if (!this.isActive()) {
                        return;
                    }
                    this.switchWindow(editors2.get((Object)side));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "window";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/fileEditor/impl/EditorWindow$SplitterService";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "activateSplitChooser";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "switchWindow";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class MySplitPainter
    extends AbstractPainter {
        private Shape myRectangle;
        private boolean myShowInfoPanel;
        RelativePosition myPosition;

        private MySplitPainter(boolean showInfoPanel) {
            this.myRectangle = EditorWindow.this.getTabbedPane().getTabs().getDropArea();
            this.myPosition = RelativePosition.CENTER;
            this.myShowInfoPanel = showInfoPanel;
        }

        public boolean needsRepaint() {
            return this.myRectangle != null;
        }

        public void executePaint(Component component2, Graphics2D g) {
            if (this.myRectangle == null) {
                return;
            }
            GraphicsUtil.setupAAPainting((Graphics)g);
            g.setColor((Color)JBColor.namedColor((String)"DragAndDrop.areaBackground", (int)4029900, (int)4213335));
            g.fill(this.myRectangle);
            if (this.myPosition == RelativePosition.CENTER && this.myShowInfoPanel) {
                this.drawInfoPanel(component2, g);
            }
        }

        private void drawInfoPanel(Component component2, Graphics2D g) {
            int centerX = this.myRectangle.getBounds().x + this.myRectangle.getBounds().width / 2;
            int centerY = this.myRectangle.getBounds().y + this.myRectangle.getBounds().height / 2;
            int height = Registry.intValue((String)"ide.splitter.chooser.info.panel.height");
            int width = Registry.intValue((String)"ide.splitter.chooser.info.panel.width");
            int arc = Registry.intValue((String)"ide.splitter.chooser.info.panel.arc");
            Function<String, String> getShortcut = actionId -> {
                KeyboardShortcut shortcut = ActionManager.getInstance().getKeyboardShortcut(actionId);
                return KeymapUtil.getKeystrokeText((KeyStroke)(shortcut == null ? null : shortcut.getFirstKeyStroke()));
            };
            String openShortcuts = String.format(IdeBundle.message((String)"split.with.chooser.move.tab", (Object[])new Object[0]), getShortcut.apply("SplitChooser.Split"), SplitterService.getInstance().myInitialEditorWindow != null ? String.format(IdeBundle.message((String)"split.with.chooser.duplicate.tab", (Object[])new Object[0]), getShortcut.apply("SplitChooser.Duplicate")) : "");
            String switchShortcuts = String.format(IdeBundle.message((String)"split.with.chooser.switch.tab", (Object[])new Object[0]), getShortcut.apply("SplitChooser.NextWindow"));
            Font font = UIUtil.getLabelFont();
            FontMetrics fontMetrics = g.getFontMetrics(font);
            int openShortcutsWidth = fontMetrics.stringWidth(openShortcuts);
            int switchShortcutsWidth = fontMetrics.stringWidth(switchShortcuts);
            width = Math.max(width, Math.round((float)Math.max(openShortcutsWidth, switchShortcutsWidth) * 1.2f));
            if ((float)this.myRectangle.getBounds().height < (float)height * 1.2f || (float)this.myRectangle.getBounds().width < (float)width * 1.2f) {
                return;
            }
            RoundRectangle2D.Double rectangle = new RoundRectangle2D.Double((double)centerX - (double)width / 2.0, (double)centerY - (double)height / 2.0, width, height, arc, arc);
            g.setColor(UIUtil.getLabelBackground());
            g.fill(rectangle);
            int arrowsCenterVShift = Registry.intValue((String)"ide.splitter.chooser.info.panel.arrows.shift.center");
            int arrowsVShift = Registry.intValue((String)"ide.splitter.chooser.info.panel.arrows.shift.vertical");
            int arrowsHShift = Registry.intValue((String)"ide.splitter.chooser.info.panel.arrows.shift.horizontal");
            Function<Icon, Point> function = icon2 -> new Point(centerX - icon2.getIconWidth() / 2, centerY - icon2.getIconHeight() / 2 + arrowsCenterVShift);
            Point forUpDownIcons = function.apply(AllIcons.Chooser.Top);
            AllIcons.Chooser.Top.paintIcon(component2, g, forUpDownIcons.x, forUpDownIcons.y - arrowsVShift);
            AllIcons.Chooser.Bottom.paintIcon(component2, g, forUpDownIcons.x, forUpDownIcons.y + arrowsVShift);
            Point forLeftRightIcons = function.apply(AllIcons.Chooser.Right);
            AllIcons.Chooser.Right.paintIcon(component2, g, forLeftRightIcons.x + arrowsHShift, forLeftRightIcons.y);
            AllIcons.Chooser.Left.paintIcon(component2, g, forLeftRightIcons.x - arrowsHShift, forLeftRightIcons.y);
            int textVShift = Registry.intValue((String)"ide.splitter.chooser.info.panel.text.shift");
            int textY = forUpDownIcons.y + AllIcons.Chooser.Bottom.getIconHeight() + textVShift;
            g.setColor(UIUtil.getInactiveTextColor());
            g.setFont(font);
            g.drawString(openShortcuts, centerX - openShortcutsWidth / 2, textY);
            if (EditorWindow.this.getOwner().getWindows().length > 1) {
                g.drawString(switchShortcuts, centerX - switchShortcutsWidth / 2, textY + fontMetrics.getHeight());
            }
        }

        private void positionChanged(RelativePosition position) {
            if (this.myPosition == position) {
                return;
            }
            this.myShowInfoPanel = false;
            this.myPosition = position;
            this.myRectangle = null;
            this.setNeedsRepaint(true);
            Rectangle r = EditorWindow.this.getTabbedPane().getTabs().getDropArea();
            switch (this.myPosition) {
                case CENTER: {
                    break;
                }
                case UP: {
                    r.height /= 2;
                    break;
                }
                case LEFT: {
                    r.width /= 2;
                    break;
                }
                case DOWN: {
                    int h = r.height / 2;
                    r.height -= h;
                    r.y += h;
                    break;
                }
                case RIGHT: {
                    int w = r.width / 2;
                    r.width -= w;
                    r.x += w;
                }
            }
            this.myRectangle = new Rectangle2D.Double(r.x, r.y, r.width, r.height);
        }
    }

    public static enum RelativePosition {
        CENTER(0),
        UP(1),
        LEFT(2),
        DOWN(3),
        RIGHT(4);

        final int mySwingConstant;

        private RelativePosition(int swingConstant) {
            this.mySwingConstant = swingConstant;
        }
    }

    protected static class TComp
    extends JPanel
    implements DataProvider,
    EditorWindowHolder {
        @NotNull
        final EditorWithProviderComposite myEditor;
        protected final EditorWindow myWindow;

        TComp(@NotNull EditorWindow window, @NotNull EditorWithProviderComposite editor) {
            if (window == null) {
                TComp.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                TComp.$$$reportNull$$$0(1);
            }
            super(new BorderLayout());
            this.myEditor = editor;
            this.myWindow = window;
            this.add((Component)editor.getComponent(), "Center");
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (!this.hasFocus()) {
                            return;
                        }
                        JComponent focus = myEditor.getSelectedWithProvider().getFileEditor().getPreferredFocusedComponent();
                        if (focus != null && !focus.hasFocus()) {
                            IdeFocusManager.getGlobalInstance().requestFocus((Component)focus, true);
                        }
                    });
                }
            });
            this.setFocusTraversalPolicy(new FocusTraversalPolicy(){

                @Override
                public Component getComponentAfter(Container aContainer, Component aComponent) {
                    return myEditor.getFocusComponent();
                }

                @Override
                public Component getComponentBefore(Container aContainer, Component aComponent) {
                    return myEditor.getFocusComponent();
                }

                @Override
                public Component getFirstComponent(Container aContainer) {
                    return myEditor.getFocusComponent();
                }

                @Override
                public Component getLastComponent(Container aContainer) {
                    return myEditor.getFocusComponent();
                }

                @Override
                public Component getDefaultComponent(Container aContainer) {
                    return myEditor.getFocusComponent();
                }
            });
            this.setFocusCycleRoot(true);
        }

        @Override
        @NotNull
        public EditorWindow getEditorWindow() {
            EditorWindow editorWindow = this.myWindow;
            if (editorWindow == null) {
                TComp.$$$reportNull$$$0(2);
            }
            return editorWindow;
        }

        @Override
        public Object getData(@NotNull String dataId) {
            if (dataId == null) {
                TComp.$$$reportNull$$$0(3);
            }
            if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
                VirtualFile virtualFile2 = this.myEditor.getFile();
                return virtualFile2.isValid() ? virtualFile2 : null;
            }
            if (CommonDataKeys.PROJECT.is(dataId)) {
                return this.myEditor.getFileEditorManager().getProject();
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "window";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/fileEditor/impl/EditorWindow$TComp";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/fileEditor/impl/EditorWindow$TComp";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditorWindow";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getData";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

