/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.statistics;

import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemActionsCollector;
import com.intellij.openapi.externalSystem.statistics.ProjectImportCollector;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a\u0010\u0010\u0006\u001a\u00020\u00072\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005\u001a0\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0018\u0010\u0010\u001a\u0014\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u0012\u0018\u00010\u0011\u00a8\u0006\u0014"}, d2={"addExternalSystemId", "", "data", "Lcom/intellij/internal/statistic/eventLog/FeatureUsageData;", "systemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "anonymizeSystemId", "", "findPluginInfoBySystemId", "Lcom/intellij/internal/statistic/utils/PluginInfo;", "getAnonymizedSystemId", "importActivityStarted", "Lcom/intellij/internal/statistic/StructuredIdeActivity;", "project", "Lcom/intellij/openapi/project/Project;", "externalSystemId", "dataSupplier", "Lkotlin/Function0;", "", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "intellij.platform.externalSystem.impl"})
public final class ExternalSystemStatUtilKt {
    @NotNull
    public static final String getAnonymizedSystemId(@NotNull ProjectSystemId systemId2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)systemId2, (String)"systemId");
        ExternalSystemManager externalSystemManager = ExternalSystemApiUtil.getManager((ProjectSystemId)systemId2);
        if (externalSystemManager == null) {
            return "undefined.system";
        }
        Intrinsics.checkNotNullExpressionValue((Object)externalSystemManager, (String)"ExternalSystemApiUtil.ge\u2026return \"undefined.system\"");
        ExternalSystemManager manager2 = externalSystemManager;
        if (PluginInfoDetectorKt.getPluginInfo(manager2.getClass()).isDevelopedByJetBrains()) {
            String string2 = systemId2.getReadableName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"systemId.readableName");
        } else {
            string = "third.party";
        }
        return string;
    }

    public static final void addExternalSystemId(@NotNull FeatureUsageData data2, @Nullable ProjectSystemId systemId2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        data2.addData("system_id", ExternalSystemStatUtilKt.anonymizeSystemId(systemId2));
    }

    @NotNull
    public static final String anonymizeSystemId(@Nullable ProjectSystemId systemId2) {
        Object object;
        block3: {
            block2: {
                object = systemId2;
                if (object == null) break block2;
                ProjectSystemId projectSystemId = object;
                boolean bl = false;
                boolean bl2 = false;
                ProjectSystemId it = projectSystemId;
                boolean bl3 = false;
                object = ExternalSystemStatUtilKt.getAnonymizedSystemId(it);
                if (object != null) break block3;
            }
            object = "undefined.system";
        }
        return object;
    }

    @Nullable
    public static final PluginInfo findPluginInfoBySystemId(@Nullable ProjectSystemId systemId2) {
        if (systemId2 == null) {
            return null;
        }
        ExternalSystemManager externalSystemManager = ExternalSystemApiUtil.getManager((ProjectSystemId)systemId2);
        if (externalSystemManager == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)externalSystemManager, (String)"ExternalSystemApiUtil.ge\u2026(systemId) ?: return null");
        ExternalSystemManager manager2 = externalSystemManager;
        PluginInfo pluginInfo = PluginInfoDetectorKt.getPluginInfo(manager2.getClass());
        return pluginInfo.isDevelopedByJetBrains() ? pluginInfo : null;
    }

    @NotNull
    public static final StructuredIdeActivity importActivityStarted(@NotNull Project project, @NotNull ProjectSystemId externalSystemId2, @Nullable Function0<? extends List<? extends EventPair<?>>> dataSupplier) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)externalSystemId2, (String)"externalSystemId");
        return ProjectImportCollector.IMPORT_ACTIVITY.started(project, new Function0<List<? extends EventPair<?>>>(externalSystemId2, dataSupplier){
            final /* synthetic */ ProjectSystemId $externalSystemId;
            final /* synthetic */ Function0 $dataSupplier;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<EventPair<?>> invoke() {
                void var1_1;
                List data2 = CollectionsKt.mutableListOf((Object[])new EventPair[]{ExternalSystemActionsCollector.Companion.getEXTERNAL_SYSTEM_ID().with((Object)ExternalSystemStatUtilKt.anonymizeSystemId(this.$externalSystemId))});
                PluginInfo pluginInfo = ExternalSystemStatUtilKt.findPluginInfoBySystemId(this.$externalSystemId);
                if (pluginInfo != null) {
                    data2.add(EventFields.PluginInfo.with((Object)pluginInfo));
                }
                if (this.$dataSupplier != null) {
                    data2.addAll((Collection)this.$dataSupplier.invoke());
                }
                return var1_1;
            }
            {
                this.$externalSystemId = projectSystemId;
                this.$dataSupplier = function0;
                super(0);
            }
        });
    }
}

