/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.ui.completetion;

import com.intellij.openapi.externalSystem.service.ui.completetion.AbstractTextCompletionContributor;
import com.intellij.openapi.externalSystem.service.ui.completetion.JTextCompletionContributor$WhenMappings;
import com.intellij.openapi.externalSystem.service.ui.completetion.TextCompletionContributor;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b'\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0013\u0014B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/externalSystem/service/ui/completetion/JTextCompletionContributor;", "Lcom/intellij/openapi/externalSystem/service/ui/completetion/AbstractTextCompletionContributor;", "Ljavax/swing/text/JTextComponent;", "completionType", "Lcom/intellij/openapi/externalSystem/service/ui/completetion/JTextCompletionContributor$CompletionType;", "(Lcom/intellij/openapi/externalSystem/service/ui/completetion/JTextCompletionContributor$CompletionType;)V", "getCaretPosition", "", "owner", "getTextToComplete", "", "getWordRange", "Lkotlin/ranges/IntRange;", "offset", "insert", "", "variant", "Lcom/intellij/openapi/externalSystem/service/ui/completetion/TextCompletionContributor$TextCompletionInfo;", "replace", "Companion", "CompletionType", "intellij.platform.externalSystem.impl"})
@ApiStatus.Experimental
public abstract class JTextCompletionContributor
extends AbstractTextCompletionContributor<JTextComponent> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public String getTextToComplete(@NotNull JTextComponent owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        int caretPosition = this.getCaretPosition(owner);
        IntRange wordRange = this.getWordRange(owner, caretPosition);
        IntRange textToCompleteRange = RangesKt.until((int)wordRange.getFirst(), (int)caretPosition);
        String string = owner.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"owner.text");
        return StringsKt.substring((String)string, (IntRange)textToCompleteRange);
    }

    private final IntRange getWordRange(JTextComponent owner, int offset) {
        int wordStartPosition = 0;
        String string = owner.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"owner.text");
        for (String word : StringsKt.split$default((CharSequence)string, (String[])new String[]{" "}, (boolean)false, (int)0, (int)6, null)) {
            int wordEndPosition;
            int n = offset;
            if (wordStartPosition <= n && (wordEndPosition = wordStartPosition + word.length()) >= n) {
                return RangesKt.until((int)wordStartPosition, (int)wordEndPosition);
            }
            wordStartPosition = wordEndPosition + 1;
        }
        throw (Throwable)new BadLocationException(owner.getText(), offset);
    }

    private final int getCaretPosition(JTextComponent owner) {
        int n = 0;
        int n2 = owner.getText().length();
        int n3 = owner.getCaretPosition();
        boolean bl = false;
        n2 = Math.min(n2, n3);
        n3 = 0;
        return Math.max(n, n2);
    }

    private final void insert(JTextComponent owner, TextCompletionContributor.TextCompletionInfo variant) {
        String textToComplete = this.getTextToComplete(owner);
        String textCompletionSuffix = StringsKt.removePrefix((String)variant.getText(), (CharSequence)textToComplete);
        int caretPosition = this.getCaretPosition(owner);
        owner.getDocument().insertString(caretPosition, textCompletionSuffix, null);
    }

    private final void replace(JTextComponent owner, TextCompletionContributor.TextCompletionInfo variant) {
        int caretPosition = this.getCaretPosition(owner);
        IntRange wordRange = this.getWordRange(owner, caretPosition);
        owner.getDocument().remove(caretPosition, wordRange.getLast() - caretPosition + 1);
        IntRange textToCompleteRange = RangesKt.until((int)wordRange.getFirst(), (int)caretPosition);
        String string = owner.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"owner.text");
        String textToComplete = StringsKt.substring((String)string, (IntRange)textToCompleteRange);
        String textCompletionSuffix = StringsKt.removePrefix((String)variant.getText(), (CharSequence)textToComplete);
        owner.getDocument().insertString(caretPosition, textCompletionSuffix, null);
    }

    public JTextCompletionContributor(final @NotNull CompletionType completionType) {
        Intrinsics.checkNotNullParameter((Object)((Object)completionType), (String)"completionType");
        this.whenVariantChosen((Function2)new Function2<JTextComponent, TextCompletionContributor.TextCompletionInfo, Unit>(){

            public final void invoke(@NotNull JTextComponent owner, @NotNull TextCompletionContributor.TextCompletionInfo variant) {
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
                switch (JTextCompletionContributor$WhenMappings.$EnumSwitchMapping$0[completionType.ordinal()]) {
                    case 1: {
                        this.insert(owner, variant);
                        break;
                    }
                    case 2: {
                        this.replace(owner, variant);
                        break;
                    }
                }
            }
        });
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/externalSystem/service/ui/completetion/JTextCompletionContributor$CompletionType;", "", "(Ljava/lang/String;I)V", "INSERT", "REPLACE", "intellij.platform.externalSystem.impl"})
    public static final class CompletionType
    extends Enum<CompletionType> {
        public static final /* enum */ CompletionType INSERT;
        public static final /* enum */ CompletionType REPLACE;
        private static final /* synthetic */ CompletionType[] $VALUES;

        static {
            CompletionType[] completionTypeArray = new CompletionType[2];
            CompletionType[] completionTypeArray2 = completionTypeArray;
            completionTypeArray[0] = INSERT = new CompletionType();
            completionTypeArray[1] = REPLACE = new CompletionType();
            $VALUES = completionTypeArray;
        }

        public static CompletionType[] values() {
            return (CompletionType[])$VALUES.clone();
        }

        public static CompletionType valueOf(String string) {
            return Enum.valueOf(CompletionType.class, string);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\b\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/externalSystem/service/ui/completetion/JTextCompletionContributor$Companion;", "", "()V", "create", "Lcom/intellij/openapi/externalSystem/service/ui/completetion/JTextCompletionContributor;", "completionType", "Lcom/intellij/openapi/externalSystem/service/ui/completetion/JTextCompletionContributor$CompletionType;", "completionVariants", "Lkotlin/Function1;", "", "", "Lcom/intellij/openapi/externalSystem/service/ui/completetion/TextCompletionContributor$TextCompletionInfo;", "intellij.platform.externalSystem.impl"})
    public static final class Companion {
        @NotNull
        public final JTextCompletionContributor create(@NotNull CompletionType completionType, @NotNull Function1<? super String, ? extends List<TextCompletionContributor.TextCompletionInfo>> completionVariants) {
            Intrinsics.checkNotNullParameter((Object)((Object)completionType), (String)"completionType");
            Intrinsics.checkNotNullParameter(completionVariants, (String)"completionVariants");
            return new JTextCompletionContributor(completionVariants, completionType, completionType){
                final /* synthetic */ Function1 $completionVariants;
                final /* synthetic */ CompletionType $completionType;

                @NotNull
                public List<TextCompletionContributor.TextCompletionInfo> getCompletionVariants(@NotNull JTextComponent owner, @NotNull String textToComplete) {
                    Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                    Intrinsics.checkNotNullParameter((Object)textToComplete, (String)"textToComplete");
                    return (List)this.$completionVariants.invoke((Object)textToComplete);
                }
                {
                    this.$completionVariants = $captured_local_variable$0;
                    this.$completionType = $captured_local_variable$1;
                    super($super_call_param$2);
                }
            };
        }

        public static /* synthetic */ JTextCompletionContributor create$default(Companion companion, CompletionType completionType, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                completionType = CompletionType.INSERT;
            }
            return companion.create(completionType, (Function1<? super String, ? extends List<TextCompletionContributor.TextCompletionInfo>>)function1);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

