/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project;

import com.intellij.ide.impl.TrustChangeNotifier;
import com.intellij.ide.impl.TrustedProjects;
import com.intellij.ide.impl.UntrustedProjectEditorNotificationPanel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.importing.ImportSpecBuilder;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.project.ExternalResolverIsSafe;
import com.intellij.openapi.externalSystem.service.project.UntrustedProjectModeProvider;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00132\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00012\u00020\u0003:\u0003\u0013\u0014\u0015B\u0005\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\"\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001b\u0010\u000f\u001a\u0015\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00020\u00020\u0010\u00a2\u0006\u0002\b\u0012H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/UntrustedProjectNotificationProvider;", "Lcom/intellij/ui/EditorNotifications$Provider;", "Lcom/intellij/ui/EditorNotificationPanel;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "collectUntrustedProjectModeProviders", "", "Lcom/intellij/openapi/externalSystem/service/project/UntrustedProjectModeProvider;", "createNotificationPanel", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "project", "Lcom/intellij/openapi/project/Project;", "getKey", "Lcom/intellij/openapi/util/Key;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "Companion", "ExternalSystemUntrustedProjectModeProvider", "TrustedListener", "intellij.platform.externalSystem.impl"})
public final class UntrustedProjectNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel>
implements DumbAware {
    private static final ExtensionPointName<UntrustedProjectModeProvider> EP_NAME;
    private static final Key<EditorNotificationPanel> KEY;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor, @NotNull Project project) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fileEditor, (String)"fileEditor");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (TrustedProjects.isTrusted(project)) {
            return null;
        }
        Iterable iterable = this.collectUntrustedProjectModeProviders();
        boolean $i$f$filter = false;
        void var7_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            UntrustedProjectModeProvider it = (UntrustedProjectModeProvider)element$iv$iv;
            boolean bl = false;
            if (!it.shouldShowEditorNotification(project)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List providers = (List)destination$iv$iv;
        if (providers.isEmpty()) {
            return null;
        }
        return new UntrustedProjectEditorNotificationPanel(project, fileEditor, (Function0<Unit>)((Function0)new Function0<Unit>(project, providers){
            final /* synthetic */ Project $project;
            final /* synthetic */ List $providers;

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                Collection<ProjectSystemId> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = this.$providers;
                Project project = this.$project;
                boolean $i$f$map = false;
                void var3_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    UntrustedProjectModeProvider untrustedProjectModeProvider = (UntrustedProjectModeProvider)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    ProjectSystemId projectSystemId = it.getSystemId();
                    collection.add(projectSystemId);
                }
                collection = (List)destination$iv$iv;
                if (ExternalSystemUtil.confirmLoadingUntrustedProject(project, collection)) {
                    for (UntrustedProjectModeProvider provider2 : this.$providers) {
                        provider2.loadAllLinkedProjects(this.$project);
                    }
                }
            }
            {
                this.$project = project;
                this.$providers = list2;
                super(0);
            }
        }));
    }

    private final Collection<UntrustedProjectModeProvider> collectUntrustedProjectModeProviders() {
        LinkedHashMap providers = new LinkedHashMap();
        ExternalSystemManager.EP_NAME.forEachExtensionSafe(new Consumer(providers){
            final /* synthetic */ LinkedHashMap $providers;

            public final void accept(ExternalSystemManager<?, ?, ?, ?, ?> it) {
                Map map2 = this.$providers;
                ExternalSystemManager<?, ?, ?, ?, ?> externalSystemManager = it;
                Intrinsics.checkNotNullExpressionValue(externalSystemManager, (String)"it");
                ProjectSystemId projectSystemId = externalSystemManager.getSystemId();
                Intrinsics.checkNotNullExpressionValue((Object)projectSystemId, (String)"it.systemId");
                map2.put(projectSystemId, new ExternalSystemUntrustedProjectModeProvider(it));
            }
            {
                this.$providers = linkedHashMap;
            }
        });
        EP_NAME.forEachExtensionSafe(new Consumer(providers){
            final /* synthetic */ LinkedHashMap $providers;

            public final void accept(UntrustedProjectModeProvider it) {
                Map map2 = this.$providers;
                ProjectSystemId projectSystemId = it.getSystemId();
                boolean bl = false;
                Map map3 = map2;
                boolean bl2 = false;
                if (map3.containsKey(projectSystemId)) {
                    UntrustedProjectNotificationProvider.access$getLOG$cp().warn(it.getClass().getSimpleName() + " for " + it.getSystemId() + " registered automatically");
                }
                Map map4 = this.$providers;
                ProjectSystemId projectSystemId2 = it.getSystemId();
                UntrustedProjectModeProvider untrustedProjectModeProvider = it;
                Intrinsics.checkNotNullExpressionValue((Object)untrustedProjectModeProvider, (String)"it");
                map4.put(projectSystemId2, untrustedProjectModeProvider);
            }
            {
                this.$providers = linkedHashMap;
            }
        });
        Collection<UntrustedProjectModeProvider> collection = providers.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"providers.values");
        return collection;
    }

    static {
        Companion = new Companion(null);
        ExtensionPointName extensionPointName = ExtensionPointName.create((String)"com.intellij.untrustedModeProvider");
        Intrinsics.checkNotNullExpressionValue((Object)extensionPointName, (String)"ExtensionPointName.creat\u2026j.untrustedModeProvider\")");
        EP_NAME = extensionPointName;
        Key key = Key.create((String)"UntrustedProjectNotification");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create<EditorNotific\u2026stedProjectNotification\")");
        KEY = key;
        Logger logger = Logger.getInstance(UntrustedProjectNotificationProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(Untru\u2026tionProvider::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/UntrustedProjectNotificationProvider$TrustedListener;", "Lcom/intellij/ide/impl/TrustChangeNotifier;", "()V", "projectTrusted", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.externalSystem.impl"})
    public static final class TrustedListener
    implements TrustChangeNotifier {
        @Override
        public void projectTrusted(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            EditorNotifications.getInstance((Project)project).updateAllNotifications();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u001a\u0010\u0002\u001a\u0016\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016R\"\u0010\u0002\u001a\u0016\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/UntrustedProjectNotificationProvider$ExternalSystemUntrustedProjectModeProvider;", "Lcom/intellij/openapi/externalSystem/service/project/UntrustedProjectModeProvider;", "manager", "Lcom/intellij/openapi/externalSystem/ExternalSystemManager;", "(Lcom/intellij/openapi/externalSystem/ExternalSystemManager;)V", "systemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "Lorg/jetbrains/annotations/NotNull;", "getSystemId", "()Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "loadAllLinkedProjects", "", "project", "Lcom/intellij/openapi/project/Project;", "shouldShowEditorNotification", "", "intellij.platform.externalSystem.impl"})
    private static final class ExternalSystemUntrustedProjectModeProvider
    implements UntrustedProjectModeProvider {
        @NotNull
        private final ProjectSystemId systemId;
        private final ExternalSystemManager<?, ?, ?, ?, ?> manager;

        @NotNull
        public ProjectSystemId getSystemId() {
            return this.systemId;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean shouldShowEditorNotification(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            AbstractExternalSystemSettings settings2 = (AbstractExternalSystemSettings)this.manager.getSettingsProvider().fun((Object)project);
            if (ExternalResolverIsSafe.executesTrustedCodeOnly((ProjectSystemId)this.getSystemId())) return false;
            AbstractExternalSystemSettings abstractExternalSystemSettings = settings2;
            Intrinsics.checkNotNullExpressionValue((Object)abstractExternalSystemSettings, (String)"settings");
            Collection collection = abstractExternalSystemSettings.getLinkedProjectsSettings();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"settings.linkedProjectsSettings");
            Collection collection2 = collection;
            boolean bl = false;
            if (collection2.isEmpty()) return false;
            return true;
        }

        public void loadAllLinkedProjects(@NotNull Project project) {
            AbstractExternalSystemSettings settings2;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            AbstractExternalSystemSettings abstractExternalSystemSettings = settings2 = (AbstractExternalSystemSettings)this.manager.getSettingsProvider().fun((Object)project);
            Intrinsics.checkNotNullExpressionValue((Object)abstractExternalSystemSettings, (String)"settings");
            Iterator iterator2 = abstractExternalSystemSettings.getLinkedProjectsSettings().iterator();
            while (iterator2.hasNext()) {
                ExternalProjectSettings linkedProjectSettings;
                ExternalProjectSettings externalProjectSettings = linkedProjectSettings = (ExternalProjectSettings)iterator2.next();
                Intrinsics.checkNotNullExpressionValue((Object)externalProjectSettings, (String)"linkedProjectSettings");
                String externalProjectPath = externalProjectSettings.getExternalProjectPath();
                ExternalSystemUtil.refreshProject(externalProjectPath, new ImportSpecBuilder(project, this.getSystemId()));
            }
        }

        public ExternalSystemUntrustedProjectModeProvider(@NotNull ExternalSystemManager<?, ?, ?, ?, ?> manager2) {
            Intrinsics.checkNotNullParameter(manager2, (String)"manager");
            this.manager = manager2;
            ProjectSystemId projectSystemId = this.manager.getSystemId();
            Intrinsics.checkNotNullExpressionValue((Object)projectSystemId, (String)"manager.systemId");
            this.systemId = projectSystemId;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\b\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\n0\n0\t\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/UntrustedProjectNotificationProvider$Companion;", "", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/openapi/externalSystem/service/project/UntrustedProjectModeProvider;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/ui/EditorNotificationPanel;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.externalSystem.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

