/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.build.BuildProgressListener;
import com.intellij.build.BuildProgressObservable;
import com.intellij.build.BuildViewProblemsService;
import com.intellij.build.ViewManager;
import com.intellij.build.events.BuildEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.DisposableWrapperList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00162\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u0016B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfigurationViewManager;", "Lcom/intellij/build/ViewManager;", "Lcom/intellij/build/BuildProgressListener;", "Lcom/intellij/build/BuildProgressObservable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "listeners", "Lcom/intellij/util/containers/DisposableWrapperList;", "addListener", "", "listener", "disposable", "Lcom/intellij/openapi/Disposable;", "isBuildContentView", "", "isConsoleEnabledByDefault", "onEvent", "buildId", "", "event", "Lcom/intellij/build/events/BuildEvent;", "Companion", "intellij.platform.externalSystem.impl"})
public final class ExternalSystemRunConfigurationViewManager
implements ViewManager,
BuildProgressListener,
BuildProgressObservable {
    private final DisposableWrapperList<BuildProgressListener> listeners;
    private static final Logger logger;
    @NotNull
    public static final Companion Companion;

    public boolean isConsoleEnabledByDefault() {
        return true;
    }

    public boolean isBuildContentView() {
        return false;
    }

    @Override
    public void addListener(@NotNull BuildProgressListener listener2, @NotNull Disposable disposable2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)disposable2, (String)"disposable");
        this.listeners.add((Object)listener2, disposable2);
    }

    public void onEvent(@NotNull Object buildId, @NotNull BuildEvent event) {
        Intrinsics.checkNotNullParameter((Object)buildId, (String)"buildId");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        for (BuildProgressListener listener2 : this.listeners) {
            try {
                listener2.onEvent(buildId, event);
            }
            catch (Exception e) {
                logger.warn((Throwable)e);
            }
        }
    }

    public ExternalSystemRunConfigurationViewManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.listeners = new DisposableWrapperList();
        Project $this$service$iv = project;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(BuildViewProblemsService.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        ((BuildViewProblemsService)object).listenToBuildView(this);
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ExternalSystemRunConfigurationViewManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        ExternalSystemRunConfigurationViewManager.logger = logger;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfigurationViewManager$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.externalSystem.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

