/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.action.ExternalSystemAction;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalConfigPathAware;
import com.intellij.openapi.externalSystem.service.settings.ExternalSystemConfigLocator;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemActionsCollector;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExternalSystemNodeAction<T>
extends ExternalSystemAction {
    private final Class<T> myExternalDataClazz;

    public ExternalSystemNodeAction(Class<T> externalDataClazz) {
        this.myExternalDataClazz = externalDataClazz;
    }

    @Override
    protected boolean isEnabled(@NotNull AnActionEvent e) {
        if (e == null) {
            ExternalSystemNodeAction.$$$reportNull$$$0(0);
        }
        return super.isEnabled(e) && this.getSystemId(e) != null && this.getExternalData(e, this.myExternalDataClazz) != null;
    }

    protected abstract void perform(@NotNull Project var1, @NotNull ProjectSystemId var2, @NotNull T var3, @NotNull AnActionEvent var4);

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ExternalSystemNodeAction.$$$reportNull$$$0(1);
        }
        if ((project = this.getProject(e)) == null) {
            return;
        }
        ProjectSystemId projectSystemId = this.getSystemId(e);
        if (projectSystemId == null) {
            return;
        }
        T data2 = this.getExternalData(e, this.myExternalDataClazz);
        if (data2 == null) {
            return;
        }
        ExternalSystemActionsCollector.trigger(project, projectSystemId, this, e);
        this.perform(project, projectSystemId, data2, e);
    }

    @Nullable
    protected ExternalSystemUiAware getExternalSystemUiAware(@NotNull AnActionEvent e) {
        if (e == null) {
            ExternalSystemNodeAction.$$$reportNull$$$0(2);
        }
        return (ExternalSystemUiAware)e.getData(ExternalSystemDataKeys.UI_AWARE);
    }

    @Nullable
    protected <T> T getExternalData(@NotNull AnActionEvent e, Class<T> dataClass) {
        ExternalSystemNode node2;
        if (e == null) {
            ExternalSystemNodeAction.$$$reportNull$$$0(3);
        }
        return (node2 = (ExternalSystemNode)ContainerUtil.getFirstItem((List)((List)e.getData(ExternalSystemDataKeys.SELECTED_NODES)))) != null && dataClass.isInstance(node2.getData()) ? (T)node2.getData() : null;
    }

    protected boolean isIgnoredNode(@NotNull AnActionEvent e) {
        ExternalSystemNode node2;
        if (e == null) {
            ExternalSystemNodeAction.$$$reportNull$$$0(4);
        }
        return (node2 = (ExternalSystemNode)ContainerUtil.getFirstItem((List)((List)e.getData(ExternalSystemDataKeys.SELECTED_NODES)))) != null && this.myExternalDataClazz.isInstance(node2.getData()) && node2.isIgnored();
    }

    @Nullable
    protected VirtualFile getExternalConfig(@NotNull ExternalConfigPathAware data2, ProjectSystemId externalSystemId2) {
        if (data2 == null) {
            ExternalSystemNodeAction.$$$reportNull$$$0(5);
        }
        String path2 = data2.getLinkedExternalProjectPath();
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        VirtualFile externalSystemConfigPath = fileSystem.refreshAndFindFileByPath(path2);
        if (externalSystemConfigPath == null) {
            return null;
        }
        VirtualFile toOpen = externalSystemConfigPath;
        for (ExternalSystemConfigLocator locator : (ExternalSystemConfigLocator[])ExternalSystemConfigLocator.EP_NAME.getExtensions()) {
            if (!externalSystemId2.equals((Object)locator.getTargetExternalSystemId())) continue;
            if ((toOpen = locator.adjust(toOpen)) != null) break;
            return null;
        }
        return toOpen.isDirectory() ? null : toOpen;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/externalSystem/action/ExternalSystemNodeAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getExternalSystemUiAware";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getExternalData";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isIgnoredNode";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getExternalConfig";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

