/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.editor.CustomFoldRegion;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.editor.impl.SoftWrapModelImpl;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapDrawingType;
import com.intellij.openapi.editor.impl.view.EditorView;
import com.intellij.openapi.editor.impl.view.VisualLineFragmentsIterator;
import com.intellij.openapi.editor.impl.view.VisualLinesIterator;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ObjectUtils;
import java.awt.geom.Point2D;
import java.util.List;
import javax.swing.JScrollBar;
import org.jetbrains.annotations.NotNull;

final class EditorCoordinateMapper {
    private final EditorView myView;
    private final Document myDocument;
    private final FoldingModelImpl myFoldingModel;

    EditorCoordinateMapper(EditorView view) {
        this.myView = view;
        this.myDocument = this.myView.getEditor().getDocument();
        this.myFoldingModel = this.myView.getEditor().getFoldingModel();
    }

    public int[] visualLineToYRange(int line) {
        if (line < 0) {
            line = 0;
        }
        int offset = line >= this.myView.getEditor().getVisibleLineCount() ? this.myDocument.getTextLength() + 1 : this.visualLineToOffset(line);
        int lineHeight = this.myView.getLineHeight();
        FoldingModelImpl foldingModel = this.myView.getEditor().getFoldingModel();
        int idx = foldingModel.getLastCollapsedRegionBefore(offset);
        int[] adjustment = foldingModel.getCustomRegionsYAdjustment(offset, idx);
        int startY = this.myView.getInsets().top + line * lineHeight + adjustment[0] + this.myView.getEditor().getInlayModel().getHeightOfBlockElementsBeforeVisualLine(line, offset, idx);
        return new int[]{startY, startY + lineHeight + adjustment[1]};
    }

    int visualLineToY(int line) {
        return this.visualLineToYRange(line)[0];
    }

    int yToVisualLine(int y) {
        int lineHeight = this.myView.getLineHeight();
        if ((y = Math.max(0, y - this.myView.getInsets().top)) < lineHeight) {
            return 0;
        }
        int lineMin = 0;
        int yMin = 0;
        int lineMax = this.myView.getEditor().getVisibleLineCount() - 1;
        int yMax = this.visualLineToY(lineMax + 1);
        if (y >= yMax) {
            return lineMax + 1 + (y - yMax) / lineHeight;
        }
        while (lineMin < lineMax) {
            if (yMax - yMin == (lineMax - lineMin + 1) * lineHeight) {
                return lineMin + (y - yMin) / lineHeight;
            }
            int lineMid = (lineMin + lineMax) / 2;
            int[] yMidRange = this.visualLineToYRange(lineMid);
            if (y < yMidRange[0]) {
                int yMidMin = yMidRange[0] - this.getInlaysHeight(lineMid, true);
                if (y >= yMidMin) {
                    return lineMid;
                }
                lineMax = lineMid - 1;
                yMax = yMidMin;
                continue;
            }
            int yMidMax = yMidRange[1] + this.getInlaysHeight(lineMid, false);
            if (y < yMidMax) {
                return lineMid;
            }
            lineMin = lineMid + 1;
            yMin = yMidMax;
        }
        return lineMin;
    }

    private int getInlaysHeight(int visualLine, boolean above) {
        return EditorUtil.getInlaysHeight(this.myView.getEditor(), visualLine, above);
    }

    @NotNull
    LogicalPosition offsetToLogicalPosition(int offset) {
        LogicalPosition logicalPosition = this.myView.getLogicalPositionCache().offsetToLogicalPosition(offset);
        if (logicalPosition == null) {
            EditorCoordinateMapper.$$$reportNull$$$0(0);
        }
        return logicalPosition;
    }

    int logicalPositionToOffset(@NotNull LogicalPosition pos) {
        if (pos == null) {
            EditorCoordinateMapper.$$$reportNull$$$0(1);
        }
        return this.myView.getLogicalPositionCache().logicalPositionToOffset(pos);
    }

    @NotNull
    VisualPosition logicalToVisualPosition(@NotNull LogicalPosition pos, boolean beforeSoftWrap) {
        if (pos == null) {
            EditorCoordinateMapper.$$$reportNull$$$0(2);
        }
        int line = pos.line;
        int column2 = pos.column;
        int logicalLineCount = Math.max(1, this.myDocument.getLineCount());
        if (line >= logicalLineCount) {
            return new VisualPosition(line - logicalLineCount + this.myView.getEditor().getVisibleLineCount(), column2, pos.leansForward);
        }
        int offset = this.logicalPositionToOffset(pos);
        int visualLine = this.offsetToVisualLine(offset, beforeSoftWrap);
        int maxVisualColumn = 0;
        int maxLogicalColumn = 0;
        int endLogicalLine = line;
        for (VisualLineFragmentsIterator.Fragment fragment2 : VisualLineFragmentsIterator.create(this.myView, offset, beforeSoftWrap)) {
            if (!pos.leansForward && offset == fragment2.getVisualLineStartOffset()) {
                return new VisualPosition(visualLine, fragment2.getStartVisualColumn());
            }
            endLogicalLine = fragment2.getEndLogicalLine();
            maxVisualColumn = fragment2.getEndVisualColumn();
            FoldRegion foldRegion = fragment2.getCurrentFoldRegion();
            if (foldRegion != null) {
                if (foldRegion instanceof CustomFoldRegion) {
                    return new VisualPosition(visualLine, 0);
                }
                int startLogicalLine = fragment2.getStartLogicalLine();
                int startLogicalColumn = fragment2.getStartLogicalColumn();
                int endLogicalColumn = fragment2.getEndLogicalColumn();
                if ((line > startLogicalLine || line == startLogicalLine && (column2 > startLogicalColumn || column2 == startLogicalColumn && pos.leansForward)) && (line < endLogicalLine || line == endLogicalLine && column2 < endLogicalColumn)) {
                    return new VisualPosition(visualLine, fragment2.getStartVisualColumn(), true);
                }
                if (line == endLogicalLine && column2 == endLogicalColumn && !pos.leansForward) {
                    return new VisualPosition(visualLine, maxVisualColumn);
                }
                maxLogicalColumn = startLogicalLine == endLogicalLine ? Math.max(maxLogicalColumn, endLogicalColumn) : endLogicalColumn;
                continue;
            }
            if (fragment2.getCurrentInlay() != null) continue;
            int minColumn = fragment2.getMinLogicalColumn();
            int maxColumn = fragment2.getMaxLogicalColumn();
            if (line == fragment2.getStartLogicalLine() && (column2 > minColumn && column2 < maxColumn || column2 == minColumn && pos.leansForward || column2 == maxColumn && !pos.leansForward)) {
                return new VisualPosition(visualLine, fragment2.logicalToVisualColumn(column2), fragment2.isRtl() ^ pos.leansForward);
            }
            maxLogicalColumn = Math.max(maxLogicalColumn, maxColumn);
        }
        int resultColumn = maxVisualColumn + this.logToVisWithInlays(endLogicalLine, column2 - maxLogicalColumn, pos.leansForward);
        if (resultColumn < 0) {
            resultColumn = Integer.MAX_VALUE;
        }
        return new VisualPosition(visualLine, resultColumn, pos.leansForward);
    }

    private int logToVisWithInlays(int logLine, int remainingLogColumn, boolean leansForward) {
        if (remainingLogColumn > 1 || remainingLogColumn == 1 && leansForward) {
            remainingLogColumn += this.myView.getEditor().getInlayModel().getAfterLineEndElementsForLogicalLine(logLine).size();
        }
        return remainingLogColumn;
    }

    private int visToLogWithInlays(int logLine, int remainingVisColumns, boolean[] leansForward) {
        if (remainingVisColumns == 0) {
            return 0;
        }
        int inlayCount = this.myView.getEditor().getInlayModel().getAfterLineEndElementsForLogicalLine(logLine).size();
        if (inlayCount == 0) {
            return remainingVisColumns;
        }
        if (remainingVisColumns < inlayCount + 1) {
            leansForward[0] = false;
            return 1;
        }
        if (remainingVisColumns == inlayCount + 1) {
            leansForward[0] = true;
        }
        return remainingVisColumns - inlayCount;
    }

    @NotNull
    LogicalPosition visualToLogicalPosition(@NotNull VisualPosition pos) {
        if (pos == null) {
            EditorCoordinateMapper.$$$reportNull$$$0(3);
        }
        int line = pos.line;
        int column2 = pos.column;
        int visualLineCount = this.myView.getEditor().getVisibleLineCount();
        if (line >= visualLineCount) {
            return new LogicalPosition(line - visualLineCount + this.myDocument.getLineCount(), column2, pos.leansRight);
        }
        int offset = this.visualLineToOffset(line);
        int logicalLine = this.myDocument.getLineNumber(offset);
        int maxVisualColumn = 0;
        int maxLogicalColumn = 0;
        int maxOffset = offset;
        LogicalPosition delayedResult = null;
        boolean delayedInlay = false;
        for (VisualLineFragmentsIterator.Fragment fragment2 : VisualLineFragmentsIterator.create(this.myView, offset, false)) {
            FoldRegion foldRegion = fragment2.getCurrentFoldRegion();
            if (foldRegion instanceof CustomFoldRegion) {
                return new LogicalPosition(fragment2.getStartLogicalLine(), fragment2.getStartLogicalColumn());
            }
            int minColumn = fragment2.getStartVisualColumn();
            int maxColumn = fragment2.getEndVisualColumn();
            if (delayedResult != null && minColumn != maxColumn) {
                LogicalPosition logicalPosition = delayedInlay ? delayedResult.leanForward(fragment2.getCurrentInlay() == null) : delayedResult;
                if (logicalPosition == null) {
                    EditorCoordinateMapper.$$$reportNull$$$0(4);
                }
                return logicalPosition;
            }
            if (column2 < minColumn || column2 == minColumn && !pos.leansRight && minColumn != maxColumn) {
                LogicalPosition logicalPosition = this.offsetToLogicalPosition(offset);
                if (logicalPosition == null) {
                    EditorCoordinateMapper.$$$reportNull$$$0(5);
                }
                return logicalPosition;
            }
            if (column2 > minColumn && column2 < maxColumn || column2 == minColumn || column2 == maxColumn && !pos.leansRight) {
                delayedInlay = fragment2.getCurrentInlay() != null;
                delayedResult = new LogicalPosition(column2 == maxColumn ? fragment2.getEndLogicalLine() : fragment2.getStartLogicalLine(), fragment2.visualToLogicalColumn(column2), foldRegion != null ? column2 < maxColumn : !delayedInlay && fragment2.isRtl() ^ pos.leansRight);
                if (column2 != maxColumn) {
                    LogicalPosition logicalPosition = delayedResult;
                    if (logicalPosition == null) {
                        EditorCoordinateMapper.$$$reportNull$$$0(6);
                    }
                    return logicalPosition;
                }
            }
            maxLogicalColumn = logicalLine == fragment2.getEndLogicalLine() ? Math.max(maxLogicalColumn, fragment2.getMaxLogicalColumn()) : fragment2.getMaxLogicalColumn();
            maxVisualColumn = maxColumn;
            logicalLine = fragment2.getEndLogicalLine();
            maxOffset = Math.max(maxOffset, fragment2.getMaxOffset());
        }
        if (delayedResult != null && !delayedInlay) {
            LogicalPosition logicalPosition = delayedResult;
            if (logicalPosition == null) {
                EditorCoordinateMapper.$$$reportNull$$$0(7);
            }
            return logicalPosition;
        }
        if (this.myView.getEditor().getSoftWrapModel().getSoftWrap(maxOffset) == null) {
            boolean[] leansForward = new boolean[]{pos.leansRight};
            int resultColumn = maxLogicalColumn + this.visToLogWithInlays(logicalLine, column2 - maxVisualColumn, leansForward);
            if (resultColumn < 0) {
                resultColumn = Integer.MAX_VALUE;
            }
            return new LogicalPosition(logicalLine, resultColumn, leansForward[0]);
        }
        LogicalPosition logicalPosition = this.offsetToLogicalPosition(maxOffset).leanForward(true);
        if (logicalPosition == null) {
            EditorCoordinateMapper.$$$reportNull$$$0(8);
        }
        return logicalPosition;
    }

    @NotNull
    VisualPosition offsetToVisualPosition(int offset, boolean leanTowardsLargerOffsets, boolean beforeSoftWrap) {
        VisualPosition visualPosition = this.logicalToVisualPosition(this.offsetToLogicalPosition(offset).leanForward(leanTowardsLargerOffsets), beforeSoftWrap);
        if (visualPosition == null) {
            EditorCoordinateMapper.$$$reportNull$$$0(9);
        }
        return visualPosition;
    }

    int visualPositionToOffset(VisualPosition visualPosition) {
        return this.logicalPositionToOffset(this.visualToLogicalPosition(visualPosition));
    }

    int offsetToVisualLine(int offset, boolean beforeSoftWrap) {
        int wrapIndex;
        int textLength = this.myDocument.getTextLength();
        if (offset < 0 || textLength == 0) {
            return 0;
        }
        offset = Math.min(offset, textLength);
        FoldRegion outermostCollapsed = this.myFoldingModel.getCollapsedRegionAtOffset(offset = DocumentUtil.alignToCodePointBoundary(this.myDocument, offset));
        if (outermostCollapsed != null && offset > outermostCollapsed.getStartOffset()) {
            assert (outermostCollapsed.isValid());
            offset = outermostCollapsed.getStartOffset();
            beforeSoftWrap = false;
        }
        int softWrapsBeforeOrAtOffset = (wrapIndex = this.myView.getEditor().getSoftWrapModel().getSoftWrapIndex(offset)) < 0 ? -wrapIndex - 1 : wrapIndex + (beforeSoftWrap ? 0 : 1);
        return this.myDocument.getLineNumber(offset) - this.myFoldingModel.getFoldedLinesCountBefore(offset) + softWrapsBeforeOrAtOffset;
    }

    int visualLineToOffset(int visualLine) {
        int start2 = 0;
        int end = this.myDocument.getTextLength();
        if (visualLine <= 0) {
            return start2;
        }
        if (visualLine >= this.myView.getEditor().getVisibleLineCount()) {
            return end;
        }
        int current2 = ObjectUtils.binarySearch((int)0, (int)this.myDocument.getTextLength(), mid -> Integer.compare(this.offsetToVisualLine(mid, false), visualLine));
        if (current2 < 0) {
            current2 = -current2 - 1;
        }
        return this.visualLineStartOffset(current2, true);
    }

    private int visualLineStartOffset(int offset, boolean leanForward) {
        SoftWrap currentOrPrevWrap;
        EditorImpl editor = this.myView.getEditor();
        offset = DocumentUtil.alignToCodePointBoundary(this.myDocument, offset);
        int result2 = EditorUtil.getNotFoldedLineStartOffset(editor, offset);
        SoftWrapModelImpl softWrapModel = editor.getSoftWrapModel();
        List<? extends SoftWrap> softWraps = softWrapModel.getRegisteredSoftWraps();
        int currentOrPrevWrapIndex = softWrapModel.getSoftWrapIndex(offset);
        if (currentOrPrevWrapIndex < 0) {
            currentOrPrevWrap = (currentOrPrevWrapIndex = -currentOrPrevWrapIndex - 2) < 0 || currentOrPrevWrapIndex >= softWraps.size() ? null : softWraps.get(currentOrPrevWrapIndex);
        } else {
            SoftWrap softWrap = currentOrPrevWrap = leanForward ? softWraps.get(currentOrPrevWrapIndex) : null;
        }
        if (currentOrPrevWrap != null && currentOrPrevWrap.getStart() > result2) {
            result2 = currentOrPrevWrap.getStart();
        }
        return result2;
    }

    private float getStartX(int line) {
        return this.myView.getEditor().isRightAligned() ? this.getRightAlignmentLineStartX(line) : (float)this.myView.getInsets().left + (line == 0 ? this.myView.getPrefixTextWidthInPixels() : 0.0f);
    }

    float getRightAlignmentLineStartX(int visualLine) {
        float shift;
        this.checkRightAlignment();
        EditorImpl editor = this.myView.getEditor();
        int max = this.getRightAlignmentMarginX();
        float f = shift = visualLine == 0 ? this.myView.getPrefixTextWidthInPixels() : 0.0f;
        if (visualLine >= editor.getVisibleLineCount()) {
            return (float)max - shift;
        }
        int lineWidth = this.myView.getSizeManager().getVisualLineWidth(new VisualLinesIterator(editor, visualLine), false);
        return Math.max(max - lineWidth, 0);
    }

    int getRightAlignmentMarginX() {
        this.checkRightAlignment();
        EditorImpl editor = this.myView.getEditor();
        JScrollBar vsb = editor.getScrollPane().getVerticalScrollBar();
        int vsbWidth = vsb != null && editor.getVerticalScrollbarOrientation() == 1 ? vsb.getWidth() : 0;
        return editor.getContentComponent().getWidth() - this.myView.getInsets().right - editor.getSettings().getLineCursorWidth() - vsbWidth;
    }

    private void checkRightAlignment() {
        if (!this.myView.getEditor().isRightAligned()) {
            throw new IllegalStateException("Editor is not right-aligned");
        }
    }

    @NotNull
    VisualPosition xyToVisualPosition(@NotNull Point2D p) {
        float plainSpaceWidth;
        float remainingShift;
        if (p == null) {
            EditorCoordinateMapper.$$$reportNull$$$0(10);
        }
        int visualLine = this.yToVisualLine((int)p.getY());
        int lastColumn = 0;
        float x = this.getStartX(visualLine);
        float px = (float)p.getX();
        int logicalLine = -1;
        if (visualLine < this.myView.getEditor().getVisibleLineCount()) {
            int visualLineStartOffset = this.visualLineToOffset(visualLine);
            int maxOffset = 0;
            for (VisualLineFragmentsIterator.Fragment fragment2 : VisualLineFragmentsIterator.create(this.myView, visualLineStartOffset, false, true)) {
                if (fragment2.getCurrentFoldRegion() instanceof CustomFoldRegion) {
                    return new VisualPosition(visualLine, 0);
                }
                if (px <= fragment2.getStartX()) {
                    if (fragment2.getStartVisualColumn() == 0) {
                        return new VisualPosition(visualLine, 0);
                    }
                    int markerWidth = this.myView.getEditor().getSoftWrapModel().getMinDrawingWidthInPixels(SoftWrapDrawingType.AFTER_SOFT_WRAP);
                    float indent = fragment2.getStartX() - (float)markerWidth;
                    if (px <= indent) break;
                    boolean after2 = px >= indent + (float)(markerWidth / 2);
                    return new VisualPosition(visualLine, fragment2.getStartVisualColumn() - (after2 ? 0 : 1), !after2);
                }
                float nextX = fragment2.getEndX();
                if (px <= nextX) {
                    int[] column2 = fragment2.xToVisualColumn(px);
                    return new VisualPosition(visualLine, column2[0], column2[1] > 0);
                }
                x = nextX;
                lastColumn = fragment2.getEndVisualColumn();
                maxOffset = Math.max(maxOffset, fragment2.getMaxOffset());
                logicalLine = fragment2.getEndLogicalLine();
            }
            if (this.myView.getEditor().getSoftWrapModel().getSoftWrap(maxOffset) != null) {
                int markerWidth = this.myView.getEditor().getSoftWrapModel().getMinDrawingWidthInPixels(SoftWrapDrawingType.BEFORE_SOFT_WRAP_LINE_FEED);
                if (px <= x + (float)markerWidth) {
                    boolean after3 = px >= x + (float)(markerWidth / 2);
                    return new VisualPosition(visualLine, lastColumn + (after3 ? 1 : 0), !after3);
                }
                px -= (float)markerWidth;
                ++lastColumn;
                logicalLine = -1;
            } else if (logicalLine == -1) {
                logicalLine = this.myDocument.getLineNumber(visualLineStartOffset);
            }
        }
        if ((remainingShift = px - x) > (plainSpaceWidth = this.myView.getPlainSpaceWidth()) && logicalLine >= 0) {
            List<Inlay<?>> inlays = this.myView.getEditor().getInlayModel().getAfterLineEndElementsForLogicalLine(logicalLine);
            int inlaysWidth = 0;
            int inlayCount = 0;
            for (Inlay<?> inlay : inlays) {
                int width = inlay.getWidthInPixels();
                int newWidth = inlaysWidth + width;
                if (remainingShift <= plainSpaceWidth + (float)newWidth) {
                    boolean leftPart = remainingShift <= plainSpaceWidth + (float)((inlaysWidth + newWidth) / 2);
                    return new VisualPosition(visualLine, lastColumn + 1 + inlayCount + (leftPart ? 0 : 1), leftPart);
                }
                inlaysWidth = newWidth;
                ++inlayCount;
            }
            remainingShift -= (float)inlaysWidth;
            lastColumn += inlayCount;
        }
        int additionalColumns = remainingShift <= 0.0f ? 0 : Math.round(remainingShift / plainSpaceWidth);
        return new VisualPosition(visualLine, lastColumn + additionalColumns, remainingShift > (float)additionalColumns * plainSpaceWidth);
    }

    @NotNull
    Point2D visualPositionToXY(@NotNull VisualPosition pos) {
        if (pos == null) {
            EditorCoordinateMapper.$$$reportNull$$$0(11);
        }
        int visualLine = pos.line;
        int column2 = pos.column;
        int y = this.visualLineToY(visualLine);
        float x = this.getStartX(visualLine);
        int lastColumn = 0;
        int logicalLine = -1;
        if (visualLine < this.myView.getEditor().getVisibleLineCount()) {
            int visualLineStartOffset = this.visualLineToOffset(visualLine);
            int maxOffset = 0;
            for (VisualLineFragmentsIterator.Fragment fragment2 : VisualLineFragmentsIterator.create(this.myView, visualLineStartOffset, false, true)) {
                if (fragment2.getCurrentFoldRegion() instanceof CustomFoldRegion) {
                    return new Point2D.Double(fragment2.getStartX(), y);
                }
                int startVisualColumn = fragment2.getStartVisualColumn();
                if (column2 < startVisualColumn || column2 == startVisualColumn && !pos.leansRight) break;
                int endColumn = fragment2.getEndVisualColumn();
                if (column2 < endColumn || column2 == endColumn && !pos.leansRight) {
                    return new Point2D.Double(fragment2.visualColumnToX(column2), y);
                }
                x = fragment2.getEndX();
                lastColumn = endColumn;
                maxOffset = Math.max(maxOffset, fragment2.getMaxOffset());
                logicalLine = fragment2.getEndLogicalLine();
            }
            if (column2 > lastColumn && this.myView.getEditor().getSoftWrapModel().getSoftWrap(maxOffset) != null) {
                --column2;
                x += (float)this.myView.getEditor().getSoftWrapModel().getMinDrawingWidthInPixels(SoftWrapDrawingType.BEFORE_SOFT_WRAP_LINE_FEED);
            } else if (logicalLine == -1) {
                logicalLine = this.myDocument.getLineNumber(visualLineStartOffset);
            }
        }
        if (column2 > lastColumn + 1 && logicalLine >= 0) {
            List<Inlay<?>> inlays = this.myView.getEditor().getInlayModel().getAfterLineEndElementsForLogicalLine(logicalLine);
            int inlaysWidth = 0;
            int inlayCount = 0;
            for (Inlay<?> inlay : inlays) {
                inlaysWidth += inlay.getWidthInPixels();
                if (column2 != lastColumn + 1 + ++inlayCount) continue;
                break;
            }
            x += (float)inlaysWidth;
            column2 -= inlayCount;
        }
        float additionalShift = column2 <= lastColumn ? 0.0f : (float)(column2 - lastColumn) * this.myView.getPlainSpaceWidth();
        return new Point2D.Double(x + additionalShift, y);
    }

    @NotNull
    Point2D offsetToXY(int offset, boolean leanTowardsLargerOffsets, boolean beforeSoftWrap) {
        offset = Math.max(0, Math.min(this.myDocument.getTextLength(), offset));
        offset = DocumentUtil.alignToCodePointBoundary(this.myDocument, offset);
        int logicalLine = this.myDocument.getLineNumber(offset);
        int visualLine = this.offsetToVisualLine(offset, beforeSoftWrap);
        int visualLineStartOffset = this.visualLineToOffset(visualLine);
        int y = this.visualLineToY(visualLine);
        float x = this.getStartX(logicalLine);
        boolean firstFragment = true;
        for (VisualLineFragmentsIterator.Fragment fragment2 : VisualLineFragmentsIterator.create(this.myView, offset, beforeSoftWrap, true)) {
            if (firstFragment && offset == visualLineStartOffset && !leanTowardsLargerOffsets || fragment2.getCurrentFoldRegion() instanceof CustomFoldRegion) {
                x = fragment2.getStartX();
                break;
            }
            firstFragment = false;
            int minOffset = fragment2.getMinOffset();
            int maxOffset = fragment2.getMaxOffset();
            if (fragment2.getCurrentInlay() == null && (offset > minOffset && offset < maxOffset || offset == minOffset && leanTowardsLargerOffsets || offset == maxOffset && !leanTowardsLargerOffsets)) {
                x = fragment2.offsetToX(offset);
                break;
            }
            x = fragment2.getEndX();
        }
        return new Point2D.Double(x, y);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/view/EditorCoordinateMapper";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "offsetToLogicalPosition";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/view/EditorCoordinateMapper";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "visualToLogicalPosition";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "offsetToVisualPosition";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "logicalPositionToOffset";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "logicalToVisualPosition";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visualToLogicalPosition";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "xyToVisualPosition";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "visualPositionToXY";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

