/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.MarkupIterator;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.impl.IntervalTree;
import com.intellij.openapi.editor.impl.MutableInterval;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.editor.impl.RedBlackTree;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.WalkingState;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class IntervalTreeImpl<T>
extends RedBlackTree<T>
implements IntervalTree<T> {
    static final Logger LOG = Logger.getInstance(RangeMarkerTree.class);
    static final boolean DEBUG = LOG.isDebugEnabled() || ApplicationManager.getApplication() != null && ApplicationManager.getApplication().isUnitTestMode();
    private int keySize;
    final ReadWriteLock l = new ReentrantReadWriteLock();
    private final ReferenceQueue<T> myReferenceQueue = new ReferenceQueue();
    private int deadReferenceCount;
    private boolean firingBeforeRemove;
    private static final IntervalTreeGuide<?> INTERVAL_TREE_GUIDE_INSTANCE = new IntervalTreeGuide();

    IntervalTreeImpl() {
    }

    protected abstract int compareEqualStartIntervals(@NotNull IntervalNode<T> var1, @NotNull IntervalNode<T> var2);

    private void assertUnderWriteLock() {
        if (DEBUG && !ApplicationManagerEx.isInStressTest()) assert (IntervalTreeImpl.isAcquired(this.l.writeLock())) : this.l.writeLock();
    }

    private static boolean isAcquired(@NotNull Lock l) {
        if (l == null) {
            IntervalTreeImpl.$$$reportNull$$$0(0);
        }
        @NonNls String s = l.toString();
        return s.contains("Locked by thread");
    }

    private void pushDeltaFromRoot(@Nullable IntervalNode<T> node2) {
        if (node2 != null) {
            long packedOffsets = ((IntervalNode)node2).cachedDeltaUpToRoot;
            if (IntervalNode.allDeltasUpAreNull(packedOffsets) && node2.isValid() && IntervalNode.modCount(packedOffsets) == this.getModCount()) {
                return;
            }
            this.pushDeltaFromRoot((IntervalNode<T>)node2.getParent());
            this.pushDelta(node2);
        }
    }

    protected boolean keepIntervalsOnWeakReferences() {
        return true;
    }

    @NotNull
    protected abstract IntervalNode<T> createNewNode(@NotNull T var1, int var2, int var3, boolean var4, boolean var5, boolean var6, int var7);

    protected abstract IntervalNode<T> lookupNode(@NotNull T var1);

    protected abstract void setNode(@NotNull T var1, @Nullable IntervalNode<T> var2);

    private int compareNodes(@NotNull IntervalNode<T> i1, int delta1, @NotNull IntervalNode<T> i2, int delta2, @NotNull List<? super IntervalNode<T>> invalid) {
        int start2;
        int start1;
        if (i1 == null) {
            IntervalTreeImpl.$$$reportNull$$$0(1);
        }
        if (i2 == null) {
            IntervalTreeImpl.$$$reportNull$$$0(2);
        }
        if (invalid == null) {
            IntervalTreeImpl.$$$reportNull$$$0(3);
        }
        if (!i2.hasAliveKey(false)) {
            invalid.add(i2);
        }
        if ((start1 = i1.intervalStart() + delta1) != (start2 = i2.intervalStart() + delta2)) {
            return start1 - start2;
        }
        return this.compareEqualStartIntervals(i1, i2);
    }

    protected IntervalNode<T> getRoot() {
        return (IntervalNode)this.root;
    }

    @Override
    public boolean processAll(@NotNull Processor<? super T> processor2) {
        if (processor2 == null) {
            IntervalTreeImpl.$$$reportNull$$$0(4);
        }
        try {
            this.l.readLock().lock();
            this.checkMax(true);
            boolean bl = this.process(this.getRoot(), this.getModCount(), processor2);
            return bl;
        }
        finally {
            this.l.readLock().unlock();
        }
    }

    private boolean process(@Nullable IntervalNode<T> root, int modCountBefore, @NotNull Processor<? super T> processor2) {
        if (processor2 == null) {
            IntervalTreeImpl.$$$reportNull$$$0(5);
        }
        if (root == null) {
            return true;
        }
        WalkingState.TreeGuide<IntervalNode<T>> guide = IntervalTreeImpl.getGuide();
        return WalkingState.processAll(root, guide, node2 -> {
            if (!node2.processAliveKeys(processor2)) {
                return false;
            }
            if (this.getModCount() != modCountBefore) {
                throw new ConcurrentModificationException();
            }
            return true;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processOverlappingWith(int start2, int end, @NotNull Processor<? super T> processor2) {
        if (processor2 == null) {
            IntervalTreeImpl.$$$reportNull$$$0(6);
        }
        try {
            this.l.readLock().lock();
            this.checkMax(true);
            boolean bl = this.processOverlappingWith(this.getRoot(), start2, end, this.getModCount(), 0, processor2);
            return bl;
        }
        finally {
            this.l.readLock().unlock();
        }
    }

    private boolean processOverlappingWith(@Nullable IntervalNode<T> root, int start2, int end, int modCountBefore, int deltaUpToRootExclusive, @NotNull Processor<? super T> processor2) {
        boolean overlaps;
        if (processor2 == null) {
            IntervalTreeImpl.$$$reportNull$$$0(7);
        }
        if (root == null) {
            return true;
        }
        assert (root.isValid());
        int delta = deltaUpToRootExclusive + root.delta;
        if (start2 > this.maxEndOf(root, deltaUpToRootExclusive)) {
            return true;
        }
        if (!this.processOverlappingWith((IntervalNode<T>)root.getLeft(), start2, end, modCountBefore, delta, processor2)) {
            return false;
        }
        int myStartOffset = root.intervalStart() + delta;
        int myEndOffset = root.intervalEnd() + delta;
        boolean bl = overlaps = Math.max(myStartOffset, start2) <= Math.min(myEndOffset, end);
        if (overlaps) {
            if (!root.processAliveKeys((Processor<T>)processor2)) {
                return false;
            }
            if (this.getModCount() != modCountBefore) {
                throw new ConcurrentModificationException();
            }
        }
        if (end < myStartOffset) {
            return true;
        }
        return this.processOverlappingWith((IntervalNode<T>)root.getRight(), start2, end, modCountBefore, delta, processor2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processOverlappingWithOutside(int start2, int end, @NotNull Processor<? super T> processor2) {
        if (processor2 == null) {
            IntervalTreeImpl.$$$reportNull$$$0(8);
        }
        try {
            this.l.readLock().lock();
            this.checkMax(true);
            boolean bl = this.processOverlappingWithOutside(this.getRoot(), start2, end, this.getModCount(), 0, processor2);
            return bl;
        }
        finally {
            this.l.readLock().unlock();
        }
    }

    private boolean processOverlappingWithOutside(@Nullable IntervalNode<T> root, int start2, int end, int modCountBefore, int deltaUpToRootExclusive, @NotNull Processor<? super T> processor2) {
        boolean toProcess;
        if (processor2 == null) {
            IntervalTreeImpl.$$$reportNull$$$0(9);
        }
        if (root == null) {
            return true;
        }
        assert (root.isValid());
        int delta = deltaUpToRootExclusive + root.delta;
        int rootMaxEnd = this.maxEndOf(root, deltaUpToRootExclusive);
        int rootStartOffset = root.intervalStart() + delta;
        int rootEndOffset = root.intervalEnd() + delta;
        if (!this.processOverlappingWithOutside((IntervalNode<T>)root.getLeft(), start2, end, modCountBefore, delta, processor2)) {
            return false;
        }
        boolean bl = toProcess = rootStartOffset < start2 || rootEndOffset > end;
        if (toProcess) {
            if (!root.processAliveKeys((Processor<T>)processor2)) {
                return false;
            }
            if (this.getModCount() != modCountBefore) {
                throw new ConcurrentModificationException();
            }
        }
        if (rootStartOffset >= start2 && rootMaxEnd <= end) {
            return true;
        }
        return this.processOverlappingWithOutside((IntervalNode<T>)root.getRight(), start2, end, modCountBefore, delta, processor2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processContaining(int offset, @NotNull Processor<? super T> processor2) {
        if (processor2 == null) {
            IntervalTreeImpl.$$$reportNull$$$0(10);
        }
        try {
            this.l.readLock().lock();
            this.checkMax(true);
            boolean bl = this.processContaining(this.getRoot(), offset, this.getModCount(), 0, processor2);
            return bl;
        }
        finally {
            this.l.readLock().unlock();
        }
    }

    private boolean processContaining(@Nullable IntervalNode<T> root, int offset, int modCountBefore, int deltaUpToRootExclusive, @NotNull Processor<? super T> processor2) {
        boolean overlaps;
        if (processor2 == null) {
            IntervalTreeImpl.$$$reportNull$$$0(11);
        }
        if (root == null) {
            return true;
        }
        assert (root.isValid());
        int delta = deltaUpToRootExclusive + root.delta;
        if (offset > this.maxEndOf(root, deltaUpToRootExclusive)) {
            return true;
        }
        if (!this.processContaining((IntervalNode<T>)root.getLeft(), offset, modCountBefore, delta, processor2)) {
            return false;
        }
        int myStartOffset = root.intervalStart() + delta;
        int myEndOffset = root.intervalEnd() + delta;
        boolean bl = overlaps = myStartOffset <= offset && offset < myEndOffset;
        if (overlaps) {
            if (!root.processAliveKeys((Processor<T>)processor2)) {
                return false;
            }
            if (this.getModCount() != modCountBefore) {
                throw new ConcurrentModificationException();
            }
        }
        if (offset < myStartOffset) {
            return true;
        }
        return this.processContaining((IntervalNode<T>)root.getRight(), offset, modCountBefore, delta, processor2);
    }

    @NotNull
    MarkupIterator<T> overlappingIterator(final @NotNull TextRange rangeInterval, final @Nullable Predicate<? super IntervalNode<T>> nodeFilter) {
        IntervalNode<T> firstOverlap;
        int endOffset;
        int startOffset;
        block5: {
            if (rangeInterval == null) {
                IntervalTreeImpl.$$$reportNull$$$0(12);
            }
            this.l.readLock().lock();
            startOffset = rangeInterval.getStartOffset();
            endOffset = rangeInterval.getEndOffset();
            firstOverlap = this.findMinOverlappingWith(this.getRoot(), rangeInterval, this.getModCount(), 0, nodeFilter);
            if (firstOverlap != null) break block5;
            this.l.readLock().unlock();
            MarkupIterator markupIterator = MarkupIterator.EMPTY;
            if (markupIterator == null) {
                IntervalTreeImpl.$$$reportNull$$$0(13);
            }
            return markupIterator;
        }
        try {
            final int firstOverlapDelta = firstOverlap.computeDeltaUpToRoot();
            final int firstOverlapStart = firstOverlap.intervalStart() + firstOverlapDelta;
            final int modCountBefore = this.getModCount();
            return new MarkupIterator<T>(){
                private IntervalNode<T> currentNode;
                private int deltaUpToRootExclusive;
                private int indexInCurrentList;
                private T current;
                {
                    this.currentNode = firstOverlap;
                    this.deltaUpToRootExclusive = firstOverlapDelta - firstOverlap.delta;
                }

                public boolean hasNext() {
                    if (this.current != null) {
                        return true;
                    }
                    if (this.currentNode == null) {
                        return false;
                    }
                    if (IntervalTreeImpl.this.getModCount() != modCountBefore) {
                        throw new ConcurrentModificationException();
                    }
                    if (this.nextInterval()) {
                        return true;
                    }
                    while (true) {
                        this.currentNode = this.nextNode(this.currentNode);
                        if (this.currentNode == null) {
                            return false;
                        }
                        if (!IntervalTreeImpl.this.overlaps(this.currentNode, rangeInterval, this.deltaUpToRootExclusive)) continue;
                        assert (this.currentNode.intervalStart() + this.deltaUpToRootExclusive + this.currentNode.delta >= firstOverlapStart);
                        this.indexInCurrentList = 0;
                        if (this.nextInterval()) break;
                    }
                    return true;
                }

                private boolean nextInterval() {
                    List intervals = this.currentNode.intervals;
                    while (this.indexInCurrentList < intervals.size()) {
                        Object t = intervals.get(this.indexInCurrentList).get();
                        ++this.indexInCurrentList;
                        if (t == null) continue;
                        this.current = t;
                        return true;
                    }
                    this.indexInCurrentList = 0;
                    return false;
                }

                public T next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Object t = this.current;
                    this.current = null;
                    return t;
                }

                public T peek() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return this.current;
                }

                public void remove() {
                    throw new IncorrectOperationException();
                }

                @Override
                public void dispose() {
                    IntervalTreeImpl.this.l.readLock().unlock();
                }

                private IntervalNode<T> nextNode(@NotNull IntervalNode<T> root) {
                    int rightMaxEnd;
                    if (root == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    assert (root.isValid()) : root;
                    int delta = this.deltaUpToRootExclusive + root.delta;
                    int myMaxEnd = IntervalTreeImpl.this.maxEndOf(root, this.deltaUpToRootExclusive);
                    if (startOffset > myMaxEnd) {
                        return null;
                    }
                    RedBlackTree.Node right = root.getRight();
                    if (right != null && (nodeFilter == null || nodeFilter.test(right)) && startOffset <= (rightMaxEnd = IntervalTreeImpl.this.maxEndOf((IntervalNode)right, delta))) {
                        RedBlackTree.Node left;
                        int rightDelta = delta + ((IntervalNode)right).delta;
                        while ((left = ((IntervalNode)right).getLeft()) != null && (nodeFilter == null || nodeFilter.test(left)) && startOffset <= IntervalTreeImpl.this.maxEndOf((IntervalNode)left, rightDelta)) {
                            right = left;
                            rightDelta += ((IntervalNode)right).delta;
                        }
                        this.deltaUpToRootExclusive = rightDelta - ((IntervalNode)right).delta;
                        return right;
                    }
                    RedBlackTree.Node parent;
                    while ((parent = root.getParent()) != null) {
                        if (((IntervalNode)parent).intervalStart() + this.deltaUpToRootExclusive > endOffset) {
                            return null;
                        }
                        this.deltaUpToRootExclusive -= ((IntervalNode)parent).delta;
                        if (((IntervalNode)parent).getLeft() == root) {
                            return parent;
                        }
                        root = parent;
                    }
                    return null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/openapi/editor/impl/IntervalTreeImpl$1", "nextNode"));
                }
            };
        }
        catch (Error | RuntimeException e) {
            this.l.readLock().unlock();
            throw e;
        }
    }

    private boolean overlaps(@Nullable IntervalNode<T> root, @NotNull TextRange rangeInterval, int deltaUpToRootExclusive) {
        if (rangeInterval == null) {
            IntervalTreeImpl.$$$reportNull$$$0(14);
        }
        if (root == null) {
            return false;
        }
        int delta = root.delta + deltaUpToRootExclusive;
        int start2 = root.intervalStart() + delta;
        int end = root.intervalEnd() + delta;
        return rangeInterval.intersects(start2, end);
    }

    @NotNull
    IntervalNode<T> findOrInsert(@NotNull IntervalNode<T> node2) {
        if (node2 == null) {
            IntervalTreeImpl.$$$reportNull$$$0(15);
        }
        this.assertUnderWriteLock();
        node2.setRed();
        node2.setParent(null);
        node2.setValid(true);
        node2.maxEnd = 0;
        node2.clearDelta();
        node2.setLeft(null);
        node2.setRight(null);
        SmartList gced = new SmartList();
        if (this.root == null) {
            this.root = node2;
        } else {
            RedBlackTree.Node current2 = this.getRoot();
            while (true) {
                this.pushDelta((IntervalNode<T>)current2);
                int compResult = this.compareNodes(node2, 0, (IntervalNode<T>)current2, 0, (List<? super IntervalNode<T>>)gced);
                if (compResult == 0) {
                    IntervalNode<T> intervalNode = current2;
                    if (intervalNode == null) {
                        IntervalTreeImpl.$$$reportNull$$$0(16);
                    }
                    return intervalNode;
                }
                if (compResult < 0) {
                    if (current2.getLeft() == null) {
                        current2.setLeft(node2);
                        break;
                    }
                    current2 = current2.getLeft();
                    continue;
                }
                if (current2.getRight() == null) {
                    current2.setRight(node2);
                    break;
                }
                current2 = current2.getRight();
            }
            node2.setParent(current2);
        }
        ((IntervalNode)node2).setCachedValues(0, true, this.getModCount());
        this.correctMaxUp(node2);
        this.onInsertNode();
        this.keySize += node2.intervals.size();
        this.insertCase1(node2);
        ((IntervalNode)node2).setAttachedToTree(true);
        this.verifyProperties();
        this.deleteNodes((List<? extends IntervalNode<T>>)gced);
        IntervalNode<T> intervalNode = node2;
        if (intervalNode == null) {
            IntervalTreeImpl.$$$reportNull$$$0(17);
        }
        return intervalNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteNodes(@NotNull List<? extends IntervalNode<T>> collectedAway) {
        if (collectedAway == null) {
            IntervalTreeImpl.$$$reportNull$$$0(18);
        }
        if (collectedAway.isEmpty()) {
            return;
        }
        try {
            this.l.writeLock().lock();
            for (IntervalNode<T> node2 : collectedAway) {
                this.removeNode(node2);
            }
        }
        finally {
            this.l.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public IntervalNode<T> addInterval(@NotNull T interval, int start2, int end, boolean greedyToLeft, boolean greedyToRight, boolean stickingToRight, int layer) {
        if (interval == null) {
            IntervalTreeImpl.$$$reportNull$$$0(19);
        }
        this.l.writeLock().lock();
        if (this.firingBeforeRemove) {
            throw new IncorrectOperationException("Must not add rangemarker from within beforeRemoved listener");
        }
        this.checkMax(true);
        this.processReferenceQueue();
        this.incModCount();
        IntervalNode<T> newNode = this.createNewNode(interval, start2, end, greedyToLeft, greedyToRight, stickingToRight, layer);
        IntervalNode<T> insertedNode = this.findOrInsert(newNode);
        if (insertedNode == newNode) {
            this.setNode(interval, insertedNode);
        } else {
            insertedNode.addInterval(interval);
        }
        this.checkMax(true);
        this.checkBelongsToTheTree(interval, true);
        IntervalNode<T> intervalNode = insertedNode;
        IntervalNode<T> intervalNode2 = intervalNode;
        if (intervalNode2 == null) {
            IntervalTreeImpl.$$$reportNull$$$0(20);
        }
        return intervalNode2;
        finally {
            this.l.writeLock().unlock();
        }
    }

    boolean checkMax(boolean assertInvalid) {
        return VERIFY && this.doCheckMax(assertInvalid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doCheckMax(boolean assertInvalid) {
        try {
            this.l.readLock().lock();
            AtomicBoolean allValid = new AtomicBoolean(true);
            int[] keyCounter = new int[1];
            int[] nodeCounter = new int[1];
            LongOpenHashSet ids = new LongOpenHashSet(this.keySize);
            this.checkMax(this.getRoot(), 0, assertInvalid, allValid, keyCounter, nodeCounter, (LongSet)ids, true);
            if (assertInvalid) {
                assert (this.nodeSize() == nodeCounter[0]) : "node size: " + this.nodeSize() + "; actual: " + nodeCounter[0];
                assert (this.keySize == keyCounter[0]) : "key size: " + this.keySize + "; actual: " + keyCounter[0];
                assert (this.keySize >= this.nodeSize()) : this.keySize + "; " + this.nodeSize();
            }
            boolean bl = allValid.get();
            return bl;
        }
        finally {
            this.l.readLock().unlock();
        }
    }

    private IntTrinity checkMax(@Nullable IntervalNode<T> root, int deltaUpToRootExclusive, boolean assertInvalid, @NotNull AtomicBoolean allValid, int @NotNull [] keyCounter, int @NotNull [] nodeCounter, @NotNull LongSet ids, boolean allDeltasUpAreNull) {
        if (allValid == null) {
            IntervalTreeImpl.$$$reportNull$$$0(21);
        }
        if (ids == null) {
            IntervalTreeImpl.$$$reportNull$$$0(22);
        }
        if (keyCounter == null) {
            IntervalTreeImpl.$$$reportNull$$$0(23);
        }
        if (nodeCounter == null) {
            IntervalTreeImpl.$$$reportNull$$$0(24);
        }
        if (root == null) {
            return new IntTrinity(Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        }
        long packedOffsets = ((IntervalNode)root).cachedDeltaUpToRoot;
        if (IntervalNode.modCount(packedOffsets) == this.getModCount()) {
            assert (IntervalNode.allDeltasUpAreNull(packedOffsets) == (root.delta == 0 && allDeltasUpAreNull));
            assert (IntervalNode.deltaUpToRoot(packedOffsets) == root.delta + deltaUpToRootExclusive);
        }
        T liveInterval = null;
        for (int i2 = root.intervals.size() - 1; i2 >= 0; --i2) {
            Object t = root.intervals.get(i2).get();
            if (t == null) continue;
            liveInterval = (T)t;
            this.checkBelongsToTheTree(t, false);
            boolean added2 = ids.add(((RangeMarkerImpl)t).getId());
            assert (added2) : t;
        }
        if (assertInvalid && liveInterval != null) {
            this.checkBelongsToTheTree(liveInterval, true);
        }
        keyCounter[0] = keyCounter[0] + root.intervals.size();
        nodeCounter[0] = nodeCounter[0] + 1;
        int delta = deltaUpToRootExclusive + (root.isValid() ? root.delta : 0);
        IntTrinity l = this.checkMax((IntervalNode<T>)root.getLeft(), delta, assertInvalid, allValid, keyCounter, nodeCounter, ids, root.delta == 0 && allDeltasUpAreNull);
        int minLeftStart = l.first;
        int maxLeftStart = l.second;
        int maxLeftEnd = l.third;
        IntTrinity r = this.checkMax((IntervalNode<T>)root.getRight(), delta, assertInvalid, allValid, keyCounter, nodeCounter, ids, root.delta == 0 && allDeltasUpAreNull);
        int maxRightEnd = r.third;
        int minRightStart = r.first;
        int maxRightStart = r.second;
        if (!root.isValid()) {
            allValid.set(false);
            if (assertInvalid) assert (false) : root;
            return new IntTrinity(Math.min(minLeftStart, minRightStart), Math.max(maxLeftStart, maxRightStart), Math.max(maxRightEnd, maxLeftEnd));
        }
        RedBlackTree.Node parent = root.getParent();
        if (parent != null && assertInvalid && root.hasAliveKey(false)) {
            int c = this.compareNodes(root, delta, (IntervalNode<T>)parent, delta - root.delta, (List<? super IntervalNode<T>>)new SmartList());
            assert (c != 0);
            assert (c < 0 && ((IntervalNode)parent).getLeft() == root || c > 0 && ((IntervalNode)parent).getRight() == root);
        }
        assert (delta + root.maxEnd == Math.max(maxLeftEnd, Math.max(maxRightEnd, delta + root.intervalEnd())));
        int myStartOffset = delta + root.intervalStart();
        assert (maxLeftStart <= myStartOffset);
        assert (minRightStart >= myStartOffset);
        assert (myStartOffset >= 0);
        assert (minLeftStart == Integer.MAX_VALUE || minLeftStart <= myStartOffset);
        assert (maxRightStart == Integer.MIN_VALUE || maxRightStart >= myStartOffset);
        int minStart = Math.min(minLeftStart, myStartOffset);
        int maxStart = Math.max(myStartOffset, Math.max(maxLeftStart, maxRightStart));
        assert (minStart <= maxStart);
        return new IntTrinity(minStart, maxStart, root.maxEnd + delta);
    }

    @Override
    @NotNull
    protected RedBlackTree.Node<T> maximumNode(@NotNull RedBlackTree.Node<T> n) {
        if (n == null) {
            IntervalTreeImpl.$$$reportNull$$$0(25);
        }
        RedBlackTree.Node root = (IntervalNode)n;
        this.pushDelta((IntervalNode<T>)root.getParent());
        this.pushDelta((IntervalNode<T>)root);
        while (root.getRight() != null) {
            root = root.getRight();
            this.pushDelta((IntervalNode<T>)root);
        }
        IntervalNode intervalNode = root;
        if (intervalNode == null) {
            IntervalTreeImpl.$$$reportNull$$$0(26);
        }
        return intervalNode;
    }

    private void checkBelongsToTheTree(@NotNull T interval, boolean assertInvalid) {
        IntervalNode<T> root;
        if (interval == null) {
            IntervalTreeImpl.$$$reportNull$$$0(27);
        }
        if ((root = this.lookupNode(interval)) == null) {
            return;
        }
        assert (root.getTree() == this) : root.getTree() + "; this: " + this;
        if (!VERIFY) {
            return;
        }
        if (assertInvalid) {
            assert (!root.intervals.isEmpty());
            boolean contains = false;
            for (int i2 = root.intervals.size() - 1; i2 >= 0; --i2) {
                Object key = root.intervals.get(i2).get();
                if (key == null) continue;
                contains |= key == interval;
                IntervalNode node2 = this.lookupNode(key);
                assert (node2 == root) : node2;
                assert (node2.getTree() == this) : node2;
            }
            assert (contains) : root.intervals + "; " + interval;
        }
        RedBlackTree.Node e = root;
        while (e.getParent() != null) {
            e = e.getParent();
        }
        assert (e == this.getRoot());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeInterval(@NotNull T interval) {
        if (interval == null) {
            IntervalTreeImpl.$$$reportNull$$$0(28);
        }
        if (!((RangeMarkerEx)interval).isValid()) {
            return false;
        }
        try {
            this.l.writeLock().lock();
            this.incModCount();
            if (!((RangeMarkerEx)interval).isValid()) {
                boolean bl = false;
                return bl;
            }
            this.checkBelongsToTheTree(interval, true);
            this.checkMax(true);
            this.processReferenceQueue();
            IntervalNode<T> node2 = this.lookupNode(interval);
            if (node2 == null) {
                boolean bl = false;
                return bl;
            }
            this.beforeRemove(interval, "Explicit Dispose");
            ((IntervalNode)node2).removeInterval(interval);
            this.setNode(interval, null);
            this.checkMax(true);
            boolean bl = true;
            return bl;
        }
        finally {
            this.l.writeLock().unlock();
        }
    }

    void removeNode(@NotNull IntervalNode<T> node2) {
        if (node2 == null) {
            IntervalTreeImpl.$$$reportNull$$$0(29);
        }
        this.deleteNode((RedBlackTree.Node<T>)node2);
        RedBlackTree.Node parent = node2.getParent();
        this.correctMaxUp((IntervalNode<T>)parent);
    }

    @Override
    protected void deleteNode(@NotNull RedBlackTree.Node<T> n) {
        if (n == null) {
            IntervalTreeImpl.$$$reportNull$$$0(30);
        }
        this.assertUnderWriteLock();
        IntervalNode node2 = (IntervalNode)n;
        this.pushDeltaFromRoot(node2);
        this.assertAllDeltasAreNull(node2);
        super.deleteNode(n);
        this.keySize -= node2.intervals.size();
        assert (this.keySize >= 0) : this.keySize;
        node2.setAttachedToTree(false);
    }

    @Override
    public int size() {
        return this.keySize;
    }

    boolean pushDelta(@Nullable IntervalNode<T> root) {
        if (root == null || !root.isValid()) {
            return true;
        }
        RedBlackTree.Node parent = root.getParent();
        this.assertAllDeltasAreNull((IntervalNode<T>)parent);
        int delta = root.delta;
        ((IntervalNode)root).setCachedValues(0, true, 0);
        if (delta != 0) {
            root.setIntervalStart(root.intervalStart() + delta);
            root.setIntervalEnd(root.intervalEnd() + delta);
            root.maxEnd += delta;
            root.delta = 0;
            return this.incDelta((IntervalNode<T>)root.getLeft(), delta) & this.incDelta((IntervalNode<T>)root.getRight(), delta);
        }
        ((IntervalNode)root).setCachedValues(0, true, this.getModCount());
        return true;
    }

    private boolean incDelta(@Nullable IntervalNode<T> root, int delta) {
        if (root == null) {
            return true;
        }
        if (root.isValid()) {
            int newDelta = root.changeDelta(delta);
            return newDelta == 0;
        }
        return this.incDelta((IntervalNode<T>)root.getLeft(), delta) & this.incDelta((IntervalNode<T>)root.getRight(), delta);
    }

    @Override
    @NotNull
    protected IntervalNode<T> swapWithMaxPred(@NotNull RedBlackTree.Node<T> root, @NotNull RedBlackTree.Node<T> maxPred) {
        if (root == null) {
            IntervalTreeImpl.$$$reportNull$$$0(31);
        }
        if (maxPred == null) {
            IntervalTreeImpl.$$$reportNull$$$0(32);
        }
        this.checkMax(false);
        IntervalNode a = (IntervalNode)root;
        IntervalNode d = (IntervalNode)maxPred;
        boolean acolor = a.isBlack();
        boolean dcolor = d.isBlack();
        assert (!a.isValid() || a.delta == 0) : a.delta;
        for (RedBlackTree.Node n = a.getLeft(); n != null; n = ((IntervalNode)n).getRight()) {
            assert (!((IntervalNode)n).isValid() || ((IntervalNode)n).delta == 0) : ((IntervalNode)n).delta;
        }
        this.swapNodes(a, d);
        a.setValid(false);
        a.setColor(dcolor);
        d.setColor(acolor);
        this.correctMaxUp(a);
        this.checkMax(false);
        assert (a.delta == 0) : a.delta;
        assert (d.delta == 0) : d.delta;
        IntervalNode intervalNode = a;
        if (intervalNode == null) {
            IntervalTreeImpl.$$$reportNull$$$0(33);
        }
        return intervalNode;
    }

    private void swapNodes(@NotNull IntervalNode<T> n1, @NotNull IntervalNode<T> n2) {
        if (n1 == null) {
            IntervalTreeImpl.$$$reportNull$$$0(34);
        }
        if (n2 == null) {
            IntervalTreeImpl.$$$reportNull$$$0(35);
        }
        RedBlackTree.Node l1 = n1.getLeft();
        RedBlackTree.Node r1 = n1.getRight();
        IntervalNode<T> p1 = n1.getParent();
        IntervalNode<T> l2 = n2.getLeft();
        IntervalNode<T> r2 = n2.getRight();
        RedBlackTree.Node p2 = n2.getParent();
        if (p1 != null) {
            if (p1.getLeft() == n1) {
                p1.setLeft(n2);
            } else {
                p1.setRight(n2);
            }
        } else {
            this.root = n2;
        }
        if (p2 != null) {
            if (((IntervalNode)p2).getLeft() == n2) {
                p2.setLeft(p2 == n1 ? l2 : n1);
            } else {
                p2.setRight(p2 == n1 ? r2 : n1);
            }
        } else {
            this.root = n1;
        }
        n1.setParent(p2 == n1 ? n2 : p2);
        n2.setParent(p1);
        n1.setLeft(l2);
        n2.setLeft(l1 == n2 ? n1 : l1);
        if (l1 != null) {
            l1.setParent(n2 == l1 ? p1 : n2);
        }
        if (r1 != null) {
            r1.setParent(n2);
        }
        n1.setRight(r2);
        n2.setRight(r1);
        if (l2 != null) {
            l2.setParent(n1);
        }
        if (r2 != null) {
            r2.setParent(n1);
        }
    }

    private int maxEndOf(@Nullable IntervalNode<T> node2, int deltaUpToRootExclusive) {
        if (node2 == null) {
            return 0;
        }
        if (node2.isValid()) {
            return node2.maxEnd + node2.delta + deltaUpToRootExclusive;
        }
        return Math.max(this.maxEndOf((IntervalNode<T>)node2.getLeft(), deltaUpToRootExclusive), this.maxEndOf((IntervalNode<T>)node2.getRight(), deltaUpToRootExclusive));
    }

    void correctMax(@NotNull IntervalNode<T> node2, int deltaUpToRoot) {
        if (node2 == null) {
            IntervalTreeImpl.$$$reportNull$$$0(36);
        }
        if (!node2.isValid()) {
            return;
        }
        int realMax = Math.max(Math.max(this.maxEndOf((IntervalNode<T>)node2.getLeft(), deltaUpToRoot), this.maxEndOf((IntervalNode<T>)node2.getRight(), deltaUpToRoot)), deltaUpToRoot + node2.intervalEnd());
        node2.maxEnd = realMax - deltaUpToRoot;
    }

    private void correctMaxUp(@Nullable IntervalNode<T> node2) {
        int delta;
        int n = delta = node2 == null ? 0 : node2.computeDeltaUpToRoot();
        assert (delta == 0) : delta;
        while (node2 != null) {
            if (node2.isValid()) {
                int d = node2.delta;
                this.correctMax((IntervalNode<T>)node2, delta);
                delta -= d;
            }
            node2 = node2.getParent();
        }
        assert (delta == 0) : delta;
    }

    @Override
    protected void rotateRight(@NotNull RedBlackTree.Node<T> n) {
        if (n == null) {
            IntervalTreeImpl.$$$reportNull$$$0(37);
        }
        this.checkMax(false);
        IntervalNode node1 = (IntervalNode)n;
        RedBlackTree.Node node2 = node1.getLeft();
        RedBlackTree.Node node3 = node1.getRight();
        RedBlackTree.Node parent = node1.getParent();
        int deltaUp = parent == null ? 0 : ((IntervalNode)parent).computeDeltaUpToRoot();
        this.pushDelta(node1);
        this.pushDelta((IntervalNode<T>)node2);
        this.pushDelta((IntervalNode<T>)node3);
        super.rotateRight(node1);
        if (node3 != null) {
            this.correctMax((IntervalNode<T>)node3, deltaUp);
        }
        this.correctMax(node1, deltaUp);
        this.correctMax((IntervalNode<T>)node2, deltaUp);
        this.assertAllDeltasAreNull(node1);
        this.assertAllDeltasAreNull((IntervalNode<T>)node2);
        this.assertAllDeltasAreNull((IntervalNode<T>)node3);
        this.checkMax(false);
    }

    @Override
    protected void rotateLeft(@NotNull RedBlackTree.Node<T> n) {
        if (n == null) {
            IntervalTreeImpl.$$$reportNull$$$0(38);
        }
        this.checkMax(false);
        IntervalNode node1 = (IntervalNode)n;
        RedBlackTree.Node node2 = node1.getLeft();
        RedBlackTree.Node node3 = node1.getRight();
        RedBlackTree.Node parent = node1.getParent();
        int deltaUp = parent == null ? 0 : ((IntervalNode)parent).computeDeltaUpToRoot();
        this.pushDelta(node1);
        this.pushDelta((IntervalNode<T>)node2);
        this.pushDelta((IntervalNode<T>)node3);
        this.checkMax(false);
        super.rotateLeft(node1);
        if (node2 != null) {
            this.correctMax((IntervalNode<T>)node2, deltaUp);
        }
        this.correctMax(node1, deltaUp);
        this.correctMax((IntervalNode<T>)node3, deltaUp);
        this.assertAllDeltasAreNull(node1);
        this.assertAllDeltasAreNull((IntervalNode<T>)node2);
        this.assertAllDeltasAreNull((IntervalNode<T>)node3);
        this.checkMax(false);
    }

    @Override
    protected void replaceNode(@NotNull RedBlackTree.Node<T> node2, RedBlackTree.Node<T> child2) {
        if (node2 == null) {
            IntervalTreeImpl.$$$reportNull$$$0(39);
        }
        IntervalNode myNode = (IntervalNode)node2;
        this.pushDelta(myNode);
        this.pushDelta((IntervalNode)child2);
        super.replaceNode(node2, child2);
        if (child2 != null && myNode.isValid()) {
            ((IntervalNode)child2).changeDelta(myNode.delta);
        }
    }

    private void assertAllDeltasAreNull(@Nullable IntervalNode<T> node2) {
        if (node2 == null) {
            return;
        }
        if (!node2.isValid()) {
            return;
        }
        assert (node2.delta == 0);
        long packedOffsets = ((IntervalNode)node2).cachedDeltaUpToRoot;
        assert (IntervalNode.modCount(packedOffsets) != this.getModCount() || IntervalNode.allDeltasUpAreNull(packedOffsets));
    }

    private IntervalNode<T> findMinOverlappingWith(@Nullable IntervalNode<T> root, @NotNull TextRange interval, int modCountBefore, int deltaUpToRootExclusive, @Nullable Predicate<? super IntervalNode<T>> nodeFilter) {
        boolean overlaps;
        if (interval == null) {
            IntervalTreeImpl.$$$reportNull$$$0(40);
        }
        if (root == null) {
            return null;
        }
        assert (root.isValid());
        if (nodeFilter != null && !nodeFilter.test(root)) {
            return null;
        }
        int delta = deltaUpToRootExclusive + root.delta;
        if (interval.getStartOffset() > this.maxEndOf(root, deltaUpToRootExclusive)) {
            return null;
        }
        IntervalNode<T> inLeft = this.findMinOverlappingWith((IntervalNode<T>)root.getLeft(), interval, modCountBefore, delta, (Predicate<? super IntervalNode<T>>)nodeFilter);
        if (inLeft != null) {
            return inLeft;
        }
        int myStartOffset = root.intervalStart() + delta;
        int myEndOffset = root.intervalEnd() + delta;
        boolean bl = overlaps = Math.max(myStartOffset, interval.getStartOffset()) <= Math.min(myEndOffset, interval.getEndOffset());
        if (overlaps) {
            return root;
        }
        if (this.getModCount() != modCountBefore) {
            throw new ConcurrentModificationException();
        }
        if (interval.getEndOffset() < myStartOffset) {
            return null;
        }
        return this.findMinOverlappingWith((IntervalNode<T>)root.getRight(), interval, modCountBefore, delta, (Predicate<? super IntervalNode<T>>)nodeFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void changeData(@NotNull T interval, int start2, int end, boolean greedyToLeft, boolean greedyToRight, boolean stickingToRight, int layer) {
        if (interval == null) {
            IntervalTreeImpl.$$$reportNull$$$0(41);
        }
        try {
            this.l.writeLock().lock();
            IntervalNode<T> node2 = this.lookupNode(interval);
            if (node2 == null) {
                return;
            }
            int before = this.size();
            boolean nodeRemoved = ((IntervalNode)node2).removeInterval(interval);
            assert (nodeRemoved || !node2.intervals.isEmpty());
            IntervalNode<T> insertedNode = this.addInterval(interval, start2, end, greedyToLeft, greedyToRight, stickingToRight, layer);
            assert (node2 != insertedNode);
            int after2 = this.size();
            assert (before >= after2) : before + ";" + after2;
            this.checkBelongsToTheTree(interval, true);
            this.checkMax(true);
        }
        finally {
            this.l.writeLock().unlock();
        }
    }

    private void processReferenceQueue() {
        int dead = 0;
        while (this.myReferenceQueue.poll() != null) {
            ++dead;
        }
        this.deadReferenceCount += dead;
        if (this.deadReferenceCount > Math.max(1, this.size() / 3)) {
            this.purgeDeadNodes();
            this.deadReferenceCount = 0;
        }
    }

    private void purgeDeadNodes() {
        this.assertUnderWriteLock();
        SmartList gced = new SmartList();
        this.collectGced(this.getRoot(), (List<? super IntervalNode<T>>)gced);
        this.deleteNodes((List<? extends IntervalNode<T>>)gced);
        this.checkMax(true);
    }

    @Override
    public void clear() {
        this.l.writeLock().lock();
        this.processAll(t -> {
            this.beforeRemove(t, "Clear all");
            return true;
        });
        try {
            super.clear();
            this.keySize = 0;
        }
        finally {
            this.l.writeLock().unlock();
        }
    }

    private void collectGced(@Nullable IntervalNode<T> root, @NotNull List<? super IntervalNode<T>> gced) {
        if (gced == null) {
            IntervalTreeImpl.$$$reportNull$$$0(42);
        }
        if (root == null) {
            return;
        }
        if (!root.hasAliveKey(true)) {
            gced.add(root);
        }
        this.collectGced((IntervalNode<T>)root.getLeft(), (List<? super IntervalNode<T>>)gced);
        this.collectGced((IntervalNode<T>)root.getRight(), (List<? super IntervalNode<T>>)gced);
    }

    void fireBeforeRemoved(@NotNull T markerEx, @NotNull @NonNls Object reason) {
        if (markerEx == null) {
            IntervalTreeImpl.$$$reportNull$$$0(43);
        }
        if (reason == null) {
            IntervalTreeImpl.$$$reportNull$$$0(44);
        }
    }

    void beforeRemove(@NotNull T markerEx, @NonNls @NotNull Object reason) {
        if (markerEx == null) {
            IntervalTreeImpl.$$$reportNull$$$0(45);
        }
        if (reason == null) {
            IntervalTreeImpl.$$$reportNull$$$0(46);
        }
        if (this.firingBeforeRemove) {
            throw new IllegalStateException();
        }
        this.firingBeforeRemove = true;
        try {
            this.fireBeforeRemoved(markerEx, reason);
        }
        finally {
            this.firingBeforeRemove = false;
        }
    }

    @NotNull
    private static <T> WalkingState.TreeGuide<IntervalNode<T>> getGuide() {
        IntervalTreeGuide<?> intervalTreeGuide = INTERVAL_TREE_GUIDE_INSTANCE;
        if (intervalTreeGuide == null) {
            IntervalTreeImpl.$$$reportNull$$$0(47);
        }
        return intervalTreeGuide;
    }

    public int maxHeight() {
        return this.maxHeight(this.root);
    }

    private int maxHeight(@Nullable RedBlackTree.Node<T> root) {
        return root == null ? 0 : 1 + Math.max(this.maxHeight(root.left), this.maxHeight(root.right));
    }

    @NotNull
    static <T> MarkupIterator<T> mergingOverlappingIterator(@NotNull IntervalTreeImpl<T> tree1, @NotNull TextRange tree1Range, @NotNull IntervalTreeImpl<T> tree2, @NotNull TextRange tree2Range, @NotNull Comparator<? super T> comparator2) {
        if (tree1 == null) {
            IntervalTreeImpl.$$$reportNull$$$0(48);
        }
        if (tree1Range == null) {
            IntervalTreeImpl.$$$reportNull$$$0(49);
        }
        if (tree2 == null) {
            IntervalTreeImpl.$$$reportNull$$$0(50);
        }
        if (tree2Range == null) {
            IntervalTreeImpl.$$$reportNull$$$0(51);
        }
        if (comparator2 == null) {
            IntervalTreeImpl.$$$reportNull$$$0(52);
        }
        MarkupIterator<T> exact = tree1.overlappingIterator(tree1Range, null);
        MarkupIterator<T> lines2 = tree2.overlappingIterator(tree2Range, null);
        MarkupIterator<? super T> markupIterator = MarkupIterator.mergeIterators(exact, lines2, comparator2);
        if (markupIterator == null) {
            IntervalTreeImpl.$$$reportNull$$$0(53);
        }
        return markupIterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T findRangeMarkerAfter(@NotNull T marker) {
        if (marker == null) {
            IntervalTreeImpl.$$$reportNull$$$0(54);
        }
        this.l.readLock().lock();
        try {
            boolean foundMarker = false;
            for (IntervalNode<T> node2 = this.lookupNode(marker); node2 != null; node2 = node2.next()) {
                List intervals = node2.intervals;
                for (int i2 = 0; i2 < intervals.size(); ++i2) {
                    Supplier interval = intervals.get(i2);
                    Object m = interval.get();
                    if (m == null) continue;
                    if (m == marker) {
                        foundMarker = true;
                        continue;
                    }
                    if (!foundMarker) continue;
                    Object e = m;
                    return (T)e;
                }
                foundMarker = true;
            }
            T t = null;
            return t;
        }
        finally {
            this.l.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T findRangeMarkerBefore(@NotNull T marker) {
        if (marker == null) {
            IntervalTreeImpl.$$$reportNull$$$0(55);
        }
        this.l.readLock().lock();
        try {
            boolean foundMarker = false;
            for (IntervalNode<T> node2 = this.lookupNode(marker); node2 != null; node2 = node2.previous()) {
                List intervals = node2.intervals;
                for (int i2 = intervals.size() - 1; i2 >= 0; --i2) {
                    Supplier interval = intervals.get(i2);
                    Object m = interval.get();
                    if (m == null) continue;
                    if (m == marker) {
                        foundMarker = true;
                        continue;
                    }
                    if (!foundMarker) continue;
                    Object e = m;
                    return (T)e;
                }
                foundMarker = true;
            }
            T t = null;
            return t;
        }
        finally {
            this.l.readLock().unlock();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 16: 
            case 17: 
            case 20: 
            case 26: 
            case 33: 
            case 47: 
            case 53: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 16: 
            case 17: 
            case 20: 
            case 26: 
            case 33: 
            case 47: 
            case 53: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "i1";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "i2";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invalid";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInterval";
                break;
            }
            case 13: 
            case 16: 
            case 17: 
            case 20: 
            case 26: 
            case 33: 
            case 47: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/IntervalTreeImpl";
                break;
            }
            case 15: 
            case 29: 
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectedAway";
                break;
            }
            case 19: 
            case 27: 
            case 28: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interval";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allValid";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyCounter";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeCounter";
                break;
            }
            case 25: 
            case 30: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "n";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maxPred";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "n1";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "n2";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gced";
                break;
            }
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markerEx";
                break;
            }
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree1";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree1Range";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree2";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree2Range";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 54: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/IntervalTreeImpl";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "overlappingIterator";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrInsert";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "addInterval";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "maximumNode";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "swapWithMaxPred";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getGuide";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "mergingOverlappingIterator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAcquired";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "compareNodes";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processAll";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processOverlappingWith";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processOverlappingWithOutside";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processContaining";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "overlappingIterator";
                break;
            }
            case 13: 
            case 16: 
            case 17: 
            case 20: 
            case 26: 
            case 33: 
            case 47: 
            case 53: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "overlaps";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findOrInsert";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "deleteNodes";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addInterval";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "checkMax";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "maximumNode";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "checkBelongsToTheTree";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "removeInterval";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "removeNode";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "deleteNode";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "swapWithMaxPred";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "swapNodes";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "correctMax";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "rotateRight";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "rotateLeft";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "replaceNode";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "findMinOverlappingWith";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "changeData";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "collectGced";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "fireBeforeRemoved";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "beforeRemove";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "mergingOverlappingIterator";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "findRangeMarkerAfter";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "findRangeMarkerBefore";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 16: 
            case 17: 
            case 20: 
            case 26: 
            case 33: 
            case 47: 
            case 53: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class IntervalTreeGuide<T extends MutableInterval>
    implements WalkingState.TreeGuide<IntervalNode<T>> {
        private IntervalTreeGuide() {
        }

        public IntervalNode<T> getNextSibling(@NotNull IntervalNode<T> element2) {
            RedBlackTree.Node parent;
            if (element2 == null) {
                IntervalTreeGuide.$$$reportNull$$$0(0);
            }
            if ((parent = element2.getParent()) == null) {
                return null;
            }
            return ((IntervalNode)parent).getLeft() == element2 ? ((IntervalNode)parent).getRight() : null;
        }

        public IntervalNode<T> getPrevSibling(@NotNull IntervalNode<T> element2) {
            RedBlackTree.Node parent;
            if (element2 == null) {
                IntervalTreeGuide.$$$reportNull$$$0(1);
            }
            if ((parent = element2.getParent()) == null) {
                return null;
            }
            return ((IntervalNode)parent).getRight() == element2 ? ((IntervalNode)parent).getLeft() : null;
        }

        public IntervalNode<T> getFirstChild(@NotNull IntervalNode<T> element2) {
            RedBlackTree.Node left;
            if (element2 == null) {
                IntervalTreeGuide.$$$reportNull$$$0(2);
            }
            return (left = element2.getLeft()) == null ? element2.getRight() : left;
        }

        public IntervalNode<T> getParent(@NotNull IntervalNode<T> element2) {
            if (element2 == null) {
                IntervalTreeGuide.$$$reportNull$$$0(3);
            }
            return element2.getParent();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "element";
            objectArray2[1] = "com/intellij/openapi/editor/impl/IntervalTreeImpl$IntervalTreeGuide";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getNextSibling";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getPrevSibling";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getFirstChild";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getParent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class IntTrinity {
        private final int first;
        private final int second;
        private final int third;

        private IntTrinity(int first, int second, int third) {
            this.first = first;
            this.second = second;
            this.third = third;
        }
    }

    static class IntervalNode<E>
    extends RedBlackTree.Node<E>
    implements MutableInterval {
        private volatile int myStart;
        private volatile int myEnd;
        private static final byte ATTACHED_TO_TREE_FLAG = 2;
        final List<Supplier<E>> intervals;
        int maxEnd;
        int delta;
        private volatile long cachedDeltaUpToRoot;
        @NotNull
        private final IntervalTreeImpl<E> myIntervalTree;
        static final byte VALID_FLAG = 4;
        private static final AtomicLongFieldUpdater<IntervalNode> cachedDeltaUpdater = AtomicLongFieldUpdater.newUpdater(IntervalNode.class, "cachedDeltaUpToRoot");

        IntervalNode(@NotNull IntervalTreeImpl<E> intervalTree, @NotNull E key, int start2, int end) {
            if (intervalTree == null) {
                IntervalNode.$$$reportNull$$$0(0);
            }
            if (key == null) {
                IntervalNode.$$$reportNull$$$0(1);
            }
            this.myIntervalTree = intervalTree;
            this.myStart = start2;
            this.myEnd = end;
            this.intervals = new SmartList(this.createGetter(key));
            this.setValid(true);
        }

        @Override
        public IntervalNode<E> getLeft() {
            return (IntervalNode)this.left;
        }

        @Override
        public IntervalNode<E> getRight() {
            return (IntervalNode)this.right;
        }

        @Override
        public IntervalNode<E> getParent() {
            return (IntervalNode)this.parent;
        }

        @Override
        public boolean processAliveKeys(@NotNull Processor<? super E> processor2) {
            if (processor2 == null) {
                IntervalNode.$$$reportNull$$$0(2);
            }
            for (int i2 = 0; i2 < this.intervals.size(); ++i2) {
                Supplier<E> interval = this.intervals.get(i2);
                E key = interval.get();
                if (key == null || processor2.process(key)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean hasAliveKey(boolean purgeDead) {
            boolean hasAliveInterval = false;
            for (int i2 = this.intervals.size() - 1; i2 >= 0; --i2) {
                Supplier<E> interval = this.intervals.get(i2);
                if (interval.get() != null) {
                    hasAliveInterval = true;
                    if (!purgeDead) break;
                    continue;
                }
                if (!purgeDead) continue;
                ((IntervalTreeImpl)this.myIntervalTree).assertUnderWriteLock();
                this.removeIntervalInternal(i2);
            }
            return hasAliveInterval;
        }

        private boolean removeInterval(@NotNull E key) {
            if (key == null) {
                IntervalNode.$$$reportNull$$$0(3);
            }
            ((IntervalTreeImpl)this.myIntervalTree).checkBelongsToTheTree(key, true);
            ((IntervalTreeImpl)this.myIntervalTree).assertUnderWriteLock();
            for (int i2 = this.intervals.size() - 1; i2 >= 0; --i2) {
                Supplier<E> interval = this.intervals.get(i2);
                E t = interval.get();
                if (t != key) continue;
                this.removeIntervalInternal(i2);
                if (this.intervals.isEmpty()) {
                    this.myIntervalTree.removeNode(this);
                    return true;
                }
                return false;
            }
            assert (false) : "interval not found: " + key + "; " + this.intervals;
            return false;
        }

        private boolean isAttachedToTree() {
            return this.isFlagSet((byte)2);
        }

        private void setAttachedToTree(boolean attached) {
            this.setFlag((byte)2, attached);
        }

        void removeIntervalInternal(int i2) {
            this.intervals.remove(i2);
            if (this.isAttachedToTree()) {
                assert (((IntervalTreeImpl)this.myIntervalTree).keySize > 0) : IntervalTreeImpl.access$200(this.myIntervalTree);
                ((IntervalTreeImpl)this.myIntervalTree).keySize--;
            }
        }

        void addInterval(@NotNull E interval) {
            if (interval == null) {
                IntervalNode.$$$reportNull$$$0(4);
            }
            ((IntervalTreeImpl)this.myIntervalTree).assertUnderWriteLock();
            this.intervals.add(this.createGetter(interval));
            if (this.isAttachedToTree()) {
                ((IntervalTreeImpl)this.myIntervalTree).keySize++;
                this.myIntervalTree.setNode(interval, this);
            }
        }

        void addIntervalsFrom(@NotNull IntervalNode<E> otherNode) {
            if (otherNode == null) {
                IntervalNode.$$$reportNull$$$0(5);
            }
            for (Supplier<E> key : otherNode.intervals) {
                E interval = key.get();
                if (interval == null) continue;
                this.addInterval(interval);
            }
        }

        private Supplier<E> createGetter(@NotNull E interval) {
            if (interval == null) {
                IntervalNode.$$$reportNull$$$0(6);
            }
            return this.myIntervalTree.keepIntervalsOnWeakReferences() ? new WeakReferencedGetter(interval, ((IntervalTreeImpl)this.myIntervalTree).myReferenceQueue) : () -> interval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int computeDeltaUpToRoot() {
            block7: while (this.isValid()) {
                int treeModCount = this.myIntervalTree.getModCount();
                long packedOffsets = this.cachedDeltaUpToRoot;
                if (IntervalNode.modCount(packedOffsets) == treeModCount) {
                    return IntervalNode.deltaUpToRoot(packedOffsets);
                }
                try {
                    boolean allDeltasAreNull;
                    int deltaUp;
                    block17: {
                        this.myIntervalTree.l.readLock().lock();
                        RedBlackTree.Node node2 = this;
                        IntervalNode<E> treeRoot = this.myIntervalTree.getRoot();
                        if (treeRoot == null) {
                            int n = this.delta;
                            return n;
                        }
                        deltaUp = 0;
                        allDeltasAreNull = true;
                        int height = 0;
                        long path2 = 0L;
                        while (node2 != treeRoot) {
                            long nodePackedOffsets = ((IntervalNode)node2).cachedDeltaUpToRoot;
                            if (((IntervalNode)node2).isValid() && IntervalNode.modCount(nodePackedOffsets) == treeModCount) {
                                deltaUp = IntervalNode.deltaUpToRoot(nodePackedOffsets) - ((IntervalNode)node2).delta;
                                allDeltasAreNull = IntervalNode.allDeltasUpAreNull(nodePackedOffsets);
                                break;
                            }
                            RedBlackTree.Node parent = ((IntervalNode)node2).getParent();
                            if (parent == null) {
                                int n = deltaUp;
                                return n;
                            }
                            path2 = path2 << 1 | (long)(((IntervalNode)parent).getLeft() == node2 ? 0 : 1);
                            node2 = parent;
                            ++height;
                        }
                        assert (height < 63) : height;
                        do {
                            int nodeDelta;
                            if (((IntervalNode)node2).isValid() && !((IntervalNode)node2).tryToSetCachedValues(deltaUp += (nodeDelta = ((IntervalNode)node2).delta), allDeltasAreNull &= nodeDelta == 0, treeModCount)) continue block7;
                            if (node2 == this) break block17;
                            node2 = (path2 & 1L) == 0L ? ((IntervalNode)node2).getLeft() : ((IntervalNode)node2).getRight();
                            path2 >>= 1;
                        } while (node2 != null);
                        int n = deltaUp;
                        return n;
                    }
                    assert (deltaUp == 0 || !allDeltasAreNull);
                    int n = deltaUp;
                    return n;
                }
                finally {
                    this.myIntervalTree.l.readLock().unlock();
                    continue;
                }
                break;
            }
            return 0;
        }

        int changeDelta(int change) {
            if (change != 0) {
                this.setCachedValues(0, false, 0);
                return this.delta += change;
            }
            return this.delta;
        }

        void clearDelta() {
            if (this.delta != 0) {
                this.setCachedValues(0, false, 0);
                this.delta = 0;
            }
        }

        @Override
        public int setIntervalStart(int start2) {
            this.myStart = start2;
            return this.myStart;
        }

        @Override
        public int setIntervalEnd(int end) {
            this.myEnd = end;
            return this.myEnd;
        }

        @Override
        public boolean isValid() {
            return this.isFlagSet((byte)4);
        }

        @Override
        public boolean setValid(boolean value2) {
            this.setFlag((byte)4, value2);
            return value2;
        }

        @Override
        public int intervalStart() {
            return this.myStart;
        }

        @Override
        public int intervalEnd() {
            return this.myEnd;
        }

        @NotNull
        public IntervalTreeImpl<E> getTree() {
            IntervalTreeImpl<E> intervalTreeImpl = this.myIntervalTree;
            if (intervalTreeImpl == null) {
                IntervalNode.$$$reportNull$$$0(7);
            }
            return intervalTreeImpl;
        }

        private void setCachedValues(int deltaUpToRoot, boolean allDeltaUpToRootAreNull, int modCount) {
            this.cachedDeltaUpToRoot = IntervalNode.packValues(deltaUpToRoot, allDeltaUpToRootAreNull, modCount);
        }

        private static long packValues(long deltaUpToRoot, boolean allDeltaUpToRootAreNull, int modCount) {
            return deltaUpToRoot << 33 | (allDeltaUpToRootAreNull ? 0x100000000L : 0L) | (long)modCount;
        }

        private boolean tryToSetCachedValues(int deltaUpToRoot, boolean allDeltasUpAreNull, int treeModCount) {
            if (this.myIntervalTree.getModCount() != treeModCount) {
                return false;
            }
            long newValue2 = IntervalNode.packValues(deltaUpToRoot, allDeltasUpAreNull, treeModCount);
            long oldValue = this.cachedDeltaUpToRoot;
            return cachedDeltaUpdater.compareAndSet(this, oldValue, newValue2);
        }

        private static boolean allDeltasUpAreNull(long packedOffsets) {
            return (packedOffsets >> 32 & 1L) != 0L;
        }

        private static int modCount(long packedOffsets) {
            return (int)packedOffsets;
        }

        private static int deltaUpToRoot(long packedOffsets) {
            return (int)(packedOffsets >> 33);
        }

        IntervalNode<E> previous() {
            RedBlackTree.Node parent;
            RedBlackTree.Node left = this.getLeft();
            if (left != null) {
                while (((IntervalNode)left).getRight() != null) {
                    left = ((IntervalNode)left).getRight();
                }
                return left;
            }
            RedBlackTree.Node prev2 = this;
            for (parent = this.getParent(); parent != null && ((IntervalNode)parent).getRight() != prev2; parent = ((IntervalNode)parent).getParent()) {
                prev2 = parent;
            }
            return parent;
        }

        IntervalNode<E> next() {
            RedBlackTree.Node parent;
            RedBlackTree.Node right = this.getRight();
            if (right != null) {
                while (((IntervalNode)right).getLeft() != null) {
                    right = ((IntervalNode)right).getLeft();
                }
                return right;
            }
            RedBlackTree.Node prev2 = this;
            for (parent = this.getParent(); parent != null && ((IntervalNode)parent).getLeft() != prev2; parent = ((IntervalNode)parent).getParent()) {
                prev2 = parent;
            }
            return parent;
        }

        @NonNls
        public String toString() {
            return "Node: " + this.intervals;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "intervalTree";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interval";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "otherNode";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/impl/IntervalTreeImpl$IntervalNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/impl/IntervalTreeImpl$IntervalNode";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTree";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "processAliveKeys";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "removeInterval";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addInterval";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "addIntervalsFrom";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "createGetter";
                    break;
                }
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static final class WeakReferencedGetter<T>
        extends WeakReference<T>
        implements Supplier<T> {
            private WeakReferencedGetter(@NotNull T referent, @NotNull ReferenceQueue<? super T> q) {
                if (referent == null) {
                    WeakReferencedGetter.$$$reportNull$$$0(0);
                }
                if (q == null) {
                    WeakReferencedGetter.$$$reportNull$$$0(1);
                }
                super(referent, q);
            }

            @NonNls
            public String toString() {
                return "Ref: " + this.get();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "referent";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "q";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/editor/impl/IntervalTreeImpl$IntervalNode$WeakReferencedGetter";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

