/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.highlighter;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.EditorHighlighterProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeEditorHighlighterProviders;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainSyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditorHighlighterFactoryImpl
extends EditorHighlighterFactory {
    private static final Logger LOG = Logger.getInstance(EditorHighlighterFactoryImpl.class);

    @NotNull
    public EditorHighlighter createEditorHighlighter(SyntaxHighlighter highlighter, @NotNull EditorColorsScheme colors) {
        if (colors == null) {
            EditorHighlighterFactoryImpl.$$$reportNull$$$0(0);
        }
        if (highlighter == null) {
            highlighter = new PlainSyntaxHighlighter();
        }
        return new LexerEditorHighlighter(highlighter, colors);
    }

    @NotNull
    public EditorHighlighter createEditorHighlighter(@NotNull FileType fileType, @NotNull EditorColorsScheme settings2, Project project) {
        if (fileType == null) {
            EditorHighlighterFactoryImpl.$$$reportNull$$$0(1);
        }
        if (settings2 == null) {
            EditorHighlighterFactoryImpl.$$$reportNull$$$0(2);
        }
        if (fileType instanceof LanguageFileType) {
            EditorHighlighter editorHighlighter = ((EditorHighlighterProvider)FileTypeEditorHighlighterProviders.INSTANCE.forFileType(fileType)).getEditorHighlighter(project, fileType, null, settings2);
            if (editorHighlighter == null) {
                EditorHighlighterFactoryImpl.$$$reportNull$$$0(3);
            }
            return editorHighlighter;
        }
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)fileType, (Project)project, null);
        EditorHighlighter editorHighlighter = this.createEditorHighlighter(highlighter, settings2);
        if (editorHighlighter == null) {
            EditorHighlighterFactoryImpl.$$$reportNull$$$0(4);
        }
        return editorHighlighter;
    }

    @NotNull
    public EditorHighlighter createEditorHighlighter(Project project, @NotNull FileType fileType) {
        if (fileType == null) {
            EditorHighlighterFactoryImpl.$$$reportNull$$$0(5);
        }
        EditorHighlighter editorHighlighter = this.createEditorHighlighter(fileType, EditorColorsManager.getInstance().getGlobalScheme(), project);
        if (editorHighlighter == null) {
            EditorHighlighterFactoryImpl.$$$reportNull$$$0(6);
        }
        return editorHighlighter;
    }

    @NotNull
    public EditorHighlighter createEditorHighlighter(@NotNull VirtualFile vFile, @NotNull EditorColorsScheme settings2, @Nullable Project project) {
        FileType fileType;
        if (vFile == null) {
            EditorHighlighterFactoryImpl.$$$reportNull$$$0(7);
        }
        if (settings2 == null) {
            EditorHighlighterFactoryImpl.$$$reportNull$$$0(8);
        }
        if ((fileType = vFile.getFileType()) instanceof LanguageFileType) {
            EditorHighlighter editorHighlighter;
            LanguageFileType substFileType;
            Language substLang = project == null ? null : LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)vFile, (FileType)fileType);
            LanguageFileType languageFileType = substFileType = substLang != null && substLang != ((LanguageFileType)fileType).getLanguage() ? substLang.getAssociatedFileType() : null;
            if (substFileType != null) {
                boolean isPlain;
                EditorHighlighterProvider provider2 = (EditorHighlighterProvider)FileTypeEditorHighlighterProviders.INSTANCE.forFileType((FileType)substFileType);
                EditorHighlighter editorHighlighter2 = provider2.getEditorHighlighter(project, (FileType)substFileType, vFile, settings2);
                boolean bl = isPlain = editorHighlighter2.getClass() == LexerEditorHighlighter.class && ((LexerEditorHighlighter)editorHighlighter2).isPlain();
                if (!isPlain) {
                    EditorHighlighter editorHighlighter3 = editorHighlighter2;
                    if (editorHighlighter3 == null) {
                        EditorHighlighterFactoryImpl.$$$reportNull$$$0(9);
                    }
                    return editorHighlighter3;
                }
            }
            try {
                editorHighlighter = ((EditorHighlighterProvider)FileTypeEditorHighlighterProviders.INSTANCE.forFileType(fileType)).getEditorHighlighter(project, fileType, vFile, settings2);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            if (editorHighlighter == null) {
                EditorHighlighterFactoryImpl.$$$reportNull$$$0(10);
            }
            return editorHighlighter;
        }
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)fileType, (Project)project, (VirtualFile)vFile);
        EditorHighlighter editorHighlighter = this.createEditorHighlighter(highlighter, settings2);
        if (editorHighlighter == null) {
            EditorHighlighterFactoryImpl.$$$reportNull$$$0(11);
        }
        return editorHighlighter;
    }

    @NotNull
    public EditorHighlighter createEditorHighlighter(Project project, @NotNull VirtualFile file2) {
        if (file2 == null) {
            EditorHighlighterFactoryImpl.$$$reportNull$$$0(12);
        }
        EditorHighlighter editorHighlighter = this.createEditorHighlighter(file2, EditorColorsManager.getInstance().getGlobalScheme(), project);
        if (editorHighlighter == null) {
            EditorHighlighterFactoryImpl.$$$reportNull$$$0(13);
        }
        return editorHighlighter;
    }

    @NotNull
    public EditorHighlighter createEditorHighlighter(Project project, @NotNull String fileName) {
        if (fileName == null) {
            EditorHighlighterFactoryImpl.$$$reportNull$$$0(14);
        }
        EditorHighlighter editorHighlighter = this.createEditorHighlighter(EditorColorsManager.getInstance().getGlobalScheme(), fileName, project);
        if (editorHighlighter == null) {
            EditorHighlighterFactoryImpl.$$$reportNull$$$0(15);
        }
        return editorHighlighter;
    }

    @NotNull
    public EditorHighlighter createEditorHighlighter(@NotNull EditorColorsScheme settings2, @NotNull String fileName, @Nullable Project project) {
        if (settings2 == null) {
            EditorHighlighterFactoryImpl.$$$reportNull$$$0(16);
        }
        if (fileName == null) {
            EditorHighlighterFactoryImpl.$$$reportNull$$$0(17);
        }
        EditorHighlighter editorHighlighter = this.createEditorHighlighter((VirtualFile)new LightVirtualFile(fileName), settings2, project);
        if (editorHighlighter == null) {
            EditorHighlighterFactoryImpl.$$$reportNull$$$0(18);
        }
        return editorHighlighter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colors";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 2: 
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/highlighter/EditorHighlighterFactoryImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/highlighter/EditorHighlighterFactoryImpl";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorHighlighter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createEditorHighlighter";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 18: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

