/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex.util;

import com.intellij.diagnostic.PluginException;
import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerPosition;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValidatingLexerWrapper
extends Lexer {
    private final Lexer myDelegate;
    private int myLastStartOffset;
    private int myLastEndOffset;
    private int myLastState;
    private IElementType myLastTokenType;
    private boolean myLastValuesActual;

    public ValidatingLexerWrapper(@NotNull Lexer delegate2) {
        if (delegate2 == null) {
            ValidatingLexerWrapper.$$$reportNull$$$0(0);
        }
        this.myDelegate = delegate2;
    }

    @NotNull
    public CharSequence getTokenSequence() {
        CharSequence charSequence = this.myDelegate.getTokenSequence();
        if (charSequence == null) {
            ValidatingLexerWrapper.$$$reportNull$$$0(1);
        }
        return charSequence;
    }

    @NotNull
    public String getTokenText() {
        String string = this.myDelegate.getTokenText();
        if (string == null) {
            ValidatingLexerWrapper.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            ValidatingLexerWrapper.$$$reportNull$$$0(3);
        }
        this.myDelegate.start(buffer, startOffset, endOffset, initialState);
        this.myLastValuesActual = false;
    }

    public int getState() {
        return this.myLastValuesActual ? this.myLastState : this.myDelegate.getState();
    }

    @Nullable
    public IElementType getTokenType() {
        if (!this.myLastValuesActual) {
            this.myLastTokenType = this.myDelegate.getTokenType();
            if (this.myLastTokenType != null) {
                this.myLastStartOffset = this.myDelegate.getTokenStart();
                this.myLastEndOffset = this.myDelegate.getTokenEnd();
                this.myLastState = this.myDelegate.getState();
            }
            this.myLastValuesActual = true;
        }
        return this.myLastTokenType;
    }

    public int getTokenStart() {
        return this.myLastValuesActual ? this.myLastStartOffset : this.myDelegate.getTokenStart();
    }

    public int getTokenEnd() {
        return this.myLastValuesActual ? this.myLastEndOffset : this.myDelegate.getTokenEnd();
    }

    public void advance() {
        this.myDelegate.advance();
        int prevStart = 0;
        int prevEnd = 0;
        int prevState2 = 0;
        IElementType prevType = null;
        if (this.myLastValuesActual) {
            prevStart = this.myLastStartOffset;
            prevEnd = this.myLastEndOffset;
            prevState2 = this.myLastState;
            prevType = this.myLastTokenType;
        }
        this.myLastValuesActual = false;
        this.getTokenType();
        if (prevType != null && this.myLastTokenType != null) {
            if (this.myLastStartOffset > this.myLastEndOffset) {
                this.throwException("Incorrect token offsets returned by lexer");
            }
            if (this.myLastStartOffset != prevEnd) {
                this.throwException("Discontinuous sequence of tokens is generated by lexer");
            }
            if (this.myLastEndOffset == this.myLastStartOffset && prevEnd == prevStart && this.myLastState == prevState2 && this.myLastTokenType == prevType) {
                this.throwException("Lexer is not progressing after calling advance()");
            }
        }
    }

    @NotNull
    public LexerPosition getCurrentPosition() {
        LexerPosition lexerPosition = this.myDelegate.getCurrentPosition();
        if (lexerPosition == null) {
            ValidatingLexerWrapper.$$$reportNull$$$0(4);
        }
        return lexerPosition;
    }

    public void restore(@NotNull LexerPosition position) {
        if (position == null) {
            ValidatingLexerWrapper.$$$reportNull$$$0(5);
        }
        this.myDelegate.restore(position);
        this.myLastValuesActual = false;
    }

    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myDelegate.getBufferSequence();
        if (charSequence == null) {
            ValidatingLexerWrapper.$$$reportNull$$$0(6);
        }
        return charSequence;
    }

    public int getBufferEnd() {
        return this.myDelegate.getBufferEnd();
    }

    private void throwException(@NotNull String message2) {
        Class<?> lexerClass;
        if (message2 == null) {
            ValidatingLexerWrapper.$$$reportNull$$$0(7);
        }
        boolean isFlexAdapter = (lexerClass = this.myDelegate.getClass()) == FlexAdapter.class;
        throw PluginException.createByClass((String)(message2 + ": " + (isFlexAdapter ? this.myDelegate.toString() : lexerClass.getName())), null, isFlexAdapter ? ((FlexAdapter)this.myDelegate).getFlex().getClass() : lexerClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/ex/util/ValidatingLexerWrapper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/ex/util/ValidatingLexerWrapper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenSequence";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentPosition";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBufferSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "restore";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "throwException";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

